/*
 * Decompiled with CFR 0.152.
 */
package jet.cache;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jet.cache.Cache;
import jet.cache.CacheException;
import jet.cache.CacheImpl;
import jet.cache.ObjectExistsException;
import jet.cache.Status;
import jet.server.log.ServiceLogger;

public class CacheManager {
    private static CacheManager SEDU;
    protected final Map caches = new ConcurrentHashMap();
    protected String name;
    protected Status status = Status.STATUS_UNINITIALISED;

    public CacheManager() throws CacheException {
        this.init();
    }

    protected void init() {
        this.status = Status.STATUS_ALIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager getInstance() throws CacheException {
        if (SEDU != null) {
            return SEDU;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (SEDU == null) {
                SEDU = new CacheManager();
                ServiceLogger.logDebug("Creating new CacheManager with default config");
            } else {
                ServiceLogger.logDebug("Attempting to create an existing singleton. Existing singleton returned.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SEDU;
        }
    }

    protected void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            if (this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("The CacheManager has not yet been initialised. It cannot be used yet.");
            }
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                throw new IllegalStateException("The CacheManager has been shut down. It can no longer be used.");
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public Cache getCache(String string) throws IllegalStateException, ClassCastException {
        this.checkStatus();
        return (Cache)this.caches.get(string);
    }

    public void addCache(String string) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.caches.get(string) != null) {
            throw new ObjectExistsException("Cache " + string + " already exists");
        }
        CacheImpl cacheImpl = new CacheImpl(string);
        this.addCache(cacheImpl);
    }

    public void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cache == null) {
            return;
        }
        if (this.caches.get(cache.getName()) != null) {
            throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
        }
        cache.setCacheManager(this);
        cache.initialise();
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            this.status = Status.STATUS_ALIVE;
        }
        this.caches.put(cache.getName(), cache);
    }

    public boolean cacheExists(String string) throws IllegalStateException {
        this.checkStatus();
        return this.caches.get(string) != null;
    }

    public String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] stringArray = new String[this.caches.size()];
        return this.caches.keySet().toArray(stringArray);
    }

    public void removeAll() {
        String[] stringArray;
        for (String string : stringArray = this.getCacheNames()) {
            this.removeCache(string);
        }
    }

    public void removeCache(String string) throws IllegalStateException {
        this.checkStatus();
        if (string == null || string.length() == 0) {
            return;
        }
        Cache cache = (Cache)this.caches.get(string);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
        }
        this.caches.remove(string);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                ServiceLogger.logDebug("CacheManager already shutdown");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Class<CacheManager> clazz2 = CacheManager.class;
            synchronized (CacheManager.class) {
                Collection collection = this.caches.values();
                for (Cache cache : collection) {
                    if (cache == null) continue;
                    cache.dispose();
                }
                this.status = Status.STATUS_SHUTDOWN;
                if (this == SEDU) {
                    SEDU = null;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getName();
    }
}

