/*
 * Decompiled with CFR 0.152.
 */
package jet.cache.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jet.cache.Cache;
import jet.cache.CacheCeilingSpaceControler;
import jet.cache.CacheException;
import jet.cache.CachedData;
import jet.cache.Status;
import jet.cache.store.FifoPolicy;
import jet.cache.store.LfuPolicy;
import jet.cache.store.LruPolicy;
import jet.cache.store.MemoryStoreEvictionPolicy;
import jet.cache.store.Policy;
import jet.cache.store.Store;
import jet.server.log.ServiceLogger;

public class MemoryStore
implements Store {
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int CONCURRENCY_LEVEL = 100;
    protected Policy policy;
    protected Cache cache;
    protected Map map;
    protected Status status = Status.STATUS_UNINITIALISED;
    protected int maxelementsinmemory;
    protected long maxmemorysize;
    private CacheCeilingSpaceControler FIFO;

    protected MemoryStore(Cache cache) {
        this.cache = cache;
        this.maxelementsinmemory = cache.getCacheConfiguration().getMaxElementsInMemory();
        this.maxmemorysize = cache.getCacheConfiguration().getMaxMemorySize();
        this.determineEvictionPolicy(cache);
        this.map = new ConcurrentHashMap(this.maxelementsinmemory, 0.75f, 100);
        this.status = Status.STATUS_ALIVE;
        ServiceLogger.logDebug("Initialized " + this.getClass().getName() + " for " + cache.getName());
    }

    public static MemoryStore create(Cache cache) {
        MemoryStore memoryStore = new MemoryStore(cache);
        return memoryStore;
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    protected void determineEvictionPolicy(Cache cache) {
        MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = cache.getCacheConfiguration().getMemoryStoreEvictionPolicy();
        if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.LRU)) {
            this.policy = new LruPolicy();
        } else if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.FIFO)) {
            this.policy = new FifoPolicy();
        } else if (memoryStoreEvictionPolicy.equals(MemoryStoreEvictionPolicy.LFU)) {
            this.policy = new LfuPolicy();
        }
    }

    @Override
    public final synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.cache = null;
        this.map = null;
        this.status = Status.STATUS_SHUTDOWN;
    }

    protected void evictElements(int n) {
        ServiceLogger.logDebug("Elements is full. Removing elements...");
        List list = this.getEvictionElements();
        if (list == null || list.size() == 0) {
            return;
        }
        int n2 = list.size();
        if (n < n2) {
            n2 = n;
        }
        for (int i = 0; i < n; ++i) {
            CachedData cachedData = (CachedData)list.get(i);
            this.remove(cachedData.getObjectKey());
        }
        list.clear();
        list = null;
    }

    protected void evictMemory(long l) {
        CachedData cachedData;
        ServiceLogger.logDebug("Elements is full. Removing elements...");
        List list = this.getEvictionElements();
        if (list == null || list.size() == 0) {
            return;
        }
        long l2 = 0L;
        for (int i = 0; i < list.size() && l2 < l; l2 += cachedData.getMemorySize(), ++i) {
            cachedData = (CachedData)list.get(i);
            this.remove(cachedData.getObjectKey());
        }
        list.clear();
        list = null;
    }

    @Override
    public void expireElements() {
    }

    @Override
    public final CachedData get(Object object) {
        if (object == null) {
            return null;
        }
        CachedData cachedData = (CachedData)this.map.get(object);
        if (cachedData != null) {
            cachedData.updateAccessStatistics();
            ServiceLogger.logDebug("Cache: " + this.cache.getName() + " MemoryStore hit for " + object);
        } else {
            ServiceLogger.logDebug("Cache: " + this.cache.getName() + " MemoryStore miss for " + object);
        }
        return cachedData;
    }

    public Map getBackingMap() {
        return this.map;
    }

    protected final List getEvictionElements() {
        ArrayList<CachedData> arrayList = new ArrayList<CachedData>();
        Set set = this.map.entrySet();
        for (Map.Entry entry : set) {
            CachedData cachedData = (CachedData)entry.getValue();
            if (cachedData.getUserCount() != 0L || cachedData.isEternal()) continue;
            arrayList.add(cachedData);
        }
        Collections.sort(arrayList, this.policy);
        return arrayList;
    }

    protected int getEvictionElementsNubmer() {
        if (this.maxelementsinmemory > 0) {
            return this.map.size() + 1 - this.maxelementsinmemory;
        }
        return 0;
    }

    protected long getEvictionMemorySize(long l) {
        if (this.maxmemorysize > 0L) {
            return this.getMemorySize() + l - this.maxmemorysize;
        }
        return 0L;
    }

    @Override
    public Policy getEvictionPolicy() {
        return this.policy;
    }

    @Override
    public final Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public final long getMemorySize() throws CacheException {
        long l = 0L;
        for (CachedData cachedData : this.map.values()) {
            CachedData cachedData2 = cachedData;
            if (cachedData2 == null) continue;
            l += cachedData2.getMemorySize();
        }
        return l;
    }

    @Override
    public final CachedData getQuiet(Object object) {
        CachedData cachedData = (CachedData)this.map.get(object);
        if (cachedData != null) {
            ServiceLogger.logDebug("Cache: " + this.cache.getName() + " MemoryStore hit for " + object);
        } else {
            ServiceLogger.logDebug("Cache: " + this.cache.getName() + " MemoryStore miss for " + object);
        }
        return cachedData;
    }

    @Override
    public final int getSize() {
        return this.map.size();
    }

    @Override
    public final Status getStatus() {
        return this.status;
    }

    protected boolean isElementsFull() {
        if (this.maxelementsinmemory > 0) {
            return this.map.size() + 1 > this.maxelementsinmemory;
        }
        return false;
    }

    protected boolean isSpacesFull(long l) {
        if (this.maxmemorysize > 0L) {
            return this.getMemorySize() + l > this.maxmemorysize;
        }
        return false;
    }

    @Override
    public final void put(CachedData cachedData) throws CacheException {
        if (cachedData != null) {
            long l;
            int n = this.getEvictionElementsNubmer();
            if (n > 0) {
                this.evictElements(n);
            }
            if ((l = this.getEvictionMemorySize(cachedData.getMemorySize())) > 0L) {
                this.evictMemory(l);
            }
            if (this.isElementsFull() || this.isSpacesFull(cachedData.getMemorySize())) {
                return;
            }
            if (this.FIFO != null && !this.FIFO.allocate(cachedData.getMemorySize())) {
                return;
            }
            cachedData.resetAccessStatistics();
            this.map.put(cachedData.getObjectKey(), cachedData);
        }
    }

    @Override
    public final CachedData remove(Object object) {
        if (object == null) {
            return null;
        }
        CachedData cachedData = (CachedData)this.map.remove(object);
        if (cachedData != null) {
            if (this.FIFO != null) {
                this.FIFO.deallocate(cachedData.getMemorySize());
            }
            return cachedData;
        }
        ServiceLogger.logDebug("Cache: Cannot remove rntry as key" + object + " was not found.");
        return null;
    }

    @Override
    public final synchronized void removeAll() throws CacheException {
        long l = this.getMemorySize();
        this.map.clear();
        if (this.FIFO != null) {
            this.FIFO.deallocate(l);
        }
    }

    @Override
    public void setEvictionPolicy(Policy policy) {
        this.policy = policy;
    }

    @Override
    public final void setMemorySize(long l) throws CacheException {
        long l2 = this.getMemorySize() - l;
        if (l2 > 0L) {
            this.evictMemory(l2);
        }
        this.maxmemorysize = l;
    }

    @Override
    public final void setSize(int n) {
        int n2 = this.getSize() - n;
        if (n2 > 0) {
            this.evictElements(n2);
        }
        this.maxelementsinmemory = n;
    }

    @Override
    public void setCeilingSpaceControler(CacheCeilingSpaceControler cacheCeilingSpaceControler) {
        this.FIFO = cacheCeilingSpaceControler;
    }
}

