/*
 * Decompiled with CFR 0.152.
 */
package jet.connect.jdbms;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import jet.connect.Record;
import jet.connect.jdbms.JDbBuffer;
import jet.connect.jdbms.JDbRecordModel;
import jet.connect.jdbms.JDbResultSet;
import jet.connect.jdbms.JDbTableDesc;
import jet.connect.jdbms.JDbTables;
import jet.connect.jdbms.JDbWhere;
import jet.connect.jdbms.JResultSet;
import jet.util.RAFile;

public class JDbConnection {
    File DbPath;
    File tblfile;
    JDbBuffer workspace;
    JDbRecordModel recmodel;
    JDbResultSet resultset;

    public JDbConnection(File file, String string) throws SQLException {
        this(file, string, JDbTables.getRecordModel(string));
    }

    public JDbConnection(File file, String string, int n, int n2) throws SQLException {
        this(file, string, JDbTables.getRecordModel(string), n, n2);
    }

    public JDbConnection(File file, String string, JDbRecordModel jDbRecordModel) throws SQLException {
        this(file, string, jDbRecordModel, -1, -1);
    }

    public JDbConnection(File file, String string, JDbRecordModel jDbRecordModel, int n, int n2) throws SQLException {
        block12: {
            int n3;
            int n4;
            this.DbPath = file;
            this.tblfile = new File(file, string);
            this.recmodel = jDbRecordModel;
            if (!this.tblfile.exists()) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.tblfile));
                n4 = dataInputStream.readInt();
                n3 = dataInputStream.readInt();
                dataInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
            catch (IOException iOException) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
            jDbRecordModel.setRecordCount(n3);
            try {
                this.workspace = n > 0 && n2 > 0 ? new JDbBuffer(jDbRecordModel, this.tblfile, n, n2) : new JDbBuffer(jDbRecordModel, this.tblfile);
                this.workspace.setNeedWaitFetch(false);
                this.workspace.setBeging(n4);
                this.workspace.setRecordCount(n3);
                if (n3 <= 0) break block12;
                try {
                    this.workspace.readFirst();
                }
                catch (Throwable throwable) {
                    if (n > 0 && n2 > 0) {
                        this.workspace.close();
                        this.workspace = new JDbBuffer(jDbRecordModel, this.tblfile);
                        this.workspace.setNeedWaitFetch(false);
                        this.workspace.setBeging(n4);
                        this.workspace.setRecordCount(n3);
                        this.workspace.readFirst();
                        this.workspace.restart();
                        Record record = jDbRecordModel.currentRecord;
                        File file2 = new File(file, this.tblfile.getName() + "temp");
                        JDbBuffer jDbBuffer = new JDbBuffer(jDbRecordModel, file2, n, n2);
                        jDbBuffer.setNeedWaitFetch(false);
                        jDbBuffer.setBeging(n4);
                        try {
                            while (true) {
                                this.workspace.nextRecord(record);
                                jDbBuffer.addRecord(record);
                            }
                        }
                        catch (SQLException sQLException) {
                            jDbBuffer.finish();
                            jDbBuffer.refreshAllToFile();
                            jDbBuffer.close();
                            this.workspace.close();
                            JDbTableDesc.copyTableHeader(this.tblfile, file2);
                            this.tblfile.delete();
                            file2.renameTo(this.tblfile);
                            this.workspace = new JDbBuffer(jDbRecordModel, this.tblfile, n, n2);
                            this.workspace.setNeedWaitFetch(false);
                            this.workspace.setBeging(n4);
                            this.workspace.setRecordCount(n3);
                            this.workspace.readFirst();
                            break block12;
                        }
                    }
                    throw new SQLException("Cannot connect to the table(" + string + ")" + "! Error:" + throwable);
                }
            }
            catch (IOException iOException) {
                throw new SQLException("Cannot connect to the table(" + string + ")");
            }
        }
        this.resultset = new JDbResultSet(jDbRecordModel);
    }

    public static JDbConnection connect(File file, String string, JDbRecordModel jDbRecordModel) throws SQLException {
        return new JDbConnection(file, string, jDbRecordModel);
    }

    public static JDbConnection connect(File file, String string, JDbRecordModel jDbRecordModel, int n, int n2) throws SQLException {
        return new JDbConnection(file, string, jDbRecordModel, n, n2);
    }

    public static JDbConnection connect(File file, String string) throws SQLException {
        return new JDbConnection(file, string);
    }

    public static JDbConnection connect(File file, String string, int n, int n2) throws SQLException {
        return new JDbConnection(file, string, n, n2);
    }

    public void disconnect() throws SQLException {
        try {
            int n = (int)this.workspace.getBeging();
            this.resultset.commit();
            this.workspace.close();
            RAFile rAFile = new RAFile(this.tblfile, "rw");
            rAFile.seek(0L);
            rAFile.writeInt(n);
            rAFile.writeInt(this.recmodel.getRecordCount());
            rAFile.close();
        }
        catch (IOException iOException) {
            throw new SQLException("Cannot disconnect from the table(" + this.tblfile.toString() + ")");
        }
    }

    public void commit() throws SQLException {
        try {
            this.resultset.commit();
            RAFile rAFile = new RAFile(this.tblfile, "rw");
            rAFile.seek(0L);
            rAFile.writeInt((int)this.workspace.getBeging());
            rAFile.writeInt(this.recmodel.getRecordCount());
            rAFile.close();
        }
        catch (IOException iOException) {
            throw new SQLException("Cannot commit to the table(" + this.tblfile.toString() + ")");
        }
    }

    public synchronized JResultSet select(JDbWhere jDbWhere) throws SQLException {
        this.resultset.setWhere(jDbWhere);
        return this.resultset;
    }

    public int getRecords() {
        return this.workspace == null ? -1 : this.workspace.getRecords();
    }
}

