/*
 * Decompiled with CFR 0.152.
 */
package jet.connect.jdbms;

import guitools.toolkit.JDebug;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.StringTokenizer;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.jdbms.JDbColDesc;
import jet.connect.jdbms.JDbConnection;
import jet.connect.jdbms.JDbRecordModel;
import jet.connect.jdbms.JResultSet;
import jet.connect.jdbms.Upgradable;
import jet.util.RAFile;

public class JDbTableDesc
implements Upgradable {
    protected String strTableName = null;
    protected JDbColDesc[] colDescs = null;
    protected JDbColDesc[] colDescsNew = null;
    protected JDbColDesc[] colDescsReal = null;
    protected JDbColDesc[] colDescsTarget = null;
    protected String path = null;
    protected int recordsPerPage = -1;
    protected int largestPageSize = -1;
    protected int realRecordsPerPage = -1;
    protected int realLargestPageSize = -1;

    public JDbTableDesc(String string, int n) {
        this(null, string, n);
    }

    public JDbTableDesc(String string, String string2, int n) {
        this(string, string2, n, -1, -1);
    }

    public JDbTableDesc(String string, String string2, int n, int n2, int n3) {
        this.path = string;
        this.strTableName = string2;
        this.colDescs = new JDbColDesc[n];
        this.recordsPerPage = n2;
        this.largestPageSize = n3;
        this.setColumnDesc(0, "~!@#$", -7, 1, 0, 0, false);
    }

    public String getTableName() {
        return this.strTableName;
    }

    public JDbColDesc[] getColDescs() {
        if (this.colDescsReal != null) {
            return this.colDescsReal;
        }
        return this.colDescs;
    }

    public void setColumnDesc(int n, String string, int n2, int n3, int n4, int n5, boolean bl) {
        this.colDescs[n] = new JDbColDesc(string, n2, n3, n4, n5, bl, this.strTableName);
    }

    public void setColumnDesc(int n, String string, int n2, int n3, int n4, int n5) {
        this.colDescs[n] = new JDbColDesc(string, n2, n3, n4, n5, this.strTableName);
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setNewColDescs(int n) {
        this.colDescsNew = new JDbColDesc[n];
        this.setNewColumnDesc(0, "~!@#$", -7, 1, 0, 0, false);
    }

    public void setNewColumnDesc(int n, String string, int n2, int n3, int n4, int n5, boolean bl) {
        this.colDescsNew[n] = new JDbColDesc(string, n2, n3, n4, n5, bl, this.strTableName + ".temp");
    }

    public void setNewColumnDesc(int n, String string, int n2, int n3, int n4, int n5) {
        this.colDescsNew[n] = new JDbColDesc(string, n2, n3, n4, n5, this.strTableName + ".temp");
    }

    public void migrateTable() throws SQLException, IOException {
        int n = this.colDescsReal.length <= this.colDescsTarget.length ? this.colDescsReal.length : this.colDescsTarget.length;
        int n2 = 0;
        int n3 = 1;
        for (n3 = 1; n3 < n && this.colDescsReal[n3].typeEquals(this.colDescsTarget[n3]); ++n3) {
        }
        n2 = n3;
        File file = this.SEDU();
        JDbConnection jDbConnection = null;
        JResultSet jResultSet = null;
        DbValue[] dbValueArray = null;
        JDbConnection jDbConnection2 = null;
        JResultSet jResultSet2 = null;
        DbValue[] dbValueArray2 = null;
        jDbConnection = JDbConnection.connect(new File(this.path), this.strTableName, new JDbRecordModel(this.colDescsReal, 0), this.realRecordsPerPage, this.realLargestPageSize);
        jResultSet = jDbConnection.select(null);
        jDbConnection2 = JDbConnection.connect(new File(this.path), file.getName(), new JDbRecordModel(this.colDescsTarget, 0), this.recordsPerPage, this.largestPageSize);
        jResultSet2 = jDbConnection2.select(null);
        jResultSet.setCursor(0);
        while (jResultSet.nextRecord() != -1) {
            dbValueArray = jResultSet.getValueArray();
            int n4 = jResultSet2.insert();
            jResultSet2.setCursor(n4);
            jResultSet2.nextRecord();
            dbValueArray2 = jResultSet2.getValueArray();
            block18: for (n3 = 0; n3 < n2; ++n3) {
                switch (this.colDescsReal[n3].getSqlType()) {
                    case -6: {
                        ((DbTinyInt)dbValueArray2[n3]).set((byte)((DbTinyInt)dbValueArray[n3]).get());
                        ((DbTinyInt)dbValueArray[n3]).set((byte)0);
                        continue block18;
                    }
                    case 5: {
                        ((DbSmallInt)dbValueArray2[n3]).set(((DbSmallInt)dbValueArray[n3]).get());
                        ((DbSmallInt)dbValueArray[n3]).set((short)0);
                        continue block18;
                    }
                    case 4: {
                        ((DbInteger)dbValueArray2[n3]).set(((DbInteger)dbValueArray[n3]).get());
                        ((DbInteger)dbValueArray[n3]).set(0);
                        continue block18;
                    }
                    case -5: {
                        ((DbBigInt)dbValueArray2[n3]).set(((DbBigInt)dbValueArray[n3]).get());
                        ((DbBigInt)dbValueArray[n3]).set(0L);
                        continue block18;
                    }
                    case 7: {
                        ((DbReal)dbValueArray2[n3]).set(((DbReal)dbValueArray[n3]).get());
                        ((DbReal)dbValueArray[n3]).set(0.0f);
                        continue block18;
                    }
                    case 2: 
                    case 3: {
                        ((DbDecimal)dbValueArray2[n3]).set(((DbDecimal)dbValueArray[n3]).get());
                        ((DbDecimal)dbValueArray[n3]).set((BigDecimal)null);
                        continue block18;
                    }
                    case 6: 
                    case 8: {
                        ((DbDouble)dbValueArray2[n3]).set(((DbDouble)dbValueArray[n3]).get());
                        ((DbDouble)dbValueArray[n3]).set(0.0);
                        continue block18;
                    }
                    case -7: {
                        ((DbBit)dbValueArray2[n3]).set(((DbBit)dbValueArray[n3]).get());
                        ((DbBit)dbValueArray[n3]).set(false);
                        continue block18;
                    }
                    case 91: {
                        ((DbDate)dbValueArray2[n3]).set(((DbDate)dbValueArray[n3]).get());
                        ((DbDate)dbValueArray[n3]).set(0L);
                        continue block18;
                    }
                    case 92: {
                        ((DbTime)dbValueArray2[n3]).set(((DbTime)dbValueArray[n3]).get());
                        ((DbTime)dbValueArray[n3]).set(0L);
                        continue block18;
                    }
                    case 93: {
                        ((DbTimestamp)dbValueArray2[n3]).set(((DbTimestamp)dbValueArray[n3]).get());
                        ((DbTimestamp)dbValueArray[n3]).set(0L);
                        continue block18;
                    }
                    case -2: {
                        ((DbBinary)dbValueArray2[n3]).set(((DbBinary)dbValueArray[n3]).get());
                        ((DbBinary)dbValueArray[n3]).set((byte[])null);
                        continue block18;
                    }
                    case 1: 
                    case 12: {
                        ((DbChar)dbValueArray2[n3]).set(((DbChar)dbValueArray[n3]).get());
                        ((DbChar)dbValueArray[n3]).set("");
                        continue block18;
                    }
                    case -4: 
                    case -1: {
                        ((DbBinary)dbValueArray2[n3]).set(((DbBinary)dbValueArray[n3]).get());
                        ((DbBinary)dbValueArray[n3]).set((byte[])null);
                        continue block18;
                    }
                }
            }
            jResultSet2.update();
        }
        jDbConnection2.commit();
        jDbConnection.disconnect();
        jDbConnection2.disconnect();
        this.WARNING(file);
    }

    private File SEDU() throws IOException {
        File file = new File(this.path, this.strTableName + ".temp");
        if (file.exists()) {
            file.delete();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.writeInt(8);
        randomAccessFile.writeInt(0);
        randomAccessFile.close();
        return file;
    }

    private void WARNING(File file) {
        File file2;
        int n = 1;
        do {
            String string = this.strTableName + ".version" + n;
            file2 = new File(this.path, string);
            ++n;
        } while (file2.exists());
        new File(this.path, this.strTableName).renameTo(file2);
        file.renameTo(new File(this.path, this.strTableName));
    }

    protected boolean noSuchTable() {
        File file;
        File file2 = new File(this.path);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (file2.exists() && !(file = new File(file2, this.strTableName)).exists()) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                this.append(randomAccessFile, this.colDescsTarget);
                randomAccessFile.close();
                this.colDescsReal = this.colDescsTarget;
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    private void append(RandomAccessFile randomAccessFile, JDbColDesc[] jDbColDescArray) throws IOException {
        int n = 8;
        randomAccessFile.writeInt(n);
        randomAccessFile.writeInt(0);
        String string = null;
        byte[] byArray = null;
        int n2 = jDbColDescArray.length;
        randomAccessFile.writeInt(n2);
        n += 4;
        for (int i = 0; i < n2; ++i) {
            string = "index:" + i + "/" + jDbColDescArray[i].getDescription();
            byArray = string.getBytes();
            int n3 = byArray.length;
            randomAccessFile.writeInt(n3);
            n += 4;
            randomAccessFile.write(byArray);
            n += n3;
        }
        randomAccessFile.writeInt(this.recordsPerPage);
        randomAccessFile.writeInt(this.largestPageSize);
        randomAccessFile.seek(0L);
        randomAccessFile.writeInt(n += 8);
        randomAccessFile.setLength(n);
    }

    public void mergeTableHead(JDbColDesc[] jDbColDescArray) throws SQLException {
        try {
            int n;
            File file = new File(this.path, this.strTableName + ".temp");
            File file2 = new File(this.path, this.strTableName);
            if (file.exists()) {
                file.delete();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            this.append(randomAccessFile, jDbColDescArray);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(file2, "rw");
            int n2 = randomAccessFile2.readInt();
            randomAccessFile.seek(0L);
            int n3 = randomAccessFile.readInt();
            int n4 = randomAccessFile2.readInt();
            randomAccessFile.writeInt(n4);
            randomAccessFile2.seek(n2);
            randomAccessFile.seek(n3);
            byte[] byArray = new byte[8192];
            while ((n = randomAccessFile2.read(byArray)) > 0) {
                randomAccessFile.write(byArray, 0, n);
            }
            randomAccessFile2.close();
            randomAccessFile.close();
            file2.delete();
            file.renameTo(file2);
        }
        catch (IOException iOException) {
            throw new SQLException("Merge table head error: Cannot connect to the table(" + this.strTableName + ").");
        }
    }

    public static void copyTableHeader(File file, File file2) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        int n = dataInputStream.readInt();
        RAFile rAFile = new RAFile(file2, "rw");
        rAFile.seek(0L);
        if (n < 102400) {
            byte[] byArray = new byte[n];
            int n2 = dataInputStream.read(byArray);
            rAFile.writeInt(n);
            if (n2 > 0) {
                rAFile.write(byArray, 0, n2);
            }
        }
        dataInputStream.close();
        rAFile.close();
    }

    JDbColDesc getColDescFromString(String string) throws SQLException {
        String string2 = string;
        String string3 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/\t\n");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string4 = stringTokenizer.nextToken();
                if (string4.equalsIgnoreCase("colName")) {
                    string3 = stringTokenizer.nextToken().trim();
                    continue;
                }
                if (string4.equalsIgnoreCase("sqlType")) {
                    n = this.parseInt(stringTokenizer.nextToken(), -1);
                    continue;
                }
                if (string4.equalsIgnoreCase("precision")) {
                    n2 = this.parseInt(stringTokenizer.nextToken(), -1);
                    continue;
                }
                if (string4.equalsIgnoreCase("scale")) {
                    n3 = this.parseInt(stringTokenizer.nextToken(), -1);
                    continue;
                }
                if (string4.equalsIgnoreCase("nullable")) {
                    n4 = this.parseInt(stringTokenizer.nextToken(), -1);
                    continue;
                }
                if (!string4.equalsIgnoreCase("flag")) continue;
                n5 = this.parseInt(stringTokenizer.nextToken(), -1);
            }
            catch (Exception exception) {
                throw new SQLException("Cannot get the table(" + this.strTableName + ")'s column description.");
            }
        }
        JDbColDesc jDbColDesc = new JDbColDesc(string3, n, n2, n3, n4, this.strTableName);
        jDbColDesc.setFlag(n5);
        return jDbColDesc;
    }

    private JDbColDesc[] close() {
        File file = new File(this.path, this.strTableName);
        JDbColDesc[] jDbColDescArray = null;
        RandomAccessFile randomAccessFile = null;
        if (file.exists()) {
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                int n = randomAccessFile.readInt();
                int n2 = randomAccessFile.readInt();
                if (n == 8) {
                    if (n2 == 0) {
                        randomAccessFile.seek(0L);
                        this.append(randomAccessFile, this.colDescsTarget);
                        jDbColDescArray = this.colDescsTarget;
                    } else {
                        randomAccessFile.close();
                        this.mergeTableHead(this.colDescs);
                        jDbColDescArray = this.colDescs;
                    }
                    this.realRecordsPerPage = this.recordsPerPage;
                    this.realLargestPageSize = this.largestPageSize;
                } else {
                    int n3 = 0;
                    byte[] byArray = null;
                    int n4 = randomAccessFile.readInt();
                    jDbColDescArray = new JDbColDesc[n4];
                    for (int i = 0; i < n4; ++i) {
                        int n5 = randomAccessFile.readInt();
                        byArray = new byte[n5];
                        randomAccessFile.read(byArray);
                        jDbColDescArray[i] = this.getColDescFromString(new String(byArray));
                        n3 += 4 + n5;
                    }
                    if (n == 12 + n3) {
                        randomAccessFile.close();
                        this.mergeTableHead(jDbColDescArray);
                        this.realRecordsPerPage = this.recordsPerPage;
                        this.realLargestPageSize = this.largestPageSize;
                    } else {
                        this.realRecordsPerPage = randomAccessFile.readInt();
                        this.realLargestPageSize = randomAccessFile.readInt();
                    }
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception exception) {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception2) {
                        JDebug.WARNING((Throwable)exception2);
                    }
                }
                return null;
            }
        }
        return jDbColDescArray;
    }

    private boolean colDescs() {
        int n;
        if (this.colDescsReal.length != this.colDescsTarget.length) {
            return false;
        }
        int n2 = this.colDescsReal.length;
        for (n = 0; n < n2 && this.colDescsReal[n].typeEquals(this.colDescsTarget[n]); ++n) {
        }
        return n >= n2;
    }

    protected boolean hasUpgraded() {
        this.colDescsReal = this.close();
        return (this.colDescsReal == this.colDescsTarget || this.colDescs()) && this.recordsPerPage == this.realRecordsPerPage && this.largestPageSize == this.realLargestPageSize;
    }

    @Override
    public boolean isUpgraded() {
        this.colDescsTarget = this.colDescsNew != null ? this.colDescsNew : this.colDescs;
        return this.path == null || this.noSuchTable() || this.hasUpgraded();
    }

    @Override
    public void upgrade() throws Exception {
        this.migrateTable();
        this.mergeTableHead(this.colDescsTarget);
        this.colDescsReal = this.colDescsTarget;
    }

    public int parseInt(String string, int n) {
        int n2 = n;
        if (string != null && string.length() > 0) {
            try {
                n2 = Integer.parseInt(string.trim(), 10);
            }
            catch (Exception exception) {
                n2 = n;
            }
        }
        return n2;
    }
}

