/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.jacl;

import java.io.Serializable;
import jet.cs.jacl.JPermission;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicy;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.JPrivilege;

public class JPermissionImpl
implements JPermission,
Serializable {
    private JPolicy jPolicy;
    private String name;
    private int type;
    public static final JPermissionImpl VISIBLE = new JPermissionImpl(JPrivilege.VISIBLE);
    public static final JPermissionImpl READ = new JPermissionImpl(JPrivilege.READ);
    public static final JPermissionImpl WRITE = new JPermissionImpl(JPrivilege.WRITE);
    public static final JPermissionImpl EXECUTE = new JPermissionImpl(JPrivilege.EXECUTE);
    public static final JPermissionImpl SCHEDULE = new JPermissionImpl(JPrivilege.SCHEDULE);
    public static final JPermissionImpl DELETE = new JPermissionImpl(JPrivilege.DELETE);
    public static final JPermissionImpl GRANT = new JPermissionImpl(JPrivilege.GRANT);
    public static final JPermissionImpl UPDATE_STATUS = new JPermissionImpl(JPrivilege.UPDATE_STATUS);
    public static final JPermissionImpl EDIT = new JPermissionImpl(JPrivilege.EDIT);
    public static final JPermissionImpl CREATE_ANALYSIS_REPORT = new JPermissionImpl(JPrivilege.CREATE_ANALYSIS_REPORT);
    public static final JPermissionImpl DEPLOY_REPORT = new JPermissionImpl(JPrivilege.DEPLOY_REPORT);
    public static final JPermissionImpl ACCESS_ADVANCED_PROPERTIES = new JPermissionImpl(JPrivilege.ACCESS_ADVANCED_PROPERTIES);
    public static final JPermissionImpl MESSAGE_TABLE_MANIPULATION = new JPermissionImpl(JPrivilege.MESSAGE_TABLE_MANIPULATION);
    public static final int BASIC_NULL_TYPE = -1;
    public static final int BASIC_TYPE = 0;
    public static final int RLS_TYPE = 1;
    public static final int CLS_TYPE = 2;
    public static final String BASIC_NULL_STR = "basic_null";
    public static final String BASIC_STR = "basic";
    public static final String RLS_STR = "RLS";
    public static final String CLS_STR = "CLS";

    private JPermissionImpl(JPrivilege jPrivilege) {
        this.name = jPrivilege.getName();
        this.type = -1;
    }

    public JPermissionImpl(JPrivilege jPrivilege, int n, JPolicy jPolicy) {
        this.name = jPrivilege.getName();
        this.type = n;
        this.jPolicy = jPolicy;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setPolicy(JPolicy jPolicy) {
        this.jPolicy = jPolicy;
    }

    @Override
    public JPolicy getPolicy() {
        if (this.jPolicy == null) {
            return null;
        }
        return (JPolicy)this.jPolicy.clone();
    }

    public void setPolicyIndividual(boolean bl) {
        if (this.jPolicy != null) {
            this.jPolicy.setIndividual(bl);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JPermission union(JPermission jPermission) throws JPolicyLinkException, JPermissionLinkException {
        if (jPermission.typeEquals(this)) {
            if (jPermission.getType() == -1) {
                return this;
            }
            JPolicy jPolicy = jPermission.getPolicy();
            JPolicy jPolicy2 = this.jPolicy.union(jPolicy);
            this.setPolicy(jPolicy2);
            return this;
        }
        throw new JPermissionLinkException(850001, new String[]{this.name}, null);
    }

    @Override
    public JPermission intersect(JPermission jPermission) throws JPolicyLinkException, JPermissionLinkException {
        if (jPermission.typeEquals(this)) {
            if (jPermission.getType() == -1) {
                return this;
            }
            JPolicy jPolicy = jPermission.getPolicy();
            JPolicy jPolicy2 = this.jPolicy.intersect(jPolicy);
            this.setPolicy(jPolicy2);
            return this;
        }
        throw new JPermissionLinkException(850002, new String[]{this.name}, null);
    }

    @Override
    public JPermission mutex(JPermission jPermission) throws JPolicyLinkException, JPermissionLinkException {
        return this;
    }

    @Override
    public boolean calculate(Object object) {
        return false;
    }

    public boolean equals(Object object) {
        if (this.type == -1) {
            return this.typeEquals(object);
        }
        if (this.typeEquals(object)) {
            JPermission jPermission = (JPermission)object;
            if (jPermission.getPolicy() == null) {
                return this.jPolicy == null;
            }
            if (this.jPolicy == null) {
                return jPermission.getPolicy() == null;
            }
            return ((Object)this.jPolicy).equals(jPermission.getPolicy());
        }
        return false;
    }

    @Override
    public boolean typeEquals(Object object) {
        if (object instanceof JPermission) {
            JPermission jPermission = (JPermission)object;
            return this.type == jPermission.getType() && this.name.equals(jPermission.getName());
        }
        return false;
    }

    public String toString() {
        return "JPermission[" + this.name + " : " + this.type + (this.jPolicy == null ? "" : " : " + ((Object)this.jPolicy).toString()) + "]";
    }

    public int hashCode() {
        return super.hashCode();
    }
}

