/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.secinfo;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Principal;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;

public class SecInfoXMLWriter {
    private Vector[] SEDU = new Vector[3];
    private StringBuffer append = new StringBuffer();

    public SecInfoXMLWriter(Vector[] vectorArray) {
        this.SEDU = vectorArray;
        this.writeSecInfo();
    }

    private void SEDU(StringBuffer stringBuffer, BaseUser baseUser) {
        if (stringBuffer == null || baseUser == null) {
            return;
        }
        stringBuffer.append("<user");
        stringBuffer.append(" username=\"" + baseUser.getName() + "\"");
        stringBuffer.append(" email=\"" + this.close(baseUser.getEmail()) + "\"");
        stringBuffer.append(" parentgroups");
        Vector vector = baseUser.getGroupNames();
        this.buffer(stringBuffer, vector);
        stringBuffer.append(" parentroles");
        Vector vector2 = baseUser.getParentRoleNames();
        this.buffer(stringBuffer, vector2);
        stringBuffer.append("/>\n");
    }

    private void append(StringBuffer stringBuffer, BaseRole baseRole) {
        if (stringBuffer == null || baseRole == null) {
            return;
        }
        stringBuffer.append("<role");
        stringBuffer.append(" rolename=\"" + baseRole.getName() + "\"");
        stringBuffer.append(" subusers");
        Vector vector = baseRole.getSubUserNames();
        this.buffer(stringBuffer, vector);
        stringBuffer.append(" parentgroups");
        Vector vector2 = baseRole.getGroupNames();
        this.buffer(stringBuffer, vector2);
        stringBuffer.append(" parentroles");
        Vector vector3 = baseRole.getParentRoleNames();
        this.buffer(stringBuffer, vector3);
        stringBuffer.append(" subroles");
        Vector vector4 = baseRole.getSubRoleNames();
        this.buffer(stringBuffer, vector4);
        stringBuffer.append("/>\n");
    }

    private void charAt(StringBuffer stringBuffer, BaseGroup baseGroup) {
        if (stringBuffer == null || baseGroup == null) {
            return;
        }
        stringBuffer.append("<group");
        stringBuffer.append(" groupname=\"" + baseGroup.getName() + "\"");
        stringBuffer.append(" subusers");
        Vector vector = baseGroup.getUserNames();
        this.buffer(stringBuffer, vector);
        stringBuffer.append(" subroles");
        Vector vector2 = baseGroup.getRoleNames();
        this.buffer(stringBuffer, vector2);
        stringBuffer.append(" parentgroups");
        Vector vector3 = baseGroup.getParentGroupNames();
        this.buffer(stringBuffer, vector3);
        stringBuffer.append(" subgroups");
        Vector vector4 = baseGroup.getSubGroupNames();
        this.buffer(stringBuffer, vector4);
        stringBuffer.append("/>\n");
    }

    private void buffer(StringBuffer stringBuffer, Vector vector) {
        stringBuffer.append("=\"");
        int n = vector.size() - 1;
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        if (!vector.isEmpty()) {
            String string = (String)vector.lastElement();
            stringBuffer.append(string);
        }
        stringBuffer.append("\"");
    }

    public void writeSecInfo() {
        Principal principal;
        int n;
        Vector vector = this.SEDU[0];
        Vector vector2 = this.SEDU[1];
        Vector vector3 = this.SEDU[2];
        this.append.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.append.append("<jreport-users>\n");
        for (n = 0; n < vector.size(); ++n) {
            principal = (BaseUser)vector.elementAt(n);
            this.SEDU(this.append, (BaseUser)principal);
        }
        for (n = 0; n < vector3.size(); ++n) {
            principal = (BaseGroup)vector3.elementAt(n);
            this.charAt(this.append, (BaseGroup)principal);
        }
        for (n = 0; n < vector2.size(); ++n) {
            principal = (BaseRole)vector2.elementAt(n);
            this.append(this.append, (BaseRole)principal);
        }
        this.append.append("</jreport-users>\n");
    }

    public void writeXMLToWriter(Writer writer) throws IOException {
        writer.write(this.append.toString());
        writer.close();
    }

    public void writeXMLToFile(String string) throws IOException, UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8");
        outputStreamWriter.write(this.append.toString());
        outputStreamWriter.close();
    }

    private String close(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            string2 = c == '<' ? string2 + "&lt;" : (c == '&' ? string2 + "&amp;" : string2 + c);
        }
        return string2;
    }
}

