/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.structurengine.engine;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.util.JRLog;
import java.sql.Date;
import java.sql.Time;
import java.util.Hashtable;
import java.util.Locale;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbSecurityContext;
import jet.connect.DbTime;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.ParameterValueList;
import jet.dataengine.api.query.SpecialFields;
import jet.exception.InvalidParameterException;
import jet.formula.ExecutableJavaFormula;
import jet.formula.JavaFormula;
import jet.formula.JavaFormulaContainer;
import jet.formula.ParamDesc;
import jet.icontrols.QueryInfo;
import jet.reportset.JetRptReport;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.structurengine.engine.SReportViewEngine;
import jet.rptservice.structurengine.engine.SRptSetEngine;
import jet.rptservice.util.RawDataQueryEnv;
import jet.rptservice.util.ReportTools;
import jet.universe.JetUUniverse;
import jet.util.ScheduleTools;
import jet.util.nls.NLSApplyParam;

public class SEngineRawDataQueryEnv
extends RawDataQueryEnv {
    private SReportViewEngine LOCAL_LANGUAGE;

    public SEngineRawDataQueryEnv(SReportViewEngine sReportViewEngine, QueryInfo queryInfo) {
        super(sReportViewEngine.getRptSetEngine().getUniverse(), queryInfo);
        this.LOCAL_LANGUAGE = sReportViewEngine;
    }

    public void prepareJavaFormula(JavaFormula javaFormula) {
        SRptSetEngine sRptSetEngine;
        EngineEnv engineEnv;
        Locale locale;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SEngineRawDataQueryEnv.prepareJavaFormula()..., jf: " + javaFormula));
        }
        if ((locale = (engineEnv = (sRptSetEngine = this.LOCAL_LANGUAGE.getRptSetEngine()).getEngineEnv()).getLocale()) == null) {
            locale = Locale.getDefault();
        }
        javaFormula.LOCAL_LANGUAGE(locale.getLanguage());
        DbSecurityContext dbSecurityContext = new DbSecurityContext();
        dbSecurityContext.set(engineEnv.getSecurityContext());
        javaFormula.setSecurityContext(dbSecurityContext);
        javaFormula.REPORT_NAME(sRptSetEngine.getReportSet().getInstName());
        javaFormula.__sys__USERNAME(new DbChar(engineEnv.getUserName()));
        java.util.Date date = new java.util.Date();
        if (date != null) {
            javaFormula.__sys__MODIFIEDDATE(new DbDate(new Date(date.getTime())));
            javaFormula.__sys__MODIFIEDTIME(new DbTime(new Time(date.getTime())));
        }
        javaFormula.setTimeZone(engineEnv.getTimeZone());
        javaFormula.setInformationBusManager(sRptSetEngine.getDataService().getDataServiceConfig().getInformationBusManager());
        ScheduleTools.setDataMapping((JavaFormula)javaFormula, (NLSApplyParam)engineEnv.getNLSParam(), (JetUUniverse)sRptSetEngine.getUniverse(), (QueryInfo)this.queryInfo);
        javaFormula.setJFieldValueNLSManager(sRptSetEngine.getNLSManager());
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)"End of SEngineRawDataQueryEnv.prepareJavaFormula().");
        }
    }

    protected JetRptReport getReportView() {
        return this.LOCAL_LANGUAGE.getReportViewCenter().getOriReportView();
    }

    public CatalogKey getCatalogKey() {
        return this.LOCAL_LANGUAGE.getRptSetEngine().getCatalogKey();
    }

    public JavaFormula getJavaFormula() throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)"SEngineRawDataQueryEnv.getJavaFormula()...");
        }
        JavaFormulaContainer javaFormulaContainer = new JavaFormulaContainer();
        JavaFormula javaFormula = ReportTools.loadJavaFormula((String)this.getQueryInfo().getDatasourceName(), (JetUUniverse)this.unv);
        javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
        javaFormula = this.LOCAL_LANGUAGE.getCFJavaFormula(this.queryInfo.getDatasourceName());
        if (javaFormula != null) {
            javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
        }
        if (this.queryInfo.getDataResoureType() == 2 && (javaFormula = this.LOCAL_LANGUAGE.getFlyJavaFormula(this.queryInfo)) != null) {
            javaFormulaContainer.addJavaFormula((ExecutableJavaFormula)javaFormula);
        }
        this.prepareJavaFormula((JavaFormula)javaFormulaContainer);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SEngineRawDataQueryEnv.getJavaFormula(), return: " + javaFormulaContainer));
        }
        return javaFormulaContainer;
    }

    public ParameterValueList getParamValues() throws DSException, InvalidParameterException {
        Hashtable hashtable = this.LOCAL_LANGUAGE.getParameters();
        if (hashtable == null) {
            return null;
        }
        ParameterValueList parameterValueList = new ParameterValueList();
        for (ParamDesc paramDesc : hashtable.values()) {
            parameterValueList.addParameterValue(paramDesc);
        }
        return parameterValueList;
    }

    public SpecialFields getSpecialFields() {
        SRptSetEngine sRptSetEngine = this.LOCAL_LANGUAGE.getRptSetEngine();
        EngineEnv engineEnv = sRptSetEngine.getEngineEnv();
        SpecialFields specialFields = new SpecialFields();
        specialFields.setUserName(new DbChar(engineEnv.getUserName()));
        java.util.Date date = new java.util.Date();
        specialFields.setModifiedDate(new DbDate(new Date(date.getTime())));
        specialFields.setModifiedTime(new DbTime(new Time(date.getTime())));
        specialFields.setPrintDate(new DbDate(new Date(date.getTime())));
        specialFields.setPrintTime(new DbTime(new Time(date.getTime())));
        return specialFields;
    }
}

