/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.structurengine.engine;

import com.jinfonet.util.JRLog;
import java.util.Hashtable;
import java.util.List;
import jet.JRStopEngineException;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.adapter.AdapterInfo;
import jet.dataservice.api.adapter.DataFragment;
import jet.ireport.osf.OnScreenFilter;
import jet.report.JetRptFilterControl;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.IDataResultInfo;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.exception.JRSInvalidParameterException;
import jet.rptservice.exception.JRTemplateParseException;
import jet.rptservice.pub.ReportDirectInfo;
import jet.rptservice.pub.ReportFullInfo;
import jet.rptservice.structurengine.engine.SReportViewEngine;
import jet.rptservice.structurengine.engine.SRptSetEngine;
import jet.rptservice.structurengine.engine.infocenter.SReportCenter;
import jet.rptservice.structurengine.engine.infocenter.SReportSetCenter;
import jet.rptservice.util.Tools;
import jet.universe.JetUUniverse;

public class SReportEngine {
    private String SEDU;
    private String append = null;
    JetRptReport report = null;
    private SRptSetEngine clear;
    private SReportCenter clearMem = null;
    private Hashtable closeQuerysForSelf = new Hashtable();

    SReportEngine(SRptSetEngine sRptSetEngine, String string) throws JRTemplateParseException {
        this.clear = sRptSetEngine;
        this.SEDU = string;
        JetRptReportSet jetRptReportSet = sRptSetEngine.getReportSet();
        this.report = jetRptReportSet.getReport(string);
        this.append = this.report.getCurViewName();
        SReportSetCenter sReportSetCenter = sRptSetEngine.getRptSetCenter();
        ReportDirectInfo reportDirectInfo = sReportSetCenter.getRptSetDirectInfo().getReportDirectInfo(string);
        ReportFullInfo reportFullInfo = sReportSetCenter.getRptSetFullInfo().getReportFullInfo(string);
        this.clearMem = new SReportCenter(sRptSetEngine.getReportSet().getReport(string), this, reportDirectInfo, reportFullInfo);
        JetRptReport jetRptReport = jetRptReportSet.getReportView(string, this.append);
        JetUUniverse jetUUniverse = sRptSetEngine.getUniverse();
        JDataService jDataService = sRptSetEngine.getDataService();
        EngineEnv engineEnv = sRptSetEngine.getEngineEnv();
        SReportViewEngine sReportViewEngine = new SReportViewEngine(jetRptReport, jetUUniverse, reportDirectInfo, reportFullInfo, jDataService, engineEnv, this);
        this.closeQuerysForSelf.put(this.append, sReportViewEngine);
    }

    public SReportViewEngine getViewEngine(String string) {
        return this.closeQuerysForSelf == null ? null : (SReportViewEngine)this.closeQuerysForSelf.get(string);
    }

    SReportViewEngine getViewEngine() {
        return this.getViewEngine(this.append);
    }

    SReportViewEngine[] getAllViewEngines() {
        return this.closeQuerysForSelf == null ? null : this.closeQuerysForSelf.values().toArray(new SReportViewEngine[0]);
    }

    void prepareStart(boolean bl) throws JRScheduleException, JRStopEngineException {
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        sReportViewEngine.prepareStart(bl);
    }

    public String getReportName() {
        return this.SEDU;
    }

    public JetRptReport getReport() {
        return this.report;
    }

    public String[] getViewNames() {
        return this.closeQuerysForSelf == null ? null : this.closeQuerysForSelf.keySet().toArray(new String[this.closeQuerysForSelf.size()]);
    }

    public SReportCenter getReportCenter() {
        return this.clearMem;
    }

    public SRptSetEngine getRptSetEngine() {
        return this.clear;
    }

    DataFragment getData(String string, AdapterInfo adapterInfo) throws JRScheduleException, JRStopEngineException {
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        return sReportViewEngine == null ? null : sReportViewEngine.getData(string, adapterInfo);
    }

    List getDataContainerDataInfo(String string) throws DSException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SReportEngine.getDataContainerDataInfo()..., dcName: " + string));
        }
        List list = null;
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        if (sReportViewEngine == null) {
            Tools.logTrace((int)6, (Object)"viewEngine is null.");
        } else {
            list = sReportViewEngine.getDataContainerDataInfo(string);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SReportEngine.getDataContainerDataInfo()..., return: " + list));
        }
        return list;
    }

    DataFragment getValueList(String string, int n, AdapterInfo adapterInfo) throws JRScheduleException, JRStopEngineException {
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        return sReportViewEngine == null ? null : sReportViewEngine.getValueList(string, n, adapterInfo);
    }

    int registFilterControlValueList(String string, String string2, boolean bl, int n) throws DSException, JRStopEngineException, JRScheduleException, ConditionException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SReportEngine.registFilterControlValueList()..., filterControlName: " + string + " colName: " + string2 + " includeNull: " + bl));
        }
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        JetRptReport jetRptReport = this.getReport();
        JetRptFilterControl jetRptFilterControl = (JetRptFilterControl)jetRptReport.nameToObject(string);
        if (jetRptFilterControl == null) {
            Tools.logTrace((int)6, (Object)"End of SReportEngine.registFilterControlValueList(), no filter control.");
            JRSInvalidParameterException jRSInvalidParameterException = new JRSInvalidParameterException(250003, (Object[])new String[]{string}, null);
            throw jRSInvalidParameterException;
        }
        int n2 = sReportViewEngine.registForFCValueList((OnScreenFilter)jetRptFilterControl, string2, bl, n);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SReportEngine.registFilterControlValueList(), return: " + n2));
        }
        return n2;
    }

    DataFragment getValueList(int n, AdapterInfo adapterInfo) throws DSException, JRStopEngineException, JRScheduleException, ConditionException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SReportEngine.getValueList()..., valueListId: " + n + " info: " + adapterInfo));
        }
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        DataFragment dataFragment = sReportViewEngine.getFCValueList(n, adapterInfo);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SReportEngine.getValueList(), return: " + dataFragment));
        }
        return dataFragment;
    }

    void unregistFilterControlValueList(int n) throws DSException, JRStopEngineException, JRScheduleException, ConditionException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SReportEngine.unregistFilterControlValueList()..., valueListId: " + n));
        }
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        sReportViewEngine.unregistForFCValueList(n);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)"End of SReportEngine.unregistFilterControlValueList().");
        }
    }

    void closeData(String string) {
        block2: {
            SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
            try {
                sReportViewEngine.closeQuerysForSelf(string, 1);
            }
            catch (JRScheduleException jRScheduleException) {
                if (!JRLog.isTrace((int)5)) break block2;
                JRLog.trace((int)5, (Throwable)jRScheduleException);
            }
        }
    }

    void clearMem() {
        SReportViewEngine[] sReportViewEngineArray = this.getAllViewEngines();
        if (sReportViewEngineArray != null && sReportViewEngineArray.length > 0) {
            for (int i = 0; i < sReportViewEngineArray.length; ++i) {
                sReportViewEngineArray[i].clearMem();
            }
            this.closeQuerysForSelf.clear();
            this.closeQuerysForSelf = null;
        }
        this.clearMem.clearMem();
    }

    IDataResultInfo getDataResultInfo(String string) throws JRScheduleException, JRStopEngineException {
        SReportViewEngine sReportViewEngine = this.getViewEngine(this.append);
        return sReportViewEngine == null ? null : sReportViewEngine.getDataResultInfo(string);
    }
}

