/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.structurengine.engine;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.util.JRLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import jet.JRStopEngineException;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.query.JRawDataQuery;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.JQueryFactory;
import jet.dataservice.api.adapter.AdapterInfo;
import jet.dataservice.api.adapter.DataFragment;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.ExternalEnv;
import jet.rptservice.api.IBLParameterProvider;
import jet.rptservice.api.IDataResultInfo;
import jet.rptservice.api.IQueryParameterProvider;
import jet.rptservice.api.RptSetDirectInfo;
import jet.rptservice.api.RptSetFullInfo;
import jet.rptservice.api.RptSetInfoFactory;
import jet.rptservice.api.RuntimeEnv;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.api.infocenter.IDataSetCenter;
import jet.rptservice.api.infocenter.IReportCenter;
import jet.rptservice.api.infocenter.IReportSetCenter;
import jet.rptservice.api.infocenter.IReportViewCenter;
import jet.rptservice.api.infocenter.InfoCenterProvider;
import jet.rptservice.exception.JRSInvalidParameterException;
import jet.rptservice.pub.LinkInfo;
import jet.rptservice.pub.PrincipalAttributes;
import jet.rptservice.structurengine.engine.SReportEngine;
import jet.rptservice.structurengine.engine.SReportViewEngine;
import jet.rptservice.structurengine.engine.infocenter.SDataSetCenter;
import jet.rptservice.structurengine.engine.infocenter.SReportSetCenter;
import jet.rptservice.structurengine.engine.infocenter.SReportViewCenter;
import jet.rptservice.util.MemoryCacheQueryParameterProvider;
import jet.rptservice.util.QueryParameterProvider;
import jet.rptservice.util.Tools;
import jet.universe.JetUUniverse;
import jet.universe.tools.ParseParametersForQuery;
import jet.universe.tools.ParseParametersForQueryFactory;
import jet.util.JFieldValueNLSManager;
import jet.util.ScheduleTools;

public class SRptSetEngine {
    public static final int ENGINE_TYPE_NORMAL = 0;
    public static final int ENGINE_TYPE_LINK = 1;
    public static final int ENGINE_TYPE_DETAIL = 2;
    public static final int ENGINE_TYPE_GOTODETAIL = 3;
    private int SEDU = 0;
    private PrincipalAttributes access$200;
    private PrincipalAttributes addAll;
    private RptSetDirectInfo append;
    private RptSetFullInfo asList;
    private String clear;
    private CatalogKey clearMem;
    private EngineEnv closeData;
    private JDataService containsKey;
    private JQueryFactory createDataSetCenters;
    private Hashtable createRptSetFullInfo = new Hashtable();
    private Hashtable get = new Hashtable();
    private SReportSetCenter getAllViewEngines;
    private Object getData;
    private ExternalEnv getDataContainerDataInfo;
    private final MemoryCacheQueryParameterProvider getDataResultInfo;
    private final _MemoryCacheBLParamProvider getDataSetCenter = new _MemoryCacheBLParamProvider();
    private Hashtable getDataSetInfo = new Hashtable();

    SRptSetEngine(PrincipalAttributes principalAttributes, String string, CatalogKey catalogKey, RptSetDirectInfo rptSetDirectInfo, String[] stringArray, EngineEnv engineEnv, JDataService jDataService, ExternalEnv externalEnv) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SRptSetEngine()..., unvAttr: " + principalAttributes + " rptSetName: " + string + " catKey: " + catalogKey + " rptSetDirInfo: " + rptSetDirectInfo + " rptNames: " + Tools.toString((Object)stringArray) + " rptSetAttr: " + (rptSetDirectInfo == null ? null : rptSetDirectInfo.getRptSetAttributes()) + " engineEnv: " + engineEnv + " dataService: " + jDataService + " extEnv: " + externalEnv));
        }
        this.access$200 = rptSetDirectInfo.getRptSetAttributes();
        this.addAll = principalAttributes;
        this.clear = string;
        this.clearMem = catalogKey;
        this.closeData = engineEnv;
        this.containsKey = jDataService;
        this.createDataSetCenters = jDataService.getQueryFactory();
        this.getDataContainerDataInfo = externalEnv;
        this.append = rptSetDirectInfo;
        this.asList = RptSetInfoFactory.createRptSetFullInfo((RptSetDirectInfo)rptSetDirectInfo, (JetUUniverse)((JetUUniverse)principalAttributes.getPrincipal()));
        this.getDataResultInfo = new MemoryCacheQueryParameterProvider((IQueryParameterProvider)new QueryParameterProvider((RuntimeEnv)engineEnv, false));
        this.getAllViewEngines = new SReportSetCenter(this, rptSetDirectInfo, this.asList);
        String[] stringArray2 = rptSetDirectInfo.getRawQueryDataSetNames(stringArray);
        this.createDataSetCenters(stringArray2);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                SReportEngine sReportEngine = new SReportEngine(this, stringArray[i]);
                this.createRptSetFullInfo.put(stringArray[i], sReportEngine);
            }
        }
    }

    SRptSetEngine(PrincipalAttributes principalAttributes, String string, CatalogKey catalogKey, RptSetDirectInfo rptSetDirectInfo, String[] stringArray, EngineEnv engineEnv, JDataService jDataService, Object object, ExternalEnv externalEnv) throws JRScheduleException {
        this(principalAttributes, string, catalogKey, rptSetDirectInfo, stringArray, engineEnv, jDataService, externalEnv);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("after this(SRptSetEngine()), engineKey: " + object));
        }
        this.getData = object;
    }

    SRptSetEngine(PrincipalAttributes principalAttributes, PrincipalAttributes principalAttributes2, String string, CatalogKey catalogKey, RptSetDirectInfo rptSetDirectInfo, String string2, EngineEnv engineEnv, JDataService jDataService, LinkInfo linkInfo) throws JRScheduleException {
        this(principalAttributes2, string, catalogKey, rptSetDirectInfo, new String[]{string2}, engineEnv, jDataService, null);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("after this(SRptSetEngine()), linkInfo: " + linkInfo));
        }
        this.SEDU = 1;
        SReportEngine sReportEngine = this.getReportEngine(string2);
        SReportViewEngine[] sReportViewEngineArray = sReportEngine.getAllViewEngines();
        for (int i = 0; i < sReportViewEngineArray.length; ++i) {
            SReportViewCenter sReportViewCenter = sReportViewEngineArray[i].getReportViewCenter();
            sReportViewCenter.setLinkInfo(linkInfo);
        }
    }

    public void createDataSetCenters(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            JetRptReportSet jetRptReportSet = this.getReportSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.get.containsKey(stringArray[i])) continue;
                SDataSetCenter sDataSetCenter = new SDataSetCenter(ScheduleTools.getRawQueryDataSet((String)stringArray[i], (JetRptReportSet)jetRptReportSet), this.asList.getDataSetInfo(stringArray[i]), jetRptReportSet.getInstName(), this.getUniverse(), this.clearMem, this.closeData, this.getExternalEnv(), this.getDataSetCenter, this.createDataSetCenters, this.containsKey);
                this.get.put(stringArray[i], sDataSetCenter);
            }
        }
    }

    public void clearDataSetCenters(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.get.containsKey(stringArray[i])) continue;
                SDataSetCenter sDataSetCenter = (SDataSetCenter)this.get.get(stringArray[i]);
                sDataSetCenter.clearMem();
                this.get.remove(stringArray[i]);
            }
        }
    }

    public int getType() {
        return this.SEDU;
    }

    public SDataSetCenter getDataSetCenter(String string) {
        return (SDataSetCenter)this.get.get(string);
    }

    public String[] getDataSetNames() {
        return this.get.keySet().toArray(new String[0]);
    }

    public String[] getReportNames() {
        return this.createRptSetFullInfo == null ? null : this.createRptSetFullInfo.keySet().toArray(new String[this.createRptSetFullInfo.size()]);
    }

    public SReportEngine getReportEngine(String string) {
        return this.createRptSetFullInfo == null ? null : (SReportEngine)this.createRptSetFullInfo.get(string);
    }

    private SReportEngine[] SEDU() {
        return this.createRptSetFullInfo == null ? null : this.createRptSetFullInfo.values().toArray(new SReportEngine[0]);
    }

    public SReportViewEngine getReportViewEngine(String string, String string2) {
        SReportEngine sReportEngine = this.getReportEngine(string);
        return sReportEngine == null ? null : sReportEngine.getViewEngine(string2);
    }

    SReportViewEngine getReportViewEngine(String string) {
        SReportEngine sReportEngine = this.getReportEngine(string);
        return sReportEngine == null ? null : sReportEngine.getViewEngine();
    }

    public SReportViewEngine[] getAllReportViewEngines() {
        SReportEngine[] sReportEngineArray = this.SEDU();
        if (sReportEngineArray == null) {
            return null;
        }
        ArrayList<SReportViewEngine> arrayList = new ArrayList<SReportViewEngine>();
        for (int i = 0; i < sReportEngineArray.length; ++i) {
            SReportViewEngine[] sReportViewEngineArray = sReportEngineArray[i].getAllViewEngines();
            if (sReportViewEngineArray == null) continue;
            arrayList.addAll(Arrays.asList(sReportViewEngineArray));
        }
        return arrayList.toArray(new SReportViewEngine[0]);
    }

    public SReportSetCenter getRptSetCenter() {
        return this.getAllViewEngines;
    }

    public String getRptSetName() {
        return this.clear;
    }

    public JetRptReportSet getReportSet() {
        return (JetRptReportSet)this.access$200.getPrincipal();
    }

    public JetUUniverse getUniverse() {
        return (JetUUniverse)this.addAll.getPrincipal();
    }

    public CatalogKey getCatalogKey() {
        return this.clearMem;
    }

    public JDataService getDataService() {
        return this.containsKey;
    }

    public EngineEnv getEngineEnv() {
        return this.closeData;
    }

    IQueryParameterProvider getQueryParameterProvider() {
        return this.getDataResultInfo;
    }

    JQueryFactory getQueryFactory() {
        return this.createDataSetCenters;
    }

    JRawDataQuery getRawDataQuery(String string) throws JRScheduleException {
        SDataSetCenter sDataSetCenter = this.getDataSetCenter(string);
        return sDataSetCenter.getRawDataQuery();
    }

    Integer getRawDataQueryId(String string) throws DSException, JRScheduleException, JRStopEngineException {
        SDataSetCenter sDataSetCenter = this.getDataSetCenter(string);
        return sDataSetCenter.getRawDataQueryId();
    }

    DataFragment getData(String string, String string2, AdapterInfo adapterInfo) throws JRScheduleException, JRStopEngineException {
        SReportEngine sReportEngine = this.getReportEngine(string);
        return sReportEngine == null ? null : sReportEngine.getData(string2, adapterInfo);
    }

    List getDataContainerDataInfo(String string, String string2) throws JRScheduleException, DSException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SRptSetEngine.getDataContainerDataInfo()..., rptName: " + string + " dcName: " + string2));
        }
        List list = null;
        SReportEngine sReportEngine = this.getReportEngine(string);
        if (sReportEngine == null) {
            JRLog.trace((int)6, (Object)"rptEngine is null.");
        } else {
            list = sReportEngine.getDataContainerDataInfo(string2);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SRptSetEngine.getDataContainerDataInfo()..., return: " + list));
        }
        return list;
    }

    DataFragment getValueList(String string, String string2, int n, AdapterInfo adapterInfo) throws JRScheduleException, JRStopEngineException {
        SReportEngine sReportEngine = this.getReportEngine(string);
        return sReportEngine == null ? null : sReportEngine.getValueList(string2, n, adapterInfo);
    }

    int registFilterControlValueList(String string, String string2, String string3, boolean bl, int n) throws DSException, JRStopEngineException, JRScheduleException, ConditionException {
        SReportEngine sReportEngine;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SRptSetEngine.registFilterControlValueList()..., rptName: " + string + " filterControlName: " + string2 + " colName: " + string3));
        }
        if ((sReportEngine = this.getReportEngine(string)) == null) {
            JRLog.trace((int)6, (Object)"End of SRptSetEngine.registFilterControlValueList(), no report engine.");
            JRSInvalidParameterException jRSInvalidParameterException = new JRSInvalidParameterException(250002, (Object[])new String[]{string}, null);
            throw jRSInvalidParameterException;
        }
        int n2 = sReportEngine.registFilterControlValueList(string2, string3, bl, n);
        this.getDataSetInfo.put(new Integer(n2), string);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SRptSetEngine.registFilterControlValueList(), return: " + n2));
        }
        return n2;
    }

    DataFragment getValueList(int n, AdapterInfo adapterInfo) throws DSException, JRStopEngineException, JRScheduleException, ConditionException {
        Integer n2;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SRptSetEngine.getValueList..., valueListId: " + n + " info: " + adapterInfo));
        }
        if (!this.getDataSetInfo.containsKey(n2 = new Integer(n))) {
            JRLog.trace((int)6, (Object)("End of SRptSetEngine.getValueList(), valueListId " + n + " has not been registered."));
            JRSInvalidParameterException jRSInvalidParameterException = new JRSInvalidParameterException(250036, (Object[])new String[]{String.valueOf(n)}, null);
            throw jRSInvalidParameterException;
        }
        String string = (String)this.getDataSetInfo.get(n2);
        SReportEngine sReportEngine = this.getReportEngine(string);
        DataFragment dataFragment = sReportEngine.getValueList(n, adapterInfo);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SRptSetEngine.getValueList(), return: " + dataFragment));
        }
        return dataFragment;
    }

    void unregistFilterControlValueList(int n) throws DSException, JRStopEngineException, JRScheduleException, ConditionException {
        Object object;
        Integer n2;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SRptSetEngine.unregistFilterControlValueList()..., valueListId: " + n));
        }
        if (!this.getDataSetInfo.containsKey(n2 = new Integer(n))) {
            JRLog.trace((int)6, (Object)("End of SRptSetEngine.getValueList(), valueListId " + n + " has not been registered."));
            object = new JRSInvalidParameterException(250036, (Object[])new String[]{String.valueOf(n)}, null);
        }
        object = (String)this.getDataSetInfo.get(n2);
        SReportEngine sReportEngine = this.getReportEngine((String)object);
        sReportEngine.unregistFilterControlValueList(n);
        this.getDataSetInfo.remove(n2);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)"End of SRptSetEngine.unregistFilterControlValueList().");
        }
    }

    void closeData(String string, String string2) {
        SReportEngine sReportEngine = this.getReportEngine(string);
        if (sReportEngine != null) {
            sReportEngine.closeData(string2);
        }
    }

    public void initReport(String string) throws JRScheduleException {
        this.initReport(string, false);
    }

    public void initReport(String string, boolean bl) throws JRScheduleException {
        SReportEngine sReportEngine = this.getReportEngine(string);
        try {
            sReportEngine.prepareStart(bl);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException((Throwable)jRStopEngineException);
        }
    }

    public void initDataSets(String[] stringArray) throws JRScheduleException {
        if (stringArray != null && stringArray.length > 0) {
            JetUUniverse jetUUniverse = this.getUniverse();
            for (int i = 0; i < stringArray.length; ++i) {
                SDataSetCenter sDataSetCenter = (SDataSetCenter)this.get.get(stringArray[i]);
                if (sDataSetCenter == null) continue;
                sDataSetCenter.refreshRecSecurity(jetUUniverse, false);
                for (SReportEngine sReportEngine : this.createRptSetFullInfo.values()) {
                    sDataSetCenter.refresh(sReportEngine);
                }
            }
        }
    }

    public void initDataSets() throws JRScheduleException {
        String[] stringArray = this.get.keySet().toArray(new String[0]);
        this.initDataSets(stringArray);
    }

    void init() throws JRScheduleException {
        String[] stringArray = this.getReportNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.initReport(stringArray[i]);
            }
        }
        this.initDataSets();
    }

    public InfoCenterProvider getInfoCenterProvider() {
        return new InfoCenterProviderImpl();
    }

    public RptSetDirectInfo getRptSetDirInfo() {
        return this.append;
    }

    public RptSetFullInfo getRptSetFullInfo() {
        return this.asList;
    }

    public Object getEngineKey() {
        return this.getData;
    }

    public JFieldValueNLSManager getNLSManager() {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)"SRptSetEngine.getNLSManager()...");
        }
        JFieldValueNLSManager jFieldValueNLSManager = this.getUniverse().getNLSManager(this.closeData.getLocale());
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of SRptSetEngine.getNLSManager()..., return: " + jFieldValueNLSManager));
        }
        return jFieldValueNLSManager;
    }

    public ExternalEnv getExternalEnv() {
        return this.getDataContainerDataInfo;
    }

    void clearMem() {
        String[] stringArray;
        this.getDataResultInfo.reset();
        this.getDataSetCenter.reset();
        SReportEngine[] sReportEngineArray = this.SEDU();
        if (sReportEngineArray != null && sReportEngineArray.length > 0) {
            for (int i = 0; i < sReportEngineArray.length; ++i) {
                sReportEngineArray[i].clearMem();
            }
        }
        if ((stringArray = this.getDataSetNames()) != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                SDataSetCenter sDataSetCenter = this.getDataSetCenter(stringArray[i]);
                sDataSetCenter.clearMem();
            }
            this.get.clear();
            this.get = null;
        }
        this.getAllViewEngines.clearMem();
    }

    IDataResultInfo getDataResultInfo(String string, String string2) throws JRScheduleException, JRStopEngineException {
        SReportEngine sReportEngine = this.getReportEngine(string);
        return sReportEngine == null ? null : sReportEngine.getDataResultInfo(string2);
    }

    private class _MemoryCacheBLParamProvider
    implements IBLParameterProvider {
        HashMap cache = new HashMap();

        private _MemoryCacheBLParamProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getQueryParamNames(JetUUniverse jetUUniverse, String string, String string2, int n, String string3, SecurityData securityData, String string4) throws DSException {
            List list = this.CreateParseParametersForQuery(jetUUniverse, string, string2, n, string3, securityData, string4);
            String[] stringArray = null;
            _MemoryCacheBLParamProvider _MemoryCacheBLParamProvider2 = this;
            synchronized (_MemoryCacheBLParamProvider2) {
                if (this.cache.containsKey(list)) {
                    stringArray = (String[])this.cache.get(list);
                } else {
                    ParseParametersForQuery parseParametersForQuery = ParseParametersForQueryFactory.CreateParseParametersForQuery((JetUUniverse)jetUUniverse, (String)string, (String)string2, (int)n, (String)string3, (SecurityData)securityData, (String)string4);
                    try {
                        stringArray = parseParametersForQuery.getParameterNamesInQuery();
                    }
                    catch (DSException dSException) {
                        JRLog.trace((int)4, (Throwable)dSException);
                    }
                    this.cache.put(list, stringArray);
                }
            }
            return stringArray;
        }

        private List CreateParseParametersForQuery(JetUUniverse jetUUniverse, String string, String string2, int n, String string3, SecurityData securityData, String string4) {
            return new ArrayList<Object>(Arrays.asList(jetUUniverse, string, string2, new Integer(n), string3, securityData, string4));
        }

        private synchronized void reset() {
            if (!this.cache.isEmpty()) {
                List[] listArray = this.cache.keySet().toArray(new List[0]);
                this.cache.clear();
                for (int i = 0; i < listArray.length; ++i) {
                    listArray[i].clear();
                }
            }
        }
    }

    private class InfoCenterProviderImpl
    implements InfoCenterProvider {
        private InfoCenterProviderImpl() {
        }

        public IReportSetCenter getRptSetCenter() {
            return SRptSetEngine.this.getAllViewEngines;
        }

        public IDataSetCenter getDataSetCenter(String string) {
            return SRptSetEngine.this.getDataSetCenter(string);
        }

        public IReportCenter getReportCenter(String string) {
            SReportEngine sReportEngine = SRptSetEngine.this.getReportEngine(string);
            return sReportEngine == null ? null : sReportEngine.getReportCenter();
        }

        public IReportViewCenter getReportViewCenter(String string, String string2) {
            SReportViewEngine sReportViewEngine = SRptSetEngine.this.getReportViewEngine(string, string2);
            return sReportViewEngine == null ? null : sReportViewEngine.getReportViewCenter();
        }
    }
}

