/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.structurengine.engine;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import com.jinfonet.validation.ValidationException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.JRException;
import jet.JRStopEngineException;
import jet.connect.DbChar;
import jet.connect.Record;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.QueryInfoImpl;
import jet.dataengine.api.DSException;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.tuple.IBooleanExpression;
import jet.dataengine.api.query.MappingNameBindInfo;
import jet.dataservice.api.BVToRstInfo;
import jet.dataservice.api.DetailBVDataInfo;
import jet.dataservice.api.DetailDataInfoFactory;
import jet.dataservice.api.GoDetailInfo;
import jet.dataservice.api.JDataService;
import jet.dataservice.api.adapter.AdapterInfo;
import jet.dataservice.api.adapter.DataFragment;
import jet.exception.InvalidParameterException;
import jet.icontrols.QueryInfo;
import jet.ireport.IDataContainer;
import jet.ireport.IReport;
import jet.report.JetRptFilterControl;
import jet.report.JetRptObject;
import jet.report.JetRptSortContainer;
import jet.report.filter.JetFilterExpression;
import jet.report.filter.convert.CvIExpression;
import jet.report.formula.JetRptAbstractFormula;
import jet.report.onTheFlyFormula.JetRptFlyFormula;
import jet.report.onTheFlyFormula.JetRptFlyMeasure;
import jet.report.onTheFlyFormula.Scope;
import jet.reportLogic.action.ActionException;
import jet.reportLogic.objectInfo.FlyFormulaInfo;
import jet.reportLogic.objectInfo.FlyMeasureInfo;
import jet.reportLogic.objectLogic.DataContainerLogic;
import jet.reportLogic.objectLogic.DisplayNameAlreadyExistsException;
import jet.reportLogic.objectLogic.DynamicParameterException;
import jet.reportLogic.objectLogic.JetFilterExpLogic;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.OnTheFlyFormulaMeasureLogic;
import jet.reportLogic.objectLogic.OnTheFlyParameterLogic;
import jet.reportLogic.objectLogic.resourceLogic.ResourceTool;
import jet.reportLogic.service.ActionManagerForService;
import jet.reportLogic.service.DataSetActionResult;
import jet.reportLogic.service.ReportSetActionResult;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.ActionWithValueInfo;
import jet.rptservice.api.EngineEnv;
import jet.rptservice.api.ExternalEnv;
import jet.rptservice.api.FlyResourceScope;
import jet.rptservice.api.IConditionControlExpander;
import jet.rptservice.api.IDataResultInfo;
import jet.rptservice.api.IDataSourceInfo;
import jet.rptservice.api.IDetailInfo;
import jet.rptservice.api.IDynamicQueryInfo;
import jet.rptservice.api.ResultSetProvidor;
import jet.rptservice.api.RptSetDirectInfo;
import jet.rptservice.api.RptSetFullInfo;
import jet.rptservice.api.RuntimeEnv;
import jet.rptservice.api.SRptSetActionResult;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.api.infocenter.IReportViewCenter;
import jet.rptservice.design.AbstractActionRst;
import jet.rptservice.design.ActionParameter;
import jet.rptservice.design.ActionParser;
import jet.rptservice.design.StructureCompRst;
import jet.rptservice.design.StructureRptRst;
import jet.rptservice.design.StructureRptSetRst;
import jet.rptservice.design.validation.ParseDHTMLActionParameterTool;
import jet.rptservice.exception.JRSInvalidParameterException;
import jet.rptservice.impl.PropValueProviderImpl;
import jet.rptservice.pub.LinkInfo;
import jet.rptservice.pub.LinkReportContext;
import jet.rptservice.pub.LinkToContentContext;
import jet.rptservice.pub.LinkToContentInfo;
import jet.rptservice.pub.LinkToReportContext;
import jet.rptservice.pub.PrincipalAttributes;
import jet.rptservice.structurengine.action.SActionExecutor;
import jet.rptservice.structurengine.action.SActionRst;
import jet.rptservice.structurengine.api.StructureJetEngine;
import jet.rptservice.structurengine.engine.SEngineRawDataQueryEnv;
import jet.rptservice.structurengine.engine.SReportEngine;
import jet.rptservice.structurengine.engine.SReportViewEngine;
import jet.rptservice.structurengine.engine.SRptSetEngine;
import jet.rptservice.structurengine.engine.helper.ActionHelper;
import jet.rptservice.structurengine.engine.helper.ScheduleHelper;
import jet.rptservice.structurengine.engine.infocenter.SReportViewCenter;
import jet.rptservice.util.LinkToContentValueProvider;
import jet.rptservice.util.RawDataQueryEnv;
import jet.rptservice.util.ReportTools;
import jet.rptservice.util.Tools;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLNode;
import jet.util.DbValueComparer;
import jet.util.link.PropValueProvider;

public class StructureJetEngineImpl
implements StructureJetEngine {
    private CatalogKey SEDU;
    private JDataService add;
    private EngineEnv addFlyParameter;
    private SRptSetEngine addOnTheFlyFormula;
    private LinkInfo addOnTheFlyMeasure;

    public StructureJetEngineImpl(PrincipalAttributes principalAttributes, String string, RptSetDirectInfo rptSetDirectInfo, String[] stringArray, EngineEnv engineEnv, JDataService jDataService, CatalogKey catalogKey) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl()..., rptSetName: " + string + " rptNames: " + Tools.toString((Object)stringArray) + " engineEnv: " + engineEnv + " dataService: " + jDataService + " catKey: " + catalogKey));
        }
        PrincipalAttributes principalAttributes2 = rptSetDirectInfo.getRptSetAttributes();
        this.SEDU(principalAttributes2, principalAttributes, engineEnv, jDataService, catalogKey);
        this.addOnTheFlyFormula = new SRptSetEngine(principalAttributes, string, catalogKey, rptSetDirectInfo, stringArray, engineEnv, jDataService, null);
    }

    public StructureJetEngineImpl(PrincipalAttributes principalAttributes, String string, RptSetDirectInfo rptSetDirectInfo, String[] stringArray, EngineEnv engineEnv, JDataService jDataService, CatalogKey catalogKey, Object object, ExternalEnv externalEnv) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl()..., rptSetName: " + string + " rptNames: " + Tools.toString((Object)stringArray) + " engineEnv: " + engineEnv + " dataService: " + jDataService + " catKey: " + catalogKey + " engineKey: " + object + " extEnv: " + externalEnv));
        }
        PrincipalAttributes principalAttributes2 = rptSetDirectInfo.getRptSetAttributes();
        this.SEDU(principalAttributes2, principalAttributes, engineEnv, jDataService, catalogKey);
        this.addOnTheFlyFormula = new SRptSetEngine(principalAttributes, string, catalogKey, rptSetDirectInfo, stringArray, engineEnv, jDataService, object, externalEnv);
    }

    public StructureJetEngineImpl(PrincipalAttributes principalAttributes, String string, RptSetDirectInfo rptSetDirectInfo, String string2, EngineEnv engineEnv, JDataService jDataService, CatalogKey catalogKey, LinkInfo linkInfo) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl()..., rptSetName: " + string + " rptName: " + string2 + " engineEnv: " + engineEnv + " dataService: " + jDataService + " catKey: " + catalogKey + " linkInfo: " + linkInfo));
        }
        PrincipalAttributes principalAttributes2 = rptSetDirectInfo.getRptSetAttributes();
        this.SEDU(principalAttributes2, principalAttributes, engineEnv, jDataService, catalogKey);
        this.addOnTheFlyMeasure = linkInfo;
        this.addOnTheFlyFormula = new SRptSetEngine(principalAttributes2, principalAttributes, string, catalogKey, rptSetDirectInfo, string2, engineEnv, jDataService, linkInfo);
    }

    private void SEDU(PrincipalAttributes principalAttributes, PrincipalAttributes principalAttributes2, EngineEnv engineEnv, JDataService jDataService, CatalogKey catalogKey) {
        this.add = jDataService;
        this.SEDU = catalogKey;
        this.addFlyParameter = engineEnv;
    }

    @Override
    public void close() {
        if (JRLog.isTrace((int)5)) {
            JRLog.trace((int)5, (Object)("StructureJetEngineImpl.close()..., this: " + this));
        }
        if (this.addOnTheFlyFormula != null) {
            JetRptReportSet jetRptReportSet;
            if (this.addFlyParameter != null && this.addFlyParameter.getRuntimeQueryInfoProvider() != null) {
                jetRptReportSet = this.addFlyParameter.getRuntimeQueryInfoProvider();
                JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
                Vector vector = jetUUniverse.getAllDatabaseNames();
                for (String string : vector) {
                    Vector vector2;
                    JetUDatabase jetUDatabase = jetUUniverse.getDatabase(string);
                    if (jetUDatabase == null || (vector2 = jetUDatabase.getQueries()) == null) continue;
                    for (JetUQueriable jetUQueriable : vector2) {
                        String string2 = jetUQueriable.getResourceName();
                        IDynamicQueryInfo iDynamicQueryInfo = jetRptReportSet.getDynamicQueryInfo(string, string2);
                        if (iDynamicQueryInfo == null || iDynamicQueryInfo.getType() != 3) continue;
                        ResultSetProvidor resultSetProvidor = iDynamicQueryInfo.getResultSetProvider();
                        resultSetProvidor.close();
                    }
                }
            }
            jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
            this.addOnTheFlyFormula.clearMem();
            this.addOnTheFlyFormula = null;
        }
        if (JRLog.isTrace((int)5)) {
            JRLog.trace((int)5, (Object)"End of StructureJetEngineImpl.close()");
        }
    }

    private void add(int n, Hashtable hashtable) throws JRScheduleException {
        Object object;
        JetRptReportSet jetRptReportSet;
        Tools.logTrace((int)6, (Object)("StructureJetEngine.validateAction()..., op: " + n + " params = " + hashtable));
        String string = (String)hashtable.get("rpt_name");
        String string2 = (String)hashtable.get("view_name");
        if (string == null || string2 == null) {
            jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
            if (string == null) {
                string = jetRptReportSet.getCurReportId();
                hashtable.put("rpt_name", string);
            }
            if (string2 == null) {
                object = jetRptReportSet.getReport(string);
                string2 = object.getCurViewName();
                hashtable.put("view_name", string2);
            }
        }
        jetRptReportSet = null;
        try {
            jetRptReportSet = new ActionParameter(n, hashtable);
        }
        catch (InvalidParameterException invalidParameterException) {
            JRLog.trace((int)4, (Throwable)invalidParameterException);
            throw new JRScheduleException((Throwable)invalidParameterException);
        }
        object = this.addOnTheFlyFormula.getReportViewEngine(string, string2).getReportViewCenter();
        ActionParser actionParser = new ActionParser((ActionParameter)jetRptReportSet, this.addOnTheFlyFormula.getUniverse(), ((SReportViewCenter)object).getOriReportView());
        SActionExecutor sActionExecutor = new SActionExecutor((ActionParameter)jetRptReportSet, this.addOnTheFlyFormula);
        try {
            sActionExecutor.validateAction(n, (ActionParameter)jetRptReportSet, actionParser);
        }
        catch (ValidationException validationException) {
            throw new JRScheduleException(250032, (Object[])new String[]{""}, (Throwable)validationException);
        }
        Tools.logTrace((int)6, (Object)"End of StructureJetEngine.validateAction().");
    }

    @Override
    public SRptSetActionResult doAction(int n, Hashtable hashtable) throws JRScheduleException {
        SReportViewCenter sReportViewCenter;
        Object object;
        JetRptReportSet jetRptReportSet;
        Tools.logTrace((int)6, (Object)("StructureJetEngineImpl.doAction()..., op: " + n + " params = " + Tools.toString((Object)hashtable)));
        this.add(n, hashtable);
        String string = (String)hashtable.get("rpt_name");
        String string2 = (String)hashtable.get("view_name");
        if (string == null || string2 == null) {
            jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
            if (string == null) {
                string = jetRptReportSet.getCurReportId();
                hashtable.put("rpt_name", string);
            }
            if (string2 == null) {
                object = jetRptReportSet.getReport(string);
                string2 = object.getCurViewName();
                hashtable.put("view_name", string2);
            }
        }
        jetRptReportSet = null;
        try {
            jetRptReportSet = new ActionParameter(n, hashtable);
        }
        catch (InvalidParameterException invalidParameterException) {
            JRLog.trace((int)4, (Throwable)invalidParameterException);
            throw new JRScheduleException((Throwable)invalidParameterException);
        }
        object = new SActionExecutor((ActionParameter)jetRptReportSet, this.addOnTheFlyFormula);
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string, string2);
        SReportViewCenter sReportViewCenter2 = sReportViewCenter = sReportViewEngine.getReportViewCenter();
        if (n == 0) {
            sReportViewCenter2 = (SReportViewCenter)sReportViewCenter.getActionManager().getUndoActionRVC();
        } else if (n == 1) {
            sReportViewCenter2 = (SReportViewCenter)sReportViewCenter.getActionManager().getRedoActionRVC();
        }
        AbstractActionRst abstractActionRst = null;
        try {
            abstractActionRst = object.execute();
        }
        catch (ConditionException conditionException) {
            JRLog.trace((int)4, (Throwable)conditionException);
            throw new JRScheduleException((Throwable)conditionException);
        }
        catch (JRScheduleException jRScheduleException) {
            JRLog.trace((int)4, (Throwable)jRScheduleException);
            throw jRScheduleException;
        }
        catch (ActionException actionException) {
            JRLog.trace((int)4, (Throwable)actionException);
            throw new JRScheduleException((Throwable)actionException);
        }
        Tools.logTrace((int)6, (Object)("SActionExecutor.execute() return: " + Tools.toString((Object)abstractActionRst)));
        ReportSetActionResult reportSetActionResult = abstractActionRst.getReportSetActionResult();
        ScheduleHelper scheduleHelper = new ScheduleHelper(this.addOnTheFlyFormula);
        scheduleHelper.afterDoAction(string, string2, reportSetActionResult);
        StructureRptSetRst structureRptSetRst = abstractActionRst.getStructureRptSetRst(this.addOnTheFlyFormula.getReportSet(), (IReportViewCenter)sReportViewCenter2);
        new ActionHelper(this.addOnTheFlyFormula).fillRefComponent(structureRptSetRst);
        Tools.logTrace((int)6, (Object)("End of StructureJetEngineImpl.doAction()..., return: " + structureRptSetRst));
        return structureRptSetRst;
    }

    @Override
    public DataFragment getData(String string, String string2, AdapterInfo adapterInfo) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.getData()..., rptName: " + string + " dcName: " + string2));
        }
        DataFragment dataFragment = null;
        try {
            dataFragment = this.addOnTheFlyFormula.getData(string, string2, adapterInfo);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException((Throwable)jRStopEngineException);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.getData(), return: " + dataFragment));
        }
        return dataFragment;
    }

    @Override
    public List getDataContainerDataInfo(String string, String string2) throws JRScheduleException, DSException {
        Tools.logTrace((int)6, (Object)("StructureJetEngineImpl.getDataContainerDataInfo()..., rptName: " + string + " dcName: " + string2));
        List list = this.addOnTheFlyFormula.getDataContainerDataInfo(string, string2);
        Tools.logTrace((int)6, (Object)("End of StructureJetEngineImpl.getDataContainerDataInfo()..., return: " + list));
        return list;
    }

    @Override
    public DataFragment getValueList(String string, String string2, int n, AdapterInfo adapterInfo) throws JRScheduleException {
        try {
            return this.addOnTheFlyFormula.getValueList(string, string2, n, adapterInfo);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException((Throwable)jRStopEngineException);
        }
    }

    @Override
    public int registFilterControlValueList(String string, String string2, String string3, boolean bl, int n) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.registFilterControlValueList()..., rptName: " + string + " filterControlName: " + string2 + " colName: " + string3 + " includeNull: " + bl));
        }
        int n2 = -1;
        try {
            n2 = this.addOnTheFlyFormula.registFilterControlValueList(string, string2, string3, bl, n);
        }
        catch (DSException dSException) {
            throw new JRScheduleException((Throwable)dSException);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException((Throwable)jRStopEngineException);
        }
        catch (ConditionException conditionException) {
            throw new JRScheduleException((Throwable)conditionException);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.registFilterControlValueList(), return: " + n2));
        }
        return n2;
    }

    @Override
    public DataFragment getValueList(int n, AdapterInfo adapterInfo) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.getValueList()..., valueListId: " + n + " info: " + adapterInfo));
        }
        DataFragment dataFragment = null;
        try {
            dataFragment = this.addOnTheFlyFormula.getValueList(n, adapterInfo);
        }
        catch (DSException dSException) {
            throw new JRScheduleException((Throwable)dSException);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException((Throwable)jRStopEngineException);
        }
        catch (ConditionException conditionException) {
            throw new JRScheduleException((Throwable)conditionException);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.getValueList(), return: " + dataFragment));
        }
        return dataFragment;
    }

    @Override
    public void unregistFilterControlValueList(int n) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.unregistFilterControlValueList()..., valueListId: " + n));
        }
        try {
            this.addOnTheFlyFormula.unregistFilterControlValueList(n);
        }
        catch (DSException dSException) {
            throw new JRScheduleException((Throwable)dSException);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException((Throwable)jRStopEngineException);
        }
        catch (ConditionException conditionException) {
            throw new JRScheduleException((Throwable)conditionException);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.unregistFilterControlValueList(), return: " + n));
        }
    }

    private SReportViewEngine addFlyParameter() {
        JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
        String string = jetRptReportSet.getCurReportId();
        return this.addOnTheFlyFormula(string);
    }

    private SReportViewEngine addOnTheFlyFormula(String string) {
        SReportEngine sReportEngine = this.addOnTheFlyFormula.getReportEngine(string);
        if (sReportEngine == null) {
            return null;
        }
        String string2 = sReportEngine.getReport().getCurViewName();
        return this.addOnTheFlyMeasure(string, string2);
    }

    private SReportViewEngine addOnTheFlyMeasure(String string, String string2) {
        return this.addOnTheFlyFormula.getReportViewEngine(string, string2);
    }

    private SReportViewCenter afterDoAction() {
        JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
        String string = jetRptReportSet.getCurReportId();
        return this.append(string);
    }

    private SReportViewCenter append(String string) {
        SReportEngine sReportEngine = this.addOnTheFlyFormula.getReportEngine(string);
        if (sReportEngine == null) {
            return null;
        }
        String string2 = sReportEngine.getReport().getCurViewName();
        return this.asList(string, string2);
    }

    private SReportViewCenter asList(String string, String string2) {
        SReportViewEngine sReportViewEngine = this.addOnTheFlyMeasure(string, string2);
        return sReportViewEngine == null ? null : sReportViewEngine.getReportViewCenter();
    }

    private ActionManagerForService canBackward() {
        SReportViewCenter sReportViewCenter = this.afterDoAction();
        ActionManagerForService actionManagerForService = sReportViewCenter.getActionManager();
        return actionManagerForService;
    }

    private ActionManagerForService canForward(String string) {
        SReportViewCenter sReportViewCenter = this.append(string);
        ActionManagerForService actionManagerForService = sReportViewCenter.getActionManager();
        return actionManagerForService;
    }

    @Override
    public boolean canUndo() {
        return this.canBackward().canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.canBackward().canRedo();
    }

    @Override
    public boolean canForward(int n) {
        Tools.logTrace((int)6, (Object)("StructureJetEngine.canForward()..., filterControlType: " + n));
        boolean bl = this.afterDoAction().canForward(this.canRedo(n));
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.canForward(), return: " + bl));
        }
        return bl;
    }

    @Override
    public boolean canBack(int n) {
        Tools.logTrace((int)6, (Object)("StructureJetEngine.canBack()..., filterControlType: " + n));
        boolean bl = this.afterDoAction().canBackward(this.canRedo(n));
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.canBack(), return: " + bl));
        }
        return bl;
    }

    private int canRedo(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            default: {
                JRLog.trace((int)6, (Object)"invalid filter control type.");
                return -1;
            }
        }
        return n2;
    }

    @Override
    public SRptSetActionResult undo() throws JRScheduleException {
        Tools.logTrace((int)6, (Object)"StructureJetEngine.undo()...");
        Hashtable hashtable = new Hashtable();
        SRptSetActionResult sRptSetActionResult = this.doAction(0, hashtable);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.undo(), return: " + sRptSetActionResult));
        }
        return sRptSetActionResult;
    }

    @Override
    public SRptSetActionResult redo() throws JRScheduleException {
        Tools.logTrace((int)6, (Object)"StructureJetEngine.redo()...");
        Hashtable hashtable = new Hashtable();
        SRptSetActionResult sRptSetActionResult = this.doAction(1, hashtable);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.redo(), return: " + sRptSetActionResult));
        }
        return sRptSetActionResult;
    }

    @Override
    public SRptSetActionResult refresh() throws JRScheduleException {
        Tools.logTrace((int)6, (Object)"StructureJetEngine.refresh()...");
        ActionHelper actionHelper = new ActionHelper(this.addOnTheFlyFormula);
        StructureRptSetRst structureRptSetRst = actionHelper.refresh();
        if (structureRptSetRst != null) {
            JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getRptSetCenter().getRptSet();
            String string = jetRptReportSet.getCurReportId();
            JetRptReport jetRptReport = jetRptReportSet.getReport(string);
            String string2 = jetRptReport.getCurViewName();
            ReportSetActionResult reportSetActionResult = structureRptSetRst.getReportSetActionResult(this.addOnTheFlyFormula.getInfoCenterProvider());
            DataSetActionResult[] dataSetActionResultArray = reportSetActionResult.getDataSetActionResults();
            if (dataSetActionResultArray != null && dataSetActionResultArray.length > 0) {
                for (int i = 0; i < dataSetActionResultArray.length; ++i) {
                    dataSetActionResultArray[i].setIsRefreshData(true);
                }
            }
            new ScheduleHelper(this.addOnTheFlyFormula).afterDoAction(string, string2, reportSetActionResult);
            actionHelper.fillRefComponent(structureRptSetRst);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.refresh(), return: " + structureRptSetRst));
        }
        return structureRptSetRst;
    }

    @Override
    public SRptSetActionResult changeParameterValues(String[] stringArray) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngine.changeParameterValues(), paramNames: " + Tools.toString((Object)stringArray)));
        }
        if (stringArray == null || stringArray.length == 0) {
            Tools.logTrace((int)6, (Object)"End of StructureJetEngine.changeParameterValues(), no parameter value changed, return null.");
            return null;
        }
        ActionHelper actionHelper = new ActionHelper(this.addOnTheFlyFormula);
        StructureRptSetRst structureRptSetRst = actionHelper.changeParameters(stringArray);
        JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getRptSetCenter().getRptSet();
        String string = jetRptReportSet.getCurReportId();
        JetRptReport jetRptReport = jetRptReportSet.getReport(string);
        String string2 = jetRptReport.getCurViewName();
        ReportSetActionResult reportSetActionResult = structureRptSetRst.getReportSetActionResult(this.addOnTheFlyFormula.getInfoCenterProvider());
        new ScheduleHelper(this.addOnTheFlyFormula).afterDoAction(string, string2, reportSetActionResult);
        actionHelper.fillRefComponent(structureRptSetRst);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.changeParameterValues(), return: " + structureRptSetRst));
        }
        return structureRptSetRst;
    }

    @Override
    public SRptSetActionResult changeExternalEnv(String string, String[] stringArray, boolean bl) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("changeExternalEnv(), influenceDcName: " + Tools.toString((Object)stringArray) + " isInfluenceMetadata: " + bl));
        }
        if (stringArray == null || stringArray.length == 0) {
            Tools.logTrace((int)6, (Object)"End of StructureJetEngine.changeExternalEnv(), no influence data container, return null.");
            return null;
        }
        JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getRptSetCenter().getRptSet();
        JetRptReport jetRptReport = jetRptReportSet.getReport(string);
        String string2 = jetRptReport.getCurViewName();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        SRptSetActionResult sRptSetActionResult = null;
        if (bl) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("rpt_name", string);
            hashtable.put("view_name", string2);
            hashtable.put("comp_name", arrayList);
            sRptSetActionResult = this.doAction(141, hashtable);
        } else {
            ActionHelper actionHelper = new ActionHelper(this.addOnTheFlyFormula);
            StructureRptSetRst structureRptSetRst = actionHelper.refreshDataContainerData(string, string2, stringArray, 15);
            ReportSetActionResult reportSetActionResult = structureRptSetRst.getReportSetActionResult(this.addOnTheFlyFormula.getInfoCenterProvider());
            new ScheduleHelper(this.addOnTheFlyFormula).afterDoAction(string, string2, reportSetActionResult);
            actionHelper.fillRefComponent(structureRptSetRst);
            sRptSetActionResult = structureRptSetRst;
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.changeExternalEnv(), return: " + sRptSetActionResult));
        }
        return sRptSetActionResult;
    }

    @Override
    public SRptSetActionResult changeLinkReportValues(ActionWithValueInfo actionWithValueInfo, Map map, String[] stringArray, JetUUniverse jetUUniverse) throws JRScheduleException {
        String[] stringArray2;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngine.changeLinkReportValues(), valueInfo: " + actionWithValueInfo + " modifiedParamNames: " + Tools.toString((Object)stringArray)));
        }
        if ((stringArray2 = this.clearBrowserIExpression()) == null) {
            JRScheduleException jRScheduleException = new JRScheduleException();
            if (JRLog.isTrace((int)5)) {
                JRLog.trace((int)5, (Object)"not link report engine.");
                JRLog.trace((int)5, (Throwable)jRScheduleException);
            }
            throw jRScheduleException;
        }
        ActionHelper actionHelper = new ActionHelper(this.addOnTheFlyFormula);
        String string = stringArray2[0];
        String string2 = stringArray2[1];
        StructureRptSetRst structureRptSetRst = actionHelper.changeLinkReportValues(string, string2, stringArray);
        if (structureRptSetRst == null) {
            if (JRLog.isTrace((int)6)) {
                JRLog.trace((int)6, (Object)"End of StructureJetEngine.changeLinkReportValues(), return: null");
            }
            return null;
        }
        ReportSetActionResult reportSetActionResult = structureRptSetRst.getReportSetActionResult(this.addOnTheFlyFormula.getInfoCenterProvider());
        new ScheduleHelper(this.addOnTheFlyFormula).afterDoAction(string, string2, reportSetActionResult);
        LinkReportContext linkReportContext = null;
        try {
            linkReportContext = new LinkReportContext(this.addOnTheFlyMeasure, actionWithValueInfo.getAvailableValues(), map, jetUUniverse, false);
        }
        catch (JRScheduleException jRScheduleException) {
            JRLog.trace((int)5, (Throwable)jRScheduleException);
            throw jRScheduleException;
        }
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string, string2);
        SReportViewCenter sReportViewCenter = sReportViewEngine.getReportViewCenter();
        sReportViewCenter.setLinkToReportContext((LinkToReportContext)linkReportContext);
        actionHelper.fillRefComponent(structureRptSetRst);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.changeLinkReportValues(), return: " + structureRptSetRst));
        }
        return structureRptSetRst;
    }

    @Override
    public void closeData(String string, String string2) {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.closeData()..., rptName: " + string + " dcName: " + string2));
        }
        this.addOnTheFlyFormula.closeData(string, string2);
        JRLog.trace((int)6, (Object)"End of StructureJetEngineImpl.closeData().");
    }

    @Override
    public JetRptReport getReport(String string) {
        if (this.addOnTheFlyFormula == null) {
            return null;
        }
        JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
        return jetRptReportSet.getReport(string);
    }

    @Override
    public void init() throws JRScheduleException {
        if (JRLog.isTrace((int)5)) {
            JRLog.trace((int)5, (Object)"StructureJetEngineImpl.init()...");
        }
        this.addOnTheFlyFormula.init();
        if (JRLog.isTrace((int)5)) {
            JRLog.trace((int)5, (Object)"End of StructureJetEngineImpl.init()");
        }
    }

    @Override
    public Map getBrowseFilters(String string) {
        SReportViewCenter sReportViewCenter;
        HashMap hashMap;
        HashMap hashMap2 = null;
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string);
        if (sReportViewEngine != null && (hashMap = (sReportViewCenter = sReportViewEngine.getReportViewCenter()).getBrowseFilters()) != null && !hashMap.isEmpty()) {
            hashMap2 = (HashMap)hashMap.clone();
        }
        return hashMap2;
    }

    @Override
    public Map getBrowseRptSortContainers(String string) {
        SReportViewCenter sReportViewCenter;
        HashMap hashMap;
        HashMap hashMap2 = null;
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string);
        if (sReportViewEngine != null && (hashMap = (sReportViewCenter = sReportViewEngine.getReportViewCenter()).getRptSortContainers()) != null && !hashMap.isEmpty()) {
            hashMap2 = (HashMap)hashMap.clone();
        }
        return hashMap2;
    }

    @Override
    public List getFilterCtrlCurrValues(String string, String string2) {
        JetRptFilterControl jetRptFilterControl;
        SReportViewCenter sReportViewCenter;
        JetRptReport jetRptReport;
        JetObject jetObject;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngine.getFilterCtrlCurrValues(), rptName: " + string + " fcName: " + string2));
        }
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string);
        List list = null;
        if (sReportViewEngine != null && (jetObject = (jetRptReport = (sReportViewCenter = sReportViewEngine.getReportViewCenter()).getOriReportView()).nameToObject(string2)) instanceof JetRptFilterControl && (list = sReportViewCenter.getFilterCtrlValue(jetRptFilterControl = (JetRptFilterControl)jetObject)) != null && list.isEmpty()) {
            list = null;
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.getFilterCtrlCurrValues(), return: " + list));
        }
        return list;
    }

    @Override
    public ResultSetProvidor getDetailResult(String string, String string2, IDetailInfo iDetailInfo) throws DSException, JRStopEngineException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngine.getDetailResult(), rptName: " + string + " dcName: " + string2 + " info: " + iDetailInfo));
        }
        GoToActionDataSource goToActionDataSource = null;
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string);
        if (sReportViewEngine != null) {
            Integer n = sReportViewEngine.getGroupQueryId(string2);
            if (n == null) {
                JRLog.trace((int)6, (Object)"no query id!");
            } else {
                GoDetailInfo goDetailInfo = iDetailInfo.generateGoDetailInfo(n);
                DetailBVDataInfo detailBVDataInfo = this.add.getDetailDataResult(goDetailInfo);
                DetailDataInfoFactory detailDataInfoFactory = new DetailDataInfoFactory(detailBVDataInfo);
                goToActionDataSource = new GoToActionDataSource(detailDataInfoFactory);
            }
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.getDetailResult(), return: " + goToActionDataSource));
        }
        return goToActionDataSource;
    }

    @Override
    public RptSetDirectInfo getRptSetDirectInfo() {
        return this.addOnTheFlyFormula == null ? null : this.addOnTheFlyFormula.getRptSetDirInfo();
    }

    @Override
    public RptSetFullInfo getRptSetFullInfo() {
        return this.addOnTheFlyFormula == null ? null : this.addOnTheFlyFormula.getRptSetFullInfo();
    }

    @Override
    public void clearUndoRedoStack() {
        if (this.addOnTheFlyFormula != null) {
            SReportViewCenter sReportViewCenter = this.afterDoAction();
            ActionManagerForService actionManagerForService = sReportViewCenter.getActionManager();
            actionManagerForService.clearStack();
        }
    }

    @Override
    public void saveBrowseInfo(boolean bl, boolean bl2, boolean bl3) {
        if (this.addOnTheFlyFormula != null && (bl || bl2 || bl3)) {
            ArrayList<String> arrayList;
            JetObject jetObject;
            Object object2;
            Object object3;
            Cloneable cloneable;
            SReportViewCenter sReportViewCenter = this.afterDoAction();
            JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
            DataContainerLogic dataContainerLogic = ObjectLogicFactory.getDataContainerLogic();
            String[] stringArray = sReportViewCenter.getAllDataContainerNames();
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray));
            if (bl) {
                cloneable = sReportViewCenter.getBrowseFilters();
                if (cloneable != null) {
                    object3 = ((HashMap)cloneable).keySet().toArray(new String[0]);
                    for (int i = 0; i < ((String[])object3).length; ++i) {
                        JetFilterExpression jetFilterExpression;
                        block16: {
                            object2 = jetRptReportSet.nameToObject(object3[i]);
                            if (object2 == null || !(object2 instanceof IDataContainer)) continue;
                            IBooleanExpression object4 = sReportViewCenter.getBrowseFilter(object3[i]);
                            jetObject = new CvIExpression();
                            jetFilterExpression = null;
                            try {
                                jetFilterExpression = jetObject.cvIExpresstion((IExpression)object4);
                            }
                            catch (ConditionException conditionException) {
                                if (!JRLog.isError((int)2)) break block16;
                                JRLog.error((int)2, (int)220019, (Object[])new Object[]{object4}, (Throwable)conditionException);
                            }
                        }
                        ((JetFilterExpLogic)dataContainerLogic).setBrowserJetFilterExpression((IDataContainer)object2, jetFilterExpression, 4098);
                    }
                }
                object3 = cloneable == null ? new ArrayList() : new ArrayList(((HashMap)cloneable).keySet());
                arrayList = new ArrayList<String>(arrayList2);
                arrayList.removeAll((Collection<?>)object3);
                if (!arrayList.isEmpty()) {
                    for (String string : arrayList) {
                        jetObject = jetRptReportSet.nameToObject(string);
                        if (jetObject == null || !(jetObject instanceof IDataContainer)) continue;
                        dataContainerLogic.clearBrowserIExpression((IDataContainer)jetObject, 4098);
                    }
                }
            }
            if (bl2) {
                cloneable = sReportViewCenter.getRptSortContainers();
                if (cloneable != null) {
                    object3 = ((HashMap)cloneable).keySet().toArray(new String[0]);
                    for (int i = 0; i < ((String[])object3).length; ++i) {
                        object2 = jetRptReportSet.nameToObject(object3[i]);
                        if (object2 == null || !ReportTools.supportBrowseAction((JetObject)object2)) continue;
                        JetRptSortContainer jetRptSortContainer = sReportViewCenter.getBrowseSortContainer(object3[i]);
                        this.canUndo((IDataContainer)object2, jetRptSortContainer);
                    }
                }
                object3 = cloneable == null ? new ArrayList() : new ArrayList(((HashMap)cloneable).keySet());
                arrayList = new ArrayList<String>(arrayList2);
                arrayList.removeAll((Collection<?>)object3);
                if (!arrayList.isEmpty()) {
                    for (String string : arrayList) {
                        jetObject = jetRptReportSet.nameToObject(string);
                        if (jetObject == null || !(jetObject instanceof IDataContainer)) continue;
                        this.canUndo((IDataContainer)jetObject, null);
                    }
                }
            }
            if (bl3) {
                cloneable = new ArrayList();
                object3 = ObjectLogicFactory.getBasicComponentLogic();
                object3.getAllPosterityComponentByClass((JetObject)sReportViewCenter.getOriReportView(), JetRptFilterControl.class, (List)((Object)cloneable));
                if (!cloneable.isEmpty()) {
                    for (int i = 0; i < cloneable.size(); ++i) {
                        object2 = (JetRptFilterControl)cloneable.get(i);
                        List list = sReportViewCenter.getFilterCtrlValue((JetRptFilterControl)object2);
                        object2.setCurrentSelections(false, list);
                    }
                }
            }
        }
    }

    private JetRptSortContainer canUndo(IDataContainer iDataContainer, JetRptSortContainer jetRptSortContainer) {
        JetRptSortContainer jetRptSortContainer2 = this.changeLinkReportValues(iDataContainer);
        if (jetRptSortContainer2 != null) {
            this.changeParameters(iDataContainer);
        }
        if (jetRptSortContainer == null) {
            return null;
        }
        return (JetRptSortContainer)ObjectLogicFactory.getBasicComponentLogic().add((JetContainable)iDataContainer, (JetObject)jetRptSortContainer);
    }

    private JetRptSortContainer changeLinkReportValues(IDataContainer iDataContainer) {
        Vector vector = iDataContainer.getChildren();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptSortContainer)) continue;
            return (JetRptSortContainer)e;
        }
        return null;
    }

    private JetRptSortContainer changeParameters(IDataContainer iDataContainer) {
        Vector vector = iDataContainer.getChildren();
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof JetRptSortContainer)) continue;
            return (JetRptSortContainer)ObjectLogicFactory.getBasicComponentLogic().remove((JetObject)e);
        }
        return null;
    }

    private String[] clearBrowserIExpression() {
        if (this.addOnTheFlyFormula == null || this.addOnTheFlyFormula.getType() != 1) {
            if (JRLog.isTrace((int)6)) {
                JRLog.trace((int)6, (Object)("rptSetEngine is null or it is not link report engine. rptSetEngine: " + this.addOnTheFlyFormula));
            }
            return null;
        }
        String[] stringArray = null;
        SReportViewEngine[] sReportViewEngineArray = this.addOnTheFlyFormula.getAllReportViewEngines();
        if (sReportViewEngineArray != null) {
            for (int i = 0; i < sReportViewEngineArray.length; ++i) {
                SReportViewCenter sReportViewCenter = sReportViewEngineArray[i].getReportViewCenter();
                if (sReportViewCenter.getLinkInfo() == null) continue;
                stringArray = new String[]{sReportViewCenter.getRptName(), sReportViewCenter.getViewName()};
                break;
            }
        }
        return stringArray;
    }

    @Override
    public FlyFormulaInfo addFlyFormula(FlyResourceScope flyResourceScope, FlyFormulaInfo flyFormulaInfo) throws JRScheduleException, JRException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.addFlyFormula(), scope: " + flyResourceScope + " fmlInfo: " + flyFormulaInfo));
        }
        JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
        String string = flyResourceScope.getReportName();
        SReportViewCenter sReportViewCenter = this.append(string);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        Scope scope = new Scope((IReport)jetRptReport, jetUUniverse, this.clearMem(jetUUniverse, flyResourceScope));
        ResourceStore resourceStore = this.addOnTheFlyFormula.getEngineEnv().getResourceStore();
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        JetRptAbstractFormula jetRptAbstractFormula = onTheFlyFormulaMeasureLogic.addOnTheFlyFormula(scope, flyFormulaInfo.getDisplayName(), flyFormulaInfo.getFormulaExpression(), flyFormulaInfo.getRoleType(), resourceStore);
        if (!(jetRptAbstractFormula instanceof JetRptFlyFormula)) {
            throw new JRScheduleException(250039, (Object[])new String[]{flyFormulaInfo.getDisplayName()}, null);
        }
        JetRptFlyFormula jetRptFlyFormula = (JetRptFlyFormula)jetRptAbstractFormula;
        FlyFormulaInfo flyFormulaInfo2 = ReportTools.getFlyFormulaInfo((JetRptFlyFormula)jetRptFlyFormula, (Scope)scope);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.addFlyFormula()..., return: " + flyFormulaInfo2));
        }
        return flyFormulaInfo2;
    }

    @Override
    public FlyMeasureInfo addFlyMeasure(FlyResourceScope flyResourceScope, FlyMeasureInfo flyMeasureInfo) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.addFlyMeasure(), scope: " + flyResourceScope + " measureInfo: " + flyMeasureInfo));
        }
        JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
        String string = flyResourceScope.getReportName();
        SReportViewCenter sReportViewCenter = this.append(string);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        Scope scope = new Scope((IReport)jetRptReport, jetUUniverse, this.clearMem(jetUUniverse, flyResourceScope));
        ResourceStore resourceStore = this.addOnTheFlyFormula.getEngineEnv().getResourceStore();
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        JetRptFlyMeasure jetRptFlyMeasure = null;
        try {
            jetRptFlyMeasure = onTheFlyFormulaMeasureLogic.addOnTheFlyMeasure(scope, flyMeasureInfo.getDisplayName(), flyMeasureInfo.getBasedQualifyDisplayName(), flyMeasureInfo.getAggFunctionName(), resourceStore);
        }
        catch (DisplayNameAlreadyExistsException displayNameAlreadyExistsException) {
            throw new JRScheduleException((Throwable)displayNameAlreadyExistsException);
        }
        FlyMeasureInfo flyMeasureInfo2 = ReportTools.getFlyMeasureInfo((JetRptFlyMeasure)jetRptFlyMeasure, (Scope)scope);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.addFlyMeasure()..., return: " + flyMeasureInfo2));
        }
        return flyMeasureInfo2;
    }

    private QueryInfo clearMem(JetUUniverse jetUUniverse, FlyResourceScope flyResourceScope) {
        ParseDHTMLActionParameterTool parseDHTMLActionParameterTool = new ParseDHTMLActionParameterTool();
        IDataSourceInfo iDataSourceInfo = parseDHTMLActionParameterTool.getDataSourceInfo(jetUUniverse, flyResourceScope.getBLName());
        return new QueryInfoImpl("", iDataSourceInfo.getDataSourceName(), iDataSourceInfo.getQueryName(), iDataSourceInfo.getBLName(), flyResourceScope.getResourceType());
    }

    @Override
    public boolean isUsedFlyResource(FlyResourceScope flyResourceScope, String string) throws JRScheduleException {
        boolean bl;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.isUsedFlyResource()..., scope: " + flyResourceScope + " rscQulifiedDisplayName: " + string));
        }
        JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
        String string2 = flyResourceScope.getReportName();
        SReportViewCenter sReportViewCenter = this.append(string2);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        Scope scope = new Scope((IReport)jetRptReport, jetUUniverse, this.clearMem(jetUUniverse, flyResourceScope));
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        BLNode bLNode = onTheFlyFormulaMeasureLogic.getBLNode(scope, string);
        if (bLNode == null) {
            throw new JRSInvalidParameterException(250004, (Object[])new String[]{string}, null);
        }
        boolean bl2 = bl = this.clearStack(jetUUniverse, jetRptReport, bLNode.getQualifyDisplayName(), true) || this.clone(scope, bLNode);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.isUsedFlyResource()..., return: " + bl));
        }
        return bl;
    }

    @Override
    public SRptSetActionResult modifyFlyFormula(FlyResourceScope flyResourceScope, String string, FlyFormulaInfo flyFormulaInfo) throws JRScheduleException, JRException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.modifyFlyFormula()..., scope: " + flyResourceScope + " rscQulifiedDisplayName: " + string));
        }
        String string2 = flyResourceScope.getReportName();
        JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
        JetRptReport jetRptReport = jetRptReportSet.getReport(string2);
        String string3 = jetRptReport.getCurViewName();
        int n = -1;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("rpt_name", string2);
        hashtable.put("view_name", string3);
        hashtable.put("is_studio_env", "true");
        ActionParameter actionParameter = null;
        try {
            actionParameter = new ActionParameter(n, hashtable);
        }
        catch (InvalidParameterException invalidParameterException) {
            if (JRLog.isTrace((int)4)) {
                JRLog.trace((int)4, (Throwable)invalidParameterException);
            }
            throw new JRScheduleException((Throwable)invalidParameterException);
        }
        SActionExecutor sActionExecutor = new SActionExecutor(actionParameter, this.addOnTheFlyFormula);
        SActionRst sActionRst = null;
        try {
            sActionRst = sActionExecutor.doModifyFlyFormula(flyResourceScope, string, flyFormulaInfo);
        }
        catch (JRException jRException) {
            if (JRLog.isTrace((int)4)) {
                JRLog.trace((int)4, (Throwable)jRException);
            }
            throw jRException;
        }
        Tools.logTrace((int)6, (Object)("SActionExecutor.doModifyFlyFormula() return: " + Tools.toString((Object)((Object)sActionRst))));
        ReportSetActionResult reportSetActionResult = sActionRst.getReportSetActionResult();
        ScheduleHelper scheduleHelper = new ScheduleHelper(this.addOnTheFlyFormula);
        scheduleHelper.afterDoAction(string2, string3, reportSetActionResult);
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string2, string3);
        SReportViewCenter sReportViewCenter = sReportViewEngine.getReportViewCenter();
        StructureRptSetRst structureRptSetRst = sActionRst.getStructureRptSetRst(jetRptReportSet, sReportViewCenter);
        new ActionHelper(this.addOnTheFlyFormula).fillRefComponent(structureRptSetRst);
        Tools.logTrace((int)6, (Object)("End of StructureJetEngine.modifyFlyFormula()..., return: " + structureRptSetRst));
        return structureRptSetRst;
    }

    @Override
    public SRptSetActionResult modifyFlyMeasure(FlyResourceScope flyResourceScope, String string, FlyMeasureInfo flyMeasureInfo) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.modifyFlyMeasure()..., scope: " + flyResourceScope + " rscQulifiedDisplayName: " + string));
        }
        String string2 = flyResourceScope.getReportName();
        JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getReportSet();
        JetRptReport jetRptReport = jetRptReportSet.getReport(string2);
        String string3 = jetRptReport.getCurViewName();
        int n = -1;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("rpt_name", string2);
        hashtable.put("view_name", string3);
        hashtable.put("is_studio_env", "true");
        ActionParameter actionParameter = null;
        try {
            actionParameter = new ActionParameter(n, hashtable);
        }
        catch (InvalidParameterException invalidParameterException) {
            if (JRLog.isTrace((int)4)) {
                JRLog.trace((int)4, (Throwable)invalidParameterException);
            }
            throw new JRScheduleException((Throwable)invalidParameterException);
        }
        SActionExecutor sActionExecutor = new SActionExecutor(actionParameter, this.addOnTheFlyFormula);
        SActionRst sActionRst = null;
        try {
            sActionRst = sActionExecutor.doModifyFlyMeasure(flyResourceScope, string, flyMeasureInfo);
        }
        catch (JRScheduleException jRScheduleException) {
            if (JRLog.isTrace((int)4)) {
                JRLog.trace((int)4, (Throwable)jRScheduleException);
            }
            throw jRScheduleException;
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("SActionExecutor.doModifyFlyFormula() return: " + Tools.toString((Object)((Object)sActionRst))));
        }
        ReportSetActionResult reportSetActionResult = sActionRst.getReportSetActionResult();
        ScheduleHelper scheduleHelper = new ScheduleHelper(this.addOnTheFlyFormula);
        scheduleHelper.afterDoAction(string2, string3, reportSetActionResult);
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string2, string3);
        SReportViewCenter sReportViewCenter = sReportViewEngine.getReportViewCenter();
        StructureRptSetRst structureRptSetRst = sActionRst.getStructureRptSetRst(jetRptReportSet, sReportViewCenter);
        new ActionHelper(this.addOnTheFlyFormula).fillRefComponent(structureRptSetRst);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.modifyFlyMeasure()..., return: " + structureRptSetRst));
        }
        return structureRptSetRst;
    }

    @Override
    public BLNode removeFlyResource(FlyResourceScope flyResourceScope, String string) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.removeFlyResource()..., scope: " + flyResourceScope + " rscQulifiedDisplayName: " + string));
        }
        if (this.isUsedFlyResource(flyResourceScope, string)) {
            throw new JRScheduleException(250034, (Object[])new String[]{string}, null);
        }
        JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
        String string2 = flyResourceScope.getReportName();
        SReportViewCenter sReportViewCenter = this.append(string2);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        Scope scope = new Scope((IReport)jetRptReport, jetUUniverse, this.clearMem(jetUUniverse, flyResourceScope));
        ResourceStore resourceStore = this.addOnTheFlyFormula.getEngineEnv().getResourceStore();
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        BLNode bLNode = onTheFlyFormulaMeasureLogic.getBLNode(scope, string);
        if (bLNode instanceof JetRptFlyFormula) {
            onTheFlyFormulaMeasureLogic.delOnTheFlyFormula(scope, string, resourceStore);
        } else {
            onTheFlyFormulaMeasureLogic.delOnTheFlyMeasure(scope, string, resourceStore);
        }
        this.canForward(string2).clearStack();
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.removeFlyResource()..., return: " + bLNode));
        }
        return bLNode;
    }

    private boolean clearStack(JetUUniverse jetUUniverse, JetRptReport jetRptReport, String string, boolean bl) {
        return ResourceTool.isUsedByReport((JetUUniverse)jetUUniverse, (IReport)jetRptReport, (String)string, (boolean)bl);
    }

    private boolean clone(Scope scope, BLNode bLNode) {
        String string = "";
        if (!(bLNode instanceof JetRptFlyFormula)) {
            return false;
        }
        string = ((JetRptFlyFormula)bLNode).getMappingName();
        OnTheFlyFormulaMeasureLogic onTheFlyFormulaMeasureLogic = ObjectLogicFactory.getOnTheFlyFormulaMeasureLogic();
        List list = onTheFlyFormulaMeasureLogic.getJetRptFlyFormulaList(scope);
        List list2 = onTheFlyFormulaMeasureLogic.getJetRptFlyMeasureList(scope);
        for (JetRptAbstractFormula jetRptAbstractFormula : list) {
            if (jetRptAbstractFormula.equals(bLNode)) continue;
            JetUFormula jetUFormula = jetRptAbstractFormula.getJetUFormula();
            Vector vector = jetUFormula.formulainfo.refFormula;
            if (!vector.contains(string.toUpperCase())) continue;
            return true;
        }
        for (JetRptAbstractFormula jetRptAbstractFormula : list2) {
            if (!jetRptAbstractFormula.getRefMappingName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IConditionControlExpander getConditionCtrlExpander(String string) {
        SReportViewEngine sReportViewEngine = this.addOnTheFlyFormula.getReportViewEngine(string);
        return sReportViewEngine == null ? null : sReportViewEngine.getConditionCtrlExpander();
    }

    @Override
    public IDataResultInfo getDataResultInfo(String string, String string2) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.getDataResultInfo()..., rptName: " + string + " dcName: " + string2));
        }
        IDataResultInfo iDataResultInfo = null;
        try {
            iDataResultInfo = this.addOnTheFlyFormula.getDataResultInfo(string, string2);
        }
        catch (JRStopEngineException jRStopEngineException) {
            throw new JRScheduleException((Throwable)jRStopEngineException);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.getDataResultInfo(), return: " + iDataResultInfo));
        }
        return iDataResultInfo;
    }

    @Override
    public SRptSetActionResult refresh(String string, String string2, String string3) throws JRScheduleException {
        Tools.logTrace((int)6, (Object)("StructureJetEngine.refresh()..., dataSourceName: " + string + " queryName: " + string2 + " blName: " + string3));
        ActionHelper actionHelper = new ActionHelper(this.addOnTheFlyFormula);
        StructureRptSetRst structureRptSetRst = actionHelper.refresh(string, string2, string3);
        if (structureRptSetRst != null) {
            JetRptReportSet jetRptReportSet = this.addOnTheFlyFormula.getRptSetCenter().getRptSet();
            String string4 = jetRptReportSet.getCurReportId();
            JetRptReport jetRptReport = jetRptReportSet.getReport(string4);
            String string5 = jetRptReport.getCurViewName();
            ReportSetActionResult reportSetActionResult = structureRptSetRst.getReportSetActionResult(this.addOnTheFlyFormula.getInfoCenterProvider());
            DataSetActionResult[] dataSetActionResultArray = reportSetActionResult.getDataSetActionResults();
            if (dataSetActionResultArray != null && dataSetActionResultArray.length > 0) {
                for (int i = 0; i < dataSetActionResultArray.length; ++i) {
                    dataSetActionResultArray[i].setIsRefreshData(true);
                }
            }
            new ScheduleHelper(this.addOnTheFlyFormula).afterDoAction(string4, string5, reportSetActionResult);
            actionHelper.fillRefComponent(structureRptSetRst);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngine.refresh(), return: " + structureRptSetRst));
        }
        return structureRptSetRst;
    }

    @Override
    public SRptSetActionResult incrementalRun(String string, String string2, String string3) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.incrementalRun()..., dataSourceName: " + string + " queryName: " + string2 + " blName: " + string3));
        }
        ArrayList<StructureRptRst> arrayList = new ArrayList<StructureRptRst>();
        SReportViewEngine[] sReportViewEngineArray = this.addOnTheFlyFormula.getAllReportViewEngines();
        if (sReportViewEngineArray != null && sReportViewEngineArray.length > 0) {
            for (int i = 0; i < sReportViewEngineArray.length; ++i) {
                List list = null;
                try {
                    list = sReportViewEngineArray[i].incrementalRun(string, string2, string3);
                }
                catch (JRStopEngineException jRStopEngineException) {
                    throw new JRScheduleException((Throwable)jRStopEngineException);
                }
                if (list == null || list.isEmpty()) continue;
                SReportViewCenter sReportViewCenter = sReportViewEngineArray[i].getReportViewCenter();
                String string4 = sReportViewCenter.getRptName();
                String string5 = sReportViewCenter.getViewName();
                ArrayList<StructureCompRst> arrayList2 = new ArrayList<StructureCompRst>();
                for (String string6 : list) {
                    StructureCompRst structureCompRst = new StructureCompRst(string6, null, 4, 63, true, true, false);
                    arrayList2.add(structureCompRst);
                }
                StructureRptRst structureRptRst = new StructureRptRst(string4, string5, arrayList2.toArray(new StructureCompRst[0]));
                arrayList.add(structureRptRst);
            }
        }
        StructureRptSetRst structureRptSetRst = null;
        if (arrayList != null && !arrayList.isEmpty()) {
            structureRptSetRst = new StructureRptSetRst(null, arrayList.toArray(new StructureRptRst[0]));
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.incrementalRun(), return: " + structureRptSetRst));
        }
        return structureRptSetRst;
    }

    @Override
    public Record getLinkToContentRecord(String string, ActionWithValueInfo actionWithValueInfo) throws JRScheduleException {
        Record record;
        SReportViewEngine sReportViewEngine;
        LinkToContentInfo linkToContentInfo;
        JetRptObject jetRptObject;
        JetRptReport jetRptReport;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.getLinkToContentRecord()..., rptName: " + string + " valueInfo: " + actionWithValueInfo));
        }
        String string2 = actionWithValueInfo.getObjectName();
        List list = actionWithValueInfo.getAvailableValues();
        if (JRLog.isTrace((int)6)) {
            Tools.logTrace((int)6, (Object)"####log link report values.");
            for (int i = 0; list != null && i < list.size(); ++i) {
                jetRptReport = (DbValueComparer)list.get(i);
                jetRptObject = jetRptReport.getValue();
                if (JRLog.isTrace((int)6)) {
                    JRLog.trace((int)6, (Object)("col: " + jetRptReport.columnName + " value: " + jetRptObject + (jetRptObject == null ? "" : " valueHash: " + jetRptObject.hashCode())));
                }
                if (!(jetRptObject instanceof DbChar)) continue;
                linkToContentInfo = (DbChar)jetRptObject;
                if (!JRLog.isTrace((int)6)) continue;
                JRLog.trace((int)6, (Object)("dbChar.v: " + (linkToContentInfo.value == null ? "##NULL##" : linkToContentInfo.value)));
            }
            Tools.logTrace((int)6, (Object)"####end log link report values.");
        }
        if ((sReportViewEngine = this.addOnTheFlyFormula(string)) == null) {
            throw new JRScheduleException(250002, (Object[])new String[]{string}, null);
        }
        jetRptReport = sReportViewEngine.getReportViewCenter().getOriReportView();
        jetRptObject = (JetRptObject)jetRptReport.nameToObject(string2);
        linkToContentInfo = new LinkToContentInfo(jetRptObject);
        LinkToContentContext linkToContentContext = new LinkToContentContext(linkToContentInfo, list, this.addOnTheFlyFormula.getEngineEnv().getParamBuf(), this.addOnTheFlyFormula.getUniverse());
        QueryInfo queryInfo = linkToContentInfo.getTargetQueryInfo();
        SEngineRawDataQueryEnv sEngineRawDataQueryEnv = new SEngineRawDataQueryEnv(sReportViewEngine, queryInfo);
        LinkToContentValueProvider linkToContentValueProvider = new LinkToContentValueProvider(this.addOnTheFlyFormula.getDataService(), linkToContentInfo, linkToContentContext, (RawDataQueryEnv)sEngineRawDataQueryEnv, (RuntimeEnv)sReportViewEngine.getRptSetEngine().getEngineEnv());
        try {
            record = linkToContentValueProvider.getResult();
        }
        catch (DSException dSException) {
            throw new JRScheduleException((Throwable)dSException);
        }
        catch (ConditionException conditionException) {
            throw new JRScheduleException((Throwable)conditionException);
        }
        catch (IOException iOException) {
            throw new JRScheduleException((Throwable)iOException);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new JRScheduleException((Throwable)invalidParameterException);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.getLinkToContentRecord(), return: " + record));
        }
        return record;
    }

    @Override
    public PropValueProvider getPropValueProvider(String string) throws JRScheduleException {
        SReportViewEngine sReportViewEngine;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.getPropValueProvider()..., rptName: " + string));
        }
        if ((sReportViewEngine = this.addOnTheFlyFormula(string)) == null) {
            throw new JRScheduleException(250002, (Object[])new String[]{string}, null);
        }
        PropValueProviderImpl propValueProviderImpl = new PropValueProviderImpl((IReportViewCenter)sReportViewEngine.getReportViewCenter());
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.getPropValueProvider(), return: " + propValueProviderImpl));
        }
        return propValueProviderImpl;
    }

    @Override
    public boolean isUsedFlyParameter(FlyResourceScope flyResourceScope, String string) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.isUsedFlyParameter()..., scope: " + flyResourceScope + " paramName: " + string));
        }
        JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
        String string2 = flyResourceScope.getReportName();
        SReportViewCenter sReportViewCenter = this.append(string2);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        Scope scope = new Scope((IReport)jetRptReport, jetUUniverse, this.clearMem(jetUUniverse, flyResourceScope));
        JetUResourceEntity jetUResourceEntity = scope.getResourceEntity(string, false);
        if (jetUResourceEntity == null) {
            throw new JRSInvalidParameterException(250004, (Object[])new String[]{string}, null);
        }
        OnTheFlyParameterLogic onTheFlyParameterLogic = ObjectLogicFactory.getOnTheFlyParameterLogic();
        boolean bl = onTheFlyParameterLogic.isUsed(jetUUniverse, (IReport)jetRptReport, string);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.isUsedFlyParameter()..., return: " + bl));
        }
        return bl;
    }

    @Override
    public void addFlyParameter(String string, List list) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.addFlyParameter()..., rptName: " + string + " params: " + list));
        }
        JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
        SReportViewCenter sReportViewCenter = this.append(string);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        Scope scope = new Scope((IReport)jetRptReport, jetUUniverse, null);
        OnTheFlyParameterLogic onTheFlyParameterLogic = ObjectLogicFactory.getOnTheFlyParameterLogic();
        for (JetUParameter jetUParameter : list) {
            try {
                onTheFlyParameterLogic.addFlyParameter(scope, jetUParameter);
            }
            catch (DynamicParameterException dynamicParameterException) {
                if (JRLog.isTrace((int)4)) {
                    JRLog.trace((int)4, (Throwable)dynamicParameterException);
                }
                throw new JRScheduleException((Throwable)dynamicParameterException);
            }
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)"End of StructureJetEngineImpl.addFlyParameter().");
        }
    }

    @Override
    public SRptSetActionResult modifyFlyParameter(String string, Map map) throws JRScheduleException {
        String[] stringArray;
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.modifyFlyParameter()..., rptName: " + string + " params: " + map));
        }
        JetUUniverse jetUUniverse = this.addOnTheFlyFormula.getUniverse();
        SReportViewCenter sReportViewCenter = this.append(string);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        Scope scope = new Scope((IReport)jetRptReport, jetUUniverse, null);
        OnTheFlyParameterLogic onTheFlyParameterLogic = ObjectLogicFactory.getOnTheFlyParameterLogic();
        List list = null;
        try {
            list = onTheFlyParameterLogic.modifyFlyParameter(scope, map);
        }
        catch (DynamicParameterException dynamicParameterException) {
            if (JRLog.isTrace((int)4)) {
                JRLog.trace((int)4, (Throwable)dynamicParameterException);
            }
            throw new JRScheduleException((Throwable)dynamicParameterException);
        }
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("modify parameters on template, return: " + list));
        }
        ActionHelper actionHelper = new ActionHelper(this.addOnTheFlyFormula);
        StructureRptSetRst structureRptSetRst = null;
        if (list != null && !list.isEmpty()) {
            stringArray = list.toArray(new String[0]);
            structureRptSetRst = actionHelper.changeParameters(stringArray);
        }
        if (structureRptSetRst == null) {
            if (JRLog.isTrace((int)6)) {
                JRLog.trace((int)6, (Object)"End of StructureJetEngineImpl.modifyFlyParameter(), return null.");
            }
            return null;
        }
        stringArray = this.addOnTheFlyFormula.getRptSetCenter().getRptSet();
        JetRptReport jetRptReport2 = stringArray.getReport(string);
        String string2 = jetRptReport2.getCurViewName();
        ReportSetActionResult reportSetActionResult = structureRptSetRst.getReportSetActionResult(this.addOnTheFlyFormula.getInfoCenterProvider());
        new ScheduleHelper(this.addOnTheFlyFormula).afterDoAction(string, string2, reportSetActionResult);
        actionHelper.fillRefComponent(structureRptSetRst);
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("End of StructureJetEngineImpl.modifyFlyParameter(), return: " + structureRptSetRst));
        }
        return structureRptSetRst;
    }

    @Override
    public void removeFlyParameter(String string, List list) throws JRScheduleException {
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)("StructureJetEngineImpl.removeFlyParameter()..., rptName: " + string + " paramNames: " + list));
        }
        SReportViewCenter sReportViewCenter = this.append(string);
        JetRptReport jetRptReport = sReportViewCenter.getOriReportView();
        OnTheFlyParameterLogic onTheFlyParameterLogic = ObjectLogicFactory.getOnTheFlyParameterLogic();
        for (String string2 : list) {
            try {
                onTheFlyParameterLogic.removeFlyParameter((IReport)jetRptReport, string2);
            }
            catch (DynamicParameterException dynamicParameterException) {
                if (JRLog.isTrace((int)4)) {
                    JRLog.trace((int)4, (Throwable)dynamicParameterException);
                }
                throw new JRScheduleException((Throwable)dynamicParameterException);
            }
        }
        this.canForward(string).clearStack();
        if (JRLog.isTrace((int)6)) {
            JRLog.trace((int)6, (Object)"End of StructureJetEngineImpl.removeFlyParameter().");
        }
    }

    private class GoToActionDataSource
    implements ResultSetProvidor {
        private DetailDataInfoFactory SEDU;
        String[][] strBindInfo;
        private boolean close = false;

        private GoToActionDataSource(DetailDataInfoFactory detailDataInfoFactory) {
            this.SEDU = detailDataInfoFactory;
        }

        private BVToRstInfo SEDU() {
            BVToRstInfo bVToRstInfo;
            block3: {
                bVToRstInfo = null;
                if (!this.close) {
                    try {
                        bVToRstInfo = this.SEDU.getResultSet();
                    }
                    catch (DSException dSException) {
                        if (!JRLog.isTrace((int)5)) break block3;
                        JRLog.trace((int)5, (Throwable)dSException);
                    }
                }
            }
            return bVToRstInfo;
        }

        public synchronized ResultSet getResultSet() {
            BVToRstInfo bVToRstInfo = this.SEDU();
            return bVToRstInfo == null ? null : bVToRstInfo.getResultSet();
        }

        public synchronized String[][] getBindInfo() {
            block5: {
                BVToRstInfo bVToRstInfo = this.SEDU();
                if (bVToRstInfo == null) {
                    return null;
                }
                if (this.strBindInfo == null) {
                    MappingNameBindInfo[] mappingNameBindInfoArray = bVToRstInfo.getBindInfo();
                    ResultSet resultSet = bVToRstInfo.getResultSet();
                    try {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        this.strBindInfo = new String[2][mappingNameBindInfoArray.length];
                        for (int i = 0; i < mappingNameBindInfoArray.length; ++i) {
                            this.strBindInfo[0][i] = mappingNameBindInfoArray[i].getMappingName();
                            this.strBindInfo[1][i] = resultSetMetaData.getColumnName(mappingNameBindInfoArray[i].getFieldIndex());
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!JRLog.isTrace((int)5)) break block5;
                        JRLog.trace((int)5, (Throwable)sQLException);
                    }
                }
            }
            return this.strBindInfo;
        }

        public synchronized void close() {
            if (!this.close) {
                block3: {
                    this.close = true;
                    try {
                        this.SEDU.close();
                    }
                    catch (DSException dSException) {
                        if (!JRLog.isTrace((int)5)) break block3;
                        JRLog.trace((int)5, (Throwable)dSException);
                    }
                }
                this.SEDU = null;
            }
        }
    }
}

