/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.structurengine.engine.helper;

import java.util.ArrayList;
import java.util.Arrays;
import jet.dataengine.api.DSException;
import jet.reportLogic.service.DataContainerActionResult;
import jet.reportLogic.service.DataSetActionResult;
import jet.reportLogic.service.ReportActionResult;
import jet.reportLogic.service.ReportSetActionResult;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.structurengine.engine.SReportViewEngine;
import jet.rptservice.structurengine.engine.SRptSetEngine;
import jet.rptservice.structurengine.engine.helper.AbstractHelper;

public class ScheduleHelper
extends AbstractHelper {
    public ScheduleHelper(SRptSetEngine sRptSetEngine) {
        super(sRptSetEngine);
    }

    public void afterDoAction(String string, String string2, ReportSetActionResult reportSetActionResult) throws JRScheduleException {
        this.SEDU(reportSetActionResult);
        this.add(reportSetActionResult);
        this.asList(reportSetActionResult);
    }

    private void SEDU(ReportSetActionResult reportSetActionResult) throws JRScheduleException {
        if (reportSetActionResult == null) {
            return;
        }
        DataSetActionResult[] dataSetActionResultArray = reportSetActionResult.getDataSetActionResults();
        if (dataSetActionResultArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < dataSetActionResultArray.length; ++i) {
                String string = dataSetActionResultArray[i].getObjectName();
                int n = dataSetActionResultArray[i].getOperation();
                if (n != 1 || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            if (!arrayList.isEmpty()) {
                String[] stringArray = arrayList.toArray(new String[0]);
                this.rptSetEngine.createDataSetCenters(stringArray);
                this.rptSetEngine.initDataSets(stringArray);
            }
        }
    }

    private void add(ReportSetActionResult reportSetActionResult) throws JRScheduleException {
        DataSetActionResult[] dataSetActionResultArray;
        DataContainerActionResult[] dataContainerActionResultArray;
        if (reportSetActionResult == null) {
            return;
        }
        ReportActionResult[] reportActionResultArray = reportSetActionResult.getReportActionResults();
        if (reportActionResultArray != null) {
            for (int i = 0; i < reportActionResultArray.length; ++i) {
                SReportViewEngine sReportViewEngine = this.rptSetEngine.getReportViewEngine(reportActionResultArray[i].getReportName(), reportActionResultArray[i].getViewName());
                dataContainerActionResultArray = reportActionResultArray[i].getDataContainerActionResults();
                if (dataContainerActionResultArray == null) continue;
                block9: for (int j = 0; j < dataContainerActionResultArray.length; ++j) {
                    String string = dataContainerActionResultArray[j].getObjectName();
                    if (dataContainerActionResultArray[j].getOperation() == 2) {
                        sReportViewEngine.closeQuerysForSelf(string, 1);
                        continue;
                    }
                    switch (dataContainerActionResultArray[j].getDataLevel()) {
                        case 7: {
                            sReportViewEngine.closeQuerysForSelf(string, 3);
                            continue block9;
                        }
                        case 15: {
                            sReportViewEngine.closeQuerysForSelf(string, 2);
                            continue block9;
                        }
                        case 31: {
                            sReportViewEngine.refreshLevelTwoDataInfo(Arrays.asList(string));
                            continue block9;
                        }
                        case 63: {
                            sReportViewEngine.closeQuerysForSelf(string, 1);
                            continue block9;
                        }
                    }
                }
            }
        }
        if ((dataSetActionResultArray = reportSetActionResult.getDataSetActionResults()) != null) {
            for (int i = 0; i < dataSetActionResultArray.length; ++i) {
                dataContainerActionResultArray = this.rptSetEngine.getDataSetCenter(dataSetActionResultArray[i].getObjectName());
                if (dataSetActionResultArray[i].getOperation() != 2 && dataSetActionResultArray[i].getDataLevel() != 3 && dataSetActionResultArray[i].getDataLevel() != 1) continue;
                try {
                    dataContainerActionResultArray.closeQuery(dataSetActionResultArray[i].isRefreshData());
                    continue;
                }
                catch (DSException dSException) {
                    throw new JRScheduleException((Throwable)dSException);
                }
            }
        }
    }

    private void asList(ReportSetActionResult reportSetActionResult) throws JRScheduleException {
        if (reportSetActionResult == null) {
            return;
        }
        DataSetActionResult[] dataSetActionResultArray = reportSetActionResult.getDataSetActionResults();
        if (dataSetActionResultArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < dataSetActionResultArray.length; ++i) {
                String string = dataSetActionResultArray[i].getObjectName();
                int n = dataSetActionResultArray[i].getOperation();
                if (n != 2 || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            if (!arrayList.isEmpty()) {
                String[] stringArray = arrayList.toArray(new String[0]);
                this.rptSetEngine.clearDataSetCenters(stringArray);
            }
        }
    }
}

