/*
 * Decompiled with CFR 0.152.
 */
package jet.rptservice.structurengine.engine.infocenter;

import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetObject;
import jet.formula.JetRptFormula;
import jet.ireport.IDataContainer;
import jet.reportset.JetRptDataSet;
import jet.reportset.JetRptReport;
import jet.rptservice.api.infocenter.IReportCenter;
import jet.rptservice.engine.infocenter.DataContainerNode;
import jet.rptservice.pub.DataContainerRunInfo;
import jet.rptservice.pub.ReportDirectInfo;
import jet.rptservice.pub.ReportFullInfo;
import jet.rptservice.pub.ReportRunInfo;
import jet.rptservice.pub.ReportStructureInfo;
import jet.rptservice.structurengine.engine.SReportEngine;
import jet.rptservice.structurengine.engine.infocenter.SReportViewCenter;
import jet.rptservice.util.ReportTools;
import jet.util.ScheduleTools;

public class SReportCenter
implements IReportCenter {
    private String SEDU;
    private JetRptReport add;
    private SReportEngine addAll;
    private DataContainerNode equals;
    private ReportRunInfo findNodeByName;

    public SReportCenter(JetRptReport jetRptReport, SReportEngine sReportEngine, ReportDirectInfo reportDirectInfo, ReportFullInfo reportFullInfo) {
        this.SEDU = reportDirectInfo.getRptName();
        this.add = jetRptReport;
        this.addAll = sReportEngine;
    }

    public String[] getViewNames() {
        return this.addAll.getViewNames();
    }

    public void refresh(SReportViewCenter sReportViewCenter) {
        this.findNodeByName = sReportViewCenter.getReportRunInfo();
        ReportFullInfo reportFullInfo = this.findNodeByName.getRptFullInfo();
        this.equals = this.SEDU(this.add, reportFullInfo);
    }

    private DataContainerNode SEDU(JetRptReport jetRptReport, ReportFullInfo reportFullInfo) {
        return ReportStructureInfo.getDataContainerNode((JetRptReport)this.add, (ReportStructureInfo)reportFullInfo);
    }

    public String getRptName() {
        return this.SEDU;
    }

    private String[] add(String string) {
        DataContainerNode dataContainerNode = this.equals.findNodeByName(string);
        if (dataContainerNode == null) {
            return null;
        }
        Vector vector = dataContainerNode.getAllMergedSubDcInstNames();
        return vector.isEmpty() ? null : vector.toArray(new String[0]);
    }

    Vector getMappingNames(String string, int n) {
        String[] stringArray = this.add(string);
        if (stringArray == null) {
            return null;
        }
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            DataContainerRunInfo dataContainerRunInfo = this.findNodeByName.getContainerRunInfo(stringArray[i]);
            if (dataContainerRunInfo == null) continue;
            Vector vector2 = null;
            switch (n) {
                case 0: {
                    vector2 = dataContainerRunInfo.getAllDbFields();
                    break;
                }
                case 1: {
                    vector2 = dataContainerRunInfo.getParameterNames();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    Vector vector3 = this.addAll(n, dataContainerRunInfo);
                    vector2 = this.equals(vector3);
                    break;
                }
            }
            if (vector2 == null) continue;
            vector.removeAll(vector2);
            vector.addAll(vector2);
        }
        return vector;
    }

    Vector getFormulas(String string, int n) {
        String[] stringArray = this.add(string);
        if (stringArray == null) {
            return null;
        }
        Vector vector = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            DataContainerRunInfo dataContainerRunInfo = this.findNodeByName.getContainerRunInfo(stringArray[i]);
            Vector vector2 = this.addAll(n, dataContainerRunInfo);
            if (vector2 == null) continue;
            vector.removeAll(vector2);
            vector.addAll(vector2);
        }
        return vector.isEmpty() ? null : vector;
    }

    private Vector addAll(int n, DataContainerRunInfo dataContainerRunInfo) {
        Vector vector;
        if (dataContainerRunInfo == null) {
            return null;
        }
        switch (n) {
            case 2: {
                vector = dataContainerRunInfo.getByRecordFormulas(0);
                break;
            }
            case 3: {
                vector = dataContainerRunInfo.getConstFormulas();
                break;
            }
            case 4: {
                vector = dataContainerRunInfo.getGlobalFormulas();
                break;
            }
            default: {
                vector = new Vector();
            }
        }
        return vector;
    }

    private Vector equals(Vector vector) {
        if (vector == null) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        for (JetRptFormula jetRptFormula : vector) {
            vector2.add(jetRptFormula.getName());
        }
        return vector2;
    }

    DataContainerNode getRootDataContainer() {
        return this.equals;
    }

    public void clearMem() {
        this.equals = null;
        this.findNodeByName = null;
    }

    Hashtable getCFFormulas(String string) {
        if (this.equals == null) {
            return null;
        }
        TreeIterator treeIterator = new TreeIterator(this.equals, true);
        Hashtable hashtable = new Hashtable();
        while (treeIterator.hasMoreElements()) {
            String[] stringArray;
            JetRptDataSet jetRptDataSet;
            DataContainerNode dataContainerNode = treeIterator.nextElement();
            String string2 = dataContainerNode.getContainerName();
            IDataContainer iDataContainer = (IDataContainer)this.add.nameToObject(string2);
            if (iDataContainer == null || (jetRptDataSet = (JetRptDataSet)ReportTools.getDataSet((JetObject)((JetObject)iDataContainer))) == null || !string.equals(jetRptDataSet.getInstName()) || (stringArray = this.add(string2)) == null || stringArray.length <= 0) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                Hashtable hashtable2;
                DataContainerRunInfo dataContainerRunInfo = this.findNodeByName.getContainerRunInfo(stringArray[i]);
                if (dataContainerRunInfo == null || (hashtable2 = dataContainerRunInfo.getCFFormulas()) == null) continue;
                hashtable.putAll(hashtable2);
            }
        }
        return hashtable;
    }

    Hashtable getFlyFormulas(String string) {
        if (this.equals == null) {
            return null;
        }
        TreeIterator treeIterator = new TreeIterator(this.equals, true);
        Hashtable hashtable = new Hashtable();
        while (treeIterator.hasMoreElements()) {
            String[] stringArray;
            JetRptDataSet jetRptDataSet;
            DataContainerNode dataContainerNode = treeIterator.nextElement();
            String string2 = dataContainerNode.getContainerName();
            IDataContainer iDataContainer = (IDataContainer)this.add.nameToObject(string2);
            if (iDataContainer == null || (jetRptDataSet = ScheduleTools.getRawQueryDataSet((IDataContainer)iDataContainer)) == null || !string.equals(jetRptDataSet.getInstName()) || (stringArray = this.add(string2)) == null || stringArray.length <= 0) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                Hashtable hashtable2;
                DataContainerRunInfo dataContainerRunInfo = this.findNodeByName.getContainerRunInfo(stringArray[i]);
                if (dataContainerRunInfo == null || (hashtable2 = dataContainerRunInfo.getFlyFormulas()) == null) continue;
                hashtable.putAll(hashtable2);
            }
        }
        return hashtable;
    }

    private class TreeIterator {
        private int SEDU = 0;
        private Vector v = new Vector();

        TreeIterator(DataContainerNode dataContainerNode, boolean bl) {
            this.initTree(dataContainerNode, bl);
        }

        void initTree(DataContainerNode dataContainerNode, boolean bl) {
            DataContainerNode[] dataContainerNodeArray;
            if (dataContainerNode == null) {
                return;
            }
            if (!bl) {
                this.v.addElement(dataContainerNode);
            }
            if ((dataContainerNodeArray = dataContainerNode.getChildren()) != null) {
                for (int i = 0; i < dataContainerNodeArray.length; ++i) {
                    this.initTree(dataContainerNodeArray[i], bl);
                }
            }
            if (bl) {
                this.v.addElement(dataContainerNode);
            }
        }

        boolean hasMoreElements() {
            return this.SEDU < this.v.size();
        }

        DataContainerNode nextElement() {
            return (DataContainerNode)this.v.elementAt(this.SEDU++);
        }

        void reset() {
            this.SEDU = 0;
        }
    }
}

