/*
 * Decompiled with CFR 0.152.
 */
package jet.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import jet.Env;
import jet.JSRuntimeException;
import jet.api.CatalogAPI;
import jet.api.Designer;
import jet.cs.CSUtil;
import jet.server.DefaultServerEnv;
import jet.server.MultipleInstanceServerEnv;
import jet.server.MyProperties;
import jet.server.ServerEnv;
import jet.server.api.http.CustomizedServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.util.ResourceLock;
import jet.server.util.ServerUtil;
import jet.server.util.ZipArchive;
import jet.server.util.webxml.WebXml;

public final class ServerEnvBuilder {
    public static final String JNDI_ENV = "java:comp/env/";
    public static final String SYSTEMDS = "jreport.datasource.systemtables";
    public static final String REALMDS = "jreport.datasource.realmtables";
    public static final String PROFILINGDS = "jreport.datasource.profiling";
    public static final String HOME_ROOT = ".jreport";
    public static final String CONTEXT = "jreport.context";
    public static final String RPT_HOME = "reporthome";
    private static final String BuildNumber = "bin" + File.separator;
    private static final String I = BuildNumber + "jslc.dat";
    private static final String SEDU = "update.log";
    private static final String add = "bak" + File.separator;
    private static final String append = BuildNumber + "report.ini";
    private static final String booleanValue = BuildNumber + "server.properties";
    private static final String checkRptHome = "jreport.standalone";
    private static final String close = "jreport.rmintegrate";
    private static final String closeLog = "jreport.prepared";
    private static final String closeReportSet = "jreport.envbuilt";
    public static Properties servEnv = new Properties(System.getProperties());
    public static Properties customizeProps = new Properties();
    private static CustomizedServerEnv compress = null;

    public static synchronized void prepare(Properties properties) {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (ServerEnvBuilder.isPrepared()) {
            return;
        }
        servEnv.put(closeLog, new Boolean(true));
        Object object4 = properties.get(CONTEXT);
        if (object4 != null) {
            object3 = (ServletContext)object4;
            WebXml.getInstance(object3);
            object2 = object3.getInitParameterNames();
            while (object2.hasMoreElements()) {
                string = (String)object2.nextElement();
                object = object3.getInitParameter(string);
                servEnv.setProperty(string, (String)object);
                System.setProperty(string, (String)object);
            }
        }
        ServerEnvBuilder.destory();
        ServerEnvBuilder.deleteOnExit();
        if (ServerEnvBuilder.isRMIntegrate()) {
            return;
        }
        ServerEnvBuilder.containsKey();
        if (ServerEnvBuilder.isStandalone()) {
            return;
        }
        try {
            ServerEnvBuilder.copyAllFiles(properties, SYSTEMDS);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        try {
            ServerEnvBuilder.copyAllFiles(properties, REALMDS);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        try {
            ServerEnvBuilder.copyAllFiles(properties, PROFILINGDS);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        object3 = properties.getProperty("jreport.url.encoding", "UTF-8");
        servEnv.setProperty("jreport.url.encoding", (String)object3);
        object2 = servEnv.getProperty(RPT_HOME);
        if (object2 != null) {
            ServerEnvBuilder.setReporthome((String)object2);
            return;
        }
        object2 = properties.getProperty(RPT_HOME);
        if (object2 != null) {
            ServerEnvBuilder.setReporthome((String)object2);
            return;
        }
        string = null;
        string = properties.getProperty("jreport.servenv");
        if (ServerEnvBuilder.isNull(string)) {
            string = servEnv.getProperty("jreport.servenv");
        }
        if (ServerEnvBuilder.isNull(string)) {
            try {
                object = new InitialContext();
                Context context = (Context)((InitialContext)object).lookup("java:comp/env");
                try {
                    string = (String)context.lookup("jreport.servenv");
                }
                catch (NameNotFoundException nameNotFoundException) {}
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (!ServerEnvBuilder.isNull(string)) {
            if ("jet.server.MultipleInstanceServerEnv".equals(string)) {
                compress = new MultipleInstanceServerEnv(properties);
            } else if ("jet.server.DefaultServerEnv".equals(string)) {
                compress = new DefaultServerEnv(properties);
            } else {
                try {
                    compress = (CustomizedServerEnv)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            compress = new DefaultServerEnv(properties);
        }
        object2 = compress.getReportHome();
        if (object2 != null) {
            ServerEnvBuilder.setReporthome((String)object2);
            return;
        }
        object = System.getProperty("user.home", ".");
        object = ((String)object).endsWith(File.separator) ? object : (String)object + File.separator;
        object2 = (String)object + HOME_ROOT + File.separator + "default";
        ServerEnvBuilder.setReporthome((String)object2);
    }

    public static synchronized boolean isPrepared() {
        return ServerEnvBuilder.BuildNumber(closeLog, false);
    }

    public static synchronized boolean isEnvBuilt() {
        return ServerEnvBuilder.BuildNumber(closeReportSet, false);
    }

    public static synchronized boolean isStandalone() {
        return ServerEnvBuilder.BuildNumber(checkRptHome, false);
    }

    public static synchronized boolean isRMIntegrate() {
        return ServerEnvBuilder.BuildNumber(close, false);
    }

    private static boolean BuildNumber(String string, boolean bl) {
        Boolean bl2 = (Boolean)servEnv.get(string);
        return bl2 != null ? bl2 : bl;
    }

    private static boolean isNull(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static synchronized void build(Properties properties) throws Exception {
        if (!ServerEnvBuilder.isPrepared() || ServerEnvBuilder.isEnvBuilt()) {
            return;
        }
        if (ServerEnvBuilder.isRMIntegrate() || ServerEnvBuilder.isStandalone()) {
            return;
        }
        String string = servEnv.getProperty(RPT_HOME);
        boolean bl = ServerEnvBuilder.booleanValue(string);
        ClassLoader classLoader = null;
        String string2 = ServerUtil.reflectClasspath(classLoader, "workspace/bin/jslc.dat", "jrenv.jar");
        if (string2 == null) {
            if (bl) {
                servEnv.put(closeReportSet, new Boolean(true));
                return;
            }
            String string3 = "Can not locate jrenv package.";
            throw new Exception(string3);
        }
        boolean bl2 = true;
        if (bl) {
            if (ServerEnvBuilder.checkRptHome(string, string2)) {
                ServerEnvBuilder.closeLog(string);
                bl2 = false;
            } else {
                servEnv.put(closeReportSet, new Boolean(true));
                return;
            }
        }
        if (string2.startsWith("jar:")) {
            string2 = string2.substring("jar:".length());
            ServerEnvBuilder.add(string2, string);
        } else if (string2.startsWith("file:")) {
            string2 = string2.substring("file:".length());
            ServerEnvBuilder.append(string2 + "workspace", string);
        }
        ServerEnvBuilder.closeReportSet(string);
        if (bl2) {
            ServerEnvBuilder.compress(string);
        }
        if (!ServerEnvBuilder.I()) {
            ServerEnvBuilder.SEDU(string);
        }
        servEnv.put(closeReportSet, new Boolean(true));
    }

    private static boolean I() {
        String string = System.getProperty("os.name");
        string = string.toUpperCase();
        return string.startsWith("WINDOWS");
    }

    private static void SEDU(String string) {
        String string2 = !string.endsWith(File.separator) ? string + File.separator : string;
        String string3 = "chmod 755 " + string2 + "derby/bin/";
        try {
            Runtime.getRuntime().exec(string3 + "env.sh");
            Runtime.getRuntime().exec(string3 + "lj.sh");
            Runtime.getRuntime().exec(string3 + "startNetworkServer.sh");
            Runtime.getRuntime().exec(string3 + "stopNetworkServer.sh");
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    private static void add(String string, String string2) throws Exception {
        ZipArchive zipArchive = new ZipArchive();
        try {
            zipArchive.open(string, "r");
            zipArchive.expand("workspace/", string2, false);
        }
        catch (Exception exception) {
            String string3 = "Can not extract env package: " + string;
            throw new Exception(string3);
        }
        finally {
            try {
                zipArchive.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void append(String string, String string2) throws Exception {
        boolean bl = false;
        String string3 = servEnv.getProperty("java.io.tmpdir");
        SecureRandom secureRandom = new SecureRandom();
        String string4 = Integer.toHexString(secureRandom.nextInt()) + ".jar";
        File file = new File(string3, string4);
        String string5 = file.getAbsolutePath();
        ZipArchive zipArchive = new ZipArchive();
        try {
            zipArchive.open(string5, "w");
            zipArchive.compress(string, "/", true);
            bl = true;
        }
        catch (Exception exception) {
            String string6 = "Can not extract env package: " + string5;
            throw new Exception(string6);
        }
        finally {
            try {
                zipArchive.close();
            }
            catch (IOException iOException) {}
        }
        if (bl) {
            ServerEnvBuilder.add(string5, string2);
        }
        file.deleteOnExit();
    }

    private static boolean booleanValue(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        ResourceLock resourceLock = ResourceLock.newResourceLock(string2);
        boolean bl = resourceLock.tryLock();
        if (!bl) {
            resourceLock.destory();
            throw new JSRuntimeException(670011, new Object[]{string2}, null);
        }
        File file2 = new File(string, I);
        return file2.exists();
    }

    private static boolean checkRptHome(String string, String string2) {
        System.out.print("Check whether need to update workspace... ");
        boolean bl = true;
        File file = new File(string, BuildNumber + SEDU);
        if (file.exists()) {
            bl = ServerEnvBuilder.close(file);
        }
        System.err.println(bl);
        return bl;
    }

    private static boolean close(File file) {
        System.out.print("Check whether it is a different version...");
        boolean bl = true;
        String string = null;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            int n = CSUtil.parseInt(properties.getProperty("build"), -1);
            int n2 = ServerEnv.BuildNumber;
            string = "Exists version: " + properties.toString() + "\nNew version: " + ServerEnv.getVerWithoutProducteInfo();
            if (n == n2) {
                int n3;
                float f = CSUtil.parseFloat(properties.getProperty("update"), -1.0f);
                if (f == (float)(n3 = ServerEnv.dot3)) {
                    bl = false;
                } else {
                    int n4 = ServerEnv.dot4;
                    float f2 = CSUtil.parseFloat(n3 + "." + n4, -1.0f);
                    if (f == f2) {
                        bl = false;
                    }
                }
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        System.out.println(bl);
        if (string != null) {
            System.out.println(string);
        }
        return bl;
    }

    private static void closeLog(String string) {
        Object object;
        File file;
        System.err.print("Begin backup workspace...");
        File file2 = new File(string, add);
        if (!file2.exists() || !file2.isDirectory()) {
            file2.mkdir();
        }
        int n = 0;
        File[] fileArray = file2.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                int n2;
                file = fileArray[i];
                if (!file.isDirectory() || !CSUtil.isNumeric((String)(object = file.getName())) || (n2 = new Integer((String)object).intValue()) <= n) continue;
                n = n2;
            }
        }
        String string2 = ++n < 10 ? "00" + n : (n < 100 ? "0" + n : "" + n);
        file = new File(file2.getAbsolutePath(), string2);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdir();
        }
        if (!((File)(object = new File(file.getAbsolutePath(), "bin"))).exists() || !((File)object).isDirectory()) {
            ((File)object).mkdir();
        }
        try {
            CSUtil.copyAllFiles(string + File.separator + "bin", ((File)object).getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        File file3 = new File(file.getAbsolutePath(), "lib");
        if (!file3.exists() || !file3.isDirectory()) {
            file3.mkdir();
        }
        try {
            CSUtil.copyAllFiles(string + File.separator + "lib", file3.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.err.println(" Ok.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeReportSet(String string) {
        Object object;
        Object object2;
        File file = new File(string, append);
        Properties properties = new Properties();
        if (file.exists()) {
            object2 = null;
            try {
                object2 = new FileInputStream(file);
                properties.load((InputStream)object2);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            finally {
                if (object2 != null) {
                    try {
                        ((InputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            properties.setProperty("dmPath", "dm");
            properties.setProperty("helpPath", "help");
            properties.setProperty("templatePath", "template");
            properties.setProperty("tempPath", "temp");
            properties.setProperty("stylePath", ServerEnv.getStyleFolder());
        }
        object2 = properties.keys();
        while (object2.hasMoreElements()) {
            object = ((String)object2.nextElement()).trim();
            String string2 = properties.getProperty((String)object);
            if (string2.startsWith(string)) continue;
            string2 = string.endsWith(File.separator) ? string + string2 : string + File.separator + string2;
            properties.setProperty((String)object, string2);
        }
        object = null;
        try {
            object = new FileOutputStream(file);
            properties.store((OutputStream)object, "paths");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        finally {
            if (object != null) {
                try {
                    ((OutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void compress(String string) {
        ArrayList<DatasourceInfo> arrayList;
        ArrayList<DatasourceInfo> arrayList2;
        String string2 = string.endsWith(File.separator) ? string : string + File.separator;
        ArrayList[] arrayListArray = new ArrayList[2];
        arrayListArray[0] = arrayList2 = new ArrayList<DatasourceInfo>();
        DatasourceInfo datasourceInfo = new DatasourceInfo();
        datasourceInfo.dsName = "Data Source 1";
        datasourceInfo.connName = "jdbc:hsqldb:JRDemo13100";
        datasourceInfo.url = "jdbc:hsqldb:" + string2 + "db" + File.separator + "JRDemo";
        arrayList2.add(datasourceInfo);
        arrayListArray[1] = arrayList = new ArrayList<DatasourceInfo>();
        datasourceInfo = new DatasourceInfo();
        datasourceInfo.dsName = "Data Source 2";
        datasourceInfo.connName = "XML:Jinfonet";
        datasourceInfo.url = "JinfonetXML";
        arrayList.add(datasourceInfo);
        datasourceInfo = new DatasourceInfo();
        datasourceInfo.dsName = "Data Source 3";
        datasourceInfo.connName = "XML:Shipping";
        datasourceInfo.url = "Shipping";
        arrayList.add(datasourceInfo);
        ServerEnvBuilder.connName(string, "SampleReports/SampleReports.cat", arrayListArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connName(String string, String string2, ArrayList[] arrayListArray) {
        String string3 = string.endsWith(File.separator) ? string : string + File.separator;
        String string4 = string3 + "temp";
        String string5 = string3 + "jreports" + File.separator + string2;
        File file = new File(string5);
        if (!file.exists()) {
            return;
        }
        Designer designer = null;
        CatalogAPI catalogAPI = null;
        try {
            Object object;
            Object object22;
            designer = new Designer(file.getParent(), file.getName());
            designer.setCallerID("Pasdf56q890weB2s5fC43fDE");
            catalogAPI = designer.getCatalogAPI();
            StringBuffer stringBuffer = new StringBuffer();
            designer.setLog((OutputStream)new FileOutputStream(string4 + File.separator + "log1.log"), "ISO-8859-1");
            catalogAPI.setLog((OutputStream)new FileOutputStream(string4 + File.separator + "log2.log"), "ISO-8859-1");
            ArrayList arrayList = arrayListArray[0];
            for (Object object22 : arrayList) {
                object = catalogAPI.getHandle(((DatasourceInfo)object22).dsName, ((DatasourceInfo)object22).connName, 1);
                if (object == null) continue;
                catalogAPI.set((String)object, "URL", ((DatasourceInfo)object22).url);
            }
            ArrayList arrayList2 = arrayListArray[1];
            object22 = arrayList2.iterator();
            while (object22.hasNext()) {
                object = (DatasourceInfo)object22.next();
                String string6 = catalogAPI.getHandle(((DatasourceInfo)object).dsName, ((DatasourceInfo)object).connName, 26);
                if (string6 != null) {
                    String[] stringArray = catalogAPI.getHandles(string6, 27);
                    if (stringArray != null && stringArray.length > 0) {
                        String string7 = string3 + "db" + File.separator + "xml" + File.separator + ((DatasourceInfo)object).url;
                        catalogAPI.set(stringArray[0], "MetadataURI", string7 + ".xsd");
                        catalogAPI.set(stringArray[0], "InstanceURI", string7 + ".xml");
                        continue;
                    }
                    stringBuffer.append("Can't find XML handles for '").append(string6).append("'. cat error: ").append(catalogAPI.getError()).append("\n");
                    continue;
                }
                stringBuffer.append("Without XML handle to cat '").append(catalogAPI).append("'. cat error: ").append(catalogAPI.getError()).append("\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (catalogAPI != null) {
                try {
                    catalogAPI.save();
                    catalogAPI.closeLog();
                }
                catch (Exception exception) {}
            }
            if (designer != null) {
                try {
                    designer.closeLog();
                    designer.closeReportSet();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void containsKey() {
        ClassLoader classLoader = null;
        String string = "hsqlServlet.class";
        String string2 = "org/hsqldb/jdbcDriver.class";
        String string3 = null;
        string3 = ServerUtil.reflectClasspath(classLoader, string);
        if (string3 == null) {
            string3 = ServerUtil.reflectClasspath(classLoader, string2);
        }
        if (string3 != null && string3.startsWith("jar:")) {
            string3 = string3.substring("jar:".length());
            servEnv.setProperty("hsqldb.classpath", string3);
        }
    }

    private static void copyAllFiles(Properties properties, String string) throws NamingException {
        InitialContext initialContext = null;
        ServletContext servletContext = null;
        String string2 = null;
        string2 = properties.getProperty(string);
        if (!ServerEnvBuilder.isNull(string2)) {
            servEnv.setProperty(string, string2);
            return;
        }
        try {
            initialContext = new InitialContext();
            initialContext.lookup("java:comp/env");
        }
        catch (NoInitialContextException noInitialContextException) {
            initialContext = null;
            return;
        }
        catch (NamingException namingException) {
            initialContext = null;
            return;
        }
        Object object = properties.get(CONTEXT);
        Object object2 = object = object == null ? servEnv.get(CONTEXT) : object;
        if (object != null) {
            servletContext = (ServletContext)object;
        }
        try {
            string2 = (String)initialContext.lookup(JNDI_ENV + string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                string2 = (String)initialContext.lookup(string);
            }
            catch (NameNotFoundException nameNotFoundException2) {
                // empty catch block
            }
        }
        if (ServerEnvBuilder.isNull(string2) && servletContext != null && !ServerEnvBuilder.isNull(string2 = servletContext.getInitParameter(string)) && string2.startsWith("jndi://")) {
            try {
                string2 = "jndi://" + ServerEnvBuilder.customizeProps(initialContext, string2.substring("jndi://".length()));
            }
            catch (NamingException namingException) {
                string2 = null;
                namingException.printStackTrace();
            }
        }
        if (!ServerEnvBuilder.isNull(string2)) {
            servEnv.setProperty(string, string2);
        }
        try {
            initialContext.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String customizeProps(Context context, String string) throws NamingException {
        Object object = null;
        String string2 = string;
        String string3 = null;
        try {
            object = context.lookup(string2);
        }
        catch (NameNotFoundException nameNotFoundException) {
            string3 = nameNotFoundException.getMessage();
            if (!string.startsWith("java:")) {
                string2 = JNDI_ENV + string;
                try {
                    object = context.lookup(string2);
                }
                catch (NameNotFoundException nameNotFoundException2) {
                    string3 = nameNotFoundException2.getMessage();
                }
            }
        }
        finally {
            DataSource dataSource = null;
            if (object != null) {
                dataSource = (DataSource)object;
                if (string2.startsWith(JNDI_ENV)) {
                    string2 = string2.substring(JNDI_ENV.length());
                }
            } else {
                throw new NameNotFoundException(string3);
            }
            context.rebind(string2, (Object)dataSource);
        }
        return string2;
    }

    public static synchronized void mergeServerProperties(Properties properties) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Properties properties2;
        if (ServerEnvBuilder.isRMIntegrate() || ServerEnvBuilder.isStandalone()) {
            return;
        }
        if (!ServerEnvBuilder.isPrepared() || !ServerEnvBuilder.isEnvBuilt()) {
            return;
        }
        Properties properties3 = ServerEnvBuilder.dot3(properties);
        if (compress != null && (properties2 = compress.getServerProperties()) != null) {
            object4 = ServerEnvBuilder.dot3(properties2);
            object3 = ((Properties)object4).keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                properties3.put(object2, ((Properties)object4).get(object2));
            }
        }
        properties2 = new MyProperties();
        object4 = servEnv.getProperty(RPT_HOME);
        object3 = new File((String)object4, booleanValue);
        if (((File)object3).exists()) {
            object2 = new FileInputStream((File)object3);
            ((MyProperties)properties2).load((InputStream)object2);
            ((FileInputStream)object2).close();
        }
        object2 = properties3.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            properties2.put(object, properties3.get(object));
        }
        if (!properties2.isEmpty()) {
            object = new FileOutputStream((File)object3);
            ((MyProperties)properties2).store((OutputStream)object, null);
            ((FileOutputStream)object).close();
        }
    }

    private static void deleteOnExit() {
        if (!servEnv.containsKey(checkRptHome)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            new Exception().printStackTrace(printStream);
            String string = byteArrayOutputStream.toString();
            boolean bl = string.indexOf("jet.server.JREntServer.main") != -1 || string.indexOf("jet.server.monitor.JREntMonServer.main") != -1;
            servEnv.put(checkRptHome, new Boolean(bl));
        }
    }

    private static void destory() {
        if (!servEnv.containsKey(close)) {
            String string = servEnv.getProperty("jrs.remote.host");
            String string2 = servEnv.getProperty("jrs.remote.rmiport");
            if (string == null || string.length() == 0) {
                string = System.getProperty("jrs.remote.host");
            }
            if (string2 == null || string2.length() == 0) {
                string2 = System.getProperty("jrs.remote.rmiport");
            }
            boolean bl = string != null && string.trim().length() > 0;
            servEnv.put(close, new Boolean(bl));
            if (bl) {
                String string3;
                if (string != null && string.length() != 0) {
                    System.setProperty("jrs.remote.host", string);
                }
                if (string2 != null && string2.length() != 0) {
                    System.setProperty("jrs.remote.rmiport", string2);
                }
                if (System.getProperty(string3 = "jrs.rmi.auth_file") == null && servEnv.getProperty(string3) != null) {
                    System.setProperty(string3, servEnv.getProperty(string3));
                }
                String string4 = "jrs.rmi.auth_string";
                String string5 = servEnv.getProperty(string4);
                if (System.getProperty(string4) == null && string5 != null) {
                    System.setProperty(string4, string5);
                }
            }
        }
    }

    public static void setReporthome(String string) {
        string = string.endsWith(File.separator) ? string : string + File.separator;
        servEnv.setProperty(RPT_HOME, string);
        Env.checkRptHome((String)string);
        Env.homePath = string;
    }

    private static Properties dot3(Properties properties) {
        Properties properties2 = customizeProps;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!ServerEnv.isServerPropertyKey(object)) continue;
            properties2.put(object, properties.get(object));
        }
        return properties2;
    }

    public static void release() {
        File file = new File(servEnv.getProperty(RPT_HOME));
        String string = file.getAbsolutePath();
        ResourceLock resourceLock = ResourceLock.newResourceLock(string);
        resourceLock.destory();
    }

    static class DatasourceInfo {
        String dsName;
        String connName;
        String url;

        DatasourceInfo() {
        }
    }
}

