/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.admin;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import jet.cs.util.APIEnums;
import jet.server.api.admin.DynamicConnectionUserMapping;

public final class DynamicConnectionRecord
implements Serializable,
Cloneable {
    private int recordId = -1;
    private String orgName;
    private String catalog;
    private String datasource;
    private String connectionName;
    private Set<DynamicConnectionUserMapping> userMapping = new HashSet<DynamicConnectionUserMapping>();
    private String name;
    private String description;
    private Boolean isJndiDatasource;
    private String jndiDatasourceName;
    private String url;
    private String jdbcDriver;
    private String dateFormat;
    private APIEnums.ConnectionNamePattern namePattern;
    private APIEnums.ConnectionReadOnly readOnly;
    private String timeFormat;
    private String timestampFormat;
    private APIEnums.ConnectionTransactionIsolation transactionIsolation;
    private String extraCharacters;
    private String quoteCharacter;
    private String databaseUser;
    private String databasePassword;

    public int hashCode() {
        return this.recordId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DynamicConnectionRecord)) {
            return false;
        }
        DynamicConnectionRecord dynamicConnectionRecord = (DynamicConnectionRecord)object;
        return this.recordId == dynamicConnectionRecord.recordId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.orgName != null) {
            stringBuilder.append(this.orgName).append("\\");
        }
        stringBuilder.append(this.name);
        stringBuilder.append(this.userMapping);
        return stringBuilder.toString();
    }

    public DynamicConnectionRecord clone() {
        try {
            DynamicConnectionRecord dynamicConnectionRecord = (DynamicConnectionRecord)super.clone();
            dynamicConnectionRecord.userMapping = new HashSet<DynamicConnectionUserMapping>();
            for (DynamicConnectionUserMapping dynamicConnectionUserMapping : this.userMapping) {
                dynamicConnectionRecord.userMapping.add(dynamicConnectionUserMapping.clone());
            }
            return dynamicConnectionRecord;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int getRecordId() {
        return this.recordId;
    }

    public void setRecordId(int n) {
        this.recordId = n;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String string) {
        this.orgName = string;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String string) {
        this.datasource = string;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public Set<DynamicConnectionUserMapping> getUserMapping() {
        return this.userMapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Boolean isJndiDatasource() {
        return this.isJndiDatasource;
    }

    public void setIsJndiDatasource(Boolean bl) {
        this.isJndiDatasource = bl;
    }

    public String getJndiDatasourceName() {
        return this.jndiDatasourceName;
    }

    public void setJndiDatasourceName(String string) {
        this.jndiDatasourceName = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String string) {
        this.jdbcDriver = string;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public APIEnums.ConnectionNamePattern getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(APIEnums.ConnectionNamePattern connectionNamePattern) {
        this.namePattern = connectionNamePattern;
    }

    public APIEnums.ConnectionReadOnly getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(APIEnums.ConnectionReadOnly connectionReadOnly) {
        this.readOnly = connectionReadOnly;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String string) {
        this.timeFormat = string;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat = string;
    }

    public APIEnums.ConnectionTransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(APIEnums.ConnectionTransactionIsolation connectionTransactionIsolation) {
        this.transactionIsolation = connectionTransactionIsolation;
    }

    public String getExtraCharacters() {
        return this.extraCharacters;
    }

    public void setExtraCharacters(String string) {
        this.extraCharacters = string;
    }

    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public void setQuoteCharacter(String string) {
        this.quoteCharacter = string;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String string) {
        this.databaseUser = string;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String string) {
        this.databasePassword = string;
    }
}

