/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.crd;

import java.util.HashMap;
import java.util.Vector;
import jet.server.api.crd.CRDInfo;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CubeInfoKey;
import jet.server.api.crd.CubeUsage;

public class CubeInfo
extends CRDInfo {
    private static final long serialVersionUID = -4234702000731611843L;
    public static final short LOCATION_UNKNOWN = 0;
    public static final short LOCATION_IN_MEMORY = 1;
    public static final short LOCATION_ON_DISK = 2;
    private double maxMemory = 0.0;
    protected long actualUsedMemory = 0L;
    protected HashMap<String, CubeUsage> usingReports = new HashMap();
    protected short location;
    private boolean canSwaptoDisk = false;

    public CubeInfo(String string, String string2, int n, String string3, String string4) {
        if (string4 != null && string4.trim().length() > 0) {
            this.crdKey = new CubeInfoKey(string, string2, n, string3, string4);
            this.cacheType = 2;
        } else {
            this.crdKey = new CRDInfoKey(string, string2, n, string3);
            this.cacheType = 1;
        }
    }

    public CubeInfo(String string, String string2, int n, String string3, String string4, int n2) {
        if (string4 != null && string4.trim().length() > 0) {
            this.crdKey = new CubeInfoKey(string, string2, n, string3, string4);
        } else {
            this.crdKey = new CRDInfoKey(string, string2, n, string3);
            this.cacheType = 1;
        }
        this.cacheType = n2;
    }

    protected CubeInfo(CubeInfo cubeInfo) {
        this.restoreInfo(cubeInfo);
    }

    public String getBVName() {
        if (this.crdKey instanceof CubeInfoKey) {
            return ((CubeInfoKey)this.crdKey).getBVName();
        }
        return null;
    }

    public Vector<CubeUsage> listCubeUsage() {
        Vector<CubeUsage> vector = new Vector<CubeUsage>(this.usingReports.values());
        return vector;
    }

    public double getMaxAllowMemory() {
        return this.maxMemory;
    }

    public long getActualUsedMemory() {
        return this.actualUsedMemory;
    }

    public void setMaxAllowMemory(double d) {
        this.maxMemory = d;
    }

    public short getLocation() {
        return this.location;
    }

    public boolean getCanSwaptoDisk() {
        return this.canSwaptoDisk;
    }

    public void setCanSwaptoDisk(boolean bl) {
        this.canSwaptoDisk = bl;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof CubeInfo) {
            CubeInfo cubeInfo = (CubeInfo)object;
            if (this.getBVName() == null ? cubeInfo.getBVName() == null : cubeInfo.getBVName() != null && this.getBVName().equals(cubeInfo.getBVName())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "{" + this.toStr() + "}";
    }

    @Override
    protected String toStr() {
        StringBuffer stringBuffer = new StringBuffer(super.toStr());
        stringBuffer.append(", maxMemory:").append(this.maxMemory);
        stringBuffer.append(", actualMemory:").append(this.actualUsedMemory);
        stringBuffer.append(", location:").append(this.location);
        return stringBuffer.toString();
    }

    protected void restoreInfo(CubeInfo cubeInfo) {
        super.restoreInfo(cubeInfo);
        this.maxMemory = cubeInfo.maxMemory;
        this.actualUsedMemory = cubeInfo.actualUsedMemory;
        this.location = cubeInfo.location;
    }
}

