/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.api.db.Workspace;
import jet.server.api.db.Workspaces;
import jet.server.db.Connector;
import jet.server.db.adapter.DBFactory;
import jet.server.db.core.ConnectorManager;
import jet.server.db.core.Dbs;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.WorkspaceManager;
import jet.server.db.transfer.AbstractTransferHelp;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.util.WebSecurityUtil;

public final class DBManager {
    public static Workspace getDefaultWorkspace() {
        return WorkspaceManager.getInstance().getActiveWorkspace();
    }

    public static Workspace getSystemWorkspace() {
        return WorkspaceManager.getInstance().getSystemWorkspace();
    }

    public static Workspaces workspaces() {
        return WorkspaceManager.getInstance().workspaces();
    }

    public static Workspace workspaces(int n) {
        return WorkspaceManager.getInstance().workspaces(n);
    }

    public static Workspace workspaces(String string) {
        return WorkspaceManager.getInstance().workspaces(string);
    }

    public static boolean isDefault(Workspace workspace) {
        return WorkspaceManager.getInstance().isDefault(workspace);
    }

    public static String[] getAllSupportDrivers() {
        return DBFactory.getAllSupportDrivers();
    }

    public static String[] getAllSupportDBTypes() {
        return DBFactory.getAllSupportDBTypes();
    }

    public static synchronized boolean testConnecting(Properties properties) {
        boolean bl = false;
        Connector connector = ConnectorManager.getInstance().getConnector(properties);
        try {
            bl = connector.testConnecting();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            bl = false;
        }
        return bl;
    }

    public static synchronized boolean backup(Database database, String string) {
        try {
            return database.backup(string);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 3);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
        }
        return false;
    }

    public static synchronized boolean cutdownTable(Table table, String string, String string2) {
        if (table != null) {
            Database database = table.getDatabase();
            try {
                database.cutdownTable(table, string, string2);
                return true;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 3);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        return false;
    }

    public static synchronized boolean importsTable(Table table, String string) {
        Database database = table.getDatabase();
        try {
            database.importsTable(table, string);
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 3);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
        }
        return false;
    }

    public static synchronized boolean saveConfig() {
        WorkspaceManager.getInstance().saveConfig();
        return true;
    }

    public static synchronized FieldValue[] statResultVersion(Database database) throws SQLException {
        String string = Dbs.fullTableName(database.getProperty("schema"), "RESULTVERSION_3");
        Table table = database.tables(string);
        Field[] fieldArray = new Field[3];
        fieldArray[0] = table.fields("ID").createClone();
        ((FieldImpl)fieldArray[0]).setCalculating(1);
        fieldArray[1] = table.fields("createdTime").createClone();
        ((FieldImpl)fieldArray[1]).setCalculating(5);
        fieldArray[2] = table.fields("createdTime").createClone();
        ((FieldImpl)fieldArray[2]).setCalculating(4);
        FieldValue[] fieldValueArray = null;
        Recordset recordset = table.query(fieldArray, null, ParameterMetaInfo.EMPTY, true);
        FieldImpl fieldImpl = new FieldImpl(table, "createdTime", JDBCType.TIMESTAMP, 0, 0, 0);
        if (recordset.next()) {
            fieldValueArray = new FieldValue[3];
            fieldValueArray[0] = recordset.fields(0);
            int n = recordset.getInt(0);
            fieldValueArray[1] = fieldImpl.createFieldValue();
            fieldValueArray[2] = fieldImpl.createFieldValue();
            if (n > 0) {
                fieldValueArray[1].setValue(new Timestamp(recordset.getLong(1)));
                fieldValueArray[2].setValue(new Timestamp(recordset.getLong(2)));
            } else {
                fieldValueArray[1].setValue(new Timestamp(System.currentTimeMillis()));
                fieldValueArray[2].setValue(new Timestamp(System.currentTimeMillis()));
            }
        }
        recordset.close();
        return fieldValueArray;
    }

    public static synchronized FieldValue[] statTaskContext(Database database) throws SQLException {
        String string = Dbs.fullTableName(database.getProperty("schema"), "TaskContext_2");
        Table table = database.tables(string);
        Field[] fieldArray = new Field[3];
        fieldArray[0] = table.fields("ID").createClone();
        ((FieldImpl)fieldArray[0]).setCalculating(1);
        fieldArray[1] = table.fields("TS_TSK_COMPLETE").createClone();
        ((FieldImpl)fieldArray[1]).setCalculating(5);
        fieldArray[2] = table.fields("TS_TSK_COMPLETE").createClone();
        ((FieldImpl)fieldArray[2]).setCalculating(4);
        FieldValue[] fieldValueArray = null;
        Recordset recordset = table.query(fieldArray, null, ParameterMetaInfo.EMPTY, true);
        if (recordset.next()) {
            fieldValueArray = recordset.fields();
            int n = recordset.getInt(0);
            if (n == 0) {
                fieldValueArray[1].setValue(new Timestamp(System.currentTimeMillis()));
                fieldValueArray[2].setValue(new Timestamp(System.currentTimeMillis()));
            }
        }
        recordset.close();
        return fieldValueArray;
    }

    public static synchronized Set checkIntegrality(String string) throws SQLException, IOException {
        Object object;
        String string2;
        String string3 = System.getProperty("history_dir");
        String string4 = string3 == null ? ServerEnv.homePath + "history" : string3;
        String string5 = string2 = ServerEnv.isSharedHistDir() ? ServerEnv.getSharedHistDir() : string4;
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        HashMap hashMap = DBManager.EMPTY(string2);
        Iterator iterator = DBManager.workspaces().iterator();
        while (iterator.hasNext()) {
            object = (Workspace)iterator.next();
            Database database = object.databases(string);
            if (database == null) continue;
            database.checkIntegrality(hashMap);
        }
        System.err.print("Checking " + string2 + " ...");
        object = hashMap.values().iterator();
        boolean bl = false;
        while (object.hasNext()) {
            if (!bl) {
                System.err.println();
                bl = true;
            }
            File file = (File)object.next();
            try {
                StorageEnv.getStorage().delete(Storage.StorageRoot.HISTORY, StorageEnv.getStorageEnv(-1).relativeStoragePath(Storage.StorageRoot.HISTORY, file.getCanonicalPath(), 2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AbstractTransferHelp.deleteExternalData(file);
            System.err.println("Cleanup: " + file.getAbsolutePath());
        }
        if (!bl) {
            System.err.println(" OK");
        }
        System.gc();
        return hashMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getVolumeSummary(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = null;
        Properties properties = null;
        try {
            zipFile = new ZipFile(WebSecurityUtil.validateFilePath(string));
            properties = AbstractTransferHelp.getVolumeSummary(zipFile);
        }
        catch (Exception exception) {
            if (properties == null) {
                properties = new Properties();
                properties.setProperty("status", "-1");
                properties.put("exception", exception);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private static HashMap EMPTY(String string) {
        HashMap<String, File> hashMap = new HashMap<String, File>();
        File file = WebSecurityUtil.validateFilePath(string);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            File[] fileArray2 = fileArray[i].listFiles();
            for (int j = 0; j < fileArray2.length; ++j) {
                if (!fileArray2[j].isDirectory()) continue;
                hashMap.put(fileArray2[j].getAbsolutePath(), fileArray2[j]);
            }
        }
        return hashMap;
    }

    private DBManager() {
    }
}

