/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.exception;

import java.io.Serializable;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import jet.JSException;
import jet.server.util.nls.NlsClientResource;
import jet.server.util.nls.PropertyMessageResourcesFactory;

public class InvalidPasswordException
extends JSException
implements Serializable {
    private static final long serialVersionUID = -1084912674447824085L;
    private boolean isAdvancedPasswordLimitedMinLength = true;
    private int passwordMinLength = 8;
    private boolean isAdvancedPasswordContainsUppercase = true;
    private boolean isAdvancedPasswordContainsLowercase = true;
    private boolean isAdvancedPasswordContainsNumber = true;
    private boolean isAdvancedPasswordContainsSymbols = true;

    public InvalidPasswordException(int n, Object[] objectArray, Throwable throwable) {
        super(n, objectArray, throwable);
    }

    public InvalidPasswordException(int n, Throwable throwable) {
        super(n, throwable);
    }

    public InvalidPasswordException(int n) {
        super(n);
    }

    public InvalidPasswordException(String string) {
        super(string);
    }

    public InvalidPasswordException(Throwable throwable) {
        super(throwable);
    }

    public InvalidPasswordException(boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.isAdvancedPasswordLimitedMinLength = bl;
        this.passwordMinLength = n;
        this.isAdvancedPasswordContainsUppercase = bl2;
        this.isAdvancedPasswordContainsLowercase = bl3;
        this.isAdvancedPasswordContainsNumber = bl4;
        this.isAdvancedPasswordContainsSymbols = bl5;
    }

    public String getNLSMessage(HttpServletRequest httpServletRequest) {
        NlsClientResource nlsClientResource = new NlsClientResource(httpServletRequest);
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = nlsClientResource.getServerResourceFactory();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isAdvancedPasswordContainsUppercase) {
            arrayList.add(propertyMessageResourcesFactory.getMessage("22221356"));
        }
        if (this.isAdvancedPasswordContainsLowercase) {
            arrayList.add(propertyMessageResourcesFactory.getMessage("22221357"));
        }
        if (this.isAdvancedPasswordContainsNumber) {
            arrayList.add(propertyMessageResourcesFactory.getMessage("22221358"));
        }
        if (this.isAdvancedPasswordContainsSymbols) {
            arrayList.add(propertyMessageResourcesFactory.getMessage("22221359"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = arrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            if (i > 0) {
                String string = ", ";
                if (i == n) {
                    string = " " + propertyMessageResourcesFactory.getMessage("22221360") + " ";
                }
                stringBuffer.append(string);
            }
            stringBuffer.append((String)arrayList.get(i));
        }
        String string = "";
        if (this.isAdvancedPasswordLimitedMinLength && stringBuffer.length() > 0) {
            string = propertyMessageResourcesFactory.getMessage("22221353", new String[]{"" + this.passwordMinLength, stringBuffer.toString()});
        } else if (this.isAdvancedPasswordLimitedMinLength && stringBuffer.length() == 0) {
            string = propertyMessageResourcesFactory.getMessage("22221354", new String[]{"" + this.passwordMinLength});
        } else if (stringBuffer.length() > 0) {
            string = propertyMessageResourcesFactory.getMessage("22221355", new String[]{stringBuffer.toString()});
        }
        return string;
    }
}

