/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.Authenticator;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.util.Base64;

public class BaseHttpUtil {
    public static final String PROP_OUTPUT_ENCODING = "output_encoding";
    public static final String CONTENT_LOCATION = "Content-Location";
    private static final String SEDU = ";";
    private static final String append = " ";
    private static final String changePassword = ",";
    private static final String charAt = ":";
    private static final String clear = "\"";
    private static final String clone = "{";
    private static final String close = "}";
    protected static boolean isRemoteServer = false;

    protected BaseHttpUtil() {
    }

    public static String makeQuery(Hashtable hashtable) {
        return CSUtil.makeNoHeadQuery(hashtable);
    }

    public static Properties parseQuery(String string) {
        return CSUtil.parseQuery(string);
    }

    public static String makeQueryWithout(Hashtable hashtable, Map map) {
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                hashtable2.remove(iterator.next());
            }
        }
        return CSUtil.makeQuery(hashtable2);
    }

    public static Properties getParameters(HttpServletRequest httpServletRequest) {
        Object object;
        ServiceLogger.logDebug("BaseHttpUtil.getParameters: RequestURI = " + ServerUtil.filterLogSecretInfo(httpServletRequest.getRequestURI()));
        ServiceLogger.logDebug("BaseHttpUtil.getParameters: RequestURL = " + httpServletRequest.getRequestURL());
        Enumeration enumeration = httpServletRequest.getParameterNames();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = httpServletRequest.getParameterValues(string);
            if (object == null) continue;
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringBuffer.append("&" + string + "=" + object[i]);
            }
        }
        ServiceLogger.logDebug("BaseHttpUtil.getParameters: queryString = " + ServerUtil.filterLogSecretInfo(stringBuffer.toString()));
        int n = BaseHttpUtil.append();
        object = new Properties();
        Properties properties = new Properties();
        switch (n) {
            case 0: {
                BaseHttpUtil.SEDU(httpServletRequest, (Properties)object, SEDU);
                break;
            }
            case 1: {
                BaseHttpUtil.SEDU(httpServletRequest, (Properties)object, append);
                break;
            }
            case 2: {
                BaseHttpUtil.SEDU(httpServletRequest, (Properties)object, changePassword);
                break;
            }
            case 3: {
                BaseHttpUtil.SEDU(httpServletRequest, (Properties)object, charAt);
                break;
            }
            case 4: {
                Enumeration enumeration2 = httpServletRequest.getParameterNames();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    String[] stringArray = httpServletRequest.getParameterValues(string);
                    int n2 = stringArray.length;
                    String string2 = null;
                    properties.clear();
                    if (stringArray.length > 1) {
                        for (int i = 0; i < n2; ++i) {
                            if (i == 0) {
                                string2 = clear + stringArray[0] + clear;
                                properties.put(stringArray[0], "");
                                continue;
                            }
                            if (properties.get(stringArray[i]) != null) continue;
                            string2 = string2 + clear + stringArray[i] + clear;
                            properties.put(stringArray[i], "");
                        }
                    } else {
                        string2 = stringArray[0];
                    }
                    if (string2 == null) continue;
                    ((Properties)object).put(string, string2);
                }
                break;
            }
            case 5: {
                Enumeration enumeration3 = httpServletRequest.getParameterNames();
                while (enumeration3.hasMoreElements()) {
                    String string = (String)enumeration3.nextElement();
                    String[] stringArray = httpServletRequest.getParameterValues(string);
                    int n3 = stringArray.length;
                    String string3 = null;
                    properties.clear();
                    if (stringArray.length > 1) {
                        for (int i = 0; i < n3; ++i) {
                            if (i == 0) {
                                string3 = clone + stringArray[0] + close;
                                properties.put(stringArray[0], "");
                                continue;
                            }
                            if (properties.get(stringArray[i]) != null) continue;
                            string3 = string3 + clone + stringArray[i] + close;
                            properties.put(stringArray[i], "");
                        }
                    } else {
                        string3 = stringArray[0];
                    }
                    if (string3 == null) continue;
                    ((Properties)object).put(string, string3);
                }
                break;
            }
            default: {
                BaseHttpUtil.SEDU(httpServletRequest, (Properties)object, SEDU);
            }
        }
        return object;
    }

    private static Properties SEDU(HttpServletRequest httpServletRequest, Properties properties, String string) {
        Properties properties2 = new Properties();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string2);
            String string3 = httpServletRequest.getParameter("_isMultiple_" + string2);
            if (string3 != null && string3.trim().length() > 0) {
                properties.put(string2, stringArray);
                continue;
            }
            int n = stringArray.length;
            String string4 = null;
            properties2.clear();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    string4 = stringArray[0];
                    properties2.put(stringArray[0], "");
                    continue;
                }
                if (properties2.get(stringArray[i]) != null) continue;
                string4 = string4 + string + stringArray[i];
                properties2.put(stringArray[i], "");
            }
            if (string4 == null) continue;
            properties.put(string2, string4);
        }
        return properties;
    }

    private static int append() {
        String string;
        if (isRemoteServer) {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            string = httpRptServer.getServerEnv().getWebPageOptions().getMultipleParameterValuesDelimiter();
        } else {
            string = ServerEnv.getMultipleParameterValuesDelimiter();
        }
        if (string == null || string.length() == 0) {
            return 0;
        }
        if (string.equals("&nbsp;")) {
            return 1;
        }
        if (string.equals(changePassword)) {
            return 2;
        }
        if (string.equals(charAt)) {
            return 3;
        }
        if (string.equals(clear)) {
            return 4;
        }
        if (string.equals("{}")) {
            return 5;
        }
        return 0;
    }

    public static String decodeEsc(String string) {
        return CSUtil.convertEscapes(string);
    }

    static int getIgnoreCaseIndexOf(String string, String string2) {
        int n = string.indexOf(string2.toLowerCase());
        int n2 = string.indexOf(string2.toUpperCase());
        if (n == -1 && n2 == -1) {
            return -1;
        }
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        return n < n2 ? n : n2;
    }

    public static String decodeEscapeEx(String string) {
        String string2;
        String string3;
        if (string == null) {
            return string;
        }
        String string4 = "";
        char c = ' ';
        int n = BaseHttpUtil.getIgnoreCaseIndexOf(string, "%u");
        while (n >= 0) {
            string4 = string4 + string.substring(0, n);
            string3 = string.substring(n + 2, n + 6);
            string2 = string.substring(n, n + 6);
            string = string.substring(n + 6, string.length());
            try {
                c = (char)Integer.parseInt(string3, 16);
                string4 = string4 + new String(new char[]{c});
            }
            catch (NumberFormatException numberFormatException) {
                string4 = string4 + string2;
            }
            n = BaseHttpUtil.getIgnoreCaseIndexOf(string, "%u");
        }
        string4 = string4 + string;
        n = string4.indexOf("%");
        String string5 = "";
        while (n >= 0) {
            string5 = string5 + string4.substring(0, n);
            string3 = string4.substring(n + 1, n + 3);
            string2 = string4.substring(n, n + 3);
            string4 = string4.substring(n + 3, string4.length());
            try {
                c = (char)Integer.parseInt(string3, 16);
                string5 = string5 + new String(new char[]{c});
            }
            catch (NumberFormatException numberFormatException) {
                string5 = string5 + string2;
            }
            n = string4.indexOf("%");
        }
        string5 = string5 + string4;
        return string5;
    }

    public static String encodeEsc(String string) {
        return CSUtil.replWithEsc(string);
    }

    public static boolean dirIncludeCatalog(HttpRptServer httpRptServer, String string, String string2) {
        int n;
        Vector<PathInfo> vector = null;
        String string3 = null;
        try {
            vector = httpRptServer.getResourceManager().getSubpathsAndCatalogs(string, string2);
        }
        catch (Exception exception) {
            string3 = exception.getMessage();
        }
        int n2 = n = vector == null ? 0 : vector.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            PathInfo pathInfo = vector.elementAt(i);
            try {
                if (!pathInfo.isCatalog()) continue;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static boolean dirIncludeReport(HttpRptServer httpRptServer, String string, String string2) {
        int n;
        Vector<PathInfo> vector = null;
        String string3 = null;
        try {
            vector = httpRptServer.getResourceManager().getSubpathsAndCatalogs(string, string2);
        }
        catch (RptServerException rptServerException) {
            string3 = rptServerException.getMessage();
        }
        int n2 = n = vector == null ? 0 : vector.size();
        if (n == 0) {
            return false;
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        for (int i = 0; i < n; ++i) {
            PathInfo pathInfo = vector.elementAt(i);
            boolean bl = pathInfo.isDir();
            boolean bl2 = pathInfo.isCatalog();
            boolean bl3 = pathInfo.isSelfContainReport();
            boolean bl4 = pathInfo.isReport();
            String string4 = pathInfo.getName();
            String string5 = HttpUtil.encodeEsc(string4);
            if (!bl2 && !bl4 && !bl3) continue;
            return true;
        }
        return false;
    }

    public static String encodeEsc(String string, boolean bl) {
        return CSUtil.replWithEsc(string, bl);
    }

    public static void sendMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string) {
        BaseHttpUtil.changePassword(httpServletRequest, httpServletResponse, n, string, null);
    }

    public static void sendMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, Throwable throwable) {
        BaseHttpUtil.changePassword(httpServletRequest, httpServletResponse, n, null, throwable);
    }

    private static void changePassword(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int n, String string, Throwable throwable) {
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (throwable != null) {
            if (string2 != null) {
                string2 = string2 + " -" + JSvrResource.getMessage("SLT_ERR_65") + ": \n";
            }
            string2 = string2 + SchdTools.getStackTraceString(throwable);
        }
        httpServletResponse.setStatus(n);
        httpServletResponse.setHeader("JRS-MESSAGE", CSUtil.replWithEsc(WebSecurityUtil.validateResponseHeader(string2)));
        try {
            if (n == 200) {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                httpServletResponse.setContentType("text/html");
                servletOutputStream.println("<html>");
                servletOutputStream.println("<head>");
                servletOutputStream.println("<title>" + JSvrResource.getMessage("SLT_ERR_66") + "</title>");
                servletOutputStream.println("</head>");
                servletOutputStream.println("<body>");
                servletOutputStream.println("<H1>" + JSvrResource.getMessage("SLT_ERR_67") + "</H1>");
                servletOutputStream.write(WebSecurityUtil.escapeHTML(string2).getBytes());
                servletOutputStream.println();
                servletOutputStream.println("</body>");
                servletOutputStream.println("</html>");
            } else {
                httpServletResponse.sendError(n, string2);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static String changePassword(Authenticator authenticator, String string, String string2, boolean bl, Hashtable hashtable) throws IOException {
        String string3 = null;
        String string4 = (String)hashtable.get("jrs.uid");
        String string5 = (String)hashtable.get("jrs.password");
        String string6 = (String)hashtable.get("jrs.new_password");
        String string7 = (String)hashtable.get("jrs.confirm_new_password");
        if (string4 == null || string4.trim().length() == 0) {
            return JSvrResource.getMessage("SLT_ERR_69");
        }
        if (bl) {
            string4 = new String(Base64.decode((String)BaseHttpUtil.dc(string4)), "ISO-8859-1");
        }
        if (bl) {
            if (string5 != null && string5.trim().length() != 0) {
                string5 = new String(Base64.decode((String)BaseHttpUtil.dc(string5)), "ISO-8859-1");
            }
            if (string6 != null && string6.trim().length() != 0) {
                string6 = new String(Base64.decode((String)BaseHttpUtil.dc(string6)), "ISO-8859-1");
            }
            if (string7 != null && string7.trim().length() != 0) {
                string7 = new String(Base64.decode((String)BaseHttpUtil.dc(string7)), "ISO-8859-1");
            }
        }
        string3 = string6 == null && string7 == null || string6 != null && string7 != null && string6.equals(string7) ? authenticator.changePassword(string, string2, string4, string5, string6) : JSvrResource.getMessage("SLT_ERR_70");
        return string3;
    }

    private static String dc(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i, --n2) {
            if (i % 2 != 0) continue;
            char c = stringBuffer.charAt(i);
            char c2 = stringBuffer.charAt(n2);
            stringBuffer.setCharAt(i, c2);
            stringBuffer.setCharAt(n2, c);
        }
        return stringBuffer.reverse().toString();
    }

    public static boolean isJRClient(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        boolean bl = false;
        String string = httpServletRequest.getHeader("User-Agent");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, append);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.toLowerCase().startsWith("JRViewer".toLowerCase()) && !string2.toLowerCase().startsWith("JRClient-API".toLowerCase()) && !string2.toLowerCase().startsWith("JRptClient".toLowerCase())) continue;
                bl = true;
                break;
            }
        }
        if (!bl && hashtable != null) {
            bl = CSUtil.getBoolean((String)hashtable.get("jrs.is_plain"), false);
        }
        return bl;
    }

    public static boolean isClientAPI(HttpServletRequest httpServletRequest, Hashtable hashtable) {
        boolean bl = false;
        String string = httpServletRequest.getHeader("User-Agent");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, append);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (!string2.toLowerCase().startsWith("JRClient-API".toLowerCase())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String getTempResultKey(String string) {
        String string2 = string;
        if (string2 != null) {
            int n = string2.lastIndexOf(".");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if ((n = string2.indexOf("_")) >= 0) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public static void redirect(HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, String string2) throws IOException {
        httpServletResponse.setStatus(301);
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("Location", string);
        httpServletResponse.setHeader(CONTENT_LOCATION, string);
        printWriter.println("<html><head><title>" + JSvrResource.getMessage("SLT_PG_125") + "</title>");
        printWriter.println("</head><body><H1>" + JSvrResource.getMessage("SLT_PG_125") + "</H1>");
        printWriter.println(JSvrResource.getMessage("SLT_PG_126") + charAt);
        printWriter.println("<a href=\"" + string + "\">" + string2 + "</a></body></html>");
        printWriter.close();
    }

    public static void outputHtmlTableHeader(PrintWriter printWriter, String string, String[] stringArray) throws IOException {
        printWriter.println("<table style=\"font-family:Arial;font-size:10pt;\" bgColor=\"#dcdcdc\" border=\"0\" cellPadding=\"2\" cellSpacing=\"1\" width=100%>");
        printWriter.println("<caption align=\"left\"><b>" + string + "</b></caption><tr bgcolor=\"#000000\">");
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.print("<td align=\"center\"><b><font color=\"#ECECEC\">" + stringArray[i] + "</td>");
        }
        printWriter.println("</tr>");
    }

    public static int getResultType(String string, int n) {
        return CSUtil.getResultType(string, n);
    }

    public static boolean hasPageSecurity(String string) {
        return new File(CSUtil.removeExtName(string) + ".pgn").exists();
    }
}

