/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.paramlist;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jet.server.api.paramlist.ParamList;
import jet.server.api.paramlist.SheetParamList;
import jet.server.util.StringUtil;

public class ReportParamList
extends ParamList
implements Serializable {
    private static final long serialVersionUID = -866032646989469165L;
    public static final byte TYPE_BUILDIN_DEFAULT = -1;
    public static final byte TYPE_MANUAL = 0;
    public static final byte TYPE_AUTO = 1;
    public static final byte TYPE_DEFAULT = 2;
    private String reportPath;
    private byte type;
    private Map<String, SheetParamList> sheetParamListMap;

    public ReportParamList(String string, byte by) {
        this.reportPath = string;
        this.type = by;
    }

    public Map<String, SheetParamList> getSheetParamListMap() {
        return this.sheetParamListMap;
    }

    public void setSheetParamListMap(Map<String, SheetParamList> map) {
        this.sheetParamListMap = map;
    }

    public void addSheetParamList(SheetParamList sheetParamList) {
        if (this.sheetParamListMap == null) {
            this.sheetParamListMap = new HashMap<String, SheetParamList>();
        }
        this.sheetParamListMap.put(sheetParamList.getName(), sheetParamList);
    }

    public SheetParamList getSheetParamList(String string) {
        if (this.sheetParamListMap != null) {
            return this.sheetParamListMap.get(string);
        }
        return null;
    }

    public String getReportPath() {
        return this.reportPath;
    }

    public void setReportPath(String string) {
        this.reportPath = string;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public boolean isManual() {
        return this.type == 0;
    }

    public boolean isAuto() {
        return this.type == 1;
    }

    public boolean isDefault() {
        return this.type == 2;
    }

    public boolean isBuildin() {
        return this.type == -1;
    }

    public boolean isSheetsEquals(Map<String, SheetParamList> map) {
        if (this.sheetParamListMap == null || this.sheetParamListMap.size() == 0) {
            return map == null || map.size() == 0;
        }
        if (map == null || map.size() == 0) {
            return false;
        }
        if (this.sheetParamListMap.size() != map.size()) {
            return false;
        }
        for (String string : this.sheetParamListMap.keySet()) {
            SheetParamList sheetParamList = map.get(string);
            SheetParamList sheetParamList2 = this.sheetParamListMap.get(string);
            if (sheetParamList == null) {
                return false;
            }
            if (sheetParamList2.isParamValuesEquals(sheetParamList.getParamValues())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        stringBuffer.append("reportPath: ").append(this.reportPath);
        stringBuffer.append(", type: ").append(this.type);
        stringBuffer.append(", name: ").append(this.name);
        stringBuffer.append(", attributes: ").append(StringUtil.toString(this.attributes));
        stringBuffer.append(", paramValues: ").append(StringUtil.toString(this.paramValues));
        stringBuffer.append(", sheetParamListMap: ").append(StringUtil.toString(this.sheetParamListMap));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

