/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.core.memory;

import jet.server.cache.core.intf.CacheAttributes;
import jet.server.cache.core.intf.CacheElement;
import jet.server.cache.core.memory.AbstractMemoryCache;
import jet.server.cache.util.DoubleLinkedList;
import jet.server.cache.util.MemoryListElement;
import jet.server.log.ServiceLogger;

public class DefaultMemoryCacheImpl
extends AbstractMemoryCache {
    private DoubleLinkedList SEDU;

    public DefaultMemoryCacheImpl(CacheAttributes cacheAttributes) {
        this.initialize(cacheAttributes);
    }

    @Override
    public void initialize(CacheAttributes cacheAttributes) {
        super.initialize(cacheAttributes);
        this.SEDU = new DoubleLinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getKeys() {
        DefaultMemoryCacheImpl defaultMemoryCacheImpl = this;
        synchronized (defaultMemoryCacheImpl) {
            return this.map.keySet().toArray();
        }
    }

    @Override
    public CacheElement getQuiet(Object object) {
        CacheElement cacheElement = null;
        MemoryListElement memoryListElement = (MemoryListElement)this.map.get(object);
        if (memoryListElement != null) {
            cacheElement = memoryListElement.getCacheElement();
        }
        return cacheElement;
    }

    @Override
    public void setCacheAttributes(CacheAttributes cacheAttributes) {
        this.cattr = cacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(CacheElement cacheElement) {
        int n;
        DefaultMemoryCacheImpl defaultMemoryCacheImpl;
        if (this.cattr.getMaxObjects() > 0) {
            cacheElement.getElementAttributes().setLastAccessTimeNow();
            MemoryListElement memoryListElement = null;
            defaultMemoryCacheImpl = this;
            synchronized (defaultMemoryCacheImpl) {
                MemoryListElement memoryListElement2 = new MemoryListElement(cacheElement);
                this.SEDU.addFirst(memoryListElement2);
                memoryListElement = this.map.put(((MemoryListElement)this.SEDU.getFirst()).getCacheElement().getKey(), (MemoryListElement)this.SEDU.getFirst());
                if (memoryListElement != null && ((MemoryListElement)this.SEDU.getFirst()).getCacheElement().getKey().equals(memoryListElement.getCacheElement().getKey())) {
                    this.SEDU.remove(memoryListElement);
                }
            }
        }
        if ((n = this.map.size()) <= this.cattr.getMaxObjects()) {
            return;
        }
        ServiceLogger.print(6670049);
        defaultMemoryCacheImpl = this;
        synchronized (defaultMemoryCacheImpl) {
            if (this.SEDU.getLast() != null) {
                if (((MemoryListElement)this.SEDU.getLast()).getCacheElement() != null) {
                    if (!this.map.containsKey(((MemoryListElement)this.SEDU.getLast()).getCacheElement().getKey())) {
                        ServiceLogger.logError(3670050, ((MemoryListElement)this.SEDU.getLast()).getCacheElement().getKey(), 3);
                    }
                    if (this.map.remove(((MemoryListElement)this.SEDU.getLast()).getCacheElement().getKey()) == null) {
                        ServiceLogger.logError(3670051, ((MemoryListElement)this.SEDU.getLast()).getCacheElement().getKey(), 3);
                    }
                } else {
                    ServiceLogger.logError("Remove the object from cache failed since last.ce is null.", 3);
                }
                this.SEDU.removeLast();
            } else {
                ServiceLogger.logError("Remove the object from cache failed since last is null.", 3);
            }
        }
    }

    @Override
    public CacheElement get(Object object) {
        CacheElement cacheElement = null;
        MemoryListElement memoryListElement = (MemoryListElement)this.map.get(object);
        if (memoryListElement != null) {
            cacheElement = memoryListElement.getCacheElement();
            cacheElement.getElementAttributes().setLastAccessTimeNow();
            this.SEDU.makeFirst(memoryListElement);
        }
        return cacheElement;
    }

    @Override
    public boolean remove(Object object) {
        ServiceLogger.print(6670055, object);
        boolean bl = false;
        MemoryListElement memoryListElement = (MemoryListElement)this.map.remove(object);
        if (memoryListElement != null) {
            this.SEDU.remove(memoryListElement);
            bl = true;
        }
        return bl;
    }

    @Override
    public CacheAttributes getCacheAttributes() {
        return this.cattr;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Default memory cache********************\n");
        stringBuffer.append("Cache attributes------------------------\n");
        stringBuffer.append(this.cattr.toString());
        stringBuffer.append("----------------------------------------\n");
        stringBuffer.append("The cache size now: " + this.map.size() + "\n");
        Object[] objectArray = this.getKeys();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuffer.append("The Element Key: " + object + "\n");
        }
        stringBuffer.append("****************************************\n");
        return stringBuffer.toString();
    }
}

