/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.util;

import jet.server.cache.core.intf.CacheElement;
import jet.server.cache.core.intf.ElementAttributes;
import jet.server.cache.core.memory.intf.MemoryCache;

public class CacheShrinker
implements Runnable {
    private final MemoryCache SEDU;
    private final long currentTimeMillis;

    public CacheShrinker(MemoryCache memoryCache) {
        this.SEDU = memoryCache;
        long l = memoryCache.getCacheAttributes().getMaxMemoryObjectIdleSeconds();
        this.currentTimeMillis = l == -1L ? -1L : l * 1000L;
    }

    @Override
    public void run() {
        this.shrink();
    }

    protected void shrink() {
        try {
            for (Object object : this.SEDU.getKeys()) {
                long l;
                CacheElement cacheElement = this.SEDU.getQuiet(object);
                if (cacheElement == null) continue;
                ElementAttributes elementAttributes = cacheElement.getElementAttributes();
                boolean bl = false;
                long l2 = System.currentTimeMillis();
                if (!cacheElement.getElementAttributes().getIsEternal() && (bl = this.SEDU(cacheElement, l2))) {
                    this.SEDU.remove(cacheElement.getKey());
                }
                if (bl || this.currentTimeMillis == 0L || (l = elementAttributes.getLastAccessTime()) + this.currentTimeMillis >= l2) continue;
                this.SEDU.remove(cacheElement.getKey());
                object = null;
                cacheElement = null;
            }
            Object[] objectArray = null;
        }
        finally {
            return;
        }
    }

    private boolean SEDU(CacheElement cacheElement, long l) {
        ElementAttributes elementAttributes = cacheElement.getElementAttributes();
        long l2 = elementAttributes.getMaxLifeSeconds();
        long l3 = elementAttributes.getCreateTime();
        if (l2 != 0L && l - l3 > l2 * 1000L) {
            return true;
        }
        long l4 = elementAttributes.getMaxIdleSeconds();
        long l5 = elementAttributes.getLastAccessTime();
        return l4 != 0L && l - l5 > l4 * 1000L;
    }
}

