/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.util;

import java.util.Date;
import jet.server.cache.util.Heap;
import jet.server.cache.util.Task;
import jet.server.cache.util.ThreadCreator;

public class ThreadExecutor {
    public static final int INITIAL_DEFAULT_CAPACITY = 1024;
    protected final Heap heap = new Heap(1024);
    protected Thread thread;
    protected ThreadCreator threadCreator;
    protected final RunLoop runLoop = new RunLoop();

    public ThreadExecutor(ThreadCreator threadCreator) {
        this.threadCreator = threadCreator;
    }

    public synchronized void setThreadFactory(ThreadCreator threadCreator) {
        this.threadCreator = threadCreator;
    }

    public Object executePeriodically(long l, Runnable runnable, boolean bl) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = System.currentTimeMillis();
        if (!bl) {
            l2 += l;
        }
        Task task = new Task(l2, runnable, l);
        this.heap.insert(task);
        this.restart();
        return task;
    }

    public Object executeAt(Date date, Runnable runnable) {
        Task task = new Task(date.getTime(), runnable);
        this.heap.insert(task);
        this.restart();
        return task;
    }

    public static void cancel(Object object) {
        ((Task)object).setCancelled();
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = this.threadCreator.create(this.runLoop);
            this.thread.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap.clear();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    protected synchronized void clearThread() {
        this.thread = null;
    }

    protected synchronized Task nextTask() {
        try {
            while (!Thread.interrupted()) {
                Task task = (Task)this.heap.peek();
                if (task == null) {
                    this.wait();
                    continue;
                }
                long l = System.currentTimeMillis();
                long l2 = task.getTimeToRun();
                if (l2 > l) {
                    this.wait(l2 - l);
                    continue;
                }
                task = (Task)this.heap.extract();
                if (task.getCancelled()) continue;
                if (task.period > 0L) {
                    task.setTimeToRun(l + task.period);
                    this.heap.insert(task);
                }
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return null;
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Task task;
                while ((task = ThreadExecutor.this.nextTask()) != null) {
                    task.mission.run();
                }
            }
            finally {
                ThreadExecutor.this.clearThread();
            }
        }
    }
}

