/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jet.server.cluster.ClusterRuntimeException;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.ClusterMapImpl;
import jet.server.cluster.blocks.InternalClusterMap;
import jet.server.cluster.blocks.MapCmd;
import jet.server.cluster.blocks.MapEvent;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapKeyTag;
import jet.server.cluster.blocks.MapListener;
import jet.server.log.ServiceLogger;

class BaseClusterMap
implements ClusterMap,
InternalClusterMap,
Serializable {
    private static final long serialVersionUID = 2463747373190923767L;
    protected final String name;
    private ConcurrentHashMap backMap;
    private transient boolean CLEAR;
    private transient CopyOnWriteArrayList PUT;

    public BaseClusterMap(String string) {
        this.name = string;
        this.backMap = new ConcurrentHashMap();
        this.PUT = new CopyOnWriteArrayList();
        ServiceLogger.logDebug(4650059, new Object[]{string}, 4);
    }

    protected Map getBackMap() {
        return this.backMap;
    }

    protected boolean isDestroied() {
        return this.CLEAR;
    }

    protected void assertNotDestoried() {
        if (this.isDestroied()) {
            throw new ClusterRuntimeException(this + ": Illegal access on destroied map.");
        }
    }

    public final void doInit(int n, ClusterMapImpl clusterMapImpl) {
        if (this.isDestroied()) {
            return;
        }
        int n2 = clusterMapImpl == null ? -1 : clusterMapImpl.getBackMap().size();
        int n3 = clusterMapImpl == null ? 0 : 1;
        ServiceLogger.logDebug(4650060, new Object[]{this.name, n2}, 4);
        this.init0(clusterMapImpl);
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterInit(this.name, n, n3);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
    }

    protected void init0(ClusterMapImpl clusterMapImpl) {
        if (clusterMapImpl != null) {
            this.getBackMap().putAll(clusterMapImpl.getBackMap());
        }
    }

    @Override
    public final void doDestroy() {
        if (this.isDestroied()) {
            return;
        }
        ServiceLogger.logDebug(4650061, this.name, 4);
        this.CLEAR = true;
        this.destroy0();
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterDestroy(this.name, -1);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
    }

    protected void destroy0() {
        this.PUT.clear();
        this.backMap.clear();
    }

    protected boolean isNewMapEvent0(MapEvent mapEvent) {
        return true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean addListener(MapListener mapListener) {
        this.assertNotDestoried();
        ServiceLogger.logDebug(4650062, new Object[]{this.name, mapListener}, 4);
        return this.PUT.addIfAbsent(mapListener);
    }

    @Override
    public final boolean removeListener(MapListener mapListener) {
        this.assertNotDestoried();
        ServiceLogger.logDebug(0x46F44F, new Object[]{this.name, mapListener}, 4);
        return this.PUT.remove(mapListener);
    }

    @Override
    public boolean isResourceNode() {
        return true;
    }

    @Override
    public final Object put(Object object, Object object2) {
        return this.put(object, object2, null);
    }

    @Override
    public final Object put(Object object, Object object2, MapFlags mapFlags) {
        return this.doPut(new MapEvent(this.name, MapCmd.PUT, new MapKeyTag(object, mapFlags), object2));
    }

    @Override
    public final Object doPut(MapEvent mapEvent) {
        this.assertNotDestoried();
        if (!this.isNewMapEvent0(mapEvent)) {
            return null;
        }
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        ServiceLogger.logDebug(6650064, new Object[]{this.name, mapEvent.getSourceMember(), mapKeyTag.getKey()}, 7);
        Object object = this.put0(mapEvent);
        Object object2 = mapEvent.getArg();
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterPut(this.name, mapEvent.getSourceMember(), mapKeyTag.getKey(), object2, object, mapKeyTag.getFlags());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
        return object;
    }

    protected Object put0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Object object = mapEvent.getArg();
        return this.backMap.put(mapKeyTag.getKey(), object);
    }

    public final Object putIfAbsent(Object object, Object object2) {
        return this.putIfAbsent(object, object2, null);
    }

    public final Object putIfAbsent(Object object, Object object2, MapFlags mapFlags) {
        return this.doPutIfAbsent(new MapEvent(this.name, MapCmd.PUT_IF_ABSENT, new MapKeyTag(object, mapFlags), object2));
    }

    @Override
    public final Object doPutIfAbsent(MapEvent mapEvent) {
        this.assertNotDestoried();
        if (!this.isNewMapEvent0(mapEvent)) {
            return null;
        }
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Object object = mapEvent.getArg();
        Object object2 = this.putIfAbsent0(mapEvent);
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterPutIfAbsent(this.name, mapEvent.getSourceMember(), mapKeyTag.getKey(), object, object2, mapKeyTag.getFlags());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
        return object2;
    }

    protected Object putIfAbsent0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Object object = mapEvent.getArg();
        return this.backMap.putIfAbsent(mapKeyTag.getKey(), object);
    }

    @Override
    public final void putAll(Map map) {
        this.putAll(map, null);
    }

    @Override
    public final void putAll(Map map, MapFlags mapFlags) {
        this.doPutAll(new MapEvent(this.name, MapCmd.PUT_ALL, new MapKeyTag(null, mapFlags), map));
    }

    @Override
    public final void doPutAll(MapEvent mapEvent) {
        this.assertNotDestoried();
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        ServiceLogger.logDebug(6650065, new Object[]{this.name, mapEvent.getSourceMember()}, 7);
        this.putAll0(mapEvent);
        Map map = (Map)mapEvent.getArg();
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterPutAll(this.name, mapEvent.getSourceMember(), map, mapKeyTag.getFlags());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
    }

    protected void putAll0(MapEvent mapEvent) {
        Map map = (Map)mapEvent.getArg();
        this.backMap.putAll(map);
    }

    @Override
    public final Object remove(Object object) {
        return this.remove(object, null);
    }

    @Override
    public final Object remove(Object object, MapFlags mapFlags) {
        return this.doRemove(new MapEvent(this.name, MapCmd.REMOVE, new MapKeyTag(object, mapFlags), new Object[0]));
    }

    @Override
    public final Object doRemove(MapEvent mapEvent) {
        this.assertNotDestoried();
        if (!this.isNewMapEvent0(mapEvent)) {
            return null;
        }
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        ServiceLogger.logDebug(6650066, new Object[]{this.name, mapEvent.getSourceMember(), mapKeyTag.getKey()}, 7);
        Object object = this.remove0(mapEvent);
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterRemove(this.name, mapEvent.getSourceMember(), mapKeyTag.getKey(), object, mapKeyTag.getFlags());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
        return object;
    }

    protected Object remove0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        return this.backMap.remove(mapKeyTag.getKey());
    }

    @Override
    public final void clear() {
        this.clear(null);
    }

    @Override
    public final void clear(MapFlags mapFlags) {
        this.doClear(new MapEvent(this.name, MapCmd.CLEAR, new MapKeyTag(null, mapFlags), new Object[0]));
    }

    @Override
    public final void doClear(MapEvent mapEvent) {
        this.assertNotDestoried();
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        ServiceLogger.logDebug(6650067, new Object[]{this.name, mapEvent.getSourceMember()}, 7);
        this.clear0(mapEvent);
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterClear(this.name, mapEvent.getSourceMember(), mapKeyTag.getFlags());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
    }

    protected void clear0(MapEvent mapEvent) {
        this.backMap.clear();
    }

    @Override
    public final boolean removeAll(Collection collection) {
        return this.removeAll(collection, null);
    }

    @Override
    public final boolean removeAll(Collection collection, MapFlags mapFlags) {
        return this.doRemoveAll(new MapEvent(this.name, MapCmd.REMOVE_ALL, new MapKeyTag(null, mapFlags), collection));
    }

    @Override
    public final boolean doRemoveAll(MapEvent mapEvent) {
        this.assertNotDestoried();
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Collection collection = (Collection)mapEvent.getArg();
        boolean bl = this.removeAll0(mapEvent);
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterRemoveAll(this.name, mapEvent.getSourceMember(), collection, bl, mapKeyTag.getFlags());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
        return bl;
    }

    protected boolean removeAll0(MapEvent mapEvent) {
        Collection collection = (Collection)mapEvent.getArg();
        return this.backMap.keySet().removeAll(collection);
    }

    @Override
    public final boolean retainAll(Collection collection) {
        return this.retainAll(collection, null);
    }

    @Override
    public final boolean retainAll(Collection collection, MapFlags mapFlags) {
        return this.doRetainAll(new MapEvent(this.name, MapCmd.RETAIN_ALL, new MapKeyTag(null, mapFlags), collection));
    }

    @Override
    public final boolean doRetainAll(MapEvent mapEvent) {
        this.assertNotDestoried();
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Collection collection = (Collection)mapEvent.getArg();
        boolean bl = this.retainAll0(mapEvent);
        for (MapListener mapListener : this.PUT) {
            try {
                mapListener.afterRetainAll(this.name, mapEvent.getSourceMember(), collection, bl, mapKeyTag.getFlags());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError("ClusterMap invoke listener failed: " + mapListener);
                ServiceLogger.logError(throwable);
            }
        }
        return bl;
    }

    protected boolean retainAll0(MapEvent mapEvent) {
        Collection collection = (Collection)mapEvent.getArg();
        return this.backMap.keySet().retainAll(collection);
    }

    @Override
    public final int size() {
        this.assertNotDestoried();
        return this.size0();
    }

    protected int size0() {
        return this.backMap.size();
    }

    @Override
    public final boolean isEmpty() {
        this.assertNotDestoried();
        return this.isEmpty0();
    }

    protected boolean isEmpty0() {
        return this.backMap.isEmpty();
    }

    @Override
    public final boolean containsKey(Object object) {
        this.assertNotDestoried();
        return this.containsKey0(object);
    }

    protected boolean containsKey0(Object object) {
        return this.backMap.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        this.assertNotDestoried();
        return this.containsValue0(object);
    }

    protected boolean containsValue0(Object object) {
        return this.backMap.containsValue(object);
    }

    @Override
    public final Object get(Object object) {
        this.assertNotDestoried();
        return this.get0(object);
    }

    protected Object get0(Object object) {
        return this.backMap.get(object);
    }

    @Override
    public final Set entrySet() {
        this.assertNotDestoried();
        return this.entrySetMap0().entrySet();
    }

    protected Map entrySetMap0() {
        return Collections.unmodifiableMap(this.backMap);
    }

    @Override
    public final Set keySet() {
        this.assertNotDestoried();
        return this.keySet0();
    }

    protected Set keySet0() {
        return Collections.unmodifiableSet(new HashSet(this.backMap.keySet()));
    }

    @Override
    public final Collection values() {
        this.assertNotDestoried();
        return this.values0();
    }

    protected Collection values0() {
        return Collections.unmodifiableCollection(new ArrayList(this.backMap.values()));
    }
}

