/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.blocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.blocks.BaseClusterMap;
import jet.server.cluster.blocks.ClusterMapTransceiver;
import jet.server.cluster.blocks.Directory;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapCmd;
import jet.server.cluster.blocks.MapEvent;
import jet.server.cluster.blocks.MapKeyTag;
import jet.server.log.ServiceLogger;

class ClusterMapImpl
extends BaseClusterMap {
    private static final long serialVersionUID = -4761979856974565319L;
    private final MapAttr mapAttr;
    private final Directory directory;
    final transient int localMemberId;
    final transient ClusterMapTransceiver transceiver;

    public ClusterMapImpl(String string, ClusterMapTransceiver clusterMapTransceiver) {
        super(string);
        this.mapAttr = MapAttr.parseMapAttr(string);
        this.transceiver = clusterMapTransceiver;
        this.localMemberId = clusterMapTransceiver.getLocalMember().getID();
        this.directory = new Directory(this);
    }

    private boolean $SwitchMap$jet$server$cluster$blocks$MapCmd() {
        return true;
    }

    MapAttr getMapAttr() {
        return this.mapAttr;
    }

    List getResourceNodes() {
        if (this.mapAttr.distributePolicy() == MapAttr.DistributePolicy.ALL_NODES) {
            return new ArrayList(this.transceiver.getMembersIdSet());
        }
        return new ArrayList(this.transceiver.getMemberService().getShareMemoryIds());
    }

    List getDestNodes(MapEvent mapEvent) {
        int[] nArray;
        if (this.mapAttr.distributePolicy() == MapAttr.DistributePolicy.ALL_NODES) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.transceiver.getMemberService().getShareMemoryIds());
        if (mapEvent.getKeyTag() != null && mapEvent.getKeyTag().getFlags() != null && (nArray = mapEvent.getKeyTag().getFlags().getForceDests()) != null) {
            for (int n : nArray) {
                if (n <= -1 || !this.transceiver.getMembersIdSet().contains(n) || arrayList.contains(n)) continue;
                arrayList.add(n);
            }
        }
        arrayList.remove(new Integer(this.transceiver.getLocalMember().getID()));
        return arrayList;
    }

    void markDirectoryToVerify() {
        this.directory.setReady(false);
    }

    void checkDirectory() {
        this.directory.checkDirectory();
    }

    @Override
    public boolean isResourceNode() {
        return this.transceiver.isShareMemoryNode() || this.mapAttr.distributePolicy() == MapAttr.DistributePolicy.ALL_NODES;
    }

    @Override
    protected void init0(ClusterMapImpl clusterMapImpl) {
        super.init0(clusterMapImpl);
        if (clusterMapImpl != null) {
            this.directory.initFromRemote(clusterMapImpl.directory);
        }
    }

    @Override
    protected void destroy0() {
        super.destroy0();
        this.directory.destroy();
    }

    private MapKeyTag ALL_NODES(MapEvent mapEvent) {
        if (mapEvent.getKeyTag().getKey() == null) {
            return null;
        }
        return this.directory.getKeyTag(mapEvent.getKeyTag().getKey());
    }

    @Override
    protected boolean isNewMapEvent0(MapEvent mapEvent) {
        if (!this.isResourceNode()) {
            return true;
        }
        if (mapEvent.getKeyTag() == null) {
            return true;
        }
        MapKeyTag mapKeyTag = this.ALL_NODES(mapEvent);
        if (mapKeyTag == null) {
            if (mapEvent.getCmd() == MapCmd.REMOVE && this.mapAttr.verifyPolicy() != MapAttr.VerifyPolicy.NO_VERIFY) {
                ServiceLogger.logDebug(5650083, new Object[]{mapEvent.getMapName(), mapEvent.getCmd(), mapEvent.getSourceMember(), mapEvent.getKeyTag().getTimestamp(), ClusterEnv.getClusterTime(), System.currentTimeMillis(), mapEvent.getKeyTag().getKey()}, 5);
            }
            return true;
        }
        if (mapEvent.getKeyTag().compareTo(mapKeyTag) == -1) {
            ServiceLogger.logDebug(5650084, new Object[]{mapEvent.getMapName(), mapEvent.getCmd(), mapEvent.getSourceMember(), mapEvent.getKeyTag().getTimestamp(), ClusterEnv.getClusterTime(), System.currentTimeMillis(), mapEvent.getKeyTag().getKey(), mapKeyTag.getModifier(), mapKeyTag.getTimestamp(), mapKeyTag.isDeleted()}, 5);
            return mapEvent.getMapName().startsWith(MapAttr.RESOURCE_VERSION_NODE_RECORD_MAP.name()) || mapEvent.getMapName().startsWith(MapAttr.RESOURCE_VERSION_RECORD_MAP.name());
        }
        return true;
    }

    @Override
    protected Object put0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Object object = null;
        if (this.isResourceNode()) {
            object = super.put0(mapEvent);
            this.directory.mapPut(mapKeyTag);
            if (mapEvent.isForwardEvent()) {
                mapEvent.setResult(object);
                this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
            }
        } else if (mapEvent.isForwardEvent()) {
            if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
                object = this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
                return object;
            }
            object = this.transceiver.mapRequest(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
        } else {
            object = mapEvent.getResult();
        }
        return object;
    }

    @Override
    protected Object putIfAbsent0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Object object = null;
        if (this.isResourceNode()) {
            object = super.putIfAbsent0(mapEvent);
            if (object != null) {
                this.directory.mapPut(mapKeyTag);
            }
            if (mapEvent.isForwardEvent()) {
                mapEvent.setResult(object);
                this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
            }
        } else if (mapEvent.isForwardEvent()) {
            if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
                object = this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
                return object;
            }
            object = this.transceiver.mapRequest(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
        } else {
            object = mapEvent.getResult();
        }
        return object;
    }

    @Override
    protected void putAll0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Map map = (Map)mapEvent.getArg();
        if (this.isResourceNode()) {
            super.putAll0(mapEvent);
            this.directory.mapPutAll(mapKeyTag, map);
            if (mapEvent.isForwardEvent()) {
                this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
            }
        } else if (mapEvent.isForwardEvent()) {
            if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
                this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
                return;
            }
            this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
        }
    }

    @Override
    protected Object remove0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Object object = null;
        if (this.isResourceNode()) {
            object = super.remove0(mapEvent);
            this.directory.mapRemove(mapKeyTag);
            if (mapEvent.isForwardEvent()) {
                mapEvent.setResult(object);
                this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
            }
        } else if (mapEvent.isForwardEvent()) {
            if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
                object = this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
                return object;
            }
            object = this.transceiver.mapRequest(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
        } else {
            object = mapEvent.getResult();
        }
        return object;
    }

    @Override
    protected void clear0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        if (this.isResourceNode()) {
            super.clear0(mapEvent);
            this.directory.mapClear(mapKeyTag);
            if (mapEvent.isForwardEvent()) {
                this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
            }
        } else if (mapEvent.isForwardEvent()) {
            if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
                this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
                return;
            }
            this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
        }
    }

    @Override
    protected boolean removeAll0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Collection collection = (Collection)mapEvent.getArg();
        boolean bl = false;
        if (this.isResourceNode()) {
            bl = super.removeAll0(mapEvent);
            this.directory.mapRemoveAll(mapKeyTag, collection);
            if (mapEvent.isForwardEvent()) {
                mapEvent.setResult(bl);
                this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
            }
        } else if (mapEvent.isForwardEvent()) {
            if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
                bl = (Boolean)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
                return bl;
            }
            bl = (Boolean)this.transceiver.mapRequest(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
        } else if (mapEvent.getResult() instanceof Boolean) {
            bl = (Boolean)mapEvent.getResult();
        }
        return bl;
    }

    @Override
    protected boolean retainAll0(MapEvent mapEvent) {
        MapKeyTag mapKeyTag = mapEvent.getKeyTag();
        Collection collection = (Collection)mapEvent.getArg();
        boolean bl = false;
        if (this.isResourceNode()) {
            bl = super.retainAll0(mapEvent);
            this.directory.mapRetainAll(mapKeyTag, collection);
            if (mapEvent.isForwardEvent()) {
                mapEvent.setResult(bl);
                this.transceiver.mapMessage(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
            }
        } else if (mapEvent.isForwardEvent()) {
            if (this.$SwitchMap$jet$server$cluster$blocks$MapCmd()) {
                bl = (Boolean)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
                return bl;
            }
            bl = (Boolean)this.transceiver.mapRequest(this.getDestNodes(mapEvent), mapEvent.unforwardEvent());
        } else if (mapEvent.getResult() instanceof Boolean) {
            bl = (Boolean)mapEvent.getResult();
        }
        return bl;
    }

    @Override
    protected int size0() {
        int n;
        if (this.isResourceNode()) {
            this.directory.mapGetAll();
            n = super.size0();
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.size, null, new Object[0]);
            n = (Integer)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return n;
    }

    @Override
    protected boolean isEmpty0() {
        boolean bl;
        if (this.isResourceNode()) {
            this.directory.mapGetAll();
            bl = super.isEmpty0();
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.isEmpty, null, new Object[0]);
            bl = (Boolean)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return bl;
    }

    @Override
    protected boolean containsKey0(Object object) {
        boolean bl;
        if (this.isResourceNode()) {
            this.directory.mapGetAll();
            bl = super.containsKey0(object);
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.containsKey, null, object);
            bl = (Boolean)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return bl;
    }

    @Override
    protected boolean containsValue0(Object object) {
        boolean bl;
        if (this.isResourceNode()) {
            this.directory.mapGetAll();
            bl = super.containsValue0(object);
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.containsValue, null, object);
            bl = (Boolean)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return bl;
    }

    @Override
    protected Object get0(Object object) {
        Object object2;
        if (this.isResourceNode()) {
            this.directory.mapGet(object);
            object2 = super.get0(object);
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.get, null, object);
            object2 = this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return object2;
    }

    @Override
    protected Map entrySetMap0() {
        Map map;
        if (this.isResourceNode()) {
            this.directory.mapGetAll();
            map = super.entrySetMap0();
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.entrySet, null, new Object[0]);
            map = (Map)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return map;
    }

    @Override
    protected Set keySet0() {
        Set set;
        if (this.isResourceNode()) {
            this.directory.mapGetAll();
            set = super.keySet0();
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.keySet, null, new Object[0]);
            set = (Set)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return set;
    }

    @Override
    protected Collection values0() {
        Collection collection;
        if (this.isResourceNode()) {
            this.directory.mapGetAll();
            collection = super.values0();
        } else {
            MapEvent mapEvent = new MapEvent(this.name, MapCmd.values, null, new Object[0]);
            collection = (Collection)this.transceiver.mapRequest(this.transceiver.getDefaultShareMemoryNode(), mapEvent);
        }
        return collection;
    }

    protected Object handleMapCommand(MapEvent mapEvent) {
        switch (mapEvent.getCmd()) {
            case GET_MAP: {
                return this;
            }
            case GET_CONTENTS: {
                return this.getBackMap();
            }
            case PUT: {
                return this.doPut(mapEvent);
            }
            case PUT_IF_ABSENT: {
                return this.doPutIfAbsent(mapEvent);
            }
            case PUT_ALL: {
                this.doPutAll(mapEvent);
                return null;
            }
            case REMOVE: {
                return this.doRemove(mapEvent);
            }
            case CLEAR: {
                this.doClear(mapEvent);
                return null;
            }
            case REMOVE_ALL: {
                return this.doRemoveAll(mapEvent);
            }
            case RETAIN_ALL: {
                return this.doRetainAll(mapEvent);
            }
            case size: {
                return this.size();
            }
            case isEmpty: {
                return this.isEmpty();
            }
            case containsKey: {
                return this.containsKey(mapEvent.getArg());
            }
            case containsValue: {
                return this.containsValue(mapEvent.getArg());
            }
            case get: {
                return this.get(mapEvent.getArg());
            }
            case entrySet: {
                return this.entrySetMap0();
            }
            case keySet: {
                return this.keySet();
            }
            case values: {
                return this.values();
            }
            case DIR_GET_STATE: 
            case DIR_CMP_AND_GET_LATEST: {
                return this.directory.handleMapDirCommand(mapEvent);
            }
        }
        return null;
    }
}

