/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.core;

import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.ClusterRemoteObjectLocator;
import jet.server.cluster.core.JRChannel;
import jet.server.cluster.core.MemberService;
import jet.server.cluster.core.Topic;
import jet.server.cluster.core.Transceiver;
import jet.server.log.ServiceLogger;

public class ClusterServer {
    private static JRChannel SEDU;

    static JRChannel getChannel() {
        if (SEDU == null) {
            SEDU = new JRChannel();
        }
        return SEDU;
    }

    public static void startup() throws ClusterException {
        try {
            ClusterEnv.init();
            ClusterServer.getChannel().startup();
            ClusterRemoteObjectLocator.initInstance(ClusterServer.getMemberService());
            ClusterServer.getMemberService().addMemberListener(ClusterRemoteObjectLocator.getInstance());
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
            ClusterServer.shutdown();
            throw clusterException;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            ClusterServer.shutdown();
            throw new ClusterException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (SEDU == null) {
            return;
        }
        try {
            SEDU.shutdown();
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        finally {
            SEDU = null;
        }
    }

    public static MemberService getMemberService() {
        return ClusterServer.getChannel().getMemberService();
    }

    public static Transceiver getTransceiver(Topic topic) {
        return ClusterServer.getChannel().getTransceiver(topic);
    }
}

