/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.server.cluster.ClusterEnv;
import jet.server.jrc.JRMember;

public class JRView
implements Serializable {
    private static final long serialVersionUID = -2531191678544739052L;
    private String viewId;
    private boolean isMergeView;
    private int size;
    private JRMember localMember;
    private JRMember coordinator;
    private List hisAllNodes = new ArrayList();
    private List memberList = new ArrayList();
    private Map memberMap = new HashMap();
    private List idList = new ArrayList();
    private List orginalMemberList;
    private JRMember defaultShareMemoryNode;
    private List hisShareNodes = new ArrayList();
    private List shareMemoryNodes = new ArrayList();
    private List shareMemoryIds = new ArrayList();

    public JRView(JRMember jRMember, String string, List list, boolean bl) {
        this(null, jRMember, string, list, bl);
    }

    public JRView(JRView jRView, JRMember jRMember, String string, List list, boolean bl) {
        this.localMember = jRMember;
        this.viewId = string;
        this.isMergeView = bl;
        this.SEDU(jRView, list);
        this.abs(jRView);
    }

    private void SEDU(JRView jRView, List list) {
        Object object2;
        this.hisAllNodes.clear();
        this.memberList.clear();
        this.memberMap.clear();
        this.idList.clear();
        this.coordinator = null;
        this.hisShareNodes.clear();
        this.shareMemoryNodes.clear();
        this.shareMemoryIds.clear();
        this.defaultShareMemoryNode = null;
        this.orginalMemberList = new ArrayList(list);
        if (jRView != null) {
            this.hisAllNodes.addAll(jRView.hisAllNodes);
            this.hisShareNodes.addAll(jRView.hisShareNodes);
        }
        for (Object object2 : list) {
            int n = this.hisAllNodes.indexOf(object2);
            if (n < 0) {
                this.hisAllNodes.add(object2);
                continue;
            }
            JRMember jRMember = (JRMember)this.hisAllNodes.get(n);
            if (JRView.add((JRMember)object2, jRMember)) {
                this.hisAllNodes.set(n, object2);
                continue;
            }
            this.hisAllNodes.remove(n);
            this.hisAllNodes.add(object2);
        }
        ArrayList arrayList = new ArrayList(this.hisAllNodes);
        arrayList.retainAll(list);
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            JRMember jRMember = (JRMember)object2.next();
            this.memberList.add(jRMember);
            this.idList.add(jRMember.getID());
            this.memberMap.put(jRMember.getID(), jRMember);
        }
        this.size = this.memberList.size();
        this.coordinator = (JRMember)this.memberList.get(0);
    }

    void setHistory(JRView jRView) {
        this.SEDU(jRView, this.orginalMemberList);
        this.abs(null);
    }

    void addShareMemoryNode(JRMember jRMember) {
        if (!this.shareMemoryNodes.contains(jRMember)) {
            this.shareMemoryNodes.add(jRMember);
            this.shareMemoryIds.add(jRMember.getID());
            this.hisShareNodes.remove(jRMember);
            this.hisShareNodes.add(jRMember);
        }
    }

    public String toString() {
        return String.format("%s%s(this=%d, m=%d, coor=%d):%s(%s)", this.isMergeView ? "MergeView" : "View", this.viewId, this.localMember.getID(), this.defaultShareMemoryNode.getID(), this.coordinator.getID(), this.idList, this.shareMemoryIds);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JRView)) {
            return false;
        }
        JRView jRView = (JRView)object;
        if (this.isMergeView() != jRView.isMergeView()) {
            return false;
        }
        if (this.size() != jRView.size()) {
            return false;
        }
        if (!((Object)this.getMembersIdSet()).equals(jRView.getMembersIdSet())) {
            return false;
        }
        for (JRMember jRMember : this.memberList) {
            JRMember jRMember2 = jRView.getMemberById(jRMember.getID());
            if (jRMember.getSignature().equals(jRMember2.getSignature())) continue;
            return false;
        }
        return true;
    }

    public String getViewId() {
        return this.viewId;
    }

    public boolean isMergeView() {
        return this.isMergeView;
    }

    public int size() {
        return this.size;
    }

    public JRMember getLocalMember() {
        return this.localMember;
    }

    public JRMember getCoordinator() {
        return this.coordinator;
    }

    boolean isCoordinator() {
        return this.localMember.equals(this.coordinator);
    }

    public List getMembers() {
        return Collections.unmodifiableList(this.memberList);
    }

    public JRMember getMemberById(int n) {
        return (JRMember)this.memberMap.get(n);
    }

    public Set getMembersIdSet() {
        return Collections.unmodifiableSet(this.memberMap.keySet());
    }

    JRMember getDefaultShareMemoryNode() {
        return this.defaultShareMemoryNode;
    }

    boolean isShareMemoryNode() {
        return this.localMember.equals(this.defaultShareMemoryNode);
    }

    List getShareMemoryNodes() {
        return Collections.unmodifiableList(this.shareMemoryNodes);
    }

    List getShareMemoryIds() {
        return Collections.unmodifiableList(this.shareMemoryIds);
    }

    private void abs(JRView jRView) {
        Iterator iterator;
        int n = ClusterEnv.getShareMemoryNodeNum();
        if (n < 0) {
            n = (int)Math.round((double)Math.abs(n) / 100.0 * (double)this.size);
        } else if (n == 0) {
            n = this.memberList.size();
        }
        n = Math.max(ClusterEnv.getMinShareMemoryNodeNum(), n);
        n = Math.min(n, this.size);
        if (jRView != null && (iterator = (JRMember)this.memberMap.get(jRView.defaultShareMemoryNode.getID())) != null && ((JRMember)((Object)iterator)).getSignature().equals(jRView.defaultShareMemoryNode.getSignature())) {
            this.defaultShareMemoryNode = iterator;
        }
        iterator = this.hisShareNodes.iterator();
        while (iterator.hasNext()) {
            JRMember jRMember = (JRMember)iterator.next();
            if (!this.memberList.contains(jRMember)) continue;
            JRMember jRMember2 = (JRMember)this.memberList.get(this.memberList.indexOf(jRMember));
            if (jRMember2.getSignature().equals(jRMember.getSignature())) {
                this.shareMemoryNodes.add(jRMember2);
                this.shareMemoryIds.add(jRMember2.getID());
                continue;
            }
            iterator.remove();
        }
        if (this.shareMemoryNodes.size() < n) {
            for (JRMember jRMember : this.memberList) {
                if (this.shareMemoryNodes.contains(jRMember)) continue;
                this.shareMemoryNodes.add(jRMember);
                this.shareMemoryIds.add(jRMember.getID());
                this.hisShareNodes.remove(jRMember);
                this.hisShareNodes.add(jRMember);
                if (this.shareMemoryNodes.size() != n) continue;
                break;
            }
        }
        if (this.shareMemoryIds.contains(this.localMember.getID())) {
            this.defaultShareMemoryNode = this.localMember;
        } else if (this.defaultShareMemoryNode == null) {
            int n2 = this.memberList.indexOf(this.localMember);
            this.defaultShareMemoryNode = (JRMember)this.shareMemoryNodes.get(n2 %= this.shareMemoryNodes.size());
        }
    }

    private static boolean add(JRMember jRMember, JRMember jRMember2) {
        return jRMember.getID() == jRMember2.getID() && jRMember.getSignature().equals(jRMember2.getSignature());
    }

    public static Set minus(JRView jRView, JRView jRView2) {
        HashSet hashSet = new HashSet();
        if (jRView != null) {
            hashSet.addAll(jRView.getMembersIdSet());
        }
        if (jRView2 != null) {
            hashSet.removeAll(jRView2.getMembersIdSet());
        }
        return hashSet;
    }
}

