/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.jgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterRuntimeException;
import jet.server.cluster.core.ChannelAdapter;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MembershipListener;
import jet.server.cluster.core.MessageReceiver;
import jet.server.cluster.core.Response;
import jet.server.cluster.jgroups.JGroupsEnv;
import jet.server.cluster.jgroups.JRMBR;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Receiver;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class JGroupsChannel
extends ExtendedReceiverAdapter
implements RequestHandler,
ChannelListener,
ChannelAdapter {
    private JChannel SEDU;
    private MessageDispatcher add;
    private JRMember addChannelListener;
    private MessageReceiver append;
    private MembershipListener castMessage;
    private Map castRequest;
    private View clear;
    private JRView close;
    private boolean connect;
    private boolean equals;

    public JGroupsChannel(JRMember jRMember, MessageReceiver messageReceiver, MembershipListener membershipListener) {
        this.append = messageReceiver;
        this.addChannelListener = jRMember;
        this.castMessage = membershipListener;
        this.castRequest = new HashMap();
    }

    private boolean SEDU() {
        return this.connect;
    }

    private boolean add() {
        return this.equals;
    }

    private void addChannelListener() {
        if (!this.SEDU()) {
            throw new ClusterRuntimeException("JGroupsChannel:: Illegal access, cluster not started.");
        }
    }

    @Override
    public void startup() throws ClusterException {
        if (this.SEDU()) {
            return;
        }
        JGroupsEnv.initEnv();
        String string = JGroupsEnv.getClusterName();
        String string2 = JGroupsEnv.getJGroupsProps();
        ServiceLogger.logDebug(4650034, new Object[]{string, this.addChannelListener, string2}, 4);
        try {
            this.SEDU = new JChannel(string2);
            JRMBR.setMember(this.SEDU, this.addChannelListener);
            this.add = new MessageDispatcher((Channel)this.SEDU, (MessageListener)this, (org.jgroups.MembershipListener)this, (RequestHandler)this);
            this.SEDU.setReceiver((Receiver)this);
            this.SEDU.addChannelListener((ChannelListener)this);
            this.SEDU.setOpt(3, (Object)false);
            this.SEDU.connect(string);
            this.castRequest(this.clear);
            ServiceLogger.logDebug(4650035, new Object[]{Version.printVersion(), this.SEDU.getAddressAsString(), this.SEDU.getProperties()}, 4);
            this.connect = true;
        }
        catch (ClusterException clusterException) {
            this.append();
            throw clusterException;
        }
        catch (Throwable throwable) {
            this.append();
            ServiceLogger.logError(throwable);
            throw new ClusterException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws ClusterException {
        try {
            if (!this.SEDU()) {
                return;
            }
            this.connect = false;
            this.SEDU.close();
            this.SEDU = null;
            ServiceLogger.logDebug(4650036, 4);
        }
        finally {
            this.append();
        }
        ServiceLogger.logDebug(4650037, 4);
    }

    private void append() {
        if (this.add()) {
            return;
        }
        this.connect = false;
        this.equals = true;
        try {
            if (this.SEDU != null) {
                this.SEDU.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.castRequest.clear();
        this.SEDU = null;
        this.add = null;
        this.castRequest = null;
        this.close = null;
        this.append = null;
        this.castMessage = null;
    }

    private JRMember castMessage(Address address) {
        JRMember jRMember = JRMBR.makeMember(address);
        jRMember = jRMember.equals(this.addChannelListener) ? this.addChannelListener : jRMember;
        return jRMember;
    }

    private JRView castRequest(View view) throws ClusterException {
        Object object2;
        HashMap<Integer, Address> hashMap = new HashMap<Integer, Address>();
        ArrayList<JRMember> arrayList = new ArrayList<JRMember>();
        Vector vector = view.getMembers();
        for (Object object2 : vector) {
            JRMember jRMember = this.castMessage((Address)object2);
            Address address = hashMap.put(jRMember.getID(), (Address)object2);
            if (address != null) {
                JRMember jRMember2 = this.castMessage(address);
                ServiceLogger.logError("JGroupsChannel:: Duplicated Member ID: exists(address=" + address + ", member=" + jRMember2 + "), duplicated(address=" + object2 + ", member=" + jRMember + ")");
                throw new ClusterException("Duplicated Member ID: " + this.addChannelListener.getID());
            }
            arrayList.add(jRMember);
        }
        boolean bl = view instanceof MergeView;
        this.castRequest.clear();
        this.castRequest.putAll(hashMap);
        object2 = new JRView(this.addChannelListener, view.getVid().toString(), arrayList, bl);
        this.close = object2;
        return object2;
    }

    private Address clear(int n) {
        return (Address)this.castRequest.get(n);
    }

    public JRView getView() {
        return this.close;
    }

    public void viewAccepted(View view) {
        ServiceLogger.logDebug(4650038, view, 4);
        this.clear = view;
        if (!this.connect) {
            return;
        }
        try {
            this.castMessage.viewAccepted(this.castRequest(view));
        }
        catch (ClusterException clusterException) {
            // empty catch block
        }
    }

    public void suspect(Address address) {
        JRMember jRMember = this.castMessage(address);
        ServiceLogger.logDebug(4650039, new Object[]{jRMember.getID(), address}, 4);
        this.castMessage.suspect(jRMember);
    }

    public void block() {
        ServiceLogger.logDebug(4650040, 4);
    }

    public void unblock() {
        ServiceLogger.logDebug(4650041, 4);
    }

    @Override
    public JRView verifyView(JRView jRView, Set set, JRView jRView2) {
        JRView jRView3 = jRView2;
        return jRView3;
    }

    @Override
    public void sendMessage(JRMessage jRMessage) throws ClusterException {
        this.addChannelListener();
        Address address = this.clear(jRMessage.getDest());
        if (address == null) {
            throw new ClusterException("JGroupsChannel:: sendMessage(): dest member not exists: " + jRMessage.getDest());
        }
        this.close(address, jRMessage);
    }

    private void close(Address address, JRMessage jRMessage) throws ClusterException {
        Message message = new Message(address, null, (Serializable)jRMessage);
        try {
            this.SEDU.send(message);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new ClusterException(throwable);
        }
    }

    @Override
    public void castMessage(JRMessage jRMessage) throws ClusterException {
        this.addChannelListener();
        Message message = new Message(null, null, (Serializable)jRMessage);
        try {
            this.SEDU.send(message);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new ClusterException(throwable);
        }
    }

    @Override
    public void castMessage(List list, JRMessage jRMessage) throws ClusterException {
        for (Integer n : list) {
            Address address = this.clear(n);
            if (address == null) {
                throw new ClusterException("JGroupsChannel:: sendMessage(): dest member not exists: " + jRMessage.getDest());
            }
            this.close(address, jRMessage);
        }
    }

    @Override
    public Object sendRequest(JRMessage jRMessage, long l) throws ClusterException {
        this.addChannelListener();
        Address address = this.clear(jRMessage.getDest());
        if (address == null) {
            throw new ClusterException("JGroupsChannel:: sendRequest(): dest member not exists: " + jRMessage.getDest());
        }
        Message message = new Message(address, null, (Serializable)jRMessage);
        try {
            Serializable serializable = (Serializable)this.add.sendMessage(message, 1, l);
            if (serializable instanceof Throwable) {
                ServiceLogger.logError(new Exception("Responsor throw exception in handleRequest(), please check cause exception.", (Throwable)serializable));
                throw (Throwable)serializable;
            }
            return serializable;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new ClusterException(throwable);
        }
    }

    @Override
    public List castRequest(JRMessage jRMessage, long l) throws ClusterException {
        return this.castRequest(null, jRMessage, l);
    }

    @Override
    public List castRequest(List list, JRMessage jRMessage, long l) throws ClusterException {
        this.addChannelListener();
        Message message = new Message(null, null, (Serializable)jRMessage);
        try {
            Serializable serializable2;
            boolean bl = false;
            Vector<Address> vector = null;
            if (list != null) {
                vector = new Vector<Address>();
                for (Serializable serializable2 : list) {
                    Address address = this.clear((Integer)serializable2);
                    if (address == null) continue;
                    vector.add(address);
                }
            }
            RspList rspList = this.add.castMessage(vector, message, 2, l, bl);
            serializable2 = new ArrayList();
            for (Rsp rsp : rspList.values()) {
                int n = JRMBR.makeMember(rsp.getSender()).getID();
                serializable2.add(new Response(n, rsp.wasReceived(), rsp.wasSuspected(), rsp.getValue()));
                if (rsp.wasSuspected()) {
                    ServiceLogger.logDebug("JGroupsChannel:: castRequest() does not received response from " + n + "(suspected), rsp=" + rsp);
                    continue;
                }
                if (!rsp.wasReceived()) {
                    ServiceLogger.logDebug("JGroupsChannel:: castRequest() does not received response from " + n + "(timeout), rsp=" + rsp);
                    continue;
                }
                if (!(rsp.getValue() instanceof Throwable)) continue;
                ServiceLogger.logError("JGroupsChannel:: castRequest() responsor throw exception in handleRequest(), please check responsor.", 3);
                ServiceLogger.logError((Throwable)rsp.getValue(), 3);
            }
            return serializable2;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            throw new ClusterException(throwable);
        }
    }

    @Override
    public Object castRequestAndReturnFirstResult(List list, JRMessage jRMessage, boolean bl, long l) throws ClusterException {
        return null;
    }

    public void receive(Message message) {
        if (!this.SEDU()) {
            return;
        }
        if (!(message.getObject() instanceof JRMessage)) {
            ServiceLogger.logError("JGroupsChannel:: receive(): Unknown message: " + message);
            return;
        }
        JRMessage jRMessage = (JRMessage)message.getObject();
        this.append.handleMessage(jRMessage);
    }

    public Object handle(Message message) {
        if (!this.SEDU()) {
            return null;
        }
        if (!(message.getObject() instanceof JRMessage)) {
            ServiceLogger.logError("JGroupsChannel:: handle(): Unknown message: " + message);
            return null;
        }
        JRMessage jRMessage = (JRMessage)message.getObject();
        return this.append.handleRequest(jRMessage);
    }

    public void channelConnected(Channel channel) {
        ServiceLogger.logDebug(4650042, 4);
    }

    public void channelDisconnected(Channel channel) {
        ServiceLogger.logDebug(4650043, 4);
    }

    public void channelClosed(Channel channel) {
        ServiceLogger.logDebug(4650044, 4);
    }

    public void channelShunned() {
        ServiceLogger.logDebug(4650045, 4);
    }

    public void channelReconnected(Address address) {
        ServiceLogger.logDebug(4650046, 4);
    }
}

