/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.jgroups;

import java.io.File;
import java.net.InetAddress;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.jgroups.JRLogFactory;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

class JGroupsEnv
extends ClusterEnv {
    JGroupsEnv() {
    }

    static void initEnv() throws ClusterException {
        ClusterEnv.init();
        System.setProperty("jgroups.logging.log_factory_class", JRLogFactory.class.getName());
        try {
            ServiceLogger.logDebug("ClusterEnv:: jgroups.bind_addr=" + System.getProperty("jgroups.bind_addr") + ", " + "java.net.preferIPv4Stack" + "=" + System.getProperty("java.net.preferIPv4Stack") + ", " + "java.net.preferIPv6Addresses" + "=" + System.getProperty("java.net.preferIPv6Addresses") + "\n\t InetAddress.getLocalHost()=" + InetAddress.getLocalHost() + ", theFirstNonLoopbackAddress=" + ServerUtil.getLocalAddress() + ", AllLocalAddresses=" + ServerUtil.getAllLocalAddresses(true, true));
            if (System.getProperty("jgroups.bind_addr") == null) {
                System.setProperty("jgroups.bind_addr", ClusterEnv.getHost());
                ServiceLogger.logDebug("ClusterEnv:: bind rmiHost for JGroups by default: " + ClusterEnv.getHost());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    public static String getJGroupsProps() {
        String string;
        String string2 = ServerEnv.getReportHome();
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (new File(string = string2 + "bin" + File.separator + "jgroups.xml").exists()) {
            return string;
        }
        return null;
    }
}

