/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cluster.rmi;

import java.io.Serializable;
import java.rmi.RemoteException;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.MessageReceiver;
import jet.server.cluster.rmi.RMITransport;

public class JRMITransport
implements RMITransport {
    private static final long serialVersionUID = -6236337448686150355L;
    private MessageReceiver SEDU;

    public JRMITransport(MessageReceiver messageReceiver) throws RemoteException {
        this.SEDU = messageReceiver;
    }

    @Override
    public void message(JRMessage jRMessage) throws RemoteException, ClusterException {
        try {
            this.SEDU.handleMessage(jRMessage);
        }
        catch (Throwable throwable) {
            throw new ClusterException(throwable);
        }
    }

    @Override
    public Serializable request(JRMessage jRMessage) throws RemoteException, ClusterException {
        try {
            return this.SEDU.handleRequest(jRMessage);
        }
        catch (Throwable throwable) {
            throw new ClusterException(throwable);
        }
    }

    @Override
    public long checkConnection(int n, long l) throws RemoteException, ClusterException {
        if (this.SEDU == null || !this.SEDU.hasStarted()) {
            throw new ClusterException("Receiver does not running.");
        }
        return ClusterEnv.getClusterTime();
    }
}

