/*
 * Decompiled with CFR 0.152.
 */
package jet.server.crd;

import com.jinfonet.api.crd.QueryInformation;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDRunDetail;
import jet.server.api.crd.CubeInfo;
import jet.server.api.crd.CubeInfoKey;
import jet.server.api.crd.CubeUsage;
import jet.server.cluster.ClusterEnv;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;

public class ExtCRDInfo
extends CubeInfo {
    public static final int STATUS_TYPE_NOT_READY = 0;
    public static final int STATUS_TYPE_RUNNING = 1;
    public static final int STATUS_TYPE_READY = 2;
    private static final long serialVersionUID = -5170118050265961043L;
    private int resultVersion;
    private int runtimeStatus;
    private int catalogVersion;
    private Date catalogLastModified;
    private String configFile;
    private int id;
    private Date startTime;
    private Map connInfoMap;
    private Map runtimeJndiNames;
    private Map runtimeJdbcUrls;
    private Map runtimeUserNames;
    private Map runtimePasswords;
    private ExtCRDInfo bakInfo = null;
    private Object monitor = new Serializable(){
        private static final long serialVersionUID = -2721862487529299489L;
    };
    private int usageSequence = 0;

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{").append(this.toStr()).append("}");
        return stringBuffer.toString();
    }

    @Override
    public String toStr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id:").append(this.id);
        stringBuffer.append(", ").append(super.toStr());
        stringBuffer.append(", runtimeStatus:").append(this.runtimeStatus == 0 ? "NOT_READY" : (this.runtimeStatus == 1 ? "RUNNING" : "READY"));
        stringBuffer.append(", resultVersion:").append(this.resultVersion);
        if (this.catalogLastModified != null) {
            stringBuffer.append(", catalogLastModified:").append(this.catalogLastModified);
        }
        stringBuffer.append(", catalogVersion:").append(this.catalogVersion);
        if (!ServerUtil.isEmpty(this.configFile)) {
            stringBuffer.append(", configFile:").append(this.configFile);
        }
        if (this.runtimeJdbcUrls != null && !this.runtimeJdbcUrls.isEmpty()) {
            stringBuffer.append(", runtimeJdbcUrls:").append(this.runtimeJdbcUrls);
        }
        if (this.runtimeJndiNames != null && !this.runtimeJndiNames.isEmpty()) {
            stringBuffer.append(", runtimeJndiNames:").append(this.runtimeJndiNames);
        }
        if (this.runtimePasswords != null && !this.runtimePasswords.isEmpty()) {
            stringBuffer.append(", runtimePasswords: ***");
        }
        if (this.runtimeUserNames != null && !this.runtimeUserNames.isEmpty()) {
            stringBuffer.append(", runtimeUserNames:").append(this.runtimeUserNames);
        }
        if (this.startTime != null) {
            stringBuffer.append(", startTime:").append(this.startTime);
        }
        if (this.connInfoMap != null && this.connInfoMap.size() > 0) {
            stringBuffer.append(", connInfoMap:").append(StringUtil.toString(this.connInfoMap));
        }
        return stringBuffer.toString();
    }

    public ExtCRDInfo(String string, String string2, int n, String string3, String string4) {
        super(string, string2, n, string3, string4);
    }

    private ExtCRDInfo(ExtCRDInfo extCRDInfo) {
        super(extCRDInfo);
        this.resultVersion = extCRDInfo.resultVersion;
        this.runtimeStatus = extCRDInfo.runtimeStatus;
        this.catalogVersion = extCRDInfo.catalogVersion;
        this.catalogLastModified = extCRDInfo.catalogLastModified;
        this.configFile = extCRDInfo.configFile;
        this.id = extCRDInfo.id;
        this.startTime = extCRDInfo.startTime;
        this.connInfoMap = extCRDInfo.connInfoMap;
        this.runtimeJndiNames = extCRDInfo.runtimeJndiNames;
        this.runtimeJdbcUrls = extCRDInfo.runtimeJdbcUrls;
        this.runtimeUserNames = extCRDInfo.runtimeUserNames;
        this.runtimePasswords = extCRDInfo.runtimePasswords;
    }

    @Override
    public CRDInfoKey getCRDKey() {
        return this.crdKey;
    }

    public void setCRDKey(CRDInfoKey cRDInfoKey) {
        this.crdKey = cRDInfoKey;
    }

    public int getResultVersion() {
        return this.resultVersion;
    }

    public void setResultVersion(int n) {
        this.resultVersion = n;
    }

    public int getCatalogVersion() {
        return this.catalogVersion;
    }

    public void setCatalogVersion(int n) {
        this.catalogVersion = n;
    }

    public Date getCatalogLastModified() {
        return this.catalogLastModified;
    }

    public void setCatalogLastModified(Date date) {
        this.catalogLastModified = date;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    public void running() {
        this.startTime = new Date();
        this.runtimeStatus = 1;
        if (super.getRunTimes() > 0) {
            this.setStatus((short)3);
        } else {
            this.setStatus((short)2);
        }
    }

    public boolean isRunning() {
        return this.runtimeStatus == 1;
    }

    public void notReady() {
        this.runtimeStatus = 0;
        if (super.getStatus() != 5) {
            this.setStatus((short)1);
        }
    }

    public boolean isNotReady() {
        return this.runtimeStatus == 0;
    }

    public void ready() {
        this.runtimeStatus = 2;
        this.status = (short)4;
    }

    public boolean isReady() {
        return this.runtimeStatus == 2;
    }

    public void setStatus(short s) {
        this.status = s;
    }

    public void setLocation(short s) {
        this.location = s;
    }

    public void setActualUsedMemory(long l) {
        this.actualUsedMemory = l;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getAutoConfigFile() {
        if (this.configFile == null || this.configFile.trim().length() == 0) {
            return this.getId() + ".cfg";
        }
        return this.configFile;
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public void setParamValues(Map map) {
        this.paramValues = map;
    }

    public void setRuntimeParamValues(Map map) {
        this.runtimeParamValues = map;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public Map getRuntimeJndiNames() {
        return this.runtimeJndiNames;
    }

    public void setRuntimeJndiNames(Map map) {
        this.runtimeJndiNames = map;
    }

    public Map getRuntimeJdbcUrls() {
        return this.runtimeJdbcUrls;
    }

    public void setRuntimeJdbcUrls(Map map) {
        this.runtimeJdbcUrls = map;
    }

    public Map getRuntimeUserNames() {
        return this.runtimeUserNames;
    }

    public void setRuntimeUserNames(Map map) {
        this.runtimeUserNames = map;
    }

    public Map getRuntimePasswords() {
        return this.runtimePasswords;
    }

    public void setRuntimePasswords(Map map) {
        this.runtimePasswords = map;
    }

    public boolean runtimeConnInfoEquals(QueryInformation queryInformation) {
        return ServerUtil.mapEquals(this.getRuntimePasswords(), queryInformation.getRuntimePwds()) && ServerUtil.mapEquals(this.getRuntimeUserNames(), queryInformation.getRuntimeUsers()) && ServerUtil.mapEquals(this.getRuntimeJdbcUrls(), queryInformation.getRuntimeJdbcUrls()) && ServerUtil.mapEquals(this.getRuntimeJndiNames(), queryInformation.getRuntimeJndiNames());
    }

    public Map getConnInfoMap() {
        return this.connInfoMap;
    }

    public void setConnInfoMap(Map map) {
        this.connInfoMap = map;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void nextResultVersion() {
        ++this.resultVersion;
    }

    public String getResultFile() {
        String string = this.getId() + "_" + this.resultVersion + ".rst";
        String string2 = ServerEnv.getServerID();
        if (string2 != null && string2.trim().length() > 0) {
            string = string2 + "_" + string;
        }
        return string;
    }

    public void backupInfo() {
        this.bakInfo = new ExtCRDInfo(this);
    }

    public void restoreInfo() {
        super.restoreInfo(this.bakInfo);
        this.resultVersion = this.bakInfo.resultVersion;
        this.runtimeStatus = this.bakInfo.runtimeStatus;
        this.catalogVersion = this.bakInfo.catalogVersion;
        this.catalogLastModified = this.bakInfo.catalogLastModified;
        this.configFile = this.bakInfo.configFile;
        this.id = this.bakInfo.id;
        this.startTime = this.bakInfo.startTime;
        this.connInfoMap = this.bakInfo.connInfoMap;
        this.runtimeJndiNames = this.bakInfo.runtimeJndiNames;
        this.runtimeJdbcUrls = this.bakInfo.runtimeJdbcUrls;
        this.runtimeUserNames = this.bakInfo.runtimeUserNames;
        this.runtimePasswords = this.bakInfo.runtimePasswords;
        this.bakInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String increaseUsingReport(String string, int n, String string2, String string3) {
        String string4 = null;
        Object object = this.monitor;
        synchronized (object) {
            int n2 = this.usageSequence++;
            string4 = ClusterEnv.isClusterEnabled() ? ClusterEnv.getMemberID() + "$" + n2 : String.valueOf(n2);
        }
        this.usingReports.put(string4, new CubeUsage((CubeInfoKey)this.getCRDKey(), string, n, string2, string3));
        return string4;
    }

    public void decreaseUsingReport(String string) {
        this.usingReports.remove(string);
    }

    public void usingReportRenamed(String string, String string2) {
        CubeUsage cubeUsage = (CubeUsage)this.usingReports.remove(string);
        if (cubeUsage != null) {
            if (cubeUsage.getType() == 1) {
                this.usingReports.put(string, new CubeUsage((CubeInfoKey)this.getCRDKey(), string2, cubeUsage.getType(), null, cubeUsage.getUser()));
            } else {
                this.usingReports.put(string, new CubeUsage((CubeInfoKey)this.getCRDKey(), cubeUsage.getResourceName(), cubeUsage.getType(), string2, cubeUsage.getUser()));
            }
        }
    }

    public void setRunDetails(Vector vector) {
        this.runDetails = vector;
    }

    public void addRunDetail(CRDRunDetail cRDRunDetail) {
        if (this.runDetails == null) {
            this.runDetails = new Vector();
        }
        this.runDetails.add(cRDRunDetail);
    }
}

