/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.api.CompletedPublishRecord;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.CompletedResultTableImpl;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.jrserver.JRCompletedPublishRecord;
import jet.server.log.ServiceLogger;

public class CompletedPublishTableImpl
extends TableImpl
implements Table {
    private static int EMPTY = 1;
    private static int INTEGER = 2;
    private static String SEDU = "COMPLETEDPUBLISHTABLE_" + INTEGER;
    private static int VARCHAR = 0;
    private static int add = 1;
    private static int addRecords = 2;
    private static int append = 3;
    private static int close = 4;
    private static String[] contains = new String[]{"Id", "RecordId", "SheetName", "displayname", "pub_type"};
    private CompletedResultTableImpl createTable = null;

    public CompletedPublishTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, SEDU);
        super.append(new FieldImpl(this.getName(), contains[VARCHAR], JDBCType.INTEGER, 0, 3, 0));
        super.append(new FieldImpl(this.getName(), contains[add], JDBCType.VARCHAR, 40, 1, 0));
        super.append(new FieldImpl(this.getName(), contains[addRecords], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), contains[append], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), contains[close], JDBCType.VARCHAR, 64, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        String string = "COMPLETEDPUBLISHTABLE_" + EMPTY;
        if (database.tables().contains(string)) {
            Table table = database.tables(string);
            if (!updateDetailsTable.isUpdating(string)) {
                this.EMPTY(table);
                table.delete(null, ParameterMetaInfo.EMPTY);
                updateDetailsTable.setUpdateDetails(string, true);
            }
            try {
                this.adapter.dropTable(table);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logDebug(3640001, string, 3);
                ServiceLogger.logError(sQLException, 3);
            }
            ((DatabaseImpl)database).remove(table);
        }
        this.createTable = new CompletedResultTableImpl(database, updateDetailsTable);
    }

    private void EMPTY(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, false);
        while (recordset.next()) {
            FieldValue[] fieldValueArray = super.fields().values();
            fieldValueArray[0].setValue(recordset.fields("Id").getValue());
            fieldValueArray[1].setValue(recordset.fields("RecordId").getValue());
            fieldValueArray[2].setValue(recordset.fields("SheetName").getValue());
            fieldValueArray[3].setValue(recordset.fields("displayname").getValue());
            fieldValueArray[4].setValue(recordset.fields("Type").getValue());
            super.insert(fieldValueArray);
        }
        recordset.close();
    }

    public void addRecords(String string, Hashtable hashtable) throws RemoteException, SQLException {
        if (string != null && hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Vector vector = (Vector)hashtable.get(string2);
                this.INTEGER(string, string2, vector);
            }
        }
    }

    private void INTEGER(String string, String string2, Vector vector) throws SQLException, RemoteException {
        if (string != null && vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                CompletedPublishRecord completedPublishRecord = (CompletedPublishRecord)vector.get(i);
                FieldValue[] fieldValueArray = super.fields().values();
                int n = this.adapter.getID(this, this.fields(contains[VARCHAR]));
                fieldValueArray[VARCHAR].setValue(new Integer(n));
                fieldValueArray[add].setValue(string);
                fieldValueArray[addRecords].setValue(string2);
                fieldValueArray[append].setValue(completedPublishRecord.getReportDisplayName());
                fieldValueArray[close].setValue(completedPublishRecord.getType());
                try {
                    super.insert(fieldValueArray);
                    this.createTable.addRecords(n, string, completedPublishRecord.getResults());
                    continue;
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    throw new RemoteException("", sQLException);
                }
            }
        }
    }

    public Hashtable getRecordsByRecordID(String string) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = new Hashtable();
        Recordset recordset = null;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(contains[add]).getName(), string, 12);
            stringBuffer.append(" WHERE ").append(this.fields(contains[add]).getName()).append("=?");
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), parameterMetaInfo, false);
            while (recordset.next()) {
                int n = recordset.getInt(contains[VARCHAR]);
                String string2 = recordset.getString(contains[addRecords]);
                Vector<JRCompletedPublishRecord> vector = (Vector<JRCompletedPublishRecord>)hashtable.get(string2);
                if (vector == null) {
                    vector = new Vector<JRCompletedPublishRecord>();
                    hashtable.put(string2, vector);
                }
                JRCompletedPublishRecord jRCompletedPublishRecord = new JRCompletedPublishRecord(recordset.getString(contains[close]), this.createTable.getRecordsByPublishID(n), recordset.getString(contains[append]));
                vector.add(jRCompletedPublishRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RemoteException("", exception);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return hashtable;
    }

    public boolean deleteRecordsByRecordID(String string) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(contains[add]).getName(), String.valueOf(string), 12);
            stringBuffer.append("WHERE ").append(this.fields(contains[add]).getName()).append("=?");
            try {
                bl = super.delete(stringBuffer.toString(), parameterMetaInfo) > 0;
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return false;
            }
            if (bl) {
                this.createTable.deleteRecordsByRecordID(string);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RemoteException("", exception);
        }
        return bl;
    }

    public int deleteAllRecords() throws SQLException {
        this.createTable.deleteAllRecords();
        return super.delete(null, ParameterMetaInfo.EMPTY);
    }

    @Override
    public void close() {
        if (this.createTable != null) {
            this.createTable.close();
            this.createTable = null;
        }
        super.close();
    }
}

