/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.CompletedTaskRecord;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.CompletedPublishTableImpl;
import jet.server.db.CompletedTable;
import jet.server.db.CompletedTaskRecordImpl;
import jet.server.db.JRTaskSuccessInfo;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.intf.jrs.SchedulingService;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.log.ServiceLogger;

public class CompletedTableImplReal
extends TableImpl
implements Table,
CompletedTable {
    public static final String COMPLETEDTABLE = "COMPLETEDTABLE_4";
    private static String BIGINT = "COMPLETEDTABLE_1";
    private static String BIT = "COMPLETEDTABLE_2";
    private static String EMPTY = "COMPLETEDTABLE_3";
    public static final int RECORD_ID_COL = 1;
    public static final int PARAM_FILE_COL = 6;
    public static final String[] colNames = new String[]{"id", "RecordId", "TaskId", "TaskClass", "CatFile", "RptFile", "ParamFile", "ResultFile", "Error", "EngMsg", "Submitter", "CompletedTime", "formatExists", "formatSuccessful", "VersionId", "LaunchType", "isSuccessful", "TaskName", "IsMissed", "scheduleTrigger", "conditionsLogic", "reportnames"};
    private int INTEGER = 3000;
    private Integer J = 0;
    private SchedulingService SEDU = null;
    private String VARCHAR = ".";
    private StringBuffer Z = new StringBuffer();
    private CompletedPublishTableImpl add = null;

    public static CompletedTableImplReal newInstance(Database database, UpdateDetailsTable updateDetailsTable) throws RemoteException {
        try {
            return new CompletedTableImplReal(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, COMPLETEDTABLE, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private CompletedTableImplReal(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, RemoteException, SQLException {
        super((DatabaseImpl)database, COMPLETEDTABLE);
        super.append(new FieldImpl(this.getName(), colNames[0], JDBCType.INTEGER, 0, 3, 0));
        super.append(new FieldImpl(this.getName(), colNames[1], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[2], JDBCType.VARCHAR, 128, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[3], JDBCType.VARCHAR, 256, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[4], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[5], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[6], JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[7], JDBCType.VARCHAR, 1024, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[8], JDBCType.VARCHAR, 256, 16, 0));
        super.append(new FieldImpl(this.getName(), colNames[9], JDBCType.VARCHAR, 512, 16, 0));
        super.append(new FieldImpl(this.getName(), colNames[10], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[11], JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[12], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[13], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[14], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[15], JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[16], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[17], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[18], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), colNames[19], JDBCType.VARCHAR, 80, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[20], JDBCType.VARCHAR, 16, 0, 0));
        super.append(new FieldImpl(this.getName(), colNames[21], JDBCType.VARCHAR, 512, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        try {
            int n;
            boolean bl = database.tables().contains(BIGINT);
            boolean bl2 = updateDetailsTable.isUpdating(BIGINT);
            if (bl) {
                Object object;
                if (!bl2) {
                    object = this.getAllRecordsFromOldTable(BIGINT, database);
                    if (object != null && ((Vector)object).size() > 0) {
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            this.insertRecord((CompletedTaskRecord)((Vector)object).elementAt(i));
                        }
                    }
                    updateDetailsTable.setUpdateDetails(BIGINT, true);
                }
                object = database.tables(BIGINT);
                try {
                    this.adapter.dropTable((Table)object);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(3640001, object.getName(), 3);
                    ServiceLogger.logError(sQLException, 3);
                }
                ((DatabaseImpl)database).remove((Table)object);
            }
            boolean bl3 = database.tables().contains(BIT);
            bl2 = updateDetailsTable.isUpdating(BIT);
            if (bl3) {
                if (!bl2) {
                    Vector vector = this.getAllRecordsFromOldTable(BIT, database);
                    if (vector != null && vector.size() > 0) {
                        for (int i = 0; i < vector.size(); ++i) {
                            this.insertRecord((CompletedTaskRecord)vector.elementAt(i));
                        }
                    }
                    updateDetailsTable.setUpdateDetails(BIT, true);
                }
                Table table = database.tables(BIT);
                try {
                    this.adapter.dropTable(table);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(3640001, table.getName(), 3);
                    ServiceLogger.logError(sQLException, 3);
                }
                ((DatabaseImpl)database).remove(table);
            }
            boolean bl4 = database.tables().contains(EMPTY);
            bl2 = updateDetailsTable.isUpdating(EMPTY);
            if (bl4) {
                if (!bl2) {
                    Vector vector = this.getAllRecordsFromOldTable(EMPTY, database);
                    if (vector != null && vector.size() > 0) {
                        for (int i = 0; i < vector.size(); ++i) {
                            this.insertRecord((CompletedTaskRecord)vector.elementAt(i));
                        }
                    }
                    updateDetailsTable.setUpdateDetails(EMPTY, true);
                }
                Table table = database.tables(EMPTY);
                try {
                    this.adapter.dropTable(table);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(3640001, table.getName(), 3);
                    ServiceLogger.logError(sQLException, 3);
                }
                ((DatabaseImpl)database).remove(table);
            }
            if ((n = this.INTEGER()) == Integer.MIN_VALUE) {
                n = -1;
            }
            this.adapter.setID(this, this.fields(colNames[0]), n + 1);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.add = new CompletedPublishTableImpl(database, updateDetailsTable);
        if (ServerEnv.getMaxCompletedRecordCount() > 0) {
            this.INTEGER = ServerEnv.getMaxCompletedRecordCount();
        }
        this.J = this.getRecordAmount();
        if (this.J > this.INTEGER) {
            this.adjustCompletedRecordAmount();
        }
    }

    @Override
    public void addRecord(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, long[] lArray, String string7, String string8, int n, String string9, int n2, String string10) throws RemoteException {
        this.addRecord(string, string2, string3, string4, string5, date, string6, bl, lArray, string7, string8, n, string9, n2, string10, null);
    }

    @Override
    public void addRecord(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, long[] lArray, String string7, String string8, int n, String string9, int n2, String string10, String string11) throws RemoteException {
        this.addRecord(string, string2, string3, string4, string5, date, string6, bl, lArray, string7, string8, n, string9, n2, string10, string11, false, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecord(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, long[] lArray, String string7, String string8, int n, String string9, int n2, String string10, String string11, boolean bl2, String string12, String string13, Hashtable hashtable, String string14) throws RemoteException {
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[1].setValue(string9);
        fieldValueArray[2].setValue(string);
        fieldValueArray[3].setValue(string8);
        fieldValueArray[4].setValue(string2);
        fieldValueArray[5].setValue(string3);
        fieldValueArray[6].setValue(string4);
        if (string5.length() > 1024) {
            string5 = string5.substring(0, 1020) + "...";
        }
        fieldValueArray[7].setValue(string5);
        fieldValueArray[8].setValue(string7);
        fieldValueArray[9].setValue(string10);
        fieldValueArray[10].setValue(string6);
        fieldValueArray[11].setValue(new Long(date.getTime()));
        fieldValueArray[12].setValue(new Long(lArray == null ? 0L : lArray[0]));
        fieldValueArray[13].setValue(new Long(lArray == null ? 0L : lArray[1]));
        fieldValueArray[14].setValue(new Integer(n));
        fieldValueArray[15].setValue(new Integer(n2));
        fieldValueArray[16].setValue(new Boolean(bl));
        fieldValueArray[17].setValue(string11);
        fieldValueArray[18].setValue(new Boolean(bl2));
        fieldValueArray[19].setValue(string12 != null ? string12 : "");
        fieldValueArray[20].setValue(string13 != null ? string13 : "");
        fieldValueArray[21].setValue(string14);
        try {
            super.insert(fieldValueArray);
            if (hashtable != null) {
                this.add.addRecords(string9, hashtable);
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        Integer n3 = this.J;
        synchronized (n3) {
            Integer n4 = this.J;
            Integer n5 = this.J = Integer.valueOf(this.J + 1);
        }
        this.adjustCompletedRecordAmount();
    }

    public void adjustCompletedRecordAmount() {
        while (this.J > this.INTEGER) {
            this.delEarliestVersion();
        }
    }

    public int getRecordAmount() {
        int n = 0;
        try {
            n = super.queryCountValue(colNames[1], null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delEarliestVersion() {
        Serializable serializable;
        Object object;
        boolean bl = false;
        this.Z.delete(0, this.Z.length());
        this.Z.append(" WHERE ID IN(").append("SELECT MIN(ID) FROM ").append(this.getName()).append(")");
        try {
            object = this.BIT(this.Z.toString(), false);
            if (object.size() > 0) {
                serializable = (CompletedTaskRecordImpl)object.remove(0);
                this.Z.delete(0, this.Z.length());
                this.Z.append(" WHERE ").append(this.fields(colNames[1]).getName()).append("=?");
                int n = super.delete(this.Z.toString(), new ParameterMetaInfo().add("completedRecordID", ((CompletedTaskRecordImpl)serializable).completedRecordID));
                boolean bl2 = bl = n > 0;
                if (bl) {
                    this.add.deleteRecordsByRecordID(((CompletedTaskRecordImpl)serializable).getCompletedRecordID());
                }
                this.EMPTY((CompletedTaskRecordImpl)serializable);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        if (bl) {
            object = this.J;
            synchronized (object) {
                serializable = this.J;
                Integer n = this.J = Integer.valueOf(this.J - 1);
            }
        }
        return bl;
    }

    public void insertRecord(CompletedTaskRecord completedTaskRecord) throws RemoteException {
        long[] lArray = ((JRTaskSuccessInfo)completedTaskRecord.getSuccessInfo()).getSuccessInfo().getSuccInfo();
        this.addRecord(completedTaskRecord.getTaskID(), completedTaskRecord.getCatalogFile(), completedTaskRecord.getReportFile(), completedTaskRecord.getParamFile(), completedTaskRecord.getResults(), completedTaskRecord.getCompletedTime(), completedTaskRecord.getSubmitter(), completedTaskRecord.isSuccessful(), lArray, completedTaskRecord.getErrorMessage(), completedTaskRecord.getTaskClass(), Integer.parseInt(completedTaskRecord.getVersionID()), completedTaskRecord.getCompletedRecordID(), completedTaskRecord.getLaunchType(), completedTaskRecord.getEngineStatus(), completedTaskRecord.getTaskName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRecord(String string) throws RemoteException {
        Serializable serializable;
        boolean bl = true;
        this.Z.delete(0, this.Z.length());
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(this.fields(colNames[1]).getName(), string, 12);
            this.Z.append(" WHERE ").append(this.fields(colNames[1]).getName()).append("=?");
            List list = this.BIGINT(this.Z.toString(), parameterMetaInfo, false);
            int n = super.delete(this.Z.toString(), parameterMetaInfo);
            boolean bl2 = bl = n > 0;
            if (bl) {
                this.add.deleteRecordsByRecordID(string);
            }
            if (list.size() > 0) {
                serializable = (CompletedTaskRecordImpl)list.remove(0);
                this.EMPTY((CompletedTaskRecordImpl)serializable);
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        if (bl) {
            Integer n = this.J;
            synchronized (n) {
                serializable = this.J;
                Integer n2 = this.J = Integer.valueOf(this.J - 1);
            }
        }
        return bl;
    }

    @Override
    public Vector getCompletedTaskRecordsByTaskID(String string) throws RemoteException {
        this.Z.delete(0, this.Z.length());
        Vector vector = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(this.fields(colNames[2]).getName(), string, 12);
            this.Z.append(" WHERE ").append(this.fields(colNames[2]).getName()).append("=?");
            this.Z.append(" ORDER BY ").append(this.fields(colNames[0]).getName()).append(" DESC");
            vector = new Vector(this.BIGINT(this.Z.toString(), parameterMetaInfo, true));
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        return vector;
    }

    @Override
    public Vector getCompletedTaskRecordsByReport(String string, String string2) throws RemoteException {
        if (string2 != null && !string2.startsWith("/") && string != null) {
            string2 = string.substring(0, string.lastIndexOf("/") + 1) + string2;
        }
        this.Z.delete(0, this.Z.length());
        Vector vector = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(this.fields(colNames[4]).getName(), string, 12);
            parameterMetaInfo.add(this.fields(colNames[5]).getName(), string2, 12);
            this.Z.append(" WHERE ").append(this.fields(colNames[4]).getName()).append("=?");
            this.Z.append(" AND ").append(this.fields(colNames[5]).getName()).append("=?");
            this.Z.append(" ORDER BY ").append(this.fields(colNames[0]).getName()).append(" DESC");
            vector = new Vector(this.BIGINT(this.Z.toString(), parameterMetaInfo, true));
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        return vector;
    }

    @Override
    public Vector getCompletedTaskRecordsByUser(String string) throws RemoteException {
        this.Z.delete(0, this.Z.length());
        Vector vector = null;
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(this.fields(colNames[10]).getName(), string, 12);
            this.Z.append(" WHERE ").append(this.fields(colNames[10]).getName()).append("=?");
            this.Z.append(" ORDER BY ").append(this.fields(colNames[11]).getName()).append(" DESC");
            vector = new Vector(this.BIGINT(this.Z.toString(), parameterMetaInfo, true));
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        return vector;
    }

    @Override
    public Vector getAllCompletedTaskRecordsVector() throws RemoteException {
        Vector vector = null;
        try {
            vector = new Vector(this.BIT(" ORDER BY ID DESC", true));
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector getAllRecordsFromOldTable(String string, Database database) throws RemoteException {
        Vector<CompletedTaskRecordImpl> vector = new Vector<CompletedTaskRecordImpl>();
        Table table = database.tables(string);
        Recordset recordset = null;
        try {
            recordset = table.query(table.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
            while (recordset.next()) {
                CompletedTaskRecordImpl completedTaskRecordImpl = new CompletedTaskRecordImpl();
                completedTaskRecordImpl.id = recordset.getInt(colNames[0]);
                completedTaskRecordImpl.completedRecordID = recordset.getString(colNames[1]);
                completedTaskRecordImpl.taskID = recordset.getString(colNames[2]);
                completedTaskRecordImpl.taskClass = recordset.getString(colNames[3]);
                completedTaskRecordImpl.catalogFile = recordset.getString(colNames[4]);
                completedTaskRecordImpl.reportFile = recordset.getString(colNames[5]);
                completedTaskRecordImpl.paramFile = recordset.getString(colNames[6]);
                completedTaskRecordImpl.results = recordset.getString(colNames[7]);
                completedTaskRecordImpl.errorMessage = recordset.getString(colNames[8]);
                completedTaskRecordImpl.engineStatus = recordset.getString(colNames[9]);
                completedTaskRecordImpl.submitter = recordset.getString(colNames[10]);
                completedTaskRecordImpl.completedTime = new Date(recordset.getLong(colNames[11]));
                completedTaskRecordImpl.formatExists = recordset.getLong(colNames[12]);
                completedTaskRecordImpl.formatSuccessful = recordset.getLong(colNames[13]);
                completedTaskRecordImpl.versionID = recordset.getInt(colNames[14]);
                completedTaskRecordImpl.launchType = recordset.getInt(colNames[15]);
                completedTaskRecordImpl.successful = recordset.getBoolean(colNames[16]);
                if (string.equalsIgnoreCase(BIT)) {
                    completedTaskRecordImpl.taskName = recordset.getString(colNames[17]);
                }
                vector.addElement(completedTaskRecordImpl);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    @Override
    public CompletedTaskRecord getCompletedTaskRecord(String string) throws RemoteException {
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        this.Z.delete(0, this.Z.length());
        try {
            parameterMetaInfo.add(this.fields(colNames[1]).getName(), string, 12);
            this.Z.append(" WHERE ").append(this.fields(colNames[1]).getName()).append("=?");
            List list = this.BIGINT(this.Z.toString(), parameterMetaInfo, true);
            if (list.size() > 0) {
                return (CompletedTaskRecord)list.remove(0);
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        return null;
    }

    public CompletedTaskRecord getCompletedTaskRecordById(int n) throws RemoteException {
        this.Z.delete(0, this.Z.length());
        ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
        try {
            parameterMetaInfo.add(this.fields(colNames[0]).getName(), String.valueOf(n), 4);
            this.Z.append(" WHERE ").append(this.fields(colNames[0]).getName()).append("=?");
            List list = this.BIGINT(this.Z.toString(), parameterMetaInfo, true);
            if (list.size() > 0) {
                return (CompletedTaskRecord)list.remove(0);
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException("", sQLException);
        }
        return null;
    }

    @Override
    public boolean removeCompletedTaskRecord(String string) throws RemoteException {
        return this.removeRecord(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllCompletedTaskRecord() throws RemoteException {
        boolean bl = true;
        Vector vector = this.getAllCompletedTaskRecordsVector();
        try {
            this.add.deleteAllRecords();
            int n = super.delete(null, ParameterMetaInfo.EMPTY);
            bl = n > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            bl = false;
        }
        while (vector.size() > 0) {
            CompletedTaskRecordImpl completedTaskRecordImpl = (CompletedTaskRecordImpl)vector.remove(0);
            this.EMPTY(completedTaskRecordImpl);
        }
        Integer n = this.J;
        synchronized (n) {
            this.J = 0;
        }
        return bl;
    }

    private List BIGINT(String string, ParameterMetaInfo parameterMetaInfo, boolean bl) throws SQLException, RemoteException {
        ArrayList<CompletedTaskRecordImpl> arrayList = new ArrayList<CompletedTaskRecordImpl>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), string, parameterMetaInfo, false);
            while (recordset.next()) {
                CompletedTaskRecordImpl completedTaskRecordImpl = new CompletedTaskRecordImpl();
                completedTaskRecordImpl.id = recordset.getInt(colNames[0]);
                completedTaskRecordImpl.completedRecordID = recordset.getString(colNames[1]);
                completedTaskRecordImpl.taskID = recordset.getString(colNames[2]);
                completedTaskRecordImpl.taskClass = recordset.getString(colNames[3]);
                completedTaskRecordImpl.catalogFile = recordset.getString(colNames[4]);
                completedTaskRecordImpl.reportFile = recordset.getString(colNames[5]);
                completedTaskRecordImpl.paramFile = recordset.getString(colNames[6]);
                completedTaskRecordImpl.results = recordset.getString(colNames[7]);
                completedTaskRecordImpl.errorMessage = recordset.getString(colNames[8]);
                completedTaskRecordImpl.engineStatus = recordset.getString(colNames[9]);
                completedTaskRecordImpl.submitter = recordset.getString(colNames[10]);
                completedTaskRecordImpl.completedTime = new Date(recordset.getLong(colNames[11]));
                completedTaskRecordImpl.formatExists = recordset.getLong(colNames[12]);
                completedTaskRecordImpl.formatSuccessful = recordset.getLong(colNames[13]);
                completedTaskRecordImpl.versionID = recordset.getInt(colNames[14]);
                completedTaskRecordImpl.launchType = recordset.getInt(colNames[15]);
                completedTaskRecordImpl.successful = recordset.getBoolean(colNames[16]);
                completedTaskRecordImpl.taskName = recordset.getString(colNames[17]);
                completedTaskRecordImpl.missed = recordset.getBoolean(colNames[18]);
                completedTaskRecordImpl.trigger = recordset.getString(colNames[19]);
                completedTaskRecordImpl.logic = recordset.getString(colNames[20]);
                completedTaskRecordImpl.rptNames = recordset.getString(colNames[21]);
                if (bl) {
                    completedTaskRecordImpl.publishRecords = this.add.getRecordsByRecordID(completedTaskRecordImpl.completedRecordID);
                }
                arrayList.add(completedTaskRecordImpl);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            throw sQLException;
        }
        finally {
            if (recordset != null) {
                recordset.close();
            }
        }
        return arrayList;
    }

    private List BIT(String string, boolean bl) throws SQLException, RemoteException {
        ArrayList<CompletedTaskRecordImpl> arrayList = new ArrayList<CompletedTaskRecordImpl>();
        Recordset recordset = null;
        try {
            recordset = super.query(this.fields().toArray(), string, ParameterMetaInfo.EMPTY, false);
            while (recordset.next()) {
                CompletedTaskRecordImpl completedTaskRecordImpl = new CompletedTaskRecordImpl();
                completedTaskRecordImpl.id = recordset.getInt(colNames[0]);
                completedTaskRecordImpl.completedRecordID = recordset.getString(colNames[1]);
                completedTaskRecordImpl.taskID = recordset.getString(colNames[2]);
                completedTaskRecordImpl.taskClass = recordset.getString(colNames[3]);
                completedTaskRecordImpl.catalogFile = recordset.getString(colNames[4]);
                completedTaskRecordImpl.reportFile = recordset.getString(colNames[5]);
                completedTaskRecordImpl.paramFile = recordset.getString(colNames[6]);
                completedTaskRecordImpl.results = recordset.getString(colNames[7]);
                completedTaskRecordImpl.errorMessage = recordset.getString(colNames[8]);
                completedTaskRecordImpl.engineStatus = recordset.getString(colNames[9]);
                completedTaskRecordImpl.submitter = recordset.getString(colNames[10]);
                completedTaskRecordImpl.completedTime = new Date(recordset.getLong(colNames[11]));
                completedTaskRecordImpl.formatExists = recordset.getLong(colNames[12]);
                completedTaskRecordImpl.formatSuccessful = recordset.getLong(colNames[13]);
                completedTaskRecordImpl.versionID = recordset.getInt(colNames[14]);
                completedTaskRecordImpl.launchType = recordset.getInt(colNames[15]);
                completedTaskRecordImpl.successful = recordset.getBoolean(colNames[16]);
                completedTaskRecordImpl.taskName = recordset.getString(colNames[17]);
                completedTaskRecordImpl.missed = recordset.getBoolean(colNames[18]);
                completedTaskRecordImpl.trigger = recordset.getString(colNames[19]);
                completedTaskRecordImpl.logic = recordset.getString(colNames[20]);
                completedTaskRecordImpl.rptNames = recordset.getString(colNames[21]);
                if (bl) {
                    completedTaskRecordImpl.publishRecords = this.add.getRecordsByRecordID(completedTaskRecordImpl.completedRecordID);
                }
                arrayList.add(completedTaskRecordImpl);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            throw sQLException;
        }
        finally {
            if (recordset != null) {
                recordset.close();
            }
        }
        return arrayList;
    }

    private void EMPTY(CompletedTaskRecordImpl completedTaskRecordImpl) {
        if (completedTaskRecordImpl != null && ParameterFileManager.getInstance() != null) {
            try {
                if (completedTaskRecordImpl.getParamFile().length() > 0) {
                    ParameterFileManager.getInstance().delete(completedTaskRecordImpl.getParamFile());
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    public void clearMem() {
        this.SEDU = null;
    }

    private synchronized int INTEGER() {
        Number number = null;
        try {
            number = super.queryMaxValue(colNames[0], null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number == null ? -1 : number.intValue();
    }

    private synchronized int J() {
        try {
            return this.adapter.getID(this, this.fields(colNames[0]));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return 0;
        }
    }

    @Override
    public void commit() throws RemoteException {
    }

    public void setHistoryDir(String string) {
        this.VARCHAR = string;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.SEDU = schedulingService;
    }

    @Override
    public void close() {
        if (this.add != null) {
            this.add.close();
            this.add = null;
        }
        super.close();
    }
}

