/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import jet.server.db.AbstractDataTable;
import jet.server.db.VersionLimitRecord;
import jet.server.db.VersionLimitRecordImpl;
import jet.server.db.VersionLimitTable;
import jet.server.db.VersionTableImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.log.ServiceLogger;

public class VersionLimitTableImpl
extends AbstractDataTable
implements VersionLimitTable {
    public static final int version = 1;
    public static final String TABLE_PREFIX = "VERLIMIT";
    private static final String SEDU = " id\t\t\t\tINTEGER NOT NULL IDENTITY, RecordId\t\t\tINTEGER NOT NULL, MaxAmount\t\t\tINTEGER NOT NULL, CatFile           VARCHAR(256), RptFile           VARCHAR(256), Submitter\t\t\tVARCHAR(128), UNIQUE(id,RecordId)";
    private static final String add = " (RecordId,MaxAmount,CatFile,RptFile,Submitter) VALUES(?,?,?,?,?);";
    private String addRecord = null;
    private PreparedStatement adjustAmount = null;
    private static VersionLimitTableImpl append = null;

    public static VersionLimitTableImpl newInstance(String string, String string2, String string3, String string4) throws RemoteException {
        if (append == null) {
            append = new VersionLimitTableImpl(string, string2, string3, string4);
        }
        return append;
    }

    public static VersionLimitTable getVersionLimitTable() {
        return append;
    }

    private VersionLimitTableImpl(String string, String string2, String string3, String string4) throws RemoteException {
        super(string, string2, string3);
        this.addRecord = super.makeTableName(TABLE_PREFIX, string4, 1);
        if (!super.isValidTable(this.addRecord)) {
            super.createTable(this.addRecord, SEDU);
        }
        try {
            this.adjustAmount = this.conn.prepareStatement("INSERT INTO " + this.addRecord + add);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedConstructor", exception);
        }
    }

    public String getTableName() {
        return this.addRecord;
    }

    @Override
    public void close() {
        try {
            append = null;
            this.adjustAmount.close();
            super.close();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    @Override
    public int getMaxAmount(String string, String string2, String string3) throws RemoteException {
        VersionLimitRecord versionLimitRecord = this.getRecord(string, string2, string3);
        return versionLimitRecord.getMaxAmount();
    }

    @Override
    public void setMaxAmount(String string, String string2, String string3, int n) throws RemoteException {
        int n2 = VersionLimitRecordImpl.makeRecordId(string, string2, string3);
        try {
            if (this.getRecord(n2) == null) {
                this.addRecord(string, string2, n, string3);
            } else {
                this.SEDU(n2, n);
            }
        }
        catch (Exception exception) {
            throw new RemoteException("FailedUpdateRecord", exception);
        }
        super.checkDoCommit(true);
        VersionTableImpl versionTableImpl = (VersionTableImpl)VersionTableImpl.getVersionTable();
        versionTableImpl.adjustAmount(string, string2, string3, n);
    }

    @Override
    public VersionLimitRecord addRecord(String string, String string2, int n, String string3) throws RemoteException {
        VersionLimitRecordImpl versionLimitRecordImpl = new VersionLimitRecordImpl(string, string2, string3, n);
        try {
            this.add(versionLimitRecordImpl);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedInsertRecord", exception);
        }
        super.checkDoCommit(true);
        return versionLimitRecordImpl;
    }

    @Override
    public void delRecord(String string, String string2, String string3) throws RemoteException {
        int n = VersionLimitRecordImpl.makeRecordId(string, string2, string3);
        this.delRecord(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delRecord(int n) throws RemoteException {
        Statement statement = this.stmt;
        synchronized (statement) {
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append(" RecordId=?");
            super.delRecord(this.addRecord, this.sqlbuf.toString(), new ParameterMetaInfo().add("recordId", n), true);
        }
    }

    @Override
    public VersionLimitRecord getRecord(String string, String string2, String string3) throws RemoteException {
        VersionLimitRecord versionLimitRecord = null;
        int n = VersionLimitRecordImpl.makeRecordId(string, string2, string3);
        versionLimitRecord = this.getRecord(n);
        if (versionLimitRecord == null) {
            versionLimitRecord = this.addRecord(string, string2, 0, string3);
        }
        return versionLimitRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionLimitRecord getRecord(int n) throws RemoteException {
        VersionLimitRecordImpl versionLimitRecordImpl = null;
        ResultSet resultSet = null;
        Statement statement = this.stmt;
        synchronized (statement) {
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append("SELECT * FROM ").append(this.addRecord);
            this.sqlbuf.append(" WHERE RecordId=").append(n);
            try {
                resultSet = this.stmt.executeQuery(this.sqlbuf.substring(0));
                if (resultSet.next()) {
                    versionLimitRecordImpl = this.addRecord(resultSet);
                }
            }
            catch (Exception exception) {
                throw new RemoteException("FailedSelectRecord", exception);
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
            }
        }
        return versionLimitRecordImpl;
    }

    @Override
    public Vector getAllRecords() throws RemoteException {
        Statement statement = this.stmt;
        synchronized (statement) {
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append("SELECT * FROM ").append(this.addRecord);
            try {
                return this.adjustAmount(this.sqlbuf.substring(0));
            }
            catch (Exception exception) {
                throw new RemoteException("FailedSelectRecord", exception);
            }
        }
    }

    public void insertRecord(VersionLimitRecordImpl versionLimitRecordImpl) throws RemoteException {
        try {
            this.add(versionLimitRecordImpl);
        }
        catch (Exception exception) {
            throw new RemoteException("FailedInsertRecord", exception);
        }
        super.checkDoCommit(false);
    }

    @Override
    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU(int n, int n2) throws SQLException {
        Statement statement = this.stmt;
        synchronized (statement) {
            this.sqlbuf.delete(0, this.sqlbuf.length());
            this.sqlbuf.append("UPDATE ").append(this.addRecord).append(" SET MaxAmount=");
            this.sqlbuf.append(n2).append(" WHERE RecordId=").append(n);
            this.stmt.execute(this.sqlbuf.substring(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(VersionLimitRecordImpl versionLimitRecordImpl) throws SQLException {
        PreparedStatement preparedStatement = this.adjustAmount;
        synchronized (preparedStatement) {
            this.adjustAmount.setInt(1, versionLimitRecordImpl.recordId);
            this.adjustAmount.setInt(2, versionLimitRecordImpl.maxAmount);
            this.adjustAmount.setString(3, versionLimitRecordImpl.catalogFile);
            this.adjustAmount.setString(4, versionLimitRecordImpl.reportFile);
            this.adjustAmount.setString(5, versionLimitRecordImpl.submitter);
            this.adjustAmount.executeUpdate();
        }
    }

    private VersionLimitRecordImpl addRecord(ResultSet resultSet) throws SQLException {
        VersionLimitRecordImpl versionLimitRecordImpl = new VersionLimitRecordImpl();
        versionLimitRecordImpl.id = resultSet.getInt("id");
        versionLimitRecordImpl.recordId = resultSet.getInt("RecordId");
        versionLimitRecordImpl.maxAmount = resultSet.getInt("MaxAmount");
        versionLimitRecordImpl.catalogFile = resultSet.getString("CatFile");
        versionLimitRecordImpl.reportFile = resultSet.getString("RptFile");
        versionLimitRecordImpl.submitter = resultSet.getString("Submitter");
        return versionLimitRecordImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector adjustAmount(String string) throws SQLException {
        Vector<VersionLimitRecordImpl> vector = new Vector<VersionLimitRecordImpl>();
        Statement statement = this.stmt;
        synchronized (statement) {
            ResultSet resultSet = this.stmt.executeQuery(string);
            while (resultSet.next()) {
                vector.add(this.addRecord(resultSet));
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return vector;
    }
}

