/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbInteger;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;

public class VersionRecord
implements Serializable {
    public static final int VERSION_ID_COL = 1;
    public static final int CATFILE_COL = 2;
    public static final int RPTFILE_COL = 3;
    public static final int PARAMFILE_COL = 4;
    public static final int RESULTFILE_COL = 5;
    public static final int CREATEDATE_COL = 6;
    public static final int SUBMITUSER_COL = 7;
    public static final int EXPIRE_COL = 8;
    public static final int EXPIREDATE_COL = 9;
    public static final int VERSION_NAME = 10;
    public static final int LAUNCH_TYPE = 11;
    public static final int TASK_ID = 12;
    public static final int RESULT_FORMATS = 13;
    DbValue[] values = null;

    public VersionRecord(DbValue[] dbValueArray) {
        this.values = new DbValue[dbValueArray.length];
        for (int i = 0; i < dbValueArray.length; ++i) {
            this.values[i] = (DbValue)dbValueArray[i].clone();
        }
    }

    public VersionRecord() {
    }

    public DbValue[] getValues() throws SQLException {
        return this.values;
    }

    public int getVersionId() throws SQLException {
        return ((DbInteger)this.values[1]).get();
    }

    public String getCatFile() throws SQLException {
        return ((DbChar)this.values[2]).get();
    }

    public String getReportFile() throws SQLException {
        return ((DbChar)this.values[3]).get();
    }

    public String getParamFile() throws SQLException {
        if (this.values[4].isNull()) {
            return null;
        }
        return ((DbChar)this.values[4]).get();
    }

    public String getResultFile() throws SQLException {
        return ((DbChar)this.values[5]).get();
    }

    public long getResultFormats() throws SQLException {
        return this.values[13].isNull() ? 0L : ((DbBigInt)this.values[13]).get();
    }

    public Date getGenerateTime() throws SQLException {
        return ((DbTimestamp)this.values[6]).toUtilDate();
    }

    public String getSubmitUser() throws SQLException {
        return ((DbChar)this.values[7]).get();
    }

    public boolean getExpire() throws SQLException {
        return ((DbBit)this.values[8]).get();
    }

    public Date getExpirationTime() throws SQLException {
        if (this.values[9].isNull()) {
            return null;
        }
        return ((DbTimestamp)this.values[9]).toUtilDate();
    }

    public String getVersionName() throws SQLException {
        if (this.values[10].isNull()) {
            return null;
        }
        return ((DbChar)this.values[10]).get();
    }

    public int getLaunchType() throws SQLException {
        return ((DbInteger)this.values[11]).get();
    }

    public String getTaskId() throws SQLException {
        if (this.values[12].isNull()) {
            return null;
        }
        return ((DbChar)this.values[12]).get();
    }

    public synchronized void setRecord(int n, String string, String string2, String string3, String string4, long l, Date date, String string5, boolean bl, Date date2, String string6, int n2, String string7) throws SQLException {
        ((DbInteger)this.values[1]).set(n);
        if (string != null) {
            ((DbChar)this.values[2]).set(string);
        } else {
            ((DbChar)this.values[2]).setNull();
        }
        if (string2 != null) {
            ((DbChar)this.values[3]).set(string2);
        } else {
            ((DbChar)this.values[3]).setNull();
        }
        if (string3 != null) {
            ((DbChar)this.values[4]).set(string3);
        } else {
            ((DbChar)this.values[4]).setNull();
        }
        if (string4 != null) {
            ((DbChar)this.values[5]).set(string4);
        } else {
            ((DbChar)this.values[5]).setNull();
        }
        ((DbBigInt)this.values[13]).set(l);
        if (date != null) {
            ((DbTimestamp)this.values[6]).set(date.getTime());
        } else {
            ((DbTimestamp)this.values[6]).setNull();
        }
        if (date != null) {
            ((DbChar)this.values[7]).set(string5);
        } else {
            ((DbChar)this.values[7]).setNull();
        }
        ((DbBit)this.values[8]).set(bl);
        if (date2 != null) {
            ((DbTimestamp)this.values[9]).set(date2.getTime());
        } else {
            ((DbTimestamp)this.values[9]).setNull();
        }
        if (string6 != null) {
            ((DbChar)this.values[10]).set(string6);
        } else {
            ((DbChar)this.values[10]).setNull();
        }
        ((DbInteger)this.values[11]).set(n2);
        if (string7 != null) {
            ((DbChar)this.values[12]).set(string7);
        } else {
            ((DbChar)this.values[12]).setNull();
        }
    }

    public boolean equalsTo(int n) throws SQLException {
        return n == this.getVersionId();
    }

    public String toString() {
        try {
            return "Version[" + String.valueOf(this.getVersionId()) + "] + //";
        }
        catch (SQLException sQLException) {
            return "Version[unknow]";
        }
    }

    public int compareWith(VersionRecord versionRecord) throws ClassCastException {
        try {
            Date date = this.getGenerateTime();
            Date date2 = versionRecord.getGenerateTime();
            if (date.equals(date2)) {
                return 0;
            }
            if (date.before(date2)) {
                return -1;
            }
            return 1;
        }
        catch (Exception exception) {
            ClassCastException classCastException = new ClassCastException("Can't compare VersionRecord with SQLException!");
            throw classCastException;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.values = new DbValue[objectInputStream.readInt()];
        this.values[0] = new DbBit(objectInputStream.readBoolean());
        this.values[1] = new DbInteger(objectInputStream.readInt());
        this.values[2] = new DbChar((String)objectInputStream.readObject());
        this.values[3] = new DbChar((String)objectInputStream.readObject());
        this.values[4] = new DbChar((String)objectInputStream.readObject());
        this.values[5] = new DbChar((String)objectInputStream.readObject());
        this.values[6] = new DbTimestamp(new Timestamp(objectInputStream.readLong()));
        this.values[7] = new DbChar((String)objectInputStream.readObject());
        this.values[8] = new DbBit(objectInputStream.readBoolean());
        this.values[9] = new DbTimestamp(new Timestamp(objectInputStream.readLong()));
        this.values[10] = new DbChar((String)objectInputStream.readObject());
        this.values[11] = new DbInteger(objectInputStream.readInt());
        this.values[12] = new DbChar((String)objectInputStream.readObject());
        this.values[13] = new DbBigInt(objectInputStream.readLong());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.values.length);
        objectOutputStream.writeBoolean(((DbBit)this.values[0]).get());
        objectOutputStream.writeInt(((DbInteger)this.values[1]).get());
        objectOutputStream.writeObject(((DbChar)this.values[2]).get());
        objectOutputStream.writeObject(((DbChar)this.values[3]).get());
        if (this.values[4].isNull()) {
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeObject(((DbChar)this.values[4]).get());
        }
        objectOutputStream.writeObject(((DbChar)this.values[5]).get());
        objectOutputStream.writeLong(((DbTimestamp)this.values[6]).get());
        objectOutputStream.writeObject(((DbChar)this.values[7]).get());
        objectOutputStream.writeBoolean(((DbBit)this.values[8]).get());
        objectOutputStream.writeLong(((DbTimestamp)this.values[9]).get());
        objectOutputStream.writeObject(((DbChar)this.values[10]).get());
        objectOutputStream.writeInt(((DbInteger)this.values[11]).get());
        objectOutputStream.writeObject(((DbChar)this.values[12]).get());
        if (this.values[13].isNull()) {
            objectOutputStream.writeLong(0L);
        } else {
            objectOutputStream.writeLong(((DbBigInt)this.values[13]).get());
        }
    }
}

