/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.adapter;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import jet.server.db.Connector;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.adapter.DBDB2db;
import jet.server.db.adapter.DBDerbydb;
import jet.server.db.adapter.DBHsqldb;
import jet.server.db.adapter.DBInformixdb;
import jet.server.db.adapter.DBMysqldb;
import jet.server.db.adapter.DBOracledb;
import jet.server.db.adapter.DBSQLServerdb;
import jet.server.db.adapter.DBSybasedb;
import jet.server.log.ServiceLogger;

public final class DBFactory {
    private static Map SEDU = new HashMap(16);
    private static Map append = new HashMap(16);
    private static Map close;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBAdapter create(Connector connector) throws InstantiationException {
        int n;
        Object object;
        DBAdapter dBAdapter = null;
        Class clazz = null;
        String string = connector.getProperty("dbtype");
        String string2 = connector.getProperty("driver");
        if (string != null) {
            clazz = (Class)append.get(string);
        } else if (string2 != null) {
            string = string2;
            clazz = (Class)SEDU.get(string2);
            if (clazz == null) {
                object = string.toLowerCase();
                for (String string3 : close.keySet()) {
                    n = ((String)object).indexOf(string3);
                    if (n == -1) continue;
                    clazz = (Class)close.get(string3);
                    break;
                }
            }
        }
        if (clazz == null) {
            object = null;
            try {
                object = connector.getConnection();
                string = object.getMetaData().getDatabaseProductName();
                clazz = (Class)append.get(string);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            finally {
                if (object != null) {
                    try {
                        if (!object.getAutoCommit()) {
                            object.commit();
                        }
                        object.close();
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException, 3);
                    }
                }
            }
        }
        if (clazz == null) {
            object = string.toLowerCase();
            for (String string3 : close.keySet()) {
                n = ((String)object).indexOf(string3);
                if (n == -1) continue;
                clazz = (Class)close.get(string3);
                break;
            }
        }
        if (clazz != null) {
            try {
                dBAdapter = (DBAdapter)clazz.newInstance();
                dBAdapter.setConnector(connector);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InstantiationException("Could not instance adapter for " + string);
            }
        } else {
            throw new InstantiationException("Unsupported: " + string);
        }
        return dBAdapter;
    }

    public static String[] getAllSupportDrivers() {
        String[] stringArray = new String[SEDU.size()];
        SEDU.keySet().toArray(stringArray);
        return stringArray;
    }

    public static String[] getAllSupportDBTypes() {
        String[] stringArray = new String[append.size()];
        append.keySet().toArray(stringArray);
        return stringArray;
    }

    static {
        append.put("IBM DB2", DBDB2db.class);
        append.put("Oracle", DBOracledb.class);
        append.put("Informix", DBInformixdb.class);
        append.put("Sybase", DBSybasedb.class);
        append.put("Microsoft SQL Server", DBSQLServerdb.class);
        append.put("MySQL", DBMysqldb.class);
        append.put("HSQL Database Engine", DBHsqldb.class);
        append.put("Apache Derby", DBDerbydb.class);
        close = new HashMap(16);
        close.put("hsql", DBHsqldb.class);
        close.put("microsoft", DBSQLServerdb.class);
        close.put("db2", DBDB2db.class);
        close.put("oracle", DBOracledb.class);
        close.put("informix", DBInformixdb.class);
        close.put("sybase", DBSybasedb.class);
        close.put("mysql", DBMysqldb.class);
        close.put("Derby", DBDerbydb.class);
        SEDU.put("org.hsqldb.jdbcDriver", DBHsqldb.class);
        SEDU.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", DBSQLServerdb.class);
        SEDU.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", DBSQLServerdb.class);
        SEDU.put("COM.ibm.db2.jdbc.net.DB2Driver", DBDB2db.class);
        SEDU.put("COM.ibm.db2.jdbc.app.DB2Driver", DBDB2db.class);
        SEDU.put("com.ibm.db2.jcc.DB2Driver", DBDB2db.class);
        SEDU.put("oracle.jdbc.driver.OracleDriver", DBOracledb.class);
        SEDU.put("com.mysql.jdbc.Driver", DBMysqldb.class);
        SEDU.put("org.gjt.mm.mysql.Driver", DBMysqldb.class);
        SEDU.put("com.sybase.jdbc2.jdbc.SybDriver", DBSybasedb.class);
        SEDU.put("com.informix.jdbc.IfxDriver", DBInformixdb.class);
        SEDU.put("org.apache.derby.jdbc.ClientDriver", DBDerbydb.class);
    }
}

