/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.adapter;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.api.db.Unique;
import jet.server.db.adapter.DB;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.UniqueImpl;
import jet.server.log.ServiceLogger;

public final class DBOdbc
extends DB
implements DBAdapter {
    @Override
    public String getDdlSQL(Table table) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ").append(table.getName()).append("(");
        Field[] fieldArray = table.fields().toArray();
        int n2 = fieldArray.length;
        for (int i = 0; i < n2; ++i) {
            Field field = fieldArray[i];
            stringBuffer.append(field.getName());
            JDBCType jDBCType = field.getJDBCType();
            stringBuffer.append(" ").append(jDBCType.typeName());
            if (jDBCType.isVariationalSize()) {
                if (jDBCType.dataType() == 12) {
                    n = field.getSize();
                    stringBuffer.append("(").append(n > 255 ? 255 : n).append(")");
                } else {
                    stringBuffer.append("(").append(field.getSize()).append(")");
                }
            }
            if (field.isNotNull()) {
                stringBuffer.append(" NOT NULL");
            }
            if (field.isPrimaryKey()) {
                stringBuffer.append(" PRIMARY KEY");
            }
            if (field.isIdentity()) {
                try {
                    this.idGen.createIdentity(table, field);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
            }
            if (i < n2 - 1) {
                stringBuffer.append(",");
            }
            if (!field.isUnique()) continue;
            Unique unique = table.uniques("UNQ_UNFORMED");
            if (unique == null) {
                unique = new UniqueImpl(table, "UNQ_UNFORMED");
                ((TableImpl)table).append(unique);
            }
            unique.append(field);
        }
        Unique[] uniqueArray = table.uniques().toArray();
        n2 = uniqueArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = uniqueArray[i].fields().size();
            for (n = 0; n < n3; ++n) {
                if (n == 0) {
                    stringBuffer.append(",");
                    stringBuffer.append(" CONSTRAINT ").append(uniqueArray[i].getName());
                    stringBuffer.append(" UNIQUE(");
                }
                stringBuffer.append(uniqueArray[i].fields(n).getName());
                if (n >= n3 - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            if (i >= n2 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean dropTable(Table table) throws SQLException {
        this.idGen.deleteIdentity(table, null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP TABLE ").append(table.getName());
        return super.execute(stringBuffer.substring(0));
    }

    @Override
    public Recordset select(Field[] fieldArray, Table[] tableArray, String string, ParameterMetaInfo parameterMetaInfo, boolean bl, int n, int n2) throws SQLException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(bl ? "DISTINCT " : "");
        int n4 = fieldArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            Field field = fieldArray[n3];
            switch (field.getCalculating()) {
                case 0: {
                    stringBuffer.append(field.getFullyQualifiedName());
                    break;
                }
                case 1: {
                    stringBuffer.append("COUNT(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 2: {
                    stringBuffer.append("SUM(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 3: {
                    stringBuffer.append("AVG(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 5: {
                    stringBuffer.append("MIN(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 4: {
                    stringBuffer.append("MAX(").append(field.getFullyQualifiedName()).append(")");
                }
            }
            if (!field.getDispName().equals(field.getName())) {
                stringBuffer.append(" AS ").append(field.getDispName());
            }
            if (n3 >= n4 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM ");
        n4 = tableArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append(tableArray[n3].getName());
            if (n3 >= n4 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(this.sqlWhere(string));
        return super.executeQuery(fieldArray, stringBuffer.toString(), parameterMetaInfo, n, n2);
    }

    @Override
    protected String valueToString(StringBuffer stringBuffer, Table table, FieldValue fieldValue) {
        int n = stringBuffer.length();
        JDBCType jDBCType = fieldValue.getJDBCType();
        Object object = fieldValue.getValue();
        if (fieldValue.isIdentity()) {
            if (object == null) {
                int n2 = 0;
                try {
                    n2 = this.getID(table, table.fields(fieldValue.getName()));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                stringBuffer.append(n2);
            } else {
                stringBuffer.append(object);
            }
        } else {
            switch (jDBCType.dataType()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stringBuffer.append(object == null ? "0" : object);
                    break;
                }
                case 91: {
                    stringBuffer.append(this.formatValue((Date)object));
                    break;
                }
                case 92: {
                    stringBuffer.append(this.formatValue((Time)object));
                    break;
                }
                case 93: {
                    stringBuffer.append(this.formatValue((Timestamp)object));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String string = (String)object;
                    if (string != null && string.length() > 255) {
                        stringBuffer.append(this.formatValue(string.substring(0, 254)));
                        break;
                    }
                    stringBuffer.append(this.formatValue(string));
                    break;
                }
                case -7: 
                case 16: {
                    stringBuffer.append(this.formatValue((Boolean)object));
                    break;
                }
                default: {
                    stringBuffer.append("'").append(object).append("'");
                }
            }
        }
        return stringBuffer.substring(n);
    }
}

