/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.adapter;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.adapter.DB;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.core.ParameterMetaInfo;

public final class DBOracledb
extends DB
implements DBAdapter {
    @Override
    public String getDefaultSchema(String string, Connection connection) {
        String string2 = super.getDefaultSchema(string, connection);
        return string2;
    }

    @Override
    public String getDdlSQL(Table table) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ").append(table.getName());
        Field[] fieldArray = table.fields().toArray();
        String string = this.SEDU(fieldArray);
        if (string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        stringBuffer.append("(").append(string).append(")");
        String string2 = table.getProperty("tablespace");
        if (string2 != null) {
            stringBuffer.append(" TABLESPACE " + string2);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean dropTable(Table table) throws SQLException {
        if (this.idGen != null) {
            this.idGen.deleteIdentity(table, null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP TABLE ").append(table.getName());
        return super.execute(stringBuffer.substring(0));
    }

    @Override
    public Recordset select(Field[] fieldArray, Table[] tableArray, String string, ParameterMetaInfo parameterMetaInfo, boolean bl, int n, int n2) throws SQLException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(bl ? "DISTINCT " : "");
        int n4 = fieldArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            Field field = fieldArray[n3];
            switch (field.getCalculating()) {
                case 0: {
                    stringBuffer.append(field.getFullyQualifiedName());
                    break;
                }
                case 1: {
                    stringBuffer.append("COUNT(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 2: {
                    stringBuffer.append("SUM(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 3: {
                    stringBuffer.append("AVG(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 5: {
                    stringBuffer.append("MIN(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 4: {
                    stringBuffer.append("MAX(").append(field.getFullyQualifiedName()).append(")");
                }
            }
            if (!field.getDispName().equals(field.getName())) {
                stringBuffer.append(" AS ").append(field.getDispName());
            }
            if (n3 >= n4 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM ");
        n4 = tableArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append(tableArray[n3].getName());
            if (n3 >= n4 - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(this.sqlWhere(string));
        return super.executeQuery(fieldArray, stringBuffer.toString(), parameterMetaInfo, n, n2);
    }

    @Override
    public String formatValue(String string) {
        if (string == null) {
            return "NULL";
        }
        if (string.trim().length() == 0) {
            return "' '";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n = 0;
        int n2 = -1;
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append("'");
        while ((n2 = string.indexOf("'", n)) != -1) {
            stringBuffer.append(string.substring(n, n2 == 0 ? 0 : n2)).append("''");
            n = n2 + 1;
        }
        stringBuffer.append(string.substring(n)).append("'");
        string2 = stringBuffer.substring(0);
        return string2;
    }

    @Override
    protected String valueToString(StringBuffer stringBuffer, Table table, FieldValue fieldValue) {
        int n = stringBuffer.length();
        JDBCType jDBCType = fieldValue.getJDBCType();
        Object object = fieldValue.getValue();
        if (fieldValue.isIdentity()) {
            if (object == null) {
                int n2 = 0;
                try {
                    n2 = this.getID(table, table.fields(fieldValue.getName()));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                stringBuffer.append(n2);
            } else {
                stringBuffer.append(object);
            }
        } else {
            switch (jDBCType.dataType()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stringBuffer.append(object == null ? "0" : object);
                    break;
                }
                case 91: {
                    stringBuffer.append(this.formatValue((Date)object));
                    break;
                }
                case 92: {
                    stringBuffer.append(this.formatValue((Time)object));
                    break;
                }
                case 93: {
                    stringBuffer.append(this.formatValue((Timestamp)object));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    stringBuffer.append(this.formatValue((String)object));
                    break;
                }
                case -7: 
                case 16: {
                    stringBuffer.append(this.formatValue((Boolean)object));
                    break;
                }
                default: {
                    stringBuffer.append("'").append(object).append("'");
                }
            }
        }
        return stringBuffer.substring(n);
    }

    private String SEDU(Field[] fieldArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        for (n = 0; n < fieldArray.length; ++n) {
            Field field = fieldArray[n];
            stringBuffer.append(field.getName());
            JDBCType jDBCType = field.getJDBCType();
            switch (jDBCType.dataType()) {
                case -7: 
                case 16: {
                    stringBuffer.append(" NUMBER(1)");
                    break;
                }
                case -6: {
                    stringBuffer.append(" NUMBER(3)");
                    break;
                }
                case 5: {
                    stringBuffer.append("  NUMBER(5)");
                    break;
                }
                case 4: {
                    stringBuffer.append("  NUMBER(10)");
                    break;
                }
                case -5: {
                    stringBuffer.append("  NUMBER(19)");
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    stringBuffer.append(" FLOAT");
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    stringBuffer.append(" DATE");
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    int n2 = field.getSize();
                    if (n2 < 1) {
                        n2 = 1;
                    }
                    if (n2 > 4000) {
                        n2 = 4000;
                    }
                    stringBuffer.append(" VARCHAR(").append(n2).append(")");
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    stringBuffer.append(" BLOB");
                    break;
                }
                case 2005: {
                    stringBuffer.append(" CLOB");
                    break;
                }
                case 0: 
                case 70: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2006: {
                    break;
                }
                default: {
                    stringBuffer.append(" ").append(jDBCType.typeName());
                }
            }
            if (field.isNotNull()) {
                stringBuffer.append(" NOT NULL");
            }
            if (field.isPrimaryKey()) {
                vector.add(field.getName());
            }
            stringBuffer.append(",");
            if (!field.isUnique()) continue;
            vector2.add(field.getName());
        }
        if (vector2.size() != 0 && vector2.equals(vector)) {
            vector2 = new Vector();
        }
        if (vector.size() != 0) {
            for (n = 0; n < vector.size(); ++n) {
                string2 = string2 + (String)vector.elementAt(n) + ",";
            }
        }
        if (vector2.size() != 0) {
            for (n = 0; n < vector2.size(); ++n) {
                string3 = string3 + (String)vector2.elementAt(n) + ",";
            }
        }
        string2 = string2.trim();
        string3 = string3.trim();
        if (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith(",")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string2.trim().length() != 0) {
            stringBuffer.append(" PRIMARY KEY(").append(string2).append("),");
        }
        if (string3.length() != 0) {
            stringBuffer.append(" UNIQUE(").append(string3).append(")");
        }
        stringBuffer.append(this.getForeignKeyString(fieldArray));
        string = stringBuffer.toString();
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public Timestamp getCurrentTimestamp() throws SQLException {
        String string = "select SysDate from dual";
        Timestamp timestamp = super.queryDBTimestamp(string);
        return timestamp == null ? super.getCurrentTimestamp() : timestamp;
    }
}

