/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.ServerEnvBuilder;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Table;
import jet.server.api.db.Tables;
import jet.server.api.db.Workspace;
import jet.server.db.Connector;
import jet.server.db.adapter.DBFactory;
import jet.server.db.adapter.DBOracledb;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.ConnectorManager;
import jet.server.db.core.Dbs;
import jet.server.db.core.DualTable;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.IDGenerator;
import jet.server.db.core.IDGeneratorImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.TablesImpl;
import jet.server.db.core.TransferHelp;
import jet.server.db.core.trans.LockResourceTable;
import jet.server.db.core.trans.LockTable;
import jet.server.db.core.trans.TransExecutor;
import jet.server.db.core.trans.TransExecutorImpl;
import jet.server.db.version.LCVersionTableImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DatabaseImpl
extends AbstractDBObject
implements Database {
    private Workspace EMPTY;
    private TablesImpl LCTABLE_1 = new TablesImpl();
    private TablesImpl SEDU = new TablesImpl();
    private TablesImpl TABLE_NAME = new TablesImpl();
    private Connector add;
    private LockTable append;
    private TransExecutor appendProfileTable;
    private LockResourceTable appendSystemTable;
    private TransExecutor backup;
    private IDGeneratorImpl checkIntegrality;
    private boolean clear = false;
    private boolean close = false;
    private String command = null;
    private String contains = null;
    private int containsKey = 4;
    private static HashSet create = new HashSet();
    private static HashSet createTransExecutor;
    private static HashSet currentTimeMillis;
    private static HashSet cutdownTable;
    private TransferHelp decode;

    protected DatabaseImpl() {
    }

    public DatabaseImpl(Workspace workspace, String string) {
        super(string);
        this.EMPTY = workspace;
    }

    public HashSet getTables() {
        return create;
    }

    protected void buildFrom(Element element) {
        String[] stringArray;
        Object object;
        String string = element.getAttribute("name");
        super.setName(string);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        block3: for (int i = 0; i < n; ++i) {
            object = nodeList.item(i);
            switch (object.getNodeType()) {
                case 1: {
                    Object object2;
                    stringArray = (String[])object;
                    if ("driver".equalsIgnoreCase(stringArray.getTagName())) {
                        object2 = stringArray.getAttribute("classpath");
                        object2 = object2 == null ? "" : ((String)object2).trim();
                        this.info.setProperty("classpath", (String)object2);
                    }
                    String string2 = (object2 = stringArray.getFirstChild()) == null ? "" : object2.getNodeValue().trim();
                    this.info.setProperty(stringArray.getTagName().toLowerCase(), string2);
                    continue block3;
                }
            }
        }
        String string3 = this.getProperty("encrypt-sign");
        if (string3 != null && (stringArray = StringUtil.split((String)(object = ServerUtil.decode(string3)), "\r\n")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                int n2 = ((String)object).indexOf("=");
                if (n2 == -1) continue;
                String string4 = ((String)object).substring(0, n2);
                String string5 = ((String)object).substring(n2 + 1);
                this.setProperty(string4, string5);
            }
        }
    }

    @Override
    public Workspace getWorkspace() {
        return this.EMPTY;
    }

    public void setWorkspace(Workspace workspace) {
        this.EMPTY = workspace;
    }

    @Override
    public Tables tables() {
        return this.LCTABLE_1;
    }

    @Override
    public Tables Systemtables() {
        return this.SEDU;
    }

    @Override
    public Tables Realmtables() {
        TablesImpl tablesImpl = new TablesImpl();
        int n = this.LCTABLE_1.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)this.LCTABLE_1.get(i);
            if (!createTransExecutor.contains(table.getNameWithoutSchema().toUpperCase())) continue;
            tablesImpl.append(table);
        }
        return tablesImpl;
    }

    @Override
    public Tables ProfileTables() {
        return this.TABLE_NAME;
    }

    @Override
    public Table tables(int n) {
        return (Table)this.LCTABLE_1.get(n);
    }

    @Override
    public Table tables(String string) {
        return (Table)this.LCTABLE_1.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector getConnector() {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            if (this.add == null) {
                this.add = ConnectorManager.newInstance().getConnector(this.info);
                this.setProperties(this.add.getProperties());
            }
            return this.add;
        }
    }

    public void append(Table table) {
        this.LCTABLE_1.append(table);
    }

    public void appendProfileTable(Table table) {
        this.TABLE_NAME.append(table);
    }

    public void appendSystemTable(Table table) {
        this.SEDU.append(table);
    }

    public void remove(Table table) {
        if (table instanceof TableImpl) {
            ((TableImpl)table).close();
        }
        this.LCTABLE_1.remove(table.getName());
    }

    private boolean EMPTY() {
        String string;
        String string2 = this.getProperty("driver");
        if (!"org.apache.derby.jdbc.ClientDriver".equals(string2)) {
            return false;
        }
        String string3 = "jdbc:derby://";
        String string4 = this.getProperty("url");
        String string5 = string = string4.substring(string4.indexOf(string3) + string3.length(), string4.lastIndexOf("/"));
        if (string.indexOf(":") >= 0) {
            string5 = string.substring(0, string.indexOf(":"));
        }
        try {
            return ServerUtil.isLocalAddress(string5);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
            return false;
        }
    }

    private boolean LCTABLE_1() {
        boolean bl = false;
        try {
            String string = this.getProperty("driver");
            String string2 = this.getProperty("url");
            String string3 = this.getProperty("user");
            String string4 = this.getProperty("password");
            Class.forName(string);
            Connection connection = DriverManager.getConnection(string2, string3, string4);
            connection.close();
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLogger.logError(classNotFoundException);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    private boolean SEDU(int n) {
        boolean bl;
        block2: {
            bl = false;
            try {
                ServerSocket serverSocket = new ServerSocket(n);
                serverSocket.close();
            }
            catch (IOException iOException) {
                if (iOException.getMessage().indexOf("Address already in use: JVM_Bind") == -1) break block2;
                bl = true;
            }
        }
        return bl;
    }

    private void TABLE_NAME() throws Exception {
        Object object;
        String string;
        boolean bl = APIUtil.getBoolean(this.getProperty("auto-start-derbyservice"), true);
        if (!bl || !this.EMPTY() || this.LCTABLE_1()) {
            return;
        }
        String string2 = this.getProperty("url");
        String string3 = string2.substring(string2.indexOf("jdbc:derby://"), string2.lastIndexOf("/"));
        string3 = string3.substring(string3.lastIndexOf(":") + 1);
        int n = 8886;
        ExProperties exProperties = new ExProperties();
        try {
            string = ServerEnv.homePath + "derby" + File.separator + "derby.properties";
            exProperties.load(string);
            n = exProperties.getProperty("derby.drda.portNumber", 1527);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        if (string3 != null) {
            n = APIUtil.parseInt(string3);
        }
        if (this.SEDU(n)) {
            throw new IOException("Address already in use: JVM_Bind, port:" + string3);
        }
        string = ServerEnv.getReportHome();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String string4 = System.getProperty("os.name").toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string4.indexOf("windows") != -1) {
            string = string + "derby\\bin";
            arrayList.add("CMD.EXE");
            arrayList.add("/c");
            arrayList.add("startNetworkServer.bat");
        } else {
            string = string + "derby/bin";
            arrayList.add("./startNetworkServer.sh");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String string5 = System.getProperty("java.home");
        if (null != string5 && 0 != string5.length()) {
            object = processBuilder.environment();
            object.put((String)"JAVA_HOME", (String)string5);
        }
        processBuilder.directory(new File(string));
        processBuilder.command(arrayList);
        if (!ServiceLogger.isLoggable(4, 7)) {
            processBuilder.start();
        } else {
            ServiceLogger.logDebug("path: " + string + ", command: " + ((Object)arrayList).toString(), 6);
            object = processBuilder.start();
            StreamGobbler streamGobbler = new StreamGobbler(((Process)object).getErrorStream(), "Error");
            StreamGobbler streamGobbler2 = new StreamGobbler(((Process)object).getInputStream(), "Output");
            streamGobbler.start();
            streamGobbler2.start();
        }
        int n2 = 0;
        while (n2 < 20) {
            ++n2;
            if (this.LCTABLE_1()) {
                this.close = true;
                break;
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException);
            }
        }
        if (this.close) {
            ServiceLogger.logDebug("Derby Network Server startup...");
        } else {
            ServiceLogger.logError("Can not connect to default derby server, please check your settings...");
        }
    }

    private void add() throws Exception {
        if (!this.close) {
            return;
        }
        String string = ServerEnv.getReportHome();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String string2 = System.getProperty("os.name").toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2.indexOf("windows") != -1) {
            string = string + "derby\\bin";
            arrayList.add("CMD.EXE");
            arrayList.add("/c");
            arrayList.add("stopNetworkServer.bat");
        } else {
            string = string + "derby/bin";
            arrayList.add("./stopNetworkServer.sh");
        }
        arrayList.add("-h");
        arrayList.add("localhost");
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String string3 = System.getProperty("java.home");
        if (null != string3 && 0 != string3.length()) {
            Map<String, String> map = processBuilder.environment();
            map.put("JAVA_HOME", string3);
        }
        processBuilder.directory(new File(string));
        processBuilder.command(arrayList);
        processBuilder.start();
        ServiceLogger.logDebug("Derby Network Server shutdown...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws SQLException {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            Object object;
            Object object2;
            if (this.isOpened()) {
                return;
            }
            try {
                this.TABLE_NAME();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
            Connection connection = this.getConnector().getConnection();
            int n = connection.getTransactionIsolation();
            this.containsKey = 4;
            try {
                object2 = DBFactory.create(this.getConnector());
                if (object2 instanceof DBOracledb) {
                    this.containsKey = 2;
                } else {
                    for (int n2 : object = new int[]{this.containsKey, 8, 4, 2, 1, 0}) {
                        try {
                            connection.setTransactionIsolation(n2);
                            this.containsKey = n2;
                            break;
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logDebug("Detect db transactionIsolation Level " + n2 + ": " + throwable.getMessage());
                        }
                    }
                    connection.setTransactionIsolation(n);
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            object2 = connection.getMetaData();
            this.command = object2.getDatabaseProductName();
            this.contains = object2.getDatabaseProductVersion();
            ServiceLogger.logDebug("Database:" + object2.getDatabaseProductName() + ", " + object2.getDatabaseProductVersion() + "; Driver:" + object2.getDriverName() + ", " + object2.getDriverVersion() + "; defaultTransactionIsolation:" + n + "; lockIsolationLevel:" + this.containsKey + "; schema: " + this.getProperty("schema"), 4);
            this.append(connection);
            try {
                new DualTable(this);
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
                throw new SQLException(instantiationException.getMessage());
            }
            try {
                this.append = new LockTable(this);
                this.appendProfileTable = TransExecutorImpl.createTransExecutor(this, this.append.getDBAdapter(), this.append);
                this.appendSystemTable = new LockResourceTable(this);
                this.backup = TransExecutorImpl.createTransExecutor(this, this.appendSystemTable.getDBAdapter(), this.appendSystemTable);
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
                throw new SQLException(instantiationException.getMessage());
            }
            try {
                this.checkIntegrality = new IDGeneratorImpl(this);
                this.checkIntegrality.open();
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
            }
            if ("true".equals(ServerEnvBuilder.servEnv.getProperty("jreport.resource.cleanup", "false"))) {
                object = this.LCTABLE_1.iterator();
                while (object.hasNext()) {
                    Object object3 = (Table)object.next();
                    object3.delete(null, ParameterMetaInfo.EMPTY);
                }
            }
            connection.close();
            this.clear = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpened() {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            return this.clear;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            int n = this.LCTABLE_1.size();
            for (int i = 0; i < n; ++i) {
                ((TableImpl)this.tables(i)).close();
            }
            this.LCTABLE_1.clear();
            if (this.checkIntegrality != null) {
                this.checkIntegrality.close();
                this.checkIntegrality = null;
            }
            if (this.append != null) {
                this.append.close();
                this.append = null;
            }
            if (this.add != null) {
                this.add.destroy();
                this.add = null;
            }
            try {
                this.add();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
            this.clear = false;
        }
    }

    public TransExecutor getTransExecutor() {
        return this.appendProfileTable;
    }

    public TransExecutor getResourceTransExecutor() {
        return this.backup;
    }

    public int getTransactionIsolation() {
        return this.containsKey;
    }

    public IDGenerator getIDGenerator() {
        return this.checkIntegrality;
    }

    public void setTransferHelp(TransferHelp transferHelp) {
        this.decode = transferHelp;
    }

    @Override
    public boolean backup(String string) throws SQLException, IOException {
        if (this.decode != null) {
            return this.decode.backup(this, string);
        }
        return false;
    }

    @Override
    public boolean restore(String string) throws SQLException, IOException {
        if (this.decode != null) {
            return this.decode.restore(this, string);
        }
        return false;
    }

    @Override
    public boolean cutdownTable(Table table, String string, String string2) throws SQLException, IOException {
        if (this.decode != null) {
            return this.decode.cutdownTable(this, table, string, string2);
        }
        return false;
    }

    @Override
    public boolean importsTable(Table table, String string) throws SQLException, IOException {
        if (this.decode != null) {
            return this.decode.importsTable(this, table, string);
        }
        return false;
    }

    @Override
    public void checkIntegrality(Map map) throws SQLException {
        if (this.decode != null) {
            this.decode.checkIntegrality(this, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(Connection connection) {
        Object object;
        String[] stringArray;
        ServiceLogger.logDebug(4640005, 4);
        long l = System.currentTimeMillis();
        String string = this.getProperty("schema");
        ServiceLogger.logDebug(4640006, string, 4);
        if (string == null || string.trim().length() == 0) {
            stringArray = this.getProperty("user");
            try {
                object = DBFactory.create(this.add);
                string = object.getDefaultSchema((String)stringArray, connection);
                ServiceLogger.logDebug(4640009, string, 4);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        stringArray = new String[]{"TABLE", "ALIAS", "SYNONYM"};
        object = null;
        ResultSet resultSet = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        int n = 0;
        String string2 = null;
        try {
            object = connection.getMetaData();
            resultSet = object.getTables(null, string, null, stringArray);
            while (resultSet.next()) {
                string2 = resultSet.getString("TABLE_NAME").toUpperCase();
                if (!create.contains(string2)) continue;
                hashSet.add(string2);
                ++n;
                if (cutdownTable.contains(string2)) {
                    hashSet3.add(string2);
                }
                if (!currentTimeMillis.contains(string2)) continue;
                hashSet2.add(string2);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            try {
                string2 = (String)iterator.next();
                TableImpl tableImpl = new TableImpl(this, string2);
                this.appendProfileTable(tableImpl, string, (DatabaseMetaData)object);
                this.append(tableImpl);
                if (hashSet3.contains(string2)) {
                    this.appendSystemTable(tableImpl);
                }
                if (hashSet2.contains(string2)) {
                    this.appendProfileTable(tableImpl);
                }
                ServiceLogger.logDebug(4640007, string2, 4);
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.logDebug(4640008, new Object[]{new Integer(n), new Long(l2)}, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendProfileTable(TableImpl tableImpl, String string, DatabaseMetaData databaseMetaData) {
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getDatabaseProductName().equalsIgnoreCase("interbase") ? databaseMetaData.getColumns("", "", tableImpl.getNameWithoutSchema(), "%") : databaseMetaData.getColumns(null, string, tableImpl.getNameWithoutSchema(), null);
            Map map = this.appendSystemTable(tableImpl, string, databaseMetaData);
            while (resultSet.next()) {
                FieldImpl fieldImpl = new FieldImpl();
                fieldImpl.setParentTable(tableImpl);
                String string2 = resultSet.getString("COLUMN_NAME").toUpperCase();
                fieldImpl.setFieldName(resultSet.getString("COLUMN_NAME"));
                fieldImpl.setSize(resultSet.getInt("COLUMN_SIZE"));
                fieldImpl.setType(JDBCType.getJDBCType(resultSet.getInt("DATA_TYPE")));
                boolean bl = resultSet.getInt("NULLABLE") == 0;
                fieldImpl.setNotNull(bl);
                if (map.containsKey(string2)) {
                    fieldImpl.setForeignTableName(((String[])map.get(string2))[0]);
                }
                tableImpl.append(fieldImpl);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }

    private Map appendSystemTable(TableImpl tableImpl, String string, DatabaseMetaData databaseMetaData) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        try {
            ResultSet resultSet = databaseMetaData.getImportedKeys(null, string, tableImpl.getNameWithoutSchema());
            while (resultSet.next()) {
                String string2 = resultSet.getString("PKTABLE_NAME").toUpperCase();
                String string3 = resultSet.getString("PKCOLUMN_NAME").toUpperCase();
                String string4 = resultSet.getString("FKCOLUMN_NAME").toUpperCase();
                string2 = Dbs.fullTableName(this.getProperty("schema"), string2);
                hashMap.put(string4, new String[]{string2, string3});
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return hashMap;
    }

    public String getProductDBName() {
        return this.command;
    }

    public String getProductDBVer() {
        return this.contains;
    }

    static {
        create.add("ACLENTRYS_1");
        create.add("ACLENTRIES_2");
        create.add("ACLENTRIES_3");
        create.add("ACLS_1");
        create.add("ACLS_2");
        create.add("ACLS_WITH_RESOURCE_1");
        create.add("ALIASES_1");
        create.add("ALIASES_2");
        create.add("CATALOGVERSION_1");
        create.add("CATALOGVERSION_2");
        create.add("CATALOGVERSION_3");
        create.add("CATALOGVERSION_4");
        create.add("COMPLETEDTABLE_1");
        create.add("COMPLETEDTABLE_2");
        create.add("COMPLETEDTABLE_3");
        create.add("COMPLETEDTABLE_4");
        create.add("COMPLETEDPUBLISHTABLE_1");
        create.add("COMPLETEDPUBLISHTABLE_2");
        create.add("COMPLETEDRESULTTABLE_1");
        create.add("COMPLETEDRESULTTABLE_2");
        create.add("COMPLETEDRESULTTABLE_3");
        create.add("DRESULT_1");
        create.add("DRESULT_2");
        create.add("DRESULT_3");
        create.add("DYNAMICNODE_1");
        create.add("DYNAMICNODE_2");
        create.add("DYNAMICNODE_3");
        create.add("DYNAMICNODE_4");
        create.add("DYNAMICNODE_5");
        create.add("DYNAMICRESULT_1");
        create.add("DYNAMICRESULT_2");
        create.add("EXTENDACLENTRIES_1");
        create.add("EXTENDACLENTRIES_2");
        create.add("EXTENDACLENTRIES_3");
        create.add("FOLDERS_1");
        create.add("FOLDERS_2");
        create.add("FOLDERS_3");
        create.add("FOLDERS_4");
        create.add("GROUPPROFILES_1");
        create.add("GROUPPROFILES_2");
        create.add("GROUPS_1");
        create.add("GROUPS_2");
        create.add("GROUPS_3");
        create.add("GUPROFILES_1");
        create.add("GUPROFILES_2");
        create.add("GUPROFILES_3");
        create.add("NODES_1");
        create.add("NODES_2");
        create.add("NODES_3");
        create.add("NODES_4");
        create.add("NODES_5");
        create.add("NODES_6");
        create.add("ORGANIZATIONS_1");
        create.add("REPORTVERSION_1");
        create.add("REPORTVERSION_2");
        create.add("REPORTVERSION_3");
        create.add("REPORTVERSION_4");
        create.add("RESOURCEMAP_1");
        create.add("RESOURCEMAP_2");
        create.add("RESOURCENODES_1");
        create.add("RESOURCENODES_2");
        create.add("RESOURCENODES_3");
        create.add("RESOURCENODES_4");
        create.add("RESOURCENODES_5");
        create.add("RESOURCENLS_1");
        create.add("RESULT_1");
        create.add("RESULT_2");
        create.add("RESULT_3");
        create.add("RESULTVERSION_1");
        create.add("RESULTVERSION_2");
        create.add("RESULTVERSION_3");
        create.add("RGPROFILES_1");
        create.add("RGPROFILES_2");
        create.add("ROLEPROFILES_1");
        create.add("ROLEPROFILES_2");
        create.add("ROLEPROFILES_3");
        create.add("ROLES_1");
        create.add("ROLES_2");
        create.add("ROLES_3");
        create.add("ROLES_4");
        create.add("SCHDLASTEXETIME_1");
        create.add("TRIGGERS_1");
        create.add("UPDATEDETAILS_1");
        create.add("USERPROFILES_1");
        create.add("USERPROFILES_2");
        create.add("USERPROFILES_3");
        create.add("USERPROFILES_4");
        create.add("USERS_1");
        create.add("USERS_2");
        create.add("USERS_3");
        create.add("USERS_4");
        create.add("VERSIONNODES_1");
        create.add("VERSIONNODES_2");
        create.add("VERSIONNODES_3");
        create.add("CUSTOM_FIELD_1");
        create.add("CUSTOM_FIELD_VALUE_1");
        create.add("COMPLETED_CRD_INFO_1");
        create.add("COMPLETED_CRD_INFO_2");
        create.add("COMPLETED_CRD_INFO_3");
        create.add("COMP_CRD_CONN_INFO_1");
        create.add("CRD_INFO_1");
        create.add("CRD_INFO_2");
        create.add("CRD_INFO_3");
        create.add("CRD_INFO_4");
        create.add("CRD_INFO_5");
        create.add("CRD_CONN_INFO_1");
        create.add("CRDRUNDETAIL_1");
        create.add("HISTORY_PARAMLIST_TABLE_1");
        create.add(LCVersionTableImpl.TABLE_NAME);
        create.add(LCVersionTableImpl.LCTABLE_1);
        create.add("MEMBERS");
        create.add("STORAGE_RESOURCE_1");
        create.add("STORAGE_MEMBER_1");
        create.add("CFG_PROPS_1");
        create.add("CFG_PROPS_2");
        create.add("GLOBAL_NLS_TEXT_1");
        create.add("GLOBAL_NLS_FORMAT_1");
        create.add("GLOBAL_NLS_FONT_1");
        create.add("TBL_DUAL_JINFONET");
        create.add("TBL_IDGENRATOR_JINFONET");
        create.add("TBL_LOCK_JINFONET");
        create.add("RESOURCE_LOCK");
        create.add("TASKCONTEXT");
        create.add("TASKCONTEXT_2");
        create.add("JR_QRTZ_JOB_DETAILS");
        create.add("JR_QRTZ_JOB_LISTENERS");
        create.add("JR_QRTZ_TRIGGERS");
        create.add("JR_QRTZ_SIMPLE_TRIGGERS");
        create.add("JR_QRTZ_CRON_TRIGGERS");
        create.add("JR_QRTZ_BLOB_TRIGGERS");
        create.add("JR_QRTZ_TRIGGER_LISTENERS");
        create.add("JR_QRTZ_CALENDARS");
        create.add("JR_QRTZ_PAUSED_TRIGGER_GRPS");
        create.add("JR_QRTZ_FIRED_TRIGGERS");
        create.add("JR_QRTZ_SCHEDULER_STATE");
        create.add("JR_QRTZ_LOCKS");
        create.add("ALIAS_MAPPING");
        create.add("ALIAS_MAPPING_KEY");
        create.add("TASKAUDIT");
        create.add("DASHBOARDLISTENER_1");
        create.add("DASHBOARDLISTENERTARGET_1");
        create.add("DYNAMIC_CONNECTIONS_1");
        create.add("DYNAMIC_CONNECTIONS_2");
        create.add("DYNAMIC_CONNECTIONS_MAPPING_1");
        create.add("DYNAMIC_CONNECTIONS_MAPPING_2");
        create.add("DYN_SECURITY_1");
        create.add("DYN_BVELE_NAME_1");
        create.add("DYN_BVELE_NAME_MAPPING_1");
        createTransExecutor = new HashSet();
        createTransExecutor.add("ACLENTRIES_3");
        createTransExecutor.add("ACLS_2");
        createTransExecutor.add("ACLS_WITH_RESOURCE_1");
        createTransExecutor.add("ALIASES_2");
        createTransExecutor.add("ALIAS_MAPPING");
        createTransExecutor.add("ALIAS_MAPPING_KEY");
        createTransExecutor.add("CATALOGVERSION_4");
        createTransExecutor.add("CFG_PROPS_2");
        createTransExecutor.add("COMPLETEDPUBLISHTABLE_2");
        createTransExecutor.add("COMPLETEDRESULTTABLE_3");
        createTransExecutor.add("COMPLETEDTABLE_4");
        createTransExecutor.add("DRESULT_3");
        createTransExecutor.add("DYNAMICNODE_5");
        createTransExecutor.add("DYNAMICRESULT_2");
        createTransExecutor.add("EXTENDACLENTRIES_3");
        createTransExecutor.add("FOLDERS_4");
        createTransExecutor.add("GROUPPROFILES_2");
        createTransExecutor.add("GROUPS_3");
        createTransExecutor.add("GUPROFILES_3");
        createTransExecutor.add("JR_QRTZ_BLOB_TRIGGERS");
        createTransExecutor.add("JR_QRTZ_CALENDARS");
        createTransExecutor.add("JR_QRTZ_CRON_TRIGGERS");
        createTransExecutor.add("JR_QRTZ_FIRED_TRIGGERS");
        createTransExecutor.add("JR_QRTZ_JOB_DETAILS");
        createTransExecutor.add("JR_QRTZ_JOB_LISTENERS");
        createTransExecutor.add("JR_QRTZ_LOCKS");
        createTransExecutor.add("JR_QRTZ_PAUSED_TRIGGER_GRPS");
        createTransExecutor.add("JR_QRTZ_SCHEDULER_STATE");
        createTransExecutor.add("JR_QRTZ_SIMPLE_TRIGGERS");
        createTransExecutor.add("JR_QRTZ_TRIGGERS");
        createTransExecutor.add("JR_QRTZ_TRIGGER_LISTENERS");
        createTransExecutor.add("NODES_6");
        createTransExecutor.add("ORGANIZATIONS_1");
        createTransExecutor.add("REPORTVERSION_4");
        createTransExecutor.add("RESOURCENLS_1");
        createTransExecutor.add("RESOURCEMAP_2");
        createTransExecutor.add("RESOURCENODES_5");
        createTransExecutor.add("RESULTVERSION_3");
        createTransExecutor.add("RESULT_3");
        createTransExecutor.add("RGPROFILES_2");
        createTransExecutor.add("ROLEPROFILES_3");
        createTransExecutor.add("ROLES_4");
        createTransExecutor.add("SCHDLASTEXETIME_1");
        createTransExecutor.add("STORAGE_MEMBER_1");
        createTransExecutor.add("STORAGE_RESOURCE_1");
        createTransExecutor.add("TBL_IDGENRATOR_JINFONET");
        createTransExecutor.add("TBL_LOCK_JINFONET");
        createTransExecutor.add("RESOURCE_LOCK");
        createTransExecutor.add("TRIGGERS_1");
        createTransExecutor.add("UPDATEDETAILS_1");
        createTransExecutor.add("USERPROFILES_4");
        createTransExecutor.add("USERS_4");
        createTransExecutor.add("VERSIONNODES_3");
        createTransExecutor.add("CRD_INFO_5");
        createTransExecutor.add("CRD_CONN_INFO_1");
        createTransExecutor.add("COMPLETED_CRD_INFO_3");
        createTransExecutor.add("COMP_CRD_CONN_INFO_1");
        createTransExecutor.add("CRDRUNDETAIL_1");
        createTransExecutor.add("CUSTOM_FIELD_1");
        createTransExecutor.add("CUSTOM_FIELD_VALUE_1");
        createTransExecutor.add("TBL_DUAL_JINFONET");
        createTransExecutor.add("HISTORY_PARAMLIST_TABLE_1");
        createTransExecutor.add(LCVersionTableImpl.TABLE_NAME);
        createTransExecutor.add("DASHBOARDLISTENER_1");
        createTransExecutor.add("DASHBOARDLISTENERTARGET_1");
        createTransExecutor.add("DYNAMIC_CONNECTIONS_2");
        createTransExecutor.add("DYNAMIC_CONNECTIONS_MAPPING_2");
        createTransExecutor.add("DYN_SECURITY_1");
        createTransExecutor.add("DYN_BVELE_NAME_1");
        createTransExecutor.add("DYN_BVELE_NAME_MAPPING_1");
        currentTimeMillis = new HashSet();
        currentTimeMillis.add("TBL_DUAL_JINFONET");
        currentTimeMillis.add("TBL_IDGENRATOR_JINFONET");
        currentTimeMillis.add("TBL_LOCK_JINFONET");
        currentTimeMillis.add("RESOURCE_LOCK");
        currentTimeMillis.add("TASKCONTEXT_2");
        currentTimeMillis.add("TASKAUDIT");
        currentTimeMillis.add("UPDATEDETAILS_1");
        cutdownTable = new HashSet();
        cutdownTable.add("TBL_DUAL_JINFONET");
        cutdownTable.add("TBL_IDGENRATOR_JINFONET");
        cutdownTable.add("TBL_LOCK_JINFONET");
        cutdownTable.add("RESOURCE_LOCK");
        cutdownTable.add("CFG_PROPS_2");
        cutdownTable.add("GLOBAL_NLS_TEXT_1");
        cutdownTable.add("GLOBAL_NLS_FORMAT_1");
        cutdownTable.add("GLOBAL_NLS_FONT_1");
        cutdownTable.add("MEMBERS");
        cutdownTable.add("UPDATEDETAILS_1");
    }

    private class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        public StreamGobbler(InputStream inputStream, String string) {
            this.is = inputStream;
            this.type = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader inputStreamReader = new InputStreamReader(this.is);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (this.type.equals("Error")) {
                        ServiceLogger.logError(string);
                        continue;
                    }
                    ServiceLogger.logDebug(string);
                }
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
            finally {
                try {
                    inputStreamReader.close();
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

