/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.log.ServiceLogger;

public class Dbs {
    public static String fullTableName(String string, String string2) {
        String string3 = string2.toUpperCase();
        if (string != null && string.trim().length() > 0) {
            string3 = string.trim() + "." + string3;
        }
        return string3;
    }

    public static void setParameterMetaInfo(PreparedStatement preparedStatement, ParameterMetaInfo parameterMetaInfo) throws SQLException {
        if (parameterMetaInfo == null) {
            ServiceLogger.logDebug("setParameterMetaInfo: the paras is null.");
            return;
        }
        int n = parameterMetaInfo.getParameterCount();
        if (n == 0) {
            if (parameterMetaInfo != ParameterMetaInfo.EMPTY) {
                ServiceLogger.logDebug("setParameterMetaInfo: warn, the paras is empty.");
            }
            return;
        }
        block28: for (int i = 1; i <= n; ++i) {
            int n2 = parameterMetaInfo.getParameterMode(i);
            int n3 = parameterMetaInfo.getJDBCType(i);
            Object object = parameterMetaInfo.getValue(i);
            if (object == null) {
                switch (n3) {
                    case -7: 
                    case 16: {
                        object = Boolean.FALSE;
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        object = " ";
                    }
                }
                if (object == null) {
                    Dbs.EMPTY(preparedStatement, i, n3);
                    continue;
                }
            }
            if (n2 == 4) {
                preparedStatement.setObject(i, object);
                continue;
            }
            switch (n3) {
                case -7: 
                case 16: {
                    boolean bl = Boolean.parseBoolean(object.toString());
                    preparedStatement.setShort(i, (short)(bl ? 1 : 0));
                    continue block28;
                }
                case -5: {
                    preparedStatement.setLong(i, Long.parseLong(object.toString()));
                    continue block28;
                }
                case 91: {
                    preparedStatement.setDate(i, (Date)object);
                    continue block28;
                }
                case 2: 
                case 3: {
                    preparedStatement.setBigDecimal(i, new BigDecimal(object.toString()));
                    continue block28;
                }
                case 8: {
                    preparedStatement.setDouble(i, Double.parseDouble(object.toString()));
                    continue block28;
                }
                case 6: {
                    preparedStatement.setFloat(i, Float.parseFloat(object.toString()));
                    continue block28;
                }
                case 4: {
                    preparedStatement.setInt(i, Integer.parseInt(object.toString()));
                    continue block28;
                }
                case 7: {
                    preparedStatement.setDouble(i, Float.parseFloat(object.toString()));
                    continue block28;
                }
                case 5: {
                    preparedStatement.setShort(i, Short.parseShort(object.toString()));
                    continue block28;
                }
                case 92: {
                    preparedStatement.setTime(i, (Time)object);
                    continue block28;
                }
                case 93: {
                    preparedStatement.setTimestamp(i, (Timestamp)object);
                    continue block28;
                }
                case -6: {
                    preparedStatement.setShort(i, Short.parseShort(object.toString()));
                    continue block28;
                }
                case -4: 
                case -3: 
                case -2: {
                    Closeable closeable;
                    if (object instanceof byte[]) {
                        preparedStatement.setBytes(i, (byte[])object);
                        continue block28;
                    }
                    if (object instanceof InputStream) {
                        closeable = (InputStream)object;
                        try {
                            preparedStatement.setBinaryStream(i, (InputStream)closeable, ((InputStream)closeable).available());
                            continue block28;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    Dbs.EMPTY(preparedStatement, i, n3);
                    continue block28;
                }
                case 2004: {
                    Closeable closeable;
                    if (object instanceof byte[]) {
                        preparedStatement.setBytes(i, (byte[])object);
                        continue block28;
                    }
                    if (object instanceof InputStream) {
                        closeable = (InputStream)object;
                        try {
                            preparedStatement.setBinaryStream(i, (InputStream)closeable, ((InputStream)closeable).available());
                            continue block28;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    if (object instanceof Blob) {
                        preparedStatement.setBlob(i, (Blob)object);
                        continue block28;
                    }
                    Dbs.EMPTY(preparedStatement, i, n3);
                    continue block28;
                }
                case 2005: {
                    Closeable closeable;
                    if (object instanceof String) {
                        preparedStatement.setString(i, (String)object);
                        continue block28;
                    }
                    if (object instanceof InputStream) {
                        closeable = (InputStream)object;
                        try {
                            preparedStatement.setAsciiStream(i, (InputStream)closeable, ((InputStream)closeable).available());
                            continue block28;
                        }
                        catch (IOException iOException) {
                            throw new SQLException(iOException.getMessage());
                        }
                    }
                    if (object instanceof Reader) {
                        closeable = (Reader)object;
                        preparedStatement.setCharacterStream(i, (Reader)closeable, Integer.MAX_VALUE);
                        continue block28;
                    }
                    if (object instanceof Clob) {
                        preparedStatement.setClob(i, (Clob)object);
                        continue block28;
                    }
                    Dbs.EMPTY(preparedStatement, i, n3);
                    continue block28;
                }
                case -1: 
                case 1: 
                case 12: {
                    preparedStatement.setString(i, object.toString());
                    continue block28;
                }
                default: {
                    ServiceLogger.logDebug("setParameterMetaInfo: warn, unknown datatype: " + n3 + " (" + parameterMetaInfo.getName(i) + ")");
                    Dbs.EMPTY(preparedStatement, i, n3);
                }
            }
        }
    }

    private static void EMPTY(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        if (n2 < 1111) {
            preparedStatement.setNull(n, n2);
        } else {
            preparedStatement.setNull(n, -2);
        }
    }
}

