/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import jet.JSException;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.db.Connector;
import jet.server.db.UpdateDetailsTableImpl;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.GlobalDbStatusChecker;
import jet.server.db.core.WorkspaceImpl;
import jet.server.db.core.WorkspaceManager;
import jet.server.db.nls.GlobalNLSTable;
import jet.server.db.transfer.SystemDBTransferHelp;
import jet.server.db.zeroconfig.MemberTableImpl;
import jet.server.log.ServiceLogger;

public class GlobalDataService {
    private static GlobalDataService SEDU = null;
    private Database append = null;
    private Connector close;
    private boolean databases = false;
    private PropsTable destroy = null;
    private GlobalDbStatusChecker getConnector = null;
    private GlobalNLSTable getInstance = null;
    private MemberTableImpl getProperties = null;
    private UpdateDetailsTableImpl getProperty = null;

    public static GlobalDataService init() throws Exception {
        if (SEDU == null) {
            try {
                SEDU = new GlobalDataService();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw exception;
            }
        }
        return SEDU;
    }

    public static GlobalDataService getInstance() {
        return SEDU;
    }

    public static void shutdown() {
        if (SEDU != null) {
            SEDU.destroy();
        }
        SEDU = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GlobalDataService() throws Exception {
        Workspace workspace = WorkspaceManager.getInstance().workspaces("systemRealm");
        if (workspace == null) {
            if (WorkspaceManager.getInstance().isConfigFileExist() && !WorkspaceManager.getInstance().isUpgradeConfig()) throw new JSException(670024);
            workspace = new WorkspaceImpl("systemRealm");
            this.append = this.SEDU(workspace);
            WorkspaceManager.getInstance().append(workspace);
            ServiceLogger.logDebug("***will save Database configuration...invoked by GlobalDataService.GlobalDataService()");
            WorkspaceManager.getInstance().saveConfig();
        } else {
            this.append = workspace.databases("systemtables");
            if (this.append == null) {
                this.append = this.SEDU(workspace);
                WorkspaceManager.getInstance().saveConfig();
            }
        }
        if (this.append instanceof DatabaseImpl) {
            ((DatabaseImpl)this.append).setTransferHelp(new SystemDBTransferHelp());
        }
        try {
            ((DatabaseImpl)this.append).open();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        this.close = ((DatabaseImpl)this.append).getConnector();
        try {
            this.getProperty = UpdateDetailsTableImpl.newInstance(this.append);
            this.destroy = new PropsTable(this.append, this.getProperty);
            this.getConnector = new GlobalDbStatusChecker(this.destroy);
            this.getInstance = new GlobalNLSTable(this.append);
            this.getProperties = MemberTableImpl.newInstance(this.append);
            String string = System.getProperty("restore.systemtables");
            if (string != null && string.trim().length() > 0) {
                try {
                    this.append.restore(string);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
                System.getProperties().remove("restore.systemtables");
            }
            this.databases = true;
            return;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (!this.databases) {
                if (this.append != null) {
                    ((DatabaseImpl)this.append).close();
                }
                if (this.close != null) {
                    this.close.destroy();
                }
            }
        }
    }

    public void quit() {
        if (this.databases) {
            this.getInstance.close();
            if (this.getConnector != null) {
                this.getConnector.close();
            }
            this.destroy.close();
            this.getProperties.close();
            this.getProperty.close();
        }
        ((DatabaseImpl)this.append).close();
    }

    public void destroy() {
        this.quit();
        WorkspaceManager workspaceManager = WorkspaceManager.getInstance();
        WorkspaceImpl workspaceImpl = (WorkspaceImpl)workspaceManager.workspaces("systemRealm");
        workspaceImpl.remove(this.append);
        workspaceManager.remove(workspaceImpl);
    }

    private Database SEDU(Workspace workspace) {
        Object object;
        int n = 8886;
        ExProperties exProperties = new ExProperties();
        try {
            object = ServerEnv.homePath + "derby" + File.separator + "derby.properties";
            exProperties.load((String)object);
            n = exProperties.getProperty("derby.drda.portNumber", 1527);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        object = new DatabaseImpl(workspace, "systemtables");
        object.setProperty("driver", "org.apache.derby.jdbc.ClientDriver");
        object.setProperty("user", "APP");
        object.setProperty("password", "APP");
        object.setProperty("auto-start-derbyservice", "true");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:derby://localhost:").append(n).append("/systemtables").append(";create=true");
        object.setProperty("url", stringBuffer.substring(0));
        ((WorkspaceImpl)workspace).append((Database)object);
        return object;
    }

    public PropsTable getPropsTable() {
        return this.destroy;
    }

    public GlobalNLSTable getGlobalNLSTable() {
        return this.getInstance;
    }

    public MemberTableImpl getMemberTable() {
        return this.getProperties;
    }

    public boolean isPendingUpgradeStatus() {
        return this.getConnector == null ? false : this.getConnector.isPendingUpgrade();
    }

    public void setFinishedUpgradeStatus() throws Exception {
        if (this.getConnector != null) {
            this.getConnector.setFinishedUpgrade();
        }
    }

    public void setFinishedStartup() throws Exception {
        if (this.getConnector != null) {
            this.getConnector.setFinishedStartup();
        }
    }
}

