/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.log.ServiceLogger;

public class GlobalDbStatus {
    private final List BuildNumber = new ArrayList();
    public final StatusEntry clusterName = new StatusEntry("clusterName", "");
    public final StatusEntry isClustered = new StatusEntry("isClustered", false);
    public final StatusEntry isActive = new StatusEntry("isActive", false);
    public final StatusEntry isPendingUpgrade = new StatusEntry("isPendingUpgrade", false);
    public final StatusEntry timestamp = new StatusEntry("timestamp", 0L);
    public final StatusEntry signature = new StatusEntry("signature", "");
    public final StatusEntry ownerMember = new StatusEntry("ownerMember", "");
    public final StatusEntry isFinishedStartup = new StatusEntry("isFinishedStartup", false);
    public final StatusEntry ver_app = new StatusEntry("ver_app", "");
    public final StatusEntry ver_major = new StatusEntry("ver_major", 0);
    public final StatusEntry ver_minor = new StatusEntry("ver_minor", 0);
    public final StatusEntry ver_dot3 = new StatusEntry("ver_dot3", 0);
    public final StatusEntry ver_dot4 = new StatusEntry("ver_dot4", 0);
    public final StatusEntry ver_BuildNumber = new StatusEntry("ver_BuildNumber", 0);
    public final StatusEntry ver_servicepack = new StatusEntry("ver_servicepack", 0);
    public final StatusEntry ver_updates = new StatusEntry("ver_updates", 0);

    boolean check(GlobalDbStatus globalDbStatus) throws Exception {
        boolean bl = (Boolean)this.isActive.get() != false && (Long)globalDbStatus.timestamp.get() - (Long)this.timestamp.get() < 130000L;
        String string = "JReport Server failed to start because the specified server database is already being used by another JReport Server or JReport Cluster.";
        if (bl) {
            boolean bl2;
            ServiceLogger.logDebug("GlobalDatabase:: database in active state.");
            boolean bl3 = bl2 = (Integer)this.ver_major.get() == ReportEnv.major && (Integer)this.ver_minor.get() == ReportEnv.minor && (Integer)this.ver_dot3.get() == ReportEnv.dot3 && (Integer)this.ver_dot4.get() == ReportEnv.dot4 && (Integer)this.ver_BuildNumber.get() == ReportEnv.BuildNumber && (Integer)this.ver_servicepack.get() == ReportEnv.servicepack && (Integer)this.ver_updates.get() == ReportEnv.updates;
            if (!(bl2 && ((Boolean)this.isClustered.get()).booleanValue() && ((Boolean)globalDbStatus.isClustered.get()).booleanValue() && ((String)this.clusterName.get()).equals(ClusterEnv.getClusterName()))) {
                throw new ClusterException(650014);
            }
        } else {
            if (((Boolean)this.isActive.get()).booleanValue()) {
                ServiceLogger.logDebug("GlobalDatabase:: database in timeout state.");
            } else if (((String)this.signature.get()).length() > 0) {
                ServiceLogger.logDebug("GlobalDatabase:: database in closed state.");
            } else {
                ServiceLogger.logDebug("GlobalDatabase:: database in free state.");
            }
            if (!this.BuildNumber()) {
                throw new ClusterException(650014);
            }
        }
        return bl;
    }

    String getSignature() {
        return (String)this.signature.get();
    }

    void setTimestamp(long l) {
        this.timestamp.set(l);
    }

    void setActive(boolean bl) {
        this.isActive.set(bl);
    }

    public String toString() {
        return this.BuildNumber.toString();
    }

    private boolean BuildNumber() {
        if ((Integer)this.ver_major.get() == 0) {
            return true;
        }
        if (ReportEnv.major > (Integer)this.ver_major.get()) {
            return true;
        }
        if (ReportEnv.major < (Integer)this.ver_major.get()) {
            return false;
        }
        if (ReportEnv.minor > (Integer)this.ver_minor.get()) {
            return true;
        }
        if (ReportEnv.minor < (Integer)this.ver_minor.get()) {
            return false;
        }
        if (ReportEnv.dot3 > (Integer)this.ver_dot3.get()) {
            return true;
        }
        if (ReportEnv.dot3 < (Integer)this.ver_dot3.get()) {
            return false;
        }
        if (ReportEnv.dot4 > (Integer)this.ver_dot4.get()) {
            return true;
        }
        if (ReportEnv.dot4 < (Integer)this.ver_dot4.get()) {
            return false;
        }
        if (ReportEnv.BuildNumber > (Integer)this.ver_BuildNumber.get()) {
            return true;
        }
        if (ReportEnv.BuildNumber < (Integer)this.ver_BuildNumber.get()) {
            return false;
        }
        if (ReportEnv.servicepack > (Integer)this.ver_servicepack.get()) {
            return true;
        }
        if (ReportEnv.servicepack < (Integer)this.ver_servicepack.get()) {
            return false;
        }
        return ReportEnv.updates >= (Integer)this.ver_updates.get();
    }

    Properties toProperties() {
        Properties properties = new Properties();
        for (StatusEntry statusEntry : this.BuildNumber) {
            statusEntry.toProp(properties);
        }
        return properties;
    }

    static GlobalDbStatus fromProperties(Properties properties) {
        GlobalDbStatus globalDbStatus = new GlobalDbStatus();
        for (StatusEntry statusEntry : globalDbStatus.BuildNumber) {
            statusEntry.parse(properties.getProperty(statusEntry.name()));
        }
        return globalDbStatus;
    }

    static GlobalDbStatus createLocalStatuses(boolean bl) {
        GlobalDbStatus globalDbStatus = new GlobalDbStatus();
        globalDbStatus.clusterName.set(ClusterEnv.getClusterName());
        globalDbStatus.isClustered.set(bl);
        globalDbStatus.isActive.set(true);
        globalDbStatus.isPendingUpgrade.set(false);
        globalDbStatus.signature.set(ClusterEnv.getMember().getSignature());
        globalDbStatus.ownerMember.set((ServerEnv.getLocalRMIHost() == null ? ServerEnv.getLocalHostName() : ServerEnv.getLocalRMIHost()) + ":" + ServerEnv.getPort());
        globalDbStatus.ver_app.set(ReportEnv.app);
        globalDbStatus.ver_major.set(ReportEnv.major);
        globalDbStatus.ver_minor.set(ReportEnv.minor);
        globalDbStatus.ver_dot3.set(ReportEnv.dot3);
        globalDbStatus.ver_dot4.set(ReportEnv.dot4);
        globalDbStatus.ver_BuildNumber.set(ReportEnv.BuildNumber);
        globalDbStatus.ver_servicepack.set(ReportEnv.servicepack);
        globalDbStatus.ver_updates.set(ReportEnv.updates);
        return globalDbStatus;
    }

    public class StatusEntry {
        private String SEDU;
        private Object access$000;
        private Object add;

        StatusEntry(String string, Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.SEDU = string;
            this.access$000 = object;
            this.add = object;
            GlobalDbStatus.this.BuildNumber.add(this);
        }

        String name() {
            return this.SEDU;
        }

        public Object get() {
            return this.access$000;
        }

        void set(Object object) {
            this.access$000 = object == null ? this.add : object;
        }

        void parse(String string) {
            if (string != null) {
                string = string.trim();
            }
            Object object = null;
            if (this.add instanceof Boolean) {
                object = CSUtil.getBoolean(string, (Boolean)this.add);
            } else if (this.add instanceof Integer) {
                object = CSUtil.parseInt(string, (Integer)this.add);
            } else if (this.add instanceof Long) {
                object = CSUtil.parseLong(string, (Long)this.add);
            } else if (this.add instanceof String) {
                object = string;
            } else if (this.add instanceof Float) {
                object = Float.valueOf(CSUtil.parseFloat(string, ((Float)this.add).floatValue()));
            } else if (this.add instanceof Double) {
                try {
                    object = Double.valueOf(string);
                }
                catch (Throwable throwable) {}
            } else if (this.add instanceof Byte) {
                try {
                    object = Byte.valueOf(string);
                }
                catch (Throwable throwable) {}
            } else if (this.add instanceof Short) {
                try {
                    object = Short.valueOf(string);
                }
                catch (Throwable throwable) {}
            } else if (this.add instanceof Character) {
                try {
                    object = Character.valueOf(string.charAt(0));
                }
                catch (Throwable throwable) {}
            } else {
                return;
            }
            this.set(object);
        }

        void toProp(Properties properties) {
            properties.setProperty(this.SEDU, String.valueOf(this.access$000));
        }

        public String toString() {
            return this.SEDU + "=" + this.access$000;
        }
    }
}

