/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.ClusterEnv;
import jet.server.cluster.core.ClusterServer;
import jet.server.cluster.core.JRView;
import jet.server.cluster.core.MemberListenerAdapter;
import jet.server.db.cfg.PropsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.GlobalDbStatus;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.jrc.JRMember;
import jet.server.log.ServiceLogger;

class GlobalDbStatusChecker
extends MemberListenerAdapter {
    private static final String SEDU = "GlobalDB_Status";
    private PropsTable access$100;
    private String access$102;
    private GlobalDbStatus addMemberListener;
    private GlobalDbStatus append;
    private boolean booleanValue = false;
    private boolean check = false;
    private RefreshThread createLocalStatuses;
    private boolean doUpdateProp = false;
    private final Object equals = new Object();

    public GlobalDbStatusChecker(PropsTable propsTable) throws Exception {
        this.access$100 = propsTable;
        this.SEDU();
    }

    private void SEDU() throws Exception {
        this.access$100();
        if (ClusterEnv.isClusterEnabled() && !ServerEnv.getInDBMaintain()) {
            ClusterServer.getMemberService().addMemberListener(this);
        } else {
            this.append(true);
        }
    }

    public void close() {
        this.close(true);
    }

    private void close(boolean bl) {
        try {
            this.append(false);
            if (bl && (!ClusterEnv.isClusterEnabled() || ServerEnv.getInDBMaintain())) {
                this.addMemberListener(false);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        this.access$100 = null;
    }

    @Override
    public void connected(JRMember jRMember) throws ClusterException {
        JRMember jRMember2 = ClusterServer.getMemberService().getCoordinator();
        if (!this.access$102.equals(jRMember2.getSignature())) {
            ServiceLogger.logDebug("GlobalDatabase:: coordinator=" + jRMember2 + ", signature=" + jRMember2.getSignature());
            ServiceLogger.logDebug("GlobalDatabase:: localMember=" + jRMember + ", signature=" + jRMember.getSignature());
            ServiceLogger.logDebug("GlobalDatabase:: dbSignature=" + this.access$102);
            if (this.access$102.equals(jRMember.getSignature())) {
                throw new ClusterException(650013);
            }
            throw new ClusterException(650014);
        }
        this.viewAccepted(ClusterServer.getMemberService().getView());
    }

    @Override
    public void viewAccepted(JRView jRView) {
        try {
            this.append(ClusterServer.getMemberService().isCoordinator());
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void beforeShutdown() {
        try {
            this.append(false);
            if (ClusterServer.getMemberService().getMembers().size() == 1) {
                this.addMemberListener(false);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void access$100() throws Exception {
        boolean bl;
        this.append = GlobalDbStatus.createLocalStatuses(ClusterEnv.isClusterEnabled() && !ServerEnv.getInDBMaintain());
        while (!(bl = ((Boolean)((DatabaseImpl)this.access$100.getDatabase()).getTransExecutor().executeInLock("CFG_PROPS_2", new ExecuteCallback(){

            @Override
            public Object execute(Connection connection) throws SQLException {
                try {
                    return GlobalDbStatusChecker.this.access$102(connection);
                }
                catch (Exception exception) {
                    throw new SQLException(exception);
                }
            }
        })).booleanValue())) {
            Thread.sleep(10000L);
        }
    }

    private boolean access$102(Connection connection) throws Exception {
        try {
            Timestamp timestamp = this.access$100.getDBAdapter().getCurrentTimestamp();
            this.append.setTimestamp(timestamp.getTime());
            Properties properties = this.access$100.queryProp(SEDU);
            this.addMemberListener = GlobalDbStatus.fromProperties(properties);
            this.booleanValue = properties.size() == 0;
            this.check = (Boolean)this.addMemberListener.isPendingUpgrade.get();
            if (ClusterEnv.isClusterEnabled()) {
                if (this.booleanValue) {
                    this.check = ServerEnv.isObsoleteMasterSlaveCluster();
                }
            } else {
                this.check = true;
            }
            this.append.isPendingUpgrade.set(this.check);
            ServiceLogger.logDebug("GlobalDatabase:: check database status: \n\t now=" + timestamp + ", lastTimestamp=" + new Timestamp((Long)this.addMemberListener.timestamp.get()) + "\n\t dbStatus=" + this.addMemberListener + "\n\t mystatus=" + this.append);
            if (this.addMemberListener.check(this.append)) {
                if (!((Boolean)this.addMemberListener.isFinishedStartup.get()).booleanValue()) {
                    ServiceLogger.logDebug("GlobalDatabase:: waiting the first node startup finished...");
                    return false;
                }
                this.check = false;
                this.access$102 = this.addMemberListener.getSignature();
            } else {
                ServiceLogger.logDebug("GlobalDatabase:: update database status to: " + this.append);
                this.access$100.doUpdateProp(connection, SEDU, this.append.toProperties(), true);
                this.doUpdateProp = true;
                this.check = this.check && ClusterEnv.isClusterEnabled();
                this.access$102 = this.append.getSignature();
            }
            ServiceLogger.logDebug("GlobalDatabase:: begin startup: isPendingUpgrade=" + this.check);
            return true;
        }
        catch (SQLException sQLException) {
            this.close(false);
            throw sQLException;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            this.close(false);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberListener(boolean bl) throws SQLException {
        Object object = this.equals;
        synchronized (object) {
            if (!bl && !this.doUpdateProp) {
                return;
            }
            if (!bl) {
                ServiceLogger.logDebug("GlobalDatabase:: to close db status.");
            } else {
                ServiceLogger.logDebug("GlobalDatabase:: to update db status.", 6);
            }
            this.append.setTimestamp(this.access$100.getDBAdapter().getCurrentTimestamp().getTime());
            this.append.setActive(bl);
            this.access$100.updateProp(SEDU, this.append.toProperties(), true);
            this.doUpdateProp = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(boolean bl) throws SQLException {
        Object object = this.equals;
        synchronized (object) {
            if (bl) {
                if (this.createLocalStatuses == null || this.createLocalStatuses.SEDU) {
                    this.createLocalStatuses = new RefreshThread();
                    this.createLocalStatuses.start();
                    ServiceLogger.logDebug("GlobalDatabase:: start status-refresh.");
                }
            } else if (this.createLocalStatuses != null) {
                this.createLocalStatuses.SEDU = true;
                this.createLocalStatuses.interrupt();
                this.createLocalStatuses = null;
                ServiceLogger.logDebug("GlobalDatabase:: stop status-refresh.");
            }
        }
    }

    boolean isPendingUpgrade() {
        return this.check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFinishedUpgrade() throws Exception {
        Object object = this.equals;
        synchronized (object) {
            if (!this.check) {
                return;
            }
            this.check = false;
            this.append.isPendingUpgrade.set(false);
            this.addMemberListener(true);
            ServiceLogger.logDebug("GlobalDatabase:: upgrade finished.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFinishedStartup() throws SQLException {
        Object object = this.equals;
        synchronized (object) {
            if (((Boolean)this.append.isFinishedStartup.get()).booleanValue()) {
                return;
            }
            this.append.isFinishedStartup.set(true);
            if (this.doUpdateProp) {
                this.addMemberListener(true);
            }
            ServiceLogger.logDebug("GlobalDatabase:: startup finished.");
        }
    }

    private class RefreshThread
    extends Thread {
        private boolean SEDU;

        RefreshThread() {
            super("DbStatusRefresh");
            this.SEDU = false;
            super.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.SEDU) {
                try {
                    GlobalDbStatusChecker.this.addMemberListener(true);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable, 2);
                }
                finally {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

