/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.JSRuntimeException;
import jet.cs.CSUtil;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.api.db.Workspaces;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.WorkspaceImpl;
import jet.server.db.core.WorkspacesImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.XMLUtil;
import jet.server.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class WorkspaceManager {
    public static final String WORK_MODE = "work.mode";
    public static final String SYSTEM_WORKSPACE = "system.workspace";
    public static final String SYSTEM_WORKSPACE_NAME = "systemRealm";
    public static final String ACTIVE_WORKSPACE = "active.workspace";
    public static final String DEFAULT_ACTIVEWORKSPACE_NAME = "defaultRealm";
    public static final String DATASOURCE = "datasource.";
    public static final String URL_FILE = "file://";
    public static final String URL_JDBC = "jdbc://";
    public static final String URL_JNDI = "jndi://";
    public static final String DB_REALM = "realmtables";
    public static final String DB_PROFILING = "profile";
    public static final String DB_SYSTEM = "systemtables";
    public static final String OLD_DB_REALM = "systables";
    public static final String OLD_DB_PROFILING = "profiling";
    private static WorkspaceManager SEDU = null;
    private boolean add = true;
    private boolean append = false;
    private String appendChild;
    private String buildFrom;
    private HashMap close = null;
    private HashMap contains = null;
    private HashSet createElement = null;
    private HashSet createTextNode = null;
    private WorkspacesImpl databases = new WorkspacesImpl();

    public static WorkspaceManager getInstance() {
        return SEDU;
    }

    public static WorkspaceManager createInstance(Properties properties) throws Throwable {
        if (SEDU == null) {
            SEDU = new WorkspaceManager(properties);
        }
        return SEDU;
    }

    private WorkspaceManager(Properties properties) throws Throwable {
        String string;
        this.close = new HashMap();
        this.contains = new HashMap();
        this.createElement = new HashSet();
        this.createTextNode = new HashSet();
        this.buildFrom = properties.getProperty(SYSTEM_WORKSPACE);
        if (this.buildFrom == null) {
            throw new IllegalArgumentException("The system configuation workspace can not be null...");
        }
        int n = CSUtil.parseInt(properties.getProperty(WORK_MODE), 1);
        for (Object object : properties.keySet()) {
            if (!((String)object).startsWith(DATASOURCE)) continue;
            String string2 = ((String)object).substring(DATASOURCE.length());
            this.createTextNode.add(string2);
            string = properties.getProperty((String)object);
            if (string.startsWith(URL_FILE)) {
                this.contains.put(string2, string);
                continue;
            }
            this.close.put(string2, string);
        }
        if (n == 1) {
            Object object;
            object = new WorkspaceImpl(this.buildFrom);
            this.append((Workspace)object);
            for (String string2 : this.close.keySet()) {
                string = (String)this.close.get(string2);
                DatabaseImpl databaseImpl = new DatabaseImpl((Workspace)object, string2);
                databaseImpl.setProperty("datasource", string);
                ((WorkspaceImpl)object).append(databaseImpl);
            }
        }
        if (n == 2) {
            for (Object object : this.contains.values()) {
                this.createElement.add(object);
                this.SEDU((String)object);
            }
        }
        if (!this.isConfigFileExist() || this.getSystemWorkspace() != null) {
            ServiceLogger.logDebug("***will save Database configuration...invoked by WorkspaceManager.WorkspaceManager()");
            this.saveConfig();
        }
    }

    public synchronized void append(Properties properties) throws Throwable {
        String string;
        this.appendChild = properties.getProperty(ACTIVE_WORKSPACE);
        if (this.appendChild == null) {
            throw new IllegalArgumentException("The active.workspace can not be null");
        }
        int n = CSUtil.parseInt(properties.getProperty(WORK_MODE), 1);
        for (Object object : properties.keySet()) {
            if (!((String)object).startsWith(DATASOURCE)) continue;
            String string2 = ((String)object).substring(DATASOURCE.length());
            this.createTextNode.add(string2);
            string = properties.getProperty((String)object);
            if (string.startsWith(URL_FILE)) {
                this.contains.put(string2, string);
                continue;
            }
            this.close.put(string2, string);
        }
        if (n == 1) {
            Object object;
            object = new WorkspaceImpl(this.appendChild);
            this.append((Workspace)object);
            for (String string2 : this.close.keySet()) {
                string = (String)this.close.get(string2);
                DatabaseImpl databaseImpl = new DatabaseImpl((Workspace)object, string2);
                databaseImpl.setProperty("datasource", string);
                ((WorkspaceImpl)object).append(databaseImpl);
            }
        }
        if (n == 2) {
            for (Object object : this.contains.values()) {
                if (this.createElement.contains(object)) continue;
                this.createElement.add(object);
                this.SEDU((String)object);
            }
        }
        ServiceLogger.logDebug("***will save Database configuration...invoked by WorkspaceManager.append()");
        this.saveConfig();
    }

    public synchronized Workspace getActiveWorkspace() {
        return (Workspace)this.databases.get(this.appendChild);
    }

    public synchronized Workspace getSystemWorkspace() {
        return (Workspace)this.databases.get(this.buildFrom);
    }

    public synchronized void saveConfig() {
        Iterator iterator = this.workspaces().iterator();
        while (iterator.hasNext()) {
            Object object = (Workspace)iterator.next();
            Iterator iterator2 = object.databases().iterator();
            while (iterator2.hasNext()) {
                Database database = (Database)iterator2.next();
                String string = database.getProperty("configFile");
                if (string != null) continue;
                string = (String)this.contains.get(database.getName());
                database.setProperty("configFile", string);
            }
        }
        for (Object object : this.createElement) {
            this.writeConfig((String)object, this.databases);
        }
    }

    public synchronized Workspaces workspaces() {
        return this.databases;
    }

    public synchronized Workspace workspaces(int n) {
        return (Workspace)this.databases.get(n);
    }

    public synchronized Workspace workspaces(String string) {
        return (Workspace)this.databases.get(string);
    }

    public synchronized boolean isDefault(Workspace workspace) {
        return workspace.getName().equals(this.appendChild);
    }

    public synchronized boolean isSystemic(Workspace workspace) {
        return workspace.getName().equals(this.buildFrom);
    }

    public synchronized void append(Workspace workspace) {
        this.databases.append(workspace);
    }

    public synchronized void remove(Workspace workspace) {
        Database[] databaseArray = workspace.databases().toArray();
        if (databaseArray != null && databaseArray.length > 0) {
            for (int i = 0; i < databaseArray.length; ++i) {
                DatabaseImpl databaseImpl = (DatabaseImpl)databaseArray[i];
                databaseImpl.close();
                ((WorkspaceImpl)workspace).remove(databaseImpl);
            }
        }
        this.databases.remove(workspace.getName());
    }

    public boolean isConfigFileExist() {
        return this.add;
    }

    public boolean isUpgradeConfig() {
        return this.append;
    }

    private void SEDU(String string) {
        Object object;
        File file = null;
        try {
            object = new URL(string);
            file = new File(((URL)object).getFile());
        }
        catch (MalformedURLException malformedURLException) {
            ServiceLogger.logError(malformedURLException, 2);
            return;
        }
        if (!file.exists()) {
            this.add = false;
            return;
        }
        object = XMLUtil.loadDocument(file);
        if (object == null) {
            return;
        }
        Element[] elementArray = XMLUtil.getChildElements(object.getDocumentElement(), "workspace");
        Element element = null;
        String string2 = null;
        for (int i = 0; i < elementArray.length; ++i) {
            element = elementArray[i];
            string2 = element.getAttribute("name");
            if (string2 == null || string2.length() == 0 || this.databases.contains(string2)) continue;
            Element[] elementArray2 = XMLUtil.getChildElements(element, "database");
            String string3 = null;
            for (int j = 0; j < elementArray2.length; ++j) {
                string3 = elementArray2[j].getAttribute("name");
                if (OLD_DB_REALM.equalsIgnoreCase(string3)) {
                    elementArray2[j].setAttribute("name", DB_REALM);
                    this.append = true;
                    continue;
                }
                if (!OLD_DB_PROFILING.equalsIgnoreCase(string3)) continue;
                elementArray2[j].setAttribute("name", DB_PROFILING);
                this.append = true;
            }
            WorkspaceImpl workspaceImpl = new WorkspaceImpl();
            workspaceImpl.buildFrom(element);
            Iterator iterator = workspaceImpl.databases().iterator();
            while (iterator.hasNext()) {
                DatabaseImpl databaseImpl = (DatabaseImpl)iterator.next();
                databaseImpl.setProperty("configFile", string);
            }
            this.databases.append(workspaceImpl);
        }
    }

    protected synchronized void writeConfig(String string, WorkspacesImpl workspacesImpl) {
        Object object;
        Object object2;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JSRuntimeException(parserConfigurationException.getMessage());
        }
        document = documentBuilder.newDocument();
        Element element = document.createElement("dbconfig");
        document.appendChild(element);
        int n = workspacesImpl.size();
        for (int i = 0; i < n; ++i) {
            object2 = (WorkspaceImpl)workspacesImpl.get(i);
            if (((WorkspaceImpl)object2).databases().isEmpty()) continue;
            object = document.createElement("workspace");
            object.setAttribute("name", ((AbstractDBObject)object2).getName());
            ServiceLogger.logDebug("***Save Database configuration...workspace:" + ((AbstractDBObject)object2).getName());
            element.appendChild((Node)object);
            int n2 = ((WorkspaceImpl)object2).databases().size();
            for (int j = 0; j < n2; ++j) {
                String string2;
                Object object3;
                Database database = ((WorkspaceImpl)object2).databases(j);
                if (!string.equals(database.getProperty("configFile"))) continue;
                Element element2 = document.createElement("database");
                element2.setAttribute("name", database.getName());
                object.appendChild(element2);
                ServiceLogger.logDebug("***Save Database configuration...database:" + ((AbstractDBObject)object2).getName());
                Properties properties = database.getProperties();
                String string3 = properties.getProperty("user");
                if (string3 != null) {
                    object3 = "user=" + properties.getProperty("user") + "\r\n" + "password=" + properties.getProperty("password", "");
                    string2 = ServerUtil.encode((String)object3);
                    properties.setProperty("encrypt-sign", string2);
                }
                object3 = properties.keys();
                while (object3.hasMoreElements()) {
                    String string4;
                    string2 = (String)object3.nextElement();
                    String string5 = properties.getProperty(string2);
                    if (string2.equals("password")) {
                        ServiceLogger.logDebug("***Save Database configuration...connection property:" + string2 + "=******");
                    } else {
                        ServiceLogger.logDebug("***Save Database configuration...connection property:" + string2 + "=" + string5);
                    }
                    if ("classpath".equalsIgnoreCase(string2) || string5.startsWith(URL_FILE) || "user".equals(string2) || "password".equals(string2)) continue;
                    Element element3 = document.createElement(string2);
                    element3.appendChild(document.createTextNode(string5));
                    element2.appendChild(element3);
                    if (!"driver".equalsIgnoreCase(string2) || "org.apache.derby.jdbc.ClientDriver".equals(string5) || (string4 = properties.getProperty("classpath")) == null || string4.trim().length() <= 0) continue;
                    element3.setAttribute("classpath", string4);
                }
            }
        }
        try {
            URL uRL = new URL(string);
            object2 = uRL.getFile();
            object = new File((String)object2);
            File file = ((File)object).getParentFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            XMLWriter.write(document, (String)object2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void destroy() {
        SEDU = null;
    }
}

