/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core.trans;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.server.db.core.trans.DbLockHandler;
import jet.server.db.core.trans.LockException;
import jet.server.db.core.trans.LockTableIntf;
import jet.server.log.ServiceLogger;

abstract class AbstractLockHandler
implements DbLockHandler {
    private final ThreadLocal SEDU = new ThreadLocal();
    private final Map add = new HashMap();
    private final String append;

    protected AbstractLockHandler(LockTableIntf lockTableIntf) {
        this.append = "LockHandler[" + lockTableIntf.getTableDescName() + "]";
    }

    @Override
    public String getHandlerDesc() {
        return this.append;
    }

    private List SEDU() {
        ArrayList arrayList = (ArrayList)this.SEDU.get();
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.SEDU.set(arrayList);
        }
        return arrayList;
    }

    protected abstract void execObtainLock(Connection var1, String var2) throws LockException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean preObtainLock(String string) throws LockException {
        ServiceLogger.logDebug(this.getHandlerDesc() + " to obtain: " + string, 7);
        if (this.isLockOwner(string)) {
            ServiceLogger.logDebug(this.getHandlerDesc() + " thread nested obtain same lock:" + string + ", locks=" + string);
            return false;
        }
        if (this.SEDU().size() > 0) {
            ServiceLogger.logDebug(this.getHandlerDesc() + " warn: thread attemp to obtian multi-locks, cur obtained locks: " + this.SEDU(), 4);
        }
        Map map = this.add;
        synchronized (map) {
            Object object;
            while (this.add.containsKey(string)) {
                try {
                    object = (Thread)((Reference)this.add.get(string)).get();
                    if (object == null || !((Thread)object).isAlive()) {
                        ServiceLogger.logDebug(this.getHandlerDesc() + " waiting lock:" + string + "; locker thread death: " + object);
                        break;
                    }
                    ServiceLogger.logDebug(this.getHandlerDesc() + " waiting lock:" + string + "; locked by: " + object);
                    this.add.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    throw new LockException(this.getHandlerDesc() + " interrupted waiting lock:" + string);
                }
            }
            object = new WeakReference<Thread>(Thread.currentThread());
            this.add.put(string, object);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void obtainLock(Connection connection, String string) throws LockException {
        ServiceLogger.logDebug(this.getHandlerDesc() + " to obtain dblock: " + string, 7);
        boolean bl = false;
        try {
            this.execObtainLock(connection, string);
            bl = true;
        }
        finally {
            if (!bl) {
                ServiceLogger.logDebug(this.getHandlerDesc() + " failed to lock: " + string);
                Map map = this.add;
                synchronized (map) {
                    this.add.remove(string);
                    this.add.notifyAll();
                }
            }
        }
    }

    @Override
    public void postObtainLock(String string) throws LockException {
        this.SEDU().add(string);
        ServiceLogger.logDebug(this.getHandlerDesc() + " obtained lock: " + string, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock(String string) throws LockException {
        ServiceLogger.logDebug(this.getHandlerDesc() + " to release lock:" + string, 7);
        if (!this.isLockOwner(string)) {
            ServiceLogger.logDebug(this.getHandlerDesc() + " stack-trace wrong, attempt to release not owned lock:" + string);
            return;
        }
        List list = this.SEDU();
        list.remove(list.lastIndexOf(string));
        if (!this.isLockOwner(string)) {
            Map map = this.add;
            synchronized (map) {
                this.add.remove(string);
                this.add.notifyAll();
            }
        }
        ServiceLogger.logDebug(this.getHandlerDesc() + " released lock: " + string, 6);
    }

    @Override
    public boolean isLockOwner(String string) throws LockException {
        return this.SEDU().contains(string);
    }

    protected void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected boolean addLock(Connection connection, String string, LockTableIntf lockTableIntf) {
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        try {
            preparedStatement = connection.prepareStatement(String.format("INSERT INTO %s(%s) VALUES(?)", lockTableIntf.getTableName(), lockTableIntf.getColumnName()));
            preparedStatement.setString(1, string);
            bl = preparedStatement.executeUpdate() > 0;
            this.closeStatement(preparedStatement);
            connection.commit();
            ServiceLogger.logDebug(this.getHandlerDesc() + " added lock: " + string, 6);
        }
        catch (Exception exception) {
            ServiceLogger.logDebug(this.getHandlerDesc() + " warn add lock failed: " + string, 6);
            ServiceLogger.logError(exception, 3);
            this.closeStatement(preparedStatement);
            try {
                connection.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            bl = false;
        }
        return bl;
    }
}

