/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core.trans;

import java.sql.SQLException;
import java.util.ArrayList;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.LockTableIntf;
import jet.server.log.ServiceLogger;

public class LockTable
extends TableImpl
implements LockTableIntf {
    public static final String TABLE_NAME = "TBL_LOCK_JINFONET";
    public static final String COL_LOCK_NAME = "LOCK_NAME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockTable(Database database) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), COL_LOCK_NAME, JDBCType.VARCHAR, 255, 9, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        ((DatabaseImpl)database).appendProfileTable(this);
        ((DatabaseImpl)database).appendSystemTable(this);
        ArrayList arrayList = new ArrayList(((DatabaseImpl)database).getTables());
        Recordset recordset = super.query(this.fields().toArray(), null, ParameterMetaInfo.EMPTY, true);
        try {
            while (recordset.next()) {
                arrayList.remove(recordset.getString(0));
            }
        }
        finally {
            recordset.close();
        }
        for (String string : arrayList) {
            this.addLock(string);
        }
    }

    @Override
    public String getTableName() {
        return super.getName();
    }

    @Override
    public String getTableDescName() {
        return "tableLock@" + this.getDatabase().getName();
    }

    @Override
    public String getColumnName() {
        return this.fields(0).getName();
    }

    @Override
    public boolean addLock(String string) {
        FieldValue[] fieldValueArray = this.fields().values();
        fieldValueArray[0].setValue(string);
        try {
            return super.insert(fieldValueArray) > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException.getMessage(), 3);
            return false;
        }
    }

    @Override
    public int deleteLock(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("WHERE ").append(this.fields(0).getName()).append("=?");
            ParameterMetaInfo parameterMetaInfo = new ParameterMetaInfo();
            parameterMetaInfo.add(this.fields(0).getName(), string, this.fields(0).getJDBCType().dataType());
            return super.delete(stringBuilder.toString(), parameterMetaInfo);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return 0;
        }
    }

    @Override
    public int deleteLocks() {
        try {
            return super.delete(null, ParameterMetaInfo.EMPTY);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return 0;
        }
    }
}

