/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core.trans;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jet.server.db.core.TableImpl;
import jet.server.db.core.trans.AbstractLockHandler;
import jet.server.db.core.trans.LockException;
import jet.server.db.core.trans.LockTableIntf;

public class MSSQLDbLockHandler
extends AbstractLockHandler {
    private String SEDU;
    private LockTableIntf addLock;

    protected MSSQLDbLockHandler(LockTableIntf lockTableIntf) {
        super(lockTableIntf);
        this.addLock = lockTableIntf;
        this.SEDU = String.format("SELECT * FROM %s WITH(ROWLOCK,UPDLOCK) WHERE %s=%%s ", lockTableIntf.getTableName(), lockTableIntf.getColumnName());
    }

    @Override
    protected void execObtainLock(Connection connection, String string) throws LockException {
        block12: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            String string2 = String.format(this.SEDU, ((TableImpl)((Object)this.addLock)).getDBAdapter().formatValue(string));
            try {
                int n = 0;
                do {
                    if ((resultSet = (preparedStatement = connection.prepareStatement(string2)).executeQuery()).next()) {
                        break block12;
                    }
                    this.closeStatement(preparedStatement);
                    connection.rollback();
                    super.addLock(connection, string, this.addLock);
                } while (++n <= 3);
                throw new LockException("not exists such lock");
            }
            catch (Exception exception) {
                throw new LockException(this.getHandlerDesc() + " obtain lock '" + string + "' failed: " + exception.getMessage(), exception);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                this.closeStatement(preparedStatement);
            }
        }
    }

    @Override
    public boolean requiresConnection() {
        return true;
    }
}

