/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core.trans;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import jet.server.ServerEnv;
import jet.server.db.adapter.DBAccessdb;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.adapter.DBHsqldb;
import jet.server.db.adapter.DBOdbc;
import jet.server.db.adapter.DBSQLServerdb;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.trans.AbstractLockHandler;
import jet.server.db.core.trans.DbLockHandler;
import jet.server.db.core.trans.ExecuteCallback;
import jet.server.db.core.trans.ExecuteCallbackEx;
import jet.server.db.core.trans.LockException;
import jet.server.db.core.trans.LockTableIntf;
import jet.server.db.core.trans.MSSQLDbLockHandler;
import jet.server.db.core.trans.SimpleLockHandler;
import jet.server.db.core.trans.StdLockHandler;
import jet.server.db.core.trans.TransExecutor;
import jet.server.log.ServiceLogger;

public class TransExecutorImpl
implements TransExecutor {
    private final DbLockHandler SEDU;
    private final DatabaseImpl append;

    public static TransExecutor createTransExecutor(DatabaseImpl databaseImpl, DBAdapter dBAdapter, LockTableIntf lockTableIntf) {
        AbstractLockHandler abstractLockHandler;
        if (!ServerEnv.isClusterEnabled()) {
            abstractLockHandler = new SimpleLockHandler(lockTableIntf);
        } else if (dBAdapter instanceof DBHsqldb || dBAdapter instanceof DBAccessdb || dBAdapter instanceof DBOdbc) {
            abstractLockHandler = new SimpleLockHandler(lockTableIntf);
            ServiceLogger.logError("TransExecutor:: the databse is not cluster-safe: " + dBAdapter, 3);
        } else {
            abstractLockHandler = dBAdapter instanceof DBSQLServerdb ? new MSSQLDbLockHandler(lockTableIntf) : new StdLockHandler(lockTableIntf);
        }
        return new TransExecutorImpl(abstractLockHandler, databaseImpl);
    }

    protected TransExecutorImpl(DbLockHandler dbLockHandler, DatabaseImpl databaseImpl) {
        this.SEDU = dbLockHandler;
        this.append = databaseImpl;
        ServiceLogger.logDebug("TransExecutor:: " + this + ", default handler: " + dbLockHandler.getHandlerDesc(), 4);
    }

    @Override
    public Object executeInLock(String string, ExecuteCallback executeCallback) throws SQLException, LockException {
        try {
            return this.execute(string, this.SEDU, executeCallback, false);
        }
        catch (LockException lockException) {
            throw lockException;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public Object executeInLock(String string, DbLockHandler dbLockHandler, ExecuteCallback executeCallback) throws SQLException, LockException {
        try {
            return this.execute(string, dbLockHandler, executeCallback, false);
        }
        catch (LockException lockException) {
            throw lockException;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public Object executeInLockEx(String string, ExecuteCallbackEx executeCallbackEx) throws LockException, Exception {
        return this.execute(string, this.SEDU, executeCallbackEx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object execute(String string, DbLockHandler dbLockHandler, Object object, boolean bl) throws LockException, SQLException, Exception {
        Object object2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        Connection connection = null;
        Map map = null;
        if (string == null) {
            throw new LockException("Lock name is null.");
        }
        try {
            if (dbLockHandler.preObtainLock(string)) {
                if (dbLockHandler.requiresConnection()) {
                    connection = this.SEDU();
                    map = this.append(connection);
                }
                dbLockHandler.obtainLock(connection, string);
            }
            dbLockHandler.postObtainLock(string);
            bl2 = true;
            if (bl) {
                object2 = ((ExecuteCallbackEx)object).execute();
            } else {
                if (connection == null) {
                    connection = this.SEDU();
                    map = this.append(connection);
                }
                object2 = ((ExecuteCallback)object).execute(connection);
            }
            this.close(connection);
            bl3 = true;
        }
        catch (Throwable throwable) {
            try {
                if (bl2) {
                    dbLockHandler.releaseLock(string);
                }
                if (!bl3) {
                    this.commit(connection);
                }
                this.booleanValue(connection, map);
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.booleanValue(connection, map);
                throw throwable2;
            }
        }
        try {
            if (bl2) {
                dbLockHandler.releaseLock(string);
            }
            if (bl3) return object2;
            this.commit(connection);
            return object2;
        }
        finally {
            this.booleanValue(connection, map);
        }
    }

    private Connection SEDU() throws SQLException {
        return this.append.getConnector().getConnection();
    }

    private Map append(Connection connection) throws SQLException {
        int n;
        int n2;
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
        boolean bl = connection.getAutoCommit();
        if (bl) {
            hashMap.put("autoCommit", Boolean.valueOf(bl));
            connection.setAutoCommit(false);
        }
        if ((n2 = connection.getTransactionIsolation()) != (n = this.append.getTransactionIsolation())) {
            hashMap.put("transactionIsolation", Integer.valueOf(n2));
            connection.setTransactionIsolation(n);
        }
        return hashMap;
    }

    private void booleanValue(Connection connection, Map map) {
        if (connection == null) {
            return;
        }
        try {
            if (map != null) {
                Integer n;
                Boolean bl = (Boolean)map.get("autoCommit");
                if (bl != null) {
                    connection.setAutoCommit(bl);
                }
                if ((n = (Integer)map.get("transactionIsolation")) != null) {
                    connection.setTransactionIsolation(n);
                }
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        try {
            connection.close();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
    }

    private void close(Connection connection) throws SQLException {
        if (connection != null) {
            connection.commit();
        }
    }

    private void commit(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
        }
    }
}

