/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.dao.CRDConnInfoDAO;
import jet.server.db.dao.CRDRunDetailDAO;
import jet.server.db.model.AbstractCRDInfoModel;
import jet.server.db.model.CRDConnInfoModel;
import jet.server.db.model.CRDInfoModel;
import jet.server.db.model.DataVersionModel;
import jet.server.log.ServiceLogger;

public class CRDInfoDAO
extends AbstractDAO {
    public static final String TABLE_NAME_1 = "CRD_INFO_1";
    public static final String TABLE_NAME_2 = "CRD_INFO_2";
    public static final String TABLE_NAME_3 = "CRD_INFO_3";
    public static final String TABLE_NAME_4 = "CRD_INFO_4";
    public static final String TABLE_NAME = "CRD_INFO_5";
    private static final String BIGINT = "ID";
    private static final String DOUBLE = "SVERSION";
    private static final String EMPTY = "CATALOGID";
    private static final String INTEGER = "CATALOGPATH";
    private static final String SEDU = "DATASOURCE";
    private static final String TINYINT = "QUERYTYPE";
    private static final String VARCHAR = "QUERYNAME";
    private static final String add = "LASTMODIFIED";
    private static final String append = "USERNAME";
    private static final String buildInsertSql = "PWD";
    private static final String buildUpdateSql = "PARAMFILE";
    private static final String close = "LAZY";
    private static final String closeResultSet = "RESULTVERSION";
    private static final String closeStatement = "CATALOGVERSION";
    private static final String commit = "CATALOGLASTMODIFIED";
    private static final String contains = "TASKID";
    private static final String createTable = "CONFIGFILE";
    private static final String currentTimeMillis = "LOGINUSER";
    private static final String delete = "CACHETYPE";
    private static final String equals = "BVNAME";
    private static final String executeQuery = "STATUS";
    private static final String executeUpdate = "CREATETIME";
    private static final String get = "MAXMEMORY";
    private static final String getBvName = "FLAGS";
    private static final String getCacheType = "LOCATION";
    private static CRDInfoDAO getCatalogId;
    private CRDConnInfoDAO getCatalogLastModified;
    private static final String getCatalogPath;
    private static final String getCatalogVersion;
    private static final String getConfigFile = "DELETE FROM {0} WHERE ID = ? AND SVERSION = ?";
    private static final String getConnection = "SELECT * FROM {0}";
    private static final String getCreateTime = "SELECT PARAMFILE FROM {0}";
    private static final String getDataSource = "SELECT * FROM {0} WHERE ID = ?";
    private static final String getDataVersion = "SELECT * FROM {0} WHERE CATALOGID = ?";
    private static final String getFlags = "SELECT * FROM {0} WHERE CATALOGPATH = ?";
    private static final String getFloat = "SELECT * FROM {0} WHERE CATALOGID = ? and DATASOURCE = ? and QUERYTYPE = ? and QUERYNAME = ?";
    private static final String getID = "SELECT * FROM {0} WHERE CATALOGPATH = ? and DATASOURCE = ? and QUERYTYPE = ? and QUERYNAME = ?";
    private static final String getId = "SELECT * FROM {0} WHERE PARAMFILE like ?";

    private CRDInfoDAO(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), BIGINT, JDBCType.INTEGER, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), DOUBLE, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), EMPTY, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), INTEGER, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), TINYINT, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), add, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), append, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), buildInsertSql, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), buildUpdateSql, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), close, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), closeResultSet, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), closeStatement, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), commit, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), contains, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), createTable, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), currentTimeMillis, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), delete, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), equals, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), executeQuery, JDBCType.TINYINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), executeUpdate, JDBCType.BIGINT, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), get, JDBCType.DOUBLE, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), getBvName, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), getCacheType, JDBCType.TINYINT, 0, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        this.getCatalogLastModified = CRDConnInfoDAO.newInstance(database, this, updateDetailsTable);
        CRDRunDetailDAO.newInstance(database, this, updateDetailsTable);
        this.upgradeOldTable(database, updateDetailsTable, TABLE_NAME_1, 1);
        this.upgradeOldTable(database, updateDetailsTable, TABLE_NAME_2, 2);
        this.upgradeOldTable(database, updateDetailsTable, TABLE_NAME_3, 3);
        this.upgradeOldTable(database, updateDetailsTable, TABLE_NAME_4, 4);
        try {
            this.adapter.setID(this, this.fields(BIGINT), this.BIGINT() + 1);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mergeOldTable(Table table, int n) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            List list = null;
            list = this.EMPTY(connection, table.getName(), n);
            if (list != null) {
                for (CRDInfoModel cRDInfoModel : list) {
                    this.DOUBLE(connection, cRDInfoModel, false);
                }
            }
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 2);
            }
            ServiceLogger.logError("upgrade crd info table exception.", 2);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException, 2);
                }
            }
        }
    }

    private synchronized int BIGINT() {
        Number number = null;
        try {
            number = super.queryMaxValue(BIGINT, null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number == null || number.intValue() == Integer.MIN_VALUE ? -1 : number.intValue();
    }

    public static CRDInfoDAO newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        if (getCatalogId == null) {
            try {
                getCatalogId = new CRDInfoDAO(database, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return getCatalogId;
    }

    public static CRDInfoDAO getInstance() {
        return getCatalogId;
    }

    public int insert(Connection connection, CRDInfoModel cRDInfoModel) throws SQLException {
        cRDInfoModel.setCreateTime(System.currentTimeMillis());
        return this.DOUBLE(connection, cRDInfoModel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int DOUBLE(Connection connection, CRDInfoModel cRDInfoModel, boolean bl) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getCatalogPath));
            int n2 = 1;
            if (bl) {
                cRDInfoModel.setId(this.adapter.getID(this, this.fields(0)));
            }
            preparedStatement.setInt(n2++, cRDInfoModel.getId());
            preparedStatement.setInt(n2++, cRDInfoModel.getDataVersion());
            preparedStatement.setInt(n2++, cRDInfoModel.getCatalogId());
            preparedStatement.setString(n2++, cRDInfoModel.getCatalogPath());
            preparedStatement.setString(n2++, cRDInfoModel.getDataSource());
            preparedStatement.setInt(n2++, cRDInfoModel.getQueryType());
            preparedStatement.setString(n2++, cRDInfoModel.getQueryName());
            preparedStatement.setLong(n2++, cRDInfoModel.getLastModified());
            preparedStatement.setString(n2++, null);
            preparedStatement.setString(n2++, null);
            preparedStatement.setString(n2++, cRDInfoModel.getParamFile());
            preparedStatement.setInt(n2++, cRDInfoModel.getLazy());
            preparedStatement.setInt(n2++, cRDInfoModel.getResultVersion());
            preparedStatement.setInt(n2++, cRDInfoModel.getCatalogVersion());
            preparedStatement.setLong(n2++, cRDInfoModel.getCatalogLastModified());
            preparedStatement.setString(n2++, cRDInfoModel.getTaskId());
            preparedStatement.setString(n2++, cRDInfoModel.getConfigFile());
            preparedStatement.setString(n2++, cRDInfoModel.getLoginUser());
            preparedStatement.setInt(n2++, cRDInfoModel.getCacheType());
            preparedStatement.setString(n2++, cRDInfoModel.getBvName());
            preparedStatement.setShort(n2++, cRDInfoModel.getStatus());
            preparedStatement.setLong(n2++, cRDInfoModel.getCreateTime());
            preparedStatement.setDouble(n2++, cRDInfoModel.getMaxMemory());
            preparedStatement.setInt(n2++, cRDInfoModel.getFlags());
            preparedStatement.setShort(n2++, cRDInfoModel.getLocation());
            int n3 = preparedStatement.executeUpdate();
            this.getCatalogLastModified.update(connection, cRDInfoModel);
            n = n3;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, CRDInfoModel cRDInfoModel) throws SQLException {
        int n;
        if (cRDInfoModel == null) {
            return 0;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getConfigFile));
            int n2 = 1;
            preparedStatement.setInt(n2++, cRDInfoModel.getId());
            preparedStatement.setInt(n2++, cRDInfoModel.getDataVersion());
            int n3 = preparedStatement.executeUpdate();
            this.getCatalogLastModified.delete(connection, cRDInfoModel.getId());
            n = n3;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, CRDInfoModel cRDInfoModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getCatalogVersion));
            int n2 = 1;
            preparedStatement.setInt(n2++, cRDInfoModel.getCatalogId());
            preparedStatement.setString(n2++, cRDInfoModel.getCatalogPath());
            preparedStatement.setString(n2++, cRDInfoModel.getDataSource());
            preparedStatement.setInt(n2++, cRDInfoModel.getQueryType());
            preparedStatement.setString(n2++, cRDInfoModel.getQueryName());
            preparedStatement.setLong(n2++, cRDInfoModel.getLastModified());
            preparedStatement.setString(n2++, null);
            preparedStatement.setString(n2++, null);
            preparedStatement.setString(n2++, cRDInfoModel.getParamFile());
            preparedStatement.setInt(n2++, cRDInfoModel.getLazy());
            preparedStatement.setInt(n2++, cRDInfoModel.getResultVersion());
            preparedStatement.setInt(n2++, cRDInfoModel.getCatalogVersion());
            preparedStatement.setLong(n2++, cRDInfoModel.getCatalogLastModified());
            preparedStatement.setString(n2++, cRDInfoModel.getTaskId());
            preparedStatement.setString(n2++, cRDInfoModel.getConfigFile());
            preparedStatement.setString(n2++, cRDInfoModel.getLoginUser());
            preparedStatement.setInt(n2++, cRDInfoModel.getCacheType());
            preparedStatement.setString(n2++, cRDInfoModel.getBvName());
            preparedStatement.setShort(n2++, cRDInfoModel.getStatus());
            preparedStatement.setLong(n2++, cRDInfoModel.getCreateTime());
            preparedStatement.setDouble(n2++, cRDInfoModel.getMaxMemory());
            preparedStatement.setInt(n2++, cRDInfoModel.getFlags());
            preparedStatement.setShort(n2++, cRDInfoModel.getLocation());
            preparedStatement.setInt(n2++, cRDInfoModel.getId());
            preparedStatement.setInt(n2++, cRDInfoModel.getDataVersion());
            int n3 = preparedStatement.executeUpdate();
            this.getCatalogLastModified.update(connection, cRDInfoModel);
            n = n3;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listAll(Connection connection) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getConnection));
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            HashMap hashMap = this.getCatalogLastModified.listAll(connection);
            while (resultSet.next()) {
                serializable = this.adapter(resultSet);
                CRDConnInfoModel cRDConnInfoModel = (CRDConnInfoModel)hashMap.get(((DataVersionModel)serializable).getId());
                if (cRDConnInfoModel != null) {
                    ((AbstractCRDInfoModel)serializable).setUserNames(cRDConnInfoModel.getUserNames());
                    ((AbstractCRDInfoModel)serializable).setPasswords(cRDConnInfoModel.getPasswords());
                }
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List EMPTY(Connection connection, String string, int n) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getConnection, string));
            resultSet = preparedStatement.executeQuery();
            Vector vector = new Vector();
            while (resultSet.next()) {
                serializable = null;
                switch (n) {
                    case 1: {
                        serializable = this.INTEGER(resultSet);
                        break;
                    }
                    case 2: {
                        serializable = this.SEDU(resultSet);
                        break;
                    }
                    case 3: {
                        serializable = this.TINYINT(resultSet);
                        break;
                    }
                    case 4: {
                        serializable = this.VARCHAR(resultSet);
                    }
                }
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRDInfoModel get(Connection connection, int n) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CRDInfoModel cRDInfoModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getDataSource));
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                cRDInfoModel = this.adapter(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return cRDInfoModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getByCatalog(Connection connection, int n) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getDataVersion));
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            Vector vector = new Vector();
            while (resultSet.next()) {
                serializable = this.adapter(resultSet);
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getByCatalog(Connection connection, String string) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getFlags));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            Vector vector = new Vector();
            while (resultSet.next()) {
                serializable = this.adapter(resultSet);
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    public boolean existed(Connection connection, CRDInfoModel cRDInfoModel) throws SQLException {
        return this.get(connection, cRDInfoModel) != null;
    }

    public CRDInfoModel get(Connection connection, CRDInfoModel cRDInfoModel) throws SQLException {
        int n = cRDInfoModel.getId();
        if (n > 0) {
            return this.get(connection, n);
        }
        String string = cRDInfoModel.getCatalogPath();
        String string2 = cRDInfoModel.getDataSource();
        int n2 = cRDInfoModel.getQueryType();
        String string3 = cRDInfoModel.getQueryName();
        String string4 = cRDInfoModel.getBvName();
        return this.get(connection, string, string2, n2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CRDInfoModel get(Connection connection, int n, String string, int n2, String string2) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CRDInfoModel cRDInfoModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getFloat));
                int n3 = 1;
                preparedStatement.setInt(n3++, n);
                preparedStatement.setString(n3++, string);
                preparedStatement.setInt(n3++, n2);
                preparedStatement.setString(n3++, string2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                cRDInfoModel = this.adapter(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return cRDInfoModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CRDInfoModel get(Connection connection, String string, String string2, int n, String string3, String string4) throws SQLException {
        CRDInfoModel cRDInfoModel;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getID));
            int n2 = 1;
            preparedStatement.setString(n2++, string);
            preparedStatement.setString(n2++, string2);
            preparedStatement.setInt(n2++, n);
            preparedStatement.setString(n2++, string3);
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList = new ArrayList(2);
            while (resultSet.next()) {
                CRDInfoModel cRDInfoModel2 = this.adapter(resultSet);
                if ((string4 != null || cRDInfoModel2.getBvName() != null) && (string4 == null || !string4.equals(cRDInfoModel2.getBvName()))) break block4;
                cRDInfoModel = cRDInfoModel2;
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        {
            block4: {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                return cRDInfoModel;
            }
            continue;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRDInfoModel get(Connection connection, String string) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CRDInfoModel cRDInfoModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getId));
                int n = 1;
                preparedStatement.setString(n++, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                cRDInfoModel = this.adapter(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return cRDInfoModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    private CRDInfoModel INTEGER(ResultSet resultSet) throws SQLException {
        CRDInfoModel cRDInfoModel = new CRDInfoModel();
        cRDInfoModel.setId(resultSet.getInt(BIGINT));
        cRDInfoModel.setDataVersion(resultSet.getInt(DOUBLE));
        cRDInfoModel.setCatalogId(resultSet.getInt(EMPTY));
        cRDInfoModel.setDataSource(resultSet.getString(SEDU));
        cRDInfoModel.setQueryType(resultSet.getInt(TINYINT));
        cRDInfoModel.setQueryName(resultSet.getString(VARCHAR));
        cRDInfoModel.setLastModified(resultSet.getLong(add));
        cRDInfoModel.setParamFile(resultSet.getString(buildUpdateSql));
        cRDInfoModel.setLazy(resultSet.getInt(close));
        cRDInfoModel.setResultVersion(resultSet.getInt(closeResultSet));
        cRDInfoModel.setCatalogVersion(resultSet.getInt(closeStatement));
        cRDInfoModel.setCatalogLastModified(resultSet.getLong(commit));
        cRDInfoModel.setTaskId(resultSet.getString(contains));
        cRDInfoModel.setConfigFile(resultSet.getString(createTable));
        return cRDInfoModel;
    }

    private CRDInfoModel SEDU(ResultSet resultSet) throws SQLException {
        CRDInfoModel cRDInfoModel = this.INTEGER(resultSet);
        cRDInfoModel.setCatalogPath(resultSet.getString(INTEGER));
        return cRDInfoModel;
    }

    private CRDInfoModel TINYINT(ResultSet resultSet) throws SQLException {
        CRDInfoModel cRDInfoModel = this.SEDU(resultSet);
        cRDInfoModel.setLoginUser(resultSet.getString(currentTimeMillis));
        return cRDInfoModel;
    }

    private CRDInfoModel VARCHAR(ResultSet resultSet) throws SQLException {
        CRDInfoModel cRDInfoModel = this.TINYINT(resultSet);
        int n = resultSet.getInt(delete);
        if (n != 2 && n != 3 && n != 1) {
            n = 1;
        }
        cRDInfoModel.setCacheType(n);
        return cRDInfoModel;
    }

    private CRDInfoModel adapter(ResultSet resultSet) throws SQLException {
        CRDInfoModel cRDInfoModel = this.VARCHAR(resultSet);
        cRDInfoModel.setBvName(resultSet.getString(equals));
        cRDInfoModel.setStatus(resultSet.getShort(executeQuery));
        cRDInfoModel.setCreateTime(resultSet.getLong(executeUpdate));
        cRDInfoModel.setMaxMemory(resultSet.getFloat(get));
        cRDInfoModel.setFlags(resultSet.getInt(getBvName));
        cRDInfoModel.setLocation(resultSet.getShort(getCacheType));
        return cRDInfoModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listAllParaFiles(Connection connection) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getCreateTime));
            resultSet = preparedStatement.executeQuery();
            Vector<Object> vector = new Vector<Object>();
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (object == null || ((String)object).trim().length() == 0) continue;
                vector.add(object);
            }
            object = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return object;
    }

    static {
        getCatalogPath = CRDInfoDAO.buildInsertSql(new String[]{BIGINT, DOUBLE, EMPTY, INTEGER, SEDU, TINYINT, VARCHAR, add, append, buildInsertSql, buildUpdateSql, close, closeResultSet, closeStatement, commit, contains, createTable, currentTimeMillis, delete, equals, executeQuery, executeUpdate, get, getBvName, getCacheType});
        getCatalogVersion = CRDInfoDAO.buildUpdateSql(BIGINT, DOUBLE, new String[]{EMPTY, INTEGER, SEDU, TINYINT, VARCHAR, add, append, buildInsertSql, buildUpdateSql, close, closeResultSet, closeStatement, commit, contains, createTable, currentTimeMillis, delete, equals, executeQuery, executeUpdate, get, getBvName, getCacheType});
    }
}

