/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.dao.CustomFieldDAO;
import jet.server.db.model.CustomFieldModel;
import jet.server.db.model.CustomFieldValueModel;
import jet.server.db.model.DataVersionModel;
import jet.server.log.ServiceLogger;

public class CustomFieldValueDAO
extends AbstractDAO {
    public static final String TABLE_NAME = "CUSTOM_FIELD_VALUE_1";
    private static final String INTEGER = "ID";
    private static final String SEDU = "SVERSION";
    private static final String VARCHAR = "NODEID";
    private static final String add = "NODEREALPATH";
    private static final String append = "FIELDID";
    private static final String closeResultSet = "STRINGVALUE";
    private static CustomFieldValueDAO closeStatement;
    private static final String contains = "INSERT INTO {0} (ID,SVERSION,NODEID,NODEREALPATH,FIELDID,STRINGVALUE) values (?,?,?,?,?,?)";
    private static final String createTable = "UPDATE {0} SET NODEID=?,NODEREALPATH=?,FIELDID=?,STRINGVALUE=? WHERE ID=? AND SVERSION=?";
    private static final String delete = "DELETE FROM {0} WHERE ID = ? AND SVERSION = ?";
    private static final String equals = "DELETE FROM {0} WHERE NODEID = ? ";
    private static final String executeQuery = "DELETE FROM {0} WHERE NODEREALPATH = ? ";
    private static final String executeUpdate = "SELECT * FROM {0}";
    private static final String getDataVersion = "SELECT * FROM {0} WHERE NODEID = ? ";
    private static final String getFieldById = "SELECT * FROM {0} WHERE NODEREALPATH = ? ";
    private static final String getFieldId = "SELECT * FROM {0} WHERE NODEID = ? and FIELDID = ?";
    private static final String getFieldValue = "SELECT * FROM {0} WHERE NODEREALPATH = ? and FIELDID = ?";

    private CustomFieldValueDAO(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, TABLE_NAME);
        super.append(new FieldImpl(this.getName(), INTEGER, JDBCType.INTEGER, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), SEDU, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), add, JDBCType.VARCHAR, 256, 0, 0));
        super.append(new FieldImpl(this.getName(), append, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), closeResultSet, JDBCType.VARCHAR, 256, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public static CustomFieldValueDAO newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        if (closeStatement == null) {
            try {
                closeStatement = new CustomFieldValueDAO(database, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, TABLE_NAME, 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return closeStatement;
    }

    public static CustomFieldValueDAO getInstance() {
        return closeStatement;
    }

    public int save(Connection connection, CustomFieldValueModel customFieldValueModel) throws SQLException {
        int n = customFieldValueModel.getNodeId();
        int n2 = customFieldValueModel.getFieldId();
        if (customFieldValueModel.getId() != 0) {
            return this.update(connection, customFieldValueModel);
        }
        Object object = customFieldValueModel.getValue();
        CustomFieldValueModel customFieldValueModel2 = null;
        if (n == -1) {
            String string = customFieldValueModel.getNodeRealPath();
            customFieldValueModel2 = this.getFieldValue(connection, string, n2);
        } else {
            customFieldValueModel2 = this.getFieldValue(connection, n, n2);
        }
        if (customFieldValueModel2 == null) {
            if (object != null && object.toString().trim().length() > 0) {
                return this.insert(connection, customFieldValueModel);
            }
            return 0;
        }
        if (object != null && object.toString().trim().length() > 0) {
            if (object.equals(customFieldValueModel2.getValue())) {
                return 0;
            }
            customFieldValueModel2.setValue(object);
            return this.update(connection, customFieldValueModel2);
        }
        this.delete(connection, customFieldValueModel2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(Connection connection, CustomFieldValueModel customFieldValueModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(contains));
            int n2 = 1;
            preparedStatement.setInt(n2++, this.adapter.getID(this, this.fields(0)));
            preparedStatement.setInt(n2++, customFieldValueModel.getDataVersion());
            preparedStatement.setInt(n2++, customFieldValueModel.getNodeId());
            preparedStatement.setString(n2++, customFieldValueModel.getNodeRealPath());
            preparedStatement.setInt(n2++, customFieldValueModel.getFieldId());
            preparedStatement.setString(n2++, customFieldValueModel.getStringValue());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, CustomFieldValueModel customFieldValueModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(this.rtp(delete));
            preparedStatement.setInt(1, customFieldValueModel.getId());
            preparedStatement.setInt(2, customFieldValueModel.getDataVersion());
            n = n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByNodeId(Connection connection, int n) throws SQLException {
        int n2;
        PreparedStatement preparedStatement = null;
        try {
            int n3;
            preparedStatement = connection.prepareStatement(this.rtp(equals));
            preparedStatement.setInt(1, n);
            n2 = n3 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteByNodeRealPath(Connection connection, String string) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = connection.prepareStatement(this.rtp(executeQuery));
            preparedStatement.setString(1, string);
            n = n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection connection, CustomFieldValueModel customFieldValueModel) throws SQLException {
        int n;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(createTable));
            int n2 = 1;
            preparedStatement.setInt(n2++, customFieldValueModel.getNodeId());
            preparedStatement.setString(n2++, customFieldValueModel.getNodeRealPath());
            preparedStatement.setInt(n2++, customFieldValueModel.getFieldId());
            preparedStatement.setString(n2++, customFieldValueModel.getStringValue());
            preparedStatement.setInt(n2++, customFieldValueModel.getId());
            preparedStatement.setInt(n2++, customFieldValueModel.getDataVersion());
            n = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector listAll(Connection connection) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        try {
            preparedStatement = connection.prepareStatement(this.rtp(executeUpdate));
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            while (resultSet.next()) {
                serializable = new CustomFieldValueModel();
                ((CustomFieldValueModel)serializable).setId(resultSet.getInt(INTEGER));
                ((DataVersionModel)serializable).setDataVersion(resultSet.getInt(SEDU));
                ((CustomFieldValueModel)serializable).setNodeId(resultSet.getInt(VARCHAR));
                ((CustomFieldValueModel)serializable).setNodeRealPath(resultSet.getString(add));
                ((CustomFieldValueModel)serializable).setFieldId(resultSet.getInt(append));
                ((CustomFieldValueModel)serializable).setStringValue(resultSet.getString(closeResultSet));
                CustomFieldModel customFieldModel = customFieldDAO.getFieldById(connection, ((CustomFieldValueModel)serializable).getNodeId());
                ((CustomFieldValueModel)serializable).setField(customFieldModel);
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFieldValues(Connection connection, int n) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getDataVersion));
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            while (resultSet.next()) {
                serializable = new CustomFieldValueModel();
                ((CustomFieldValueModel)serializable).setId(resultSet.getInt(INTEGER));
                ((DataVersionModel)serializable).setDataVersion(resultSet.getInt(SEDU));
                ((CustomFieldValueModel)serializable).setNodeId(resultSet.getInt(VARCHAR));
                ((CustomFieldValueModel)serializable).setNodeRealPath(resultSet.getString(add));
                ((CustomFieldValueModel)serializable).setFieldId(resultSet.getInt(append));
                ((CustomFieldValueModel)serializable).setStringValue(resultSet.getString(closeResultSet));
                CustomFieldModel customFieldModel = customFieldDAO.getFieldById(connection, ((CustomFieldValueModel)serializable).getFieldId());
                ((CustomFieldValueModel)serializable).setField(customFieldModel);
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFieldValues(Connection connection, String string) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getFieldById));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            Vector<Serializable> vector = new Vector<Serializable>();
            while (resultSet.next()) {
                serializable = new CustomFieldValueModel();
                ((CustomFieldValueModel)serializable).setId(resultSet.getInt(INTEGER));
                ((DataVersionModel)serializable).setDataVersion(resultSet.getInt(SEDU));
                ((CustomFieldValueModel)serializable).setNodeId(resultSet.getInt(VARCHAR));
                ((CustomFieldValueModel)serializable).setNodeRealPath(resultSet.getString(add));
                ((CustomFieldValueModel)serializable).setFieldId(resultSet.getInt(append));
                ((CustomFieldValueModel)serializable).setStringValue(resultSet.getString(closeResultSet));
                CustomFieldModel customFieldModel = customFieldDAO.getFieldById(connection, ((CustomFieldValueModel)serializable).getFieldId());
                ((CustomFieldValueModel)serializable).setField(customFieldModel);
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFieldValueModel getFieldValue(Connection connection, int n, int n2) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CustomFieldValueModel customFieldValueModel;
            preparedStatement = null;
            resultSet = null;
            CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getFieldId));
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                CustomFieldValueModel customFieldValueModel2 = new CustomFieldValueModel();
                customFieldValueModel2.setId(resultSet.getInt(INTEGER));
                customFieldValueModel2.setDataVersion(resultSet.getInt(SEDU));
                customFieldValueModel2.setNodeId(resultSet.getInt(VARCHAR));
                customFieldValueModel2.setNodeRealPath(resultSet.getString(add));
                customFieldValueModel2.setFieldId(resultSet.getInt(append));
                customFieldValueModel2.setStringValue(resultSet.getString(closeResultSet));
                CustomFieldModel customFieldModel = customFieldDAO.getFieldById(connection, customFieldValueModel2.getNodeId());
                customFieldValueModel2.setField(customFieldModel);
                customFieldValueModel = customFieldValueModel2;
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return customFieldValueModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFieldValueModel getFieldValue(Connection connection, String string, int n) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            CustomFieldValueModel customFieldValueModel;
            preparedStatement = null;
            resultSet = null;
            CustomFieldDAO customFieldDAO = CustomFieldDAO.getInstance();
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getFieldValue));
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                CustomFieldValueModel customFieldValueModel2 = new CustomFieldValueModel();
                customFieldValueModel2.setId(resultSet.getInt(INTEGER));
                customFieldValueModel2.setDataVersion(resultSet.getInt(SEDU));
                customFieldValueModel2.setNodeId(resultSet.getInt(VARCHAR));
                customFieldValueModel2.setNodeRealPath(resultSet.getString(add));
                customFieldValueModel2.setFieldId(resultSet.getInt(append));
                customFieldValueModel2.setStringValue(resultSet.getString(closeResultSet));
                CustomFieldModel customFieldModel = customFieldDAO.getFieldById(connection, customFieldValueModel2.getNodeId());
                customFieldValueModel2.setField(customFieldModel);
                customFieldValueModel = customFieldValueModel2;
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return customFieldValueModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }
}

