/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.db.dao.AbstractDAO;
import jet.server.db.model.DynamicSecurityModel;
import jet.server.log.ServiceLogger;

public class DynamicSecurityDAO
extends AbstractDAO {
    public static final String TABLE_NAME_1 = "DYN_SECURITY_1";
    public static final String TABLE_NAME = "DYN_SECURITY_1";
    private static final String EMPTY = "ID";
    private static final String INTEGER = "SVERSION";
    private static final String SEDU = "CATALOG_PATH";
    private static final String VARCHAR = "SECURITY_FILE_NAME";
    private static final String add = "SECURITY_FILE_PATH";
    private static final String append = "TYPE";
    private static DynamicSecurityDAO buildInsertSql;
    private static final String buildUpdateSql;
    private static final String closeResultSet;
    private static final String closeStatement;
    private static final String contains;
    private static final String createTable;
    private static final String executeQuery = "DELETE FROM {0} WHERE ID = ? AND SVERSION = ?";
    private static final String executeUpdate = "DELETE FROM {0} WHERE CATALOG_PATH = ? ";
    private static final String get = "DELETE FROM {0} WHERE CATALOG_PATH = ? AND SECURITY_FILE_NAME = ?";
    private static final String getByCatalogAndFilename = "SELECT * FROM {0}";
    private static final String getCatalogPath = "SELECT * FROM {0} WHERE ID = ?";
    private static final String getDataVersion = "SELECT * FROM {0} WHERE CATALOG_PATH = ?";
    private static final String getID = "SELECT * FROM {0} WHERE CATALOG_PATH = ? AND SECURITY_FILE_NAME = ?";

    private DynamicSecurityDAO(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, "DYN_SECURITY_1");
        super.append(new FieldImpl(this.getName(), EMPTY, JDBCType.INTEGER, 0, 7, 0));
        super.append(new FieldImpl(this.getName(), INTEGER, JDBCType.INTEGER, 0, 0, 0));
        super.append(new FieldImpl(this.getName(), SEDU, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), VARCHAR, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), add, JDBCType.VARCHAR, 255, 0, 0));
        super.append(new FieldImpl(this.getName(), append, JDBCType.INTEGER, 0, 0, 0));
        if (!database.tables().contains(this.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        try {
            this.adapter.setID(this, this.fields(EMPTY), this.EMPTY() + 1);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    private synchronized int EMPTY() {
        Number number = null;
        try {
            number = super.queryMaxValue(EMPTY, null, ParameterMetaInfo.EMPTY, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number == null || number.intValue() == Integer.MIN_VALUE ? -1 : number.intValue();
    }

    public static DynamicSecurityDAO newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        if (buildInsertSql == null) {
            try {
                buildInsertSql = new DynamicSecurityDAO(database, updateDetailsTable);
            }
            catch (Exception exception) {
                ServiceLogger.logError(1640001, "DYN_SECURITY_1", 1);
                ServiceLogger.logError(exception, 1);
            }
        }
        return buildInsertSql;
    }

    public static DynamicSecurityDAO getInstance() {
        return buildInsertSql;
    }

    public DynamicSecurityModel insert(Connection connection, DynamicSecurityModel dynamicSecurityModel) throws SQLException {
        return this.INTEGER(connection, dynamicSecurityModel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicSecurityModel INTEGER(Connection connection, DynamicSecurityModel dynamicSecurityModel, boolean bl) throws SQLException {
        DynamicSecurityModel dynamicSecurityModel2;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(buildUpdateSql));
            int n = 1;
            if (bl) {
                dynamicSecurityModel.setId(this.adapter.getID(this, this.fields(0)));
            }
            preparedStatement.setInt(n++, dynamicSecurityModel.getId());
            preparedStatement.setInt(n++, dynamicSecurityModel.getDataVersion());
            preparedStatement.setString(n++, dynamicSecurityModel.getCatalogPath());
            preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFileName());
            preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFilePath());
            preparedStatement.setInt(n++, dynamicSecurityModel.getType());
            preparedStatement.executeUpdate();
            dynamicSecurityModel2 = dynamicSecurityModel;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return dynamicSecurityModel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSecurityModel delete(Connection connection, DynamicSecurityModel dynamicSecurityModel) throws SQLException {
        DynamicSecurityModel dynamicSecurityModel2;
        if (dynamicSecurityModel == null) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        DynamicSecurityModel dynamicSecurityModel3 = null;
        try {
            int n;
            if (dynamicSecurityModel.getId() > 0) {
                preparedStatement = connection.prepareStatement(this.rtp(executeQuery));
                n = 1;
                preparedStatement.setInt(n++, dynamicSecurityModel.getId());
                preparedStatement.setInt(n++, dynamicSecurityModel.getDataVersion());
                dynamicSecurityModel3 = this.get(connection, dynamicSecurityModel.getId());
            } else if (dynamicSecurityModel.getCatalogPath() != null && dynamicSecurityModel.getCatalogPath().trim().length() > 0 && dynamicSecurityModel.getSecurityFileName() != null && dynamicSecurityModel.getSecurityFileName().trim().length() > 0) {
                preparedStatement = connection.prepareStatement(this.rtp(get));
                n = 1;
                preparedStatement.setString(n++, dynamicSecurityModel.getCatalogPath());
                preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFileName());
                dynamicSecurityModel3 = this.getByCatalogAndFilename(connection, dynamicSecurityModel.getCatalogPath(), dynamicSecurityModel.getSecurityFileName());
            }
            preparedStatement.executeUpdate();
            dynamicSecurityModel2 = dynamicSecurityModel3;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return dynamicSecurityModel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSecurityModel delete(Connection connection, String string, String string2) throws SQLException {
        DynamicSecurityModel dynamicSecurityModel;
        PreparedStatement preparedStatement = null;
        DynamicSecurityModel dynamicSecurityModel2 = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(get));
            int n = 1;
            preparedStatement.setString(n++, string);
            preparedStatement.setString(n++, string2);
            dynamicSecurityModel2 = this.getByCatalogAndFilename(connection, string, string2);
            preparedStatement.executeUpdate();
            dynamicSecurityModel = dynamicSecurityModel2;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return dynamicSecurityModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateTypesByCatalog(Connection connection, String string, int n) throws SQLException {
        int n2;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(contains));
            int n3 = 1;
            preparedStatement.setInt(n3++, n);
            preparedStatement.setString(n3++, string);
            n2 = preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSecurityModel updateTypeByCatalogAndFilename(Connection connection, String string, String string2, int n) throws SQLException {
        DynamicSecurityModel dynamicSecurityModel;
        PreparedStatement preparedStatement = null;
        try {
            DynamicSecurityModel dynamicSecurityModel2;
            preparedStatement = connection.prepareStatement(this.rtp(createTable));
            int n2 = 1;
            preparedStatement.setInt(n2++, n);
            preparedStatement.setString(n2++, string);
            preparedStatement.setString(n2++, string2);
            preparedStatement.executeUpdate();
            dynamicSecurityModel = dynamicSecurityModel2 = this.getByCatalogAndFilename(connection, string, string2);
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return dynamicSecurityModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSecurityModel update(Connection connection, DynamicSecurityModel dynamicSecurityModel) throws SQLException {
        DynamicSecurityModel dynamicSecurityModel2;
        PreparedStatement preparedStatement = null;
        try {
            int n;
            if (dynamicSecurityModel.getId() > 0) {
                preparedStatement = connection.prepareStatement(this.rtp(closeResultSet));
                n = 1;
                preparedStatement.setInt(n++, dynamicSecurityModel.getDataVersion() + 1);
                preparedStatement.setString(n++, dynamicSecurityModel.getCatalogPath());
                preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFileName());
                preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFilePath());
                preparedStatement.setInt(n++, dynamicSecurityModel.getType());
                preparedStatement.setInt(n++, dynamicSecurityModel.getId());
                preparedStatement.setInt(n++, dynamicSecurityModel.getDataVersion());
                preparedStatement.executeUpdate();
            } else if (dynamicSecurityModel.getCatalogPath() != null && dynamicSecurityModel.getCatalogPath().trim().length() > 0 && dynamicSecurityModel.getSecurityFileName() != null && dynamicSecurityModel.getSecurityFileName().trim().length() > 0) {
                preparedStatement = connection.prepareStatement(this.rtp(closeStatement));
                n = 1;
                preparedStatement.setString(n++, dynamicSecurityModel.getCatalogPath());
                preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFileName());
                preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFilePath());
                preparedStatement.setInt(n++, dynamicSecurityModel.getType());
                preparedStatement.setString(n++, dynamicSecurityModel.getCatalogPath());
                preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFileName());
                preparedStatement.executeUpdate();
                DynamicSecurityModel dynamicSecurityModel3 = this.getByCatalogAndFilename(connection, dynamicSecurityModel.getCatalogPath(), dynamicSecurityModel.getSecurityFileName());
                dynamicSecurityModel.setId(dynamicSecurityModel3.getId());
                dynamicSecurityModel.setDataVersion(dynamicSecurityModel3.getDataVersion());
            }
            dynamicSecurityModel2 = dynamicSecurityModel;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return dynamicSecurityModel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSecurityModel update(Connection connection, String string, String string2, DynamicSecurityModel dynamicSecurityModel) throws SQLException {
        DynamicSecurityModel dynamicSecurityModel2;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(closeStatement));
            int n = 1;
            preparedStatement.setString(n++, dynamicSecurityModel.getCatalogPath());
            preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFileName());
            preparedStatement.setString(n++, dynamicSecurityModel.getSecurityFilePath());
            preparedStatement.setInt(n++, dynamicSecurityModel.getType());
            preparedStatement.setString(n++, string);
            preparedStatement.setString(n++, string2);
            preparedStatement.executeUpdate();
            DynamicSecurityModel dynamicSecurityModel3 = this.getByCatalogAndFilename(connection, dynamicSecurityModel.getCatalogPath(), dynamicSecurityModel.getSecurityFileName());
            dynamicSecurityModel.setId(dynamicSecurityModel3.getId());
            dynamicSecurityModel.setDataVersion(dynamicSecurityModel3.getDataVersion());
            dynamicSecurityModel2 = dynamicSecurityModel;
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeStatement(preparedStatement);
        return dynamicSecurityModel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listAll(Connection connection) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getByCatalogAndFilename));
            resultSet = preparedStatement.executeQuery();
            Vector vector = new Vector();
            while (resultSet.next()) {
                serializable = this.SEDU(resultSet);
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSecurityModel get(Connection connection, int n) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            DynamicSecurityModel dynamicSecurityModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getCatalogPath));
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                dynamicSecurityModel = this.SEDU(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return dynamicSecurityModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getByCatalog(Connection connection, String string) throws SQLException {
        Serializable serializable;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(this.rtp(getDataVersion));
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            Vector vector = new Vector();
            while (resultSet.next()) {
                serializable = this.SEDU(resultSet);
                vector.add(serializable);
            }
            serializable = vector;
        }
        catch (Throwable throwable) {
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSecurityModel getByCatalogAndFilename(Connection connection, String string, String string2) throws SQLException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block2: {
            DynamicSecurityModel dynamicSecurityModel;
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(this.rtp(getID));
                int n = 1;
                preparedStatement.setString(n++, string);
                preparedStatement.setString(n++, string2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block2;
                dynamicSecurityModel = this.SEDU(resultSet);
            }
            catch (Throwable throwable) {
                this.closeResultSet(resultSet);
                this.closeStatement(preparedStatement);
                throw throwable;
            }
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            return dynamicSecurityModel;
        }
        this.closeResultSet(resultSet);
        this.closeStatement(preparedStatement);
        return null;
    }

    private DynamicSecurityModel SEDU(ResultSet resultSet) throws SQLException {
        DynamicSecurityModel dynamicSecurityModel = new DynamicSecurityModel();
        dynamicSecurityModel.setId(resultSet.getInt(EMPTY));
        dynamicSecurityModel.setDataVersion(resultSet.getInt(INTEGER));
        dynamicSecurityModel.setCatalogPath(resultSet.getString(SEDU));
        dynamicSecurityModel.setSecurityFileName(resultSet.getString(VARCHAR));
        dynamicSecurityModel.setSecurityFilePath(resultSet.getString(add));
        dynamicSecurityModel.setType(resultSet.getInt(append));
        return dynamicSecurityModel;
    }

    static {
        buildUpdateSql = DynamicSecurityDAO.buildInsertSql(new String[]{EMPTY, INTEGER, SEDU, VARCHAR, add, append});
        closeResultSet = DynamicSecurityDAO.buildUpdateSql(EMPTY, INTEGER, new String[]{INTEGER, SEDU, VARCHAR, add, append});
        closeStatement = DynamicSecurityDAO.buildUpdateSql(SEDU, VARCHAR, new String[]{SEDU, VARCHAR, add, append});
        contains = DynamicSecurityDAO.buildUpdateSql(SEDU, new String[]{append});
        createTable = DynamicSecurityDAO.buildUpdateSql(SEDU, VARCHAR, new String[]{append});
    }
}

